
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * A data type for MARKETING CARRIER Supplier Role with Mandatory Flight Number.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MarketingCarrierFlightType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:AssociatedObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element ref="ns:AirlineID"/>
 *         &lt;xs:element type="xs:string" name="Name" minOccurs="0"/>
 *         &lt;xs:element ref="ns:FlightNumber"/>
 *         &lt;xs:element name="ResBookDesigCode" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class MarketingCarrierFlightType extends AssociatedObjectBaseType
    implements Serializable
{
    private AirlineIDType airlineID;
    private String name;
    private FlightNumber flightNumber;
    private boolean resBookDesigCode;

    /** 
     * Get the 'AirlineID' element value.
     * 
     * @return value
     */
    public AirlineIDType getAirlineID() {
        return airlineID;
    }

    /** 
     * Set the 'AirlineID' element value.
     * 
     * @param airlineID
     */
    public void setAirlineID(AirlineIDType airlineID) {
        this.airlineID = airlineID;
    }

    /** 
     * Get the 'Name' element value. Airline Name.  Example: British Airways
     * 
     * @return value
     */
    public String getName() {
        return name;
    }

    /** 
     * Set the 'Name' element value. Airline Name.  Example: British Airways
     * 
     * @param name
     */
    public void setName(String name) {
        this.name = name;
    }

    /** 
     * Get the 'FlightNumber' element value.
     * 
     * @return value
     */
    public FlightNumber getFlightNumber() {
        return flightNumber;
    }

    /** 
     * Set the 'FlightNumber' element value.
     * 
     * @param flightNumber
     */
    public void setFlightNumber(FlightNumber flightNumber) {
        this.flightNumber = flightNumber;
    }

    /** 
     * Check if the 'ResBookDesigCode' element is present.
     * 
     * @return <code>true</code> if present, <code>false</code> if not
     */
    public boolean ifResBookDesigCodePresent() {
        return resBookDesigCode;
    }

    /** 
     * Set flag for 'ResBookDesigCode' element present.
     * 
     * @param resBookDesigCode
     */
    public void flagResBookDesigCodePresent(boolean resBookDesigCode) {
        this.resBookDesigCode = resBookDesigCode;
    }
}
