
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Transaction Processing Marketing Message(s). Note: Marketing messages specified here apply to all message results, e.g. they are at a message-wide level.

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MarketingMessages">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element name="MarketMessage" maxOccurs="unbounded">
 *         &lt;!-- Reference to inner class MarketMessage -->
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class MarketingMessages implements Serializable
{
    private List<MarketMessage> marketMessageList = new ArrayList<MarketMessage>();

    /** 
     * Get the list of 'MarketMessage' element items.
     * 
     * @return list
     */
    public List<MarketMessage> getMarketMessageList() {
        return marketMessageList;
    }

    /** 
     * Set the list of 'MarketMessage' element items.
     * 
     * @param list
     */
    public void setMarketMessageList(List<MarketMessage> list) {
        marketMessageList = list;
    }
    /** 
     * Marketing message. Example: ONE Traveler MAY BE ELIGIBLE FOR A FREE SEAT
              
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MarketMessage" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="ns:DescriptionType">
     *         &lt;xs:sequence>
     *           &lt;xs:element type="ns:MultiAssociationType" name="Associations" minOccurs="0"/>
     *         &lt;/xs:sequence>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class MarketMessage extends DescriptionType implements
        Serializable
    {
        private MultiAssociationType associations;

        /** 
         * Get the 'Associations' element value. 
                            Business Warning Association(s), including Order, Order Item, Passenger, Group, Offer Item and Service.
                          
         * 
         * @return value
         */
        public MultiAssociationType getAssociations() {
            return associations;
        }

        /** 
         * Set the 'Associations' element value. 
                            Business Warning Association(s), including Order, Order Item, Passenger, Group, Offer Item and Service.
                          
         * 
         * @param associations
         */
        public void setAssociations(MultiAssociationType associations) {
            this.associations = associations;
        }
    }
}
