
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * MEDIA ATTACHMENT representation. 
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MediaAttachmentType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:AssociatedObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element name="AttachmentURI" minOccurs="0">
 *           &lt;!-- Reference to inner class AttachmentURI -->
 *         &lt;/xs:element>
 *         &lt;xs:element type="xs:string" name="Description" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="EncodingMethod" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="FileKbSize" minOccurs="0"/>
 *         &lt;xs:element type="ns:RenderingInstructionsType" name="Rendering" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class MediaAttachmentType extends AssociatedObjectBaseType implements
    Serializable
{
    private AttachmentURI attachmentURI;
    private String description;
    private String encodingMethod;
    private String fileKbSize;
    private RenderingInstructionsType rendering;

    /** 
     * Get the 'AttachmentURI' element value.
     * 
     * @return value
     */
    public AttachmentURI getAttachmentURI() {
        return attachmentURI;
    }

    /** 
     * Set the 'AttachmentURI' element value.
     * 
     * @param attachmentURI
     */
    public void setAttachmentURI(AttachmentURI attachmentURI) {
        this.attachmentURI = attachmentURI;
    }

    /** 
     * Get the 'Description' element value. Attachment Description.
     * 
     * @return value
     */
    public String getDescription() {
        return description;
    }

    /** 
     * Set the 'Description' element value. Attachment Description.
     * 
     * @param description
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /** 
     * Get the 'EncodingMethod' element value. Attachment Encoding Method. Example: BASE64
     * 
     * @return value
     */
    public String getEncodingMethod() {
        return encodingMethod;
    }

    /** 
     * Set the 'EncodingMethod' element value. Attachment Encoding Method. Example: BASE64
     * 
     * @param encodingMethod
     */
    public void setEncodingMethod(String encodingMethod) {
        this.encodingMethod = encodingMethod;
    }

    /** 
     * Get the 'FileKbSize' element value. The size of the Attachment in kilobytes. Example: 60
     * 
     * @return value
     */
    public String getFileKbSize() {
        return fileKbSize;
    }

    /** 
     * Set the 'FileKbSize' element value. The size of the Attachment in kilobytes. Example: 60
     * 
     * @param fileKbSize
     */
    public void setFileKbSize(String fileKbSize) {
        this.fileKbSize = fileKbSize;
    }

    /** 
     * Get the 'Rendering' element value. Rendered Media Instructions.
     * 
     * @return value
     */
    public RenderingInstructionsType getRendering() {
        return rendering;
    }

    /** 
     * Set the 'Rendering' element value. Rendered Media Instructions.
     * 
     * @param rendering
     */
    public void setRendering(RenderingInstructionsType rendering) {
        this.rendering = rendering;
    }
    /** 
     * Attachment Uniform Resource Identifier (URI).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AttachmentURI" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:string">
     *         &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * 
     * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
     *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
     * &lt;/xs:attributeGroup>
     * </pre>
     */
    public static class AttachmentURI implements Serializable
    {
        private String string;
        private String refs;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getString() {
            return string;
        }

        /** 
         * Set the extension value.
         * 
         * @param string
         */
        public void setString(String string) {
            this.string = string;
        }

        /** 
         * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @return value
         */
        public String getRefs() {
            return refs;
        }

        /** 
         * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @param refs
         */
        public void setRefs(String refs) {
            this.refs = refs;
        }
    }
}
