
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * A data type for Business Object Parameters.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MessageParamsBaseType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:AssociatedObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element name="Languages" minOccurs="0">
 *           &lt;!-- Reference to inner class Languages -->
 *         &lt;/xs:element>
 *         &lt;xs:element name="CurrCodes" minOccurs="0">
 *           &lt;!-- Reference to inner class CurrCodes -->
 *         &lt;/xs:element>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class MessageParamsBaseType extends AssociatedObjectBaseType implements
    Serializable
{
    private Languages languages;
    private CurrCodes currCodes;

    /** 
     * Get the 'Languages' element value.
     * 
     * @return value
     */
    public Languages getLanguages() {
        return languages;
    }

    /** 
     * Set the 'Languages' element value.
     * 
     * @param languages
     */
    public void setLanguages(Languages languages) {
        this.languages = languages;
    }

    /** 
     * Get the 'CurrCodes' element value.
     * 
     * @return value
     */
    public CurrCodes getCurrCodes() {
        return currCodes;
    }

    /** 
     * Set the 'CurrCodes' element value.
     * 
     * @param currCodes
     */
    public void setCurrCodes(CurrCodes currCodes) {
        this.currCodes = currCodes;
    }
    /** 
     * Requested and/ or Actual Primary and/ or Alternate message content language(s).

    Note: Language context is specified in the @application attribute, e.g. Requested, Display.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Languages" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element ref="ns:LanguageCode" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Languages implements Serializable
    {
        private List<LanguageCodeType> languageCodeList = new ArrayList<LanguageCodeType>();

        /** 
         * Get the list of 'LanguageCode' element items.
         * 
         * @return list
         */
        public List<LanguageCodeType> getLanguageCodeList() {
            return languageCodeList;
        }

        /** 
         * Set the list of 'LanguageCode' element items.
         * 
         * @param list
         */
        public void setLanguageCodeList(List<LanguageCodeType> list) {
            languageCodeList = list;
        }
    }
    /** 
     * Requested search processing and results currency information.

    Notes:
    1. Currency context is specified in the @application attribute, e.g. Requested, Display.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CurrCodes" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element ref="ns:CurrCode" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class CurrCodes implements Serializable
    {
        private List<CurrCode> currCodeList = new ArrayList<CurrCode>();

        /** 
         * Get the list of 'CurrCode' element items.
         * 
         * @return list
         */
        public List<CurrCode> getCurrCodeList() {
            return currCodeList;
        }

        /** 
         * Set the list of 'CurrCode' element items.
         * 
         * @param list
         */
        public void setCurrCodeList(List<CurrCode> list) {
            currCodeList = list;
        }
    }
}
