
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Non Geographic Specification information
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NonGeographicSpecificationType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:CodesetType" name="Type"/>
 *     &lt;xs:choice>
 *       &lt;xs:element type="xs:string" name="AgentPseudoCityCode"/>
 *       &lt;xs:element type="xs:string" name="AgentNumericCode"/>
 *       &lt;xs:element type="xs:string" name="DepartmentID"/>
 *       &lt;xs:element type="xs:string" name="CRSDepartmentCode"/>
 *       &lt;xs:element type="xs:string" name="LNIATANumber"/>
 *       &lt;xs:element ref="ns:AirlineID" maxOccurs="unbounded"/>
 *     &lt;/xs:choice>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class NonGeographicSpecificationType implements Serializable
{
    private CodesetType type;
    private int choiceSelect = -1;
    private static final int AGENT_PSEUDO_CITY_CODE_CHOICE = 0;
    private static final int AGENT_NUMERIC_CODE_CHOICE = 1;
    private static final int DEPARTMENT_ID_CHOICE = 2;
    private static final int CRS_DEPARTMENT_CODE_CHOICE = 3;
    private static final int LNIATA_NUMBER_CHOICE = 4;
    private static final int AIRLINE_ID_LIST_CHOICE = 5;
    private String agentPseudoCityCode;
    private String agentNumericCode;
    private String departmentID;
    private String CRSDepartmentCode;
    private String LNIATANumber;
    private List<AirlineIDType> airlineIDList = new ArrayList<AirlineIDType>();

    /** 
     * Get the 'Type' element value. A code Indicating the type of CODE data to be found in the following fields:                                                     T = Pseudo Code/Travel Agency Code I = IATA Travel Agency No. H = Home IATA Agency No. U = Home Travel Agency Code X = Department/Identifier V = CRS/CXR Department Code L = LNIATA Number (CRT Address) Blank = No application
     * 
     * @return value
     */
    public CodesetType getType() {
        return type;
    }

    /** 
     * Set the 'Type' element value. A code Indicating the type of CODE data to be found in the following fields:                                                     T = Pseudo Code/Travel Agency Code I = IATA Travel Agency No. H = Home IATA Agency No. U = Home Travel Agency Code X = Department/Identifier V = CRS/CXR Department Code L = LNIATA Number (CRT Address) Blank = No application
     * 
     * @param type
     */
    public void setType(CodesetType type) {
        this.type = type;
    }

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if AgentPseudoCityCode is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAgentPseudoCityCode() {
        return choiceSelect == AGENT_PSEUDO_CITY_CODE_CHOICE;
    }

    /** 
     * Get the 'AgentPseudoCityCode' element value. Up to a six character code for a pseudo
    code/Travel Agency (left justified) followed by spaces.
     * 
     * @return value
     */
    public String getAgentPseudoCityCode() {
        return agentPseudoCityCode;
    }

    /** 
     * Set the 'AgentPseudoCityCode' element value. Up to a six character code for a pseudo
    code/Travel Agency (left justified) followed by spaces.
     * 
     * @param agentPseudoCityCode
     */
    public void setAgentPseudoCityCode(String agentPseudoCityCode) {
        setChoiceSelect(AGENT_PSEUDO_CITY_CODE_CHOICE);
        this.agentPseudoCityCode = agentPseudoCityCode;
    }

    /** 
     * Check if AgentNumericCode is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAgentNumericCode() {
        return choiceSelect == AGENT_NUMERIC_CODE_CHOICE;
    }

    /** 
     * Get the 'AgentNumericCode' element value. An eight digit IATA assigned travel agency code.
     * 
     * @return value
     */
    public String getAgentNumericCode() {
        return agentNumericCode;
    }

    /** 
     * Set the 'AgentNumericCode' element value. An eight digit IATA assigned travel agency code.
     * 
     * @param agentNumericCode
     */
    public void setAgentNumericCode(String agentNumericCode) {
        setChoiceSelect(AGENT_NUMERIC_CODE_CHOICE);
        this.agentNumericCode = agentNumericCode;
    }

    /** 
     * Check if DepartmentID is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifDepartmentID() {
        return choiceSelect == DEPARTMENT_ID_CHOICE;
    }

    /** 
     * Get the 'DepartmentID' element value. Up to a seven digit code indicating the airline department or CRS agency/department (right justified) with leading zeros. Space in packed byte 32 or unpacked byte 41.
     * 
     * @return value
     */
    public String getDepartmentID() {
        return departmentID;
    }

    /** 
     * Set the 'DepartmentID' element value. Up to a seven digit code indicating the airline department or CRS agency/department (right justified) with leading zeros. Space in packed byte 32 or unpacked byte 41.
     * 
     * @param departmentID
     */
    public void setDepartmentID(String departmentID) {
        setChoiceSelect(DEPARTMENT_ID_CHOICE);
        this.departmentID = departmentID;
    }

    /** 
     * Check if CRSDepartmentCode is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifCRSDepartmentCode() {
        return choiceSelect == CRS_DEPARTMENT_CODE_CHOICE;
    }

    /** 
     * Get the 'CRSDepartmentCode' element value. Up to a six character code indicating the airline department or CRS agency/department (left justified) followed by spaces.
     * 
     * @return value
     */
    public String getCRSDepartmentCode() {
        return CRSDepartmentCode;
    }

    /** 
     * Set the 'CRSDepartmentCode' element value. Up to a six character code indicating the airline department or CRS agency/department (left justified) followed by spaces.
     * 
     * @param CRSDepartmentCode
     */
    public void setCRSDepartmentCode(String CRSDepartmentCode) {
        setChoiceSelect(CRS_DEPARTMENT_CODE_CHOICE);
        this.CRSDepartmentCode = CRSDepartmentCode;
    }

    /** 
     * Check if LNIATANumber is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifLNIATANumber() {
        return choiceSelect == LNIATA_NUMBER_CHOICE;
    }

    /** 
     * Get the 'LNIATANumber' element value. Up to an eight character assigned complete line address (left justified) followed by spaces
     * 
     * @return value
     */
    public String getLNIATANumber() {
        return LNIATANumber;
    }

    /** 
     * Set the 'LNIATANumber' element value. Up to an eight character assigned complete line address (left justified) followed by spaces
     * 
     * @param LNIATANumber
     */
    public void setLNIATANumber(String LNIATANumber) {
        setChoiceSelect(LNIATA_NUMBER_CHOICE);
        this.LNIATANumber = LNIATANumber;
    }

    /** 
     * Check if AirlineIDList is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAirlineIDList() {
        return choiceSelect == AIRLINE_ID_LIST_CHOICE;
    }

    /** 
     * Get the list of 'AirlineID' element items.
     * 
     * @return list
     */
    public List<AirlineIDType> getAirlineIDList() {
        return airlineIDList;
    }

    /** 
     * Set the list of 'AirlineID' element items.
     * 
     * @param list
     */
    public void setAirlineIDList(List<AirlineIDType> list) {
        setChoiceSelect(AIRLINE_ID_LIST_CHOICE);
        airlineIDList = list;
    }
}
