
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * 
 A data type for One Time Pass Code Generation Format contextual list. Examples: Email, SMS, Text

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OTP_CodeFormatListType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Email"/>
 *     &lt;xs:enumeration value="SMS"/>
 *     &lt;xs:enumeration value="Text"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum OTPCodeFormatListType implements Serializable {
    EMAIL("Email"), SMS("SMS"), TEXT("Text");
    private final String value;

    private OTPCodeFormatListType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static OTPCodeFormatListType convert(String value) {
        for (OTPCodeFormatListType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
