
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Shopping Offer Association(s) definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OfferAssociationsType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:ShopperInfoAssocType" name="Shopper" minOccurs="0"/>
 *     &lt;xs:element type="ns:FlightInfoAssocType" name="Flight" minOccurs="0"/>
 *     &lt;xs:element name="PriceClass" minOccurs="0">
 *       &lt;xs:complexType>
 *         &lt;xs:sequence>
 *           &lt;xs:element ref="ns:PriceClassReference"/>
 *         &lt;/xs:sequence>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns:BagDetailAssocType" name="BagDetails" minOccurs="0"/>
 *     &lt;xs:element type="ns:OfferDetailInfoAssocType" name="OfferDetails" minOccurs="0"/>
 *     &lt;xs:element name="Services" minOccurs="0">
 *       &lt;!-- Reference to inner class Services -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns:MediaAssocType" name="Media" minOccurs="0"/>
 *     &lt;xs:element type="ns:OtherOfferAssocType" name="Other" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class OfferAssociationsType implements Serializable
{
    private ShopperInfoAssocType shopper;
    private FlightInfoAssocType flight;
    private PriceClassReference priceClass;
    private BagDetailAssocType bagDetails;
    private OfferDetailInfoAssocType offerDetails;
    private Services services;
    private MediaAssocType media;
    private OtherOfferAssocType other;

    /** 
     * Get the 'Shopper' element value. 
              Associated Shoppers. Note: Includes Anonymous, Recognized and/or PTC shopper association.
            
     * 
     * @return value
     */
    public ShopperInfoAssocType getShopper() {
        return shopper;
    }

    /** 
     * Set the 'Shopper' element value. 
              Associated Shoppers. Note: Includes Anonymous, Recognized and/or PTC shopper association.
            
     * 
     * @param shopper
     */
    public void setShopper(ShopperInfoAssocType shopper) {
        this.shopper = shopper;
    }

    /** 
     * Get the 'Flight' element value. Associated Flight(s).
     * 
     * @return value
     */
    public FlightInfoAssocType getFlight() {
        return flight;
    }

    /** 
     * Set the 'Flight' element value. Associated Flight(s).
     * 
     * @param flight
     */
    public void setFlight(FlightInfoAssocType flight) {
        this.flight = flight;
    }

    /** 
     * Get the 'PriceClassReference' element value. Associated Price Class information.
     * 
     * @return value
     */
    public PriceClassReference getPriceClass() {
        return priceClass;
    }

    /** 
     * Set the 'PriceClassReference' element value. Associated Price Class information.
     * 
     * @param priceClass
     */
    public void setPriceClass(PriceClassReference priceClass) {
        this.priceClass = priceClass;
    }

    /** 
     * Get the 'BagDetails' element value. Baggage Detail Associations.
     * 
     * @return value
     */
    public BagDetailAssocType getBagDetails() {
        return bagDetails;
    }

    /** 
     * Set the 'BagDetails' element value. Baggage Detail Associations.
     * 
     * @param bagDetails
     */
    public void setBagDetails(BagDetailAssocType bagDetails) {
        this.bagDetails = bagDetails;
    }

    /** 
     * Get the 'OfferDetails' element value. Offer Detail Association(s).
     * 
     * @return value
     */
    public OfferDetailInfoAssocType getOfferDetails() {
        return offerDetails;
    }

    /** 
     * Set the 'OfferDetails' element value. Offer Detail Association(s).
     * 
     * @param offerDetails
     */
    public void setOfferDetails(OfferDetailInfoAssocType offerDetails) {
        this.offerDetails = offerDetails;
    }

    /** 
     * Get the 'Services' element value.
     * 
     * @return value
     */
    public Services getServices() {
        return services;
    }

    /** 
     * Set the 'Services' element value.
     * 
     * @param services
     */
    public void setServices(Services services) {
        this.services = services;
    }

    /** 
     * Get the 'Media' element value. Associated Media.
     * 
     * @return value
     */
    public MediaAssocType getMedia() {
        return media;
    }

    /** 
     * Set the 'Media' element value. Associated Media.
     * 
     * @param media
     */
    public void setMedia(MediaAssocType media) {
        this.media = media;
    }

    /** 
     * Get the 'Other' element value. Other Association(s).
     * 
     * @return value
     */
    public OtherOfferAssocType getOther() {
        return other;
    }

    /** 
     * Set the 'Other' element value. Other Association(s).
     * 
     * @param other
     */
    public void setOther(OtherOfferAssocType other) {
        this.other = other;
    }
    /** 
     * Associated Service(s).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Services" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Service" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class Service -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Services implements Serializable
    {
        private List<Service> serviceList = new ArrayList<Service>();

        /** 
         * Get the list of 'Service' element items.
         * 
         * @return list
         */
        public List<Service> getServiceList() {
            return serviceList;
        }

        /** 
         * Set the list of 'Service' element items.
         * 
         * @param list
         */
        public void setServiceList(List<Service> list) {
            serviceList = list;
        }
        /** 
         * Associated Service.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Service" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element ref="ns:BundleReference" minOccurs="0"/>
         *       &lt;xs:element ref="ns:ServiceReferences"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Service implements Serializable
        {
            private BundleReference bundleReference;
            private ServiceReferences serviceReferences;

            /** 
             * Get the 'BundleReference' element value.
             * 
             * @return value
             */
            public BundleReference getBundleReference() {
                return bundleReference;
            }

            /** 
             * Set the 'BundleReference' element value.
             * 
             * @param bundleReference
             */
            public void setBundleReference(BundleReference bundleReference) {
                this.bundleReference = bundleReference;
            }

            /** 
             * Get the 'ServiceReferences' element value.
             * 
             * @return value
             */
            public ServiceReferences getServiceReferences() {
                return serviceReferences;
            }

            /** 
             * Set the 'ServiceReferences' element value.
             * 
             * @param serviceReferences
             */
            public void setServiceReferences(ServiceReferences serviceReferences) {
                this.serviceReferences = serviceReferences;
            }
        }
    }
}
