
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * Offer Geographic Specification information
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OfferGeographicSpecificationType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:CodesetType" name="DirectionalIndicator" minOccurs="0"/>
 *     &lt;xs:element type="ns:GeographicSpecificationType" name="OfferOriginPoint" minOccurs="0"/>
 *     &lt;xs:element type="ns:GeographicSpecificationType" name="OfferDestinationPoint" minOccurs="0"/>
 *     &lt;xs:element type="ns:GeographicSpecificationType" name="TravelWithinLocation" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class OfferGeographicSpecificationType implements Serializable
{
    private CodesetType directionalIndicator;
    private GeographicSpecificationType offerOriginPoint;
    private GeographicSpecificationType offerDestinationPoint;
    private GeographicSpecificationType travelWithinLocation;

    /** 
     * Get the 'DirectionalIndicator' element value. 1 = From LOC 1 to LOC 2   2 = To LOC 1 from LOC 2   3 = Originating from LOC 1 to LOC 2                           4 = Originating from LOC 2 to LOC 1                    "Blank = No application"
     * 
     * @return value
     */
    public CodesetType getDirectionalIndicator() {
        return directionalIndicator;
    }

    /** 
     * Set the 'DirectionalIndicator' element value. 1 = From LOC 1 to LOC 2   2 = To LOC 1 from LOC 2   3 = Originating from LOC 1 to LOC 2                           4 = Originating from LOC 2 to LOC 1                    "Blank = No application"
     * 
     * @param directionalIndicator
     */
    public void setDirectionalIndicator(CodesetType directionalIndicator) {
        this.directionalIndicator = directionalIndicator;
    }

    /** 
     * Get the 'OfferOriginPoint' element value. Identifies the Offer Origin Point.
     * 
     * @return value
     */
    public GeographicSpecificationType getOfferOriginPoint() {
        return offerOriginPoint;
    }

    /** 
     * Set the 'OfferOriginPoint' element value. Identifies the Offer Origin Point.
     * 
     * @param offerOriginPoint
     */
    public void setOfferOriginPoint(GeographicSpecificationType offerOriginPoint) {
        this.offerOriginPoint = offerOriginPoint;
    }

    /** 
     * Get the 'OfferDestinationPoint' element value. Identifies the Offer Destination Point.
     * 
     * @return value
     */
    public GeographicSpecificationType getOfferDestinationPoint() {
        return offerDestinationPoint;
    }

    /** 
     * Set the 'OfferDestinationPoint' element value. Identifies the Offer Destination Point.
     * 
     * @param offerDestinationPoint
     */
    public void setOfferDestinationPoint(
            GeographicSpecificationType offerDestinationPoint) {
        this.offerDestinationPoint = offerDestinationPoint;
    }

    /** 
     * Get the 'TravelWithinLocation' element value. Specifies that all travel on the itinerary must be wholly within the specified location.
     * 
     * @return value
     */
    public GeographicSpecificationType getTravelWithinLocation() {
        return travelWithinLocation;
    }

    /** 
     * Set the 'TravelWithinLocation' element value. Specifies that all travel on the itinerary must be wholly within the specified location.
     * 
     * @param travelWithinLocation
     */
    public void setTravelWithinLocation(
            GeographicSpecificationType travelWithinLocation) {
        this.travelWithinLocation = travelWithinLocation;
    }
}
