
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Offer Item Type.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OfferItemType">
 *   &lt;xs:complexType>
 *     &lt;xs:choice>
 *       &lt;xs:element ref="ns:BaggageItem" maxOccurs="unbounded"/>
 *       &lt;xs:element ref="ns:DetailedFlightItem" maxOccurs="unbounded"/>
 *       &lt;xs:element ref="ns:OtherItem" maxOccurs="unbounded"/>
 *       &lt;xs:element ref="ns:SeatItem" maxOccurs="unbounded"/>
 *     &lt;/xs:choice>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class OfferItemType implements Serializable
{
    private int offerItemTypeSelect = -1;
    private static final int BAGGAGE_ITEM_LIST_CHOICE = 0;
    private static final int DETAILED_FLIGHT_ITEM_LIST_CHOICE = 1;
    private static final int OTHER_ITEM_LIST_CHOICE = 2;
    private static final int SEAT_ITEM_LIST_CHOICE = 3;
    private List<BaggageItem> baggageItemList = new ArrayList<BaggageItem>();
    private List<DetailedFlightItem> detailedFlightItemList = new ArrayList<DetailedFlightItem>();
    private List<OtherItem> otherItemList = new ArrayList<OtherItem>();
    private List<SeatItem> seatItemList = new ArrayList<SeatItem>();

    private void setOfferItemTypeSelect(int choice) {
        if (offerItemTypeSelect == -1) {
            offerItemTypeSelect = choice;
        } else if (offerItemTypeSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearOfferItemTypeSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearOfferItemTypeSelect() {
        offerItemTypeSelect = -1;
    }

    /** 
     * Check if BaggageItemList is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifBaggageItemList() {
        return offerItemTypeSelect == BAGGAGE_ITEM_LIST_CHOICE;
    }

    /** 
     * Get the list of 'BaggageItem' element items.
     * 
     * @return list
     */
    public List<BaggageItem> getBaggageItemList() {
        return baggageItemList;
    }

    /** 
     * Set the list of 'BaggageItem' element items.
     * 
     * @param list
     */
    public void setBaggageItemList(List<BaggageItem> list) {
        setOfferItemTypeSelect(BAGGAGE_ITEM_LIST_CHOICE);
        baggageItemList = list;
    }

    /** 
     * Check if DetailedFlightItemList is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifDetailedFlightItemList() {
        return offerItemTypeSelect == DETAILED_FLIGHT_ITEM_LIST_CHOICE;
    }

    /** 
     * Get the list of 'DetailedFlightItem' element items. Flight Offer Item.
     * 
     * @return list
     */
    public List<DetailedFlightItem> getDetailedFlightItemList() {
        return detailedFlightItemList;
    }

    /** 
     * Set the list of 'DetailedFlightItem' element items. Flight Offer Item.
     * 
     * @param list
     */
    public void setDetailedFlightItemList(List<DetailedFlightItem> list) {
        setOfferItemTypeSelect(DETAILED_FLIGHT_ITEM_LIST_CHOICE);
        detailedFlightItemList = list;
    }

    /** 
     * Check if OtherItemList is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifOtherItemList() {
        return offerItemTypeSelect == OTHER_ITEM_LIST_CHOICE;
    }

    /** 
     * Get the list of 'OtherItem' element items.
     * 
     * @return list
     */
    public List<OtherItem> getOtherItemList() {
        return otherItemList;
    }

    /** 
     * Set the list of 'OtherItem' element items.
     * 
     * @param list
     */
    public void setOtherItemList(List<OtherItem> list) {
        setOfferItemTypeSelect(OTHER_ITEM_LIST_CHOICE);
        otherItemList = list;
    }

    /** 
     * Check if SeatItemList is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifSeatItemList() {
        return offerItemTypeSelect == SEAT_ITEM_LIST_CHOICE;
    }

    /** 
     * Get the list of 'SeatItem' element items.
     * 
     * @return list
     */
    public List<SeatItem> getSeatItemList() {
        return seatItemList;
    }

    /** 
     * Set the list of 'SeatItem' element items.
     * 
     * @param list
     */
    public void setSeatItemList(List<SeatItem> list) {
        setOfferItemTypeSelect(SEAT_ITEM_LIST_CHOICE);
        seatItemList = list;
    }
}
