
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.math.BigDecimal;

/** 
 * A data type for Search Query to Results Match.

 Offer match to shopping criteria.  Examples: Full, None, Partial, Other

 Note: An additional percentage qualifier, such as 50%, may be specified for a Partial match.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OfferMatchType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:KeyWithMetaObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="xs:string" name="Application"/>
 *         &lt;xs:element type="xs:string" name="MatchResult"/>
 *         &lt;xs:element type="xs:decimal" name="Percentage" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class OfferMatchType extends KeyWithMetaObjectBaseType implements
    Serializable
{
    private String application;
    private String matchResult;
    private BigDecimal percentage;

    /** 
     * Get the 'Application' element value. Match Application.  Examples: ATTRIBUTE, AFFINITY, Other
     * 
     * @return value
     */
    public String getApplication() {
        return application;
    }

    /** 
     * Set the 'Application' element value. Match Application.  Examples: ATTRIBUTE, AFFINITY, Other
     * 
     * @param application
     */
    public void setApplication(String application) {
        this.application = application;
    }

    /** 
     * Get the 'MatchResult' element value. Offer Match Result.  Examples: Full, None, Partial, Other
     * 
     * @return value
     */
    public String getMatchResult() {
        return matchResult;
    }

    /** 
     * Set the 'MatchResult' element value. Offer Match Result.  Examples: Full, None, Partial, Other
     * 
     * @param matchResult
     */
    public void setMatchResult(String matchResult) {
        this.matchResult = matchResult;
    }

    /** 
     * Get the 'Percentage' element value. Match percentage. Example: 60

    Note: This value may be used to indicate a percentage of a Partial match.
     * 
     * @return value
     */
    public BigDecimal getPercentage() {
        return percentage;
    }

    /** 
     * Set the 'Percentage' element value. Match percentage. Example: 60

    Note: This value may be used to indicate a percentage of a Partial match.
     * 
     * @param percentage
     */
    public void setPercentage(BigDecimal percentage) {
        this.percentage = percentage;
    }
}
