
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * LEAD PRICING CALENDAR Pricing definition.

 Price information for alternate dates.

 Notes:
 1. This is based on lead pricing specified in the AirShoppingRQ/ AttributeQuery/Flight node Arrival and/ or Departure elements.

 2. This capability may not be supported by all NDC-enabled systems or may be supported by bilateral agreement only.The technical implementation of this capability is not dictated by this specification.

 3. If implemented, the client application will typically send new a new shopping request if any of these window shopping dates are selected.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OfferPriceLeadType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:AssociatedObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element name="RequestedDate">
 *           &lt;xs:complexType>
 *             &lt;xs:complexContent>
 *               &lt;xs:extension base="ns:OfferPriceLeadDetailType">
 *                 &lt;xs:sequence>
 *                   &lt;xs:element type="ns:PricedFlightOfferAssocType" name="Associations" minOccurs="0" maxOccurs="unbounded"/>
 *                 &lt;/xs:sequence>
 *               &lt;/xs:extension>
 *             &lt;/xs:complexContent>
 *           &lt;/xs:complexType>
 *         &lt;/xs:element>
 *         &lt;xs:element ref="ns:FareDetail" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *       &lt;xs:attribute type="xs:anySimpleType" name="OfferItemID"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class OfferPriceLeadType extends AssociatedObjectBaseType implements
    Serializable
{
    private OfferPriceLeadDetailType requestedDateOfferPriceLeadDetailType;
    private List<PricedFlightOfferAssocType> requestedDateAssociationList = new ArrayList<PricedFlightOfferAssocType>();
    private FareDetailType fareDetail;
    private String offerItemID;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public OfferPriceLeadDetailType getRequestedDateOfferPriceLeadDetailType() {
        return requestedDateOfferPriceLeadDetailType;
    }

    /** 
     * Set the extension value.
     * 
     * @param requestedDateOfferPriceLeadDetailType
     */
    public void setRequestedDateOfferPriceLeadDetailType(
            OfferPriceLeadDetailType requestedDateOfferPriceLeadDetailType) {
        this.requestedDateOfferPriceLeadDetailType = requestedDateOfferPriceLeadDetailType;
    }

    /** 
     * Get the list of 'Associations' element items. Fare Offer Associations.
     * 
     * @return list
     */
    public List<PricedFlightOfferAssocType> getRequestedDateAssociationList() {
        return requestedDateAssociationList;
    }

    /** 
     * Set the list of 'Associations' element items. Fare Offer Associations.
     * 
     * @param list
     */
    public void setRequestedDateAssociationList(
            List<PricedFlightOfferAssocType> list) {
        requestedDateAssociationList = list;
    }

    /** 
     * Get the 'FareDetail' element value.
     * 
     * @return value
     */
    public FareDetailType getFareDetail() {
        return fareDetail;
    }

    /** 
     * Set the 'FareDetail' element value.
     * 
     * @param fareDetail
     */
    public void setFareDetail(FareDetailType fareDetail) {
        this.fareDetail = fareDetail;
    }

    /** 
     * Get the 'OfferItemID' attribute value. Globally unique OfferItem instance ID. Length should be 64 chars and it is recommended to not use dash char in it.Example: QWASZXERDFCVTYGHBNUIJKNMF67D5F9GHR567SWER41SD458F9456FMDIRTN34DF
     * 
     * @return value
     */
    public String getOfferItemID() {
        return offerItemID;
    }

    /** 
     * Set the 'OfferItemID' attribute value. Globally unique OfferItem instance ID. Length should be 64 chars and it is recommended to not use dash char in it.Example: QWASZXERDFCVTYGHBNUIJKNMF67D5F9GHR567SWER41SD458F9456FMDIRTN34DF
     * 
     * @param offerItemID
     */
    public void setOfferItemID(String offerItemID) {
        this.offerItemID = offerItemID;
    }
}
