
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * The OrderCancel transaction set requests the cancellation of a specified order, and returns confirmation of cancellation.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OrderCancelRS">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element ref="ns:Document"/>
 *       &lt;xs:choice>
 *         &lt;xs:sequence>
 *           &lt;xs:element type="ns:SuccessType" name="Success"/>
 *           &lt;xs:element type="ns:WarningsType" name="Warnings" minOccurs="0"/>
 *           &lt;xs:element name="Response">
 *             &lt;xs:complexType>
 *               &lt;xs:sequence>
 *                 &lt;xs:element ref="ns:OrderCancelProcessing"/>
 *                 &lt;xs:element type="xs:string" name="OrderReference"/>
 *                 &lt;xs:element type="ns:PenaltyType" name="ChangeFees" minOccurs="0"/>
 *                 &lt;xs:element name="TicketDocInfos" minOccurs="0">
 *                   &lt;!-- Reference to inner class TicketDocInfos -->
 *                 &lt;/xs:element>
 *               &lt;/xs:sequence>
 *             &lt;/xs:complexType>
 *           &lt;/xs:element>
 *         &lt;/xs:sequence>
 *         &lt;xs:element ref="ns:Errors"/>
 *       &lt;/xs:choice>
 *     &lt;/xs:sequence>
 *     &lt;xs:attributeGroup ref="ns:IATA_PayloadStdAttributes"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class OrderCancelRS implements Serializable
{
    private MsgDocumentType document;
    private int choiceSelect = -1;
    private static final int SUCCESS_CHOICE = 0;
    private static final int ERRORS_CHOICE = 1;
    private SuccessType success;
    private WarningsType warnings;
    private OrdCancelProcessType responseOrderCancelProcessing;
    private String responseOrderReference;
    private PenaltyType responseChangeFees;
    private TicketDocInfos ticketDocInfos;
    private ErrorsType errors;
    private IATAPayloadStdAttributes IATAPayloadStdAttributes;

    /** 
     * Get the 'Document' element value.
     * 
     * @return value
     */
    public MsgDocumentType getDocument() {
        return document;
    }

    /** 
     * Set the 'Document' element value.
     * 
     * @param document
     */
    public void setDocument(MsgDocumentType document) {
        this.document = document;
    }

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if Success is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifSuccess() {
        return choiceSelect == SUCCESS_CHOICE;
    }

    /** 
     * Get the 'Success' element value. The presence of the empty Success element explicitly indicates that the message succeeded.
     * 
     * @return value
     */
    public SuccessType getSuccess() {
        return success;
    }

    /** 
     * Set the 'Success' element value. The presence of the empty Success element explicitly indicates that the message succeeded.
     * 
     * @param success
     */
    public void setSuccess(SuccessType success) {
        setChoiceSelect(SUCCESS_CHOICE);
        this.success = success;
    }

    /** 
     * Get the 'Warnings' element value. Used in conjunction with the Success element to define one or more business errors.
     * 
     * @return value
     */
    public WarningsType getWarnings() {
        return warnings;
    }

    /** 
     * Set the 'Warnings' element value. Used in conjunction with the Success element to define one or more business errors.
     * 
     * @param warnings
     */
    public void setWarnings(WarningsType warnings) {
        setChoiceSelect(SUCCESS_CHOICE);
        this.warnings = warnings;
    }

    /** 
     * Get the 'OrderCancelProcessing' element value. Transaction Processing Results, including processing status, alerts, notices, business warnings, supplemental marketing messages and policy.
     * 
     * @return value
     */
    public OrdCancelProcessType getResponseOrderCancelProcessing() {
        return responseOrderCancelProcessing;
    }

    /** 
     * Set the 'OrderCancelProcessing' element value. Transaction Processing Results, including processing status, alerts, notices, business warnings, supplemental marketing messages and policy.
     * 
     * @param responseOrderCancelProcessing
     */
    public void setResponseOrderCancelProcessing(
            OrdCancelProcessType responseOrderCancelProcessing) {
        setChoiceSelect(SUCCESS_CHOICE);
        this.responseOrderCancelProcessing = responseOrderCancelProcessing;
    }

    /** 
     * Get the 'OrderReference' element value. Cancelled order reference. Example: REF12345
     * 
     * @return value
     */
    public String getResponseOrderReference() {
        return responseOrderReference;
    }

    /** 
     * Set the 'OrderReference' element value. Cancelled order reference. Example: REF12345
     * 
     * @param responseOrderReference
     */
    public void setResponseOrderReference(String responseOrderReference) {
        setChoiceSelect(SUCCESS_CHOICE);
        this.responseOrderReference = responseOrderReference;
    }

    /** 
     * Get the 'ChangeFees' element value. Order Change Fees(s) and Penalty(s).
     * 
     * @return value
     */
    public PenaltyType getResponseChangeFees() {
        return responseChangeFees;
    }

    /** 
     * Set the 'ChangeFees' element value. Order Change Fees(s) and Penalty(s).
     * 
     * @param responseChangeFees
     */
    public void setResponseChangeFees(PenaltyType responseChangeFees) {
        setChoiceSelect(SUCCESS_CHOICE);
        this.responseChangeFees = responseChangeFees;
    }

    /** 
     * Get the 'TicketDocInfos' element value. Query Results.
     * 
     * @return value
     */
    public TicketDocInfos getTicketDocInfos() {
        return ticketDocInfos;
    }

    /** 
     * Set the 'TicketDocInfos' element value. Query Results.
     * 
     * @param ticketDocInfos
     */
    public void setTicketDocInfos(TicketDocInfos ticketDocInfos) {
        setChoiceSelect(SUCCESS_CHOICE);
        this.ticketDocInfos = ticketDocInfos;
    }

    /** 
     * Check if Errors is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifErrors() {
        return choiceSelect == ERRORS_CHOICE;
    }

    /** 
     * Get the 'Errors' element value.
     * 
     * @return value
     */
    public ErrorsType getErrors() {
        return errors;
    }

    /** 
     * Set the 'Errors' element value.
     * 
     * @param errors
     */
    public void setErrors(ErrorsType errors) {
        setChoiceSelect(ERRORS_CHOICE);
        this.errors = errors;
    }

    /** 
     * Get the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @return value
     */
    public IATAPayloadStdAttributes getIATAPayloadStdAttributes() {
        return IATAPayloadStdAttributes;
    }

    /** 
     * Set the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @param IATAPayloadStdAttributes
     */
    public void setIATAPayloadStdAttributes(
            IATAPayloadStdAttributes IATAPayloadStdAttributes) {
        this.IATAPayloadStdAttributes = IATAPayloadStdAttributes;
    }
    /** 
     * Ticket/ document information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TicketDocInfos" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="TicketDocInfo" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class TicketDocInfo -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class TicketDocInfos implements Serializable
    {
        private List<TicketDocInfo> ticketDocInfoList = new ArrayList<TicketDocInfo>();

        /** 
         * Get the list of 'TicketDocInfo' element items.
         * 
         * @return list
         */
        public List<TicketDocInfo> getTicketDocInfoList() {
            return ticketDocInfoList;
        }

        /** 
         * Set the list of 'TicketDocInfo' element items.
         * 
         * @param list
         */
        public void setTicketDocInfoList(List<TicketDocInfo> list) {
            ticketDocInfoList = list;
        }
        /** 
         * Ticket/document detail.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TicketDocInfo" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:CouponTravelerDetailType" name="Traveler"/>
         *       &lt;xs:element name="AgentIDs" minOccurs="0">
         *         &lt;!-- Reference to inner class AgentIDs -->
         *       &lt;/xs:element>
         *       &lt;xs:element ref="ns:IssuingAirlineInfo" minOccurs="0"/>
         *       &lt;xs:element ref="ns:BookingReferences" minOccurs="0"/>
         *       &lt;xs:element name="Payments" minOccurs="0">
         *         &lt;!-- Reference to inner class Payments -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="OriginDestination" minOccurs="0">
         *         &lt;!-- Reference to inner class OriginDestination -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="xs:string" name="EndorsementText" minOccurs="0"/>
         *       &lt;xs:element name="AddlReferenceIDs" minOccurs="0">
         *         &lt;!-- Reference to inner class AddlReferenceIDs -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="FareInfo" minOccurs="0">
         *         &lt;!-- Reference to inner class FareInfo -->
         *       &lt;/xs:element>
         *       &lt;xs:element ref="ns:TicketDocument" maxOccurs="4"/>
         *       &lt;xs:element type="ns:CouponOrderKeyType" name="OrderReference" minOccurs="0"/>
         *       &lt;xs:element type="ns:CommissionType" name="Commission" minOccurs="0"/>
         *       &lt;xs:element ref="ns:CarrierFeeInfo" minOccurs="0"/>
         *       &lt;xs:element ref="ns:OriginalIssueInfo" minOccurs="0"/>
         *       &lt;xs:element ref="ns:PricingInfo" minOccurs="0"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class TicketDocInfo implements Serializable
        {
            private CouponTravelerDetailType traveler;
            private AgentIDs agentIDs;
            private AirlineIssuanceType issuingAirlineInfo;
            private BookingReferences bookingReferences;
            private Payments payments;
            private OriginDestination originDestination;
            private String endorsementText;
            private AddlReferenceIDs addlReferenceIDs;
            private FareInfo fareInfo;
            private List<TicketDocument> ticketDocumentList = new ArrayList<TicketDocument>();
            private CouponOrderKeyType orderReference;
            private CommissionType commission;
            private CarrierFeeInfoType carrierFeeInfo;
            private OriginalIssueType originalIssueInfo;
            private PricingInfoType pricingInfo;

            /** 
             * Get the 'Traveler' element value. Traveler information.
             * 
             * @return value
             */
            public CouponTravelerDetailType getTraveler() {
                return traveler;
            }

            /** 
             * Set the 'Traveler' element value. Traveler information.
             * 
             * @param traveler
             */
            public void setTraveler(CouponTravelerDetailType traveler) {
                this.traveler = traveler;
            }

            /** 
             * Get the 'AgentIDs' element value.
             * 
             * @return value
             */
            public AgentIDs getAgentIDs() {
                return agentIDs;
            }

            /** 
             * Set the 'AgentIDs' element value.
             * 
             * @param agentIDs
             */
            public void setAgentIDs(AgentIDs agentIDs) {
                this.agentIDs = agentIDs;
            }

            /** 
             * Get the 'IssuingAirlineInfo' element value.
             * 
             * @return value
             */
            public AirlineIssuanceType getIssuingAirlineInfo() {
                return issuingAirlineInfo;
            }

            /** 
             * Set the 'IssuingAirlineInfo' element value.
             * 
             * @param issuingAirlineInfo
             */
            public void setIssuingAirlineInfo(
                    AirlineIssuanceType issuingAirlineInfo) {
                this.issuingAirlineInfo = issuingAirlineInfo;
            }

            /** 
             * Get the 'BookingReferences' element value.
             * 
             * @return value
             */
            public BookingReferences getBookingReferences() {
                return bookingReferences;
            }

            /** 
             * Set the 'BookingReferences' element value.
             * 
             * @param bookingReferences
             */
            public void setBookingReferences(BookingReferences bookingReferences) {
                this.bookingReferences = bookingReferences;
            }

            /** 
             * Get the 'Payments' element value.
             * 
             * @return value
             */
            public Payments getPayments() {
                return payments;
            }

            /** 
             * Set the 'Payments' element value.
             * 
             * @param payments
             */
            public void setPayments(Payments payments) {
                this.payments = payments;
            }

            /** 
             * Get the 'OriginDestination' element value.
             * 
             * @return value
             */
            public OriginDestination getOriginDestination() {
                return originDestination;
            }

            /** 
             * Set the 'OriginDestination' element value.
             * 
             * @param originDestination
             */
            public void setOriginDestination(OriginDestination originDestination) {
                this.originDestination = originDestination;
            }

            /** 
             * Get the 'EndorsementText' element value. Endorsement/ Restriction text.
             * 
             * @return value
             */
            public String getEndorsementText() {
                return endorsementText;
            }

            /** 
             * Set the 'EndorsementText' element value. Endorsement/ Restriction text.
             * 
             * @param endorsementText
             */
            public void setEndorsementText(String endorsementText) {
                this.endorsementText = endorsementText;
            }

            /** 
             * Get the 'AddlReferenceIDs' element value.
             * 
             * @return value
             */
            public AddlReferenceIDs getAddlReferenceIDs() {
                return addlReferenceIDs;
            }

            /** 
             * Set the 'AddlReferenceIDs' element value.
             * 
             * @param addlReferenceIDs
             */
            public void setAddlReferenceIDs(AddlReferenceIDs addlReferenceIDs) {
                this.addlReferenceIDs = addlReferenceIDs;
            }

            /** 
             * Get the 'FareInfo' element value.
             * 
             * @return value
             */
            public FareInfo getFareInfo() {
                return fareInfo;
            }

            /** 
             * Set the 'FareInfo' element value.
             * 
             * @param fareInfo
             */
            public void setFareInfo(FareInfo fareInfo) {
                this.fareInfo = fareInfo;
            }

            /** 
             * Get the list of 'TicketDocument' element items.
             * 
             * @return list
             */
            public List<TicketDocument> getTicketDocumentList() {
                return ticketDocumentList;
            }

            /** 
             * Set the list of 'TicketDocument' element items.
             * 
             * @param list
             */
            public void setTicketDocumentList(List<TicketDocument> list) {
                ticketDocumentList = list;
            }

            /** 
             * Get the 'OrderReference' element value. Associated Order ID(s) information.
             * 
             * @return value
             */
            public CouponOrderKeyType getOrderReference() {
                return orderReference;
            }

            /** 
             * Set the 'OrderReference' element value. Associated Order ID(s) information.
             * 
             * @param orderReference
             */
            public void setOrderReference(CouponOrderKeyType orderReference) {
                this.orderReference = orderReference;
            }

            /** 
             * Get the 'Commission' element value. Commission information.
             * 
             * @return value
             */
            public CommissionType getCommission() {
                return commission;
            }

            /** 
             * Set the 'Commission' element value. Commission information.
             * 
             * @param commission
             */
            public void setCommission(CommissionType commission) {
                this.commission = commission;
            }

            /** 
             * Get the 'CarrierFeeInfo' element value.
             * 
             * @return value
             */
            public CarrierFeeInfoType getCarrierFeeInfo() {
                return carrierFeeInfo;
            }

            /** 
             * Set the 'CarrierFeeInfo' element value.
             * 
             * @param carrierFeeInfo
             */
            public void setCarrierFeeInfo(CarrierFeeInfoType carrierFeeInfo) {
                this.carrierFeeInfo = carrierFeeInfo;
            }

            /** 
             * Get the 'OriginalIssueInfo' element value.
             * 
             * @return value
             */
            public OriginalIssueType getOriginalIssueInfo() {
                return originalIssueInfo;
            }

            /** 
             * Set the 'OriginalIssueInfo' element value.
             * 
             * @param originalIssueInfo
             */
            public void setOriginalIssueInfo(OriginalIssueType originalIssueInfo) {
                this.originalIssueInfo = originalIssueInfo;
            }

            /** 
             * Get the 'PricingInfo' element value.
             * 
             * @return value
             */
            public PricingInfoType getPricingInfo() {
                return pricingInfo;
            }

            /** 
             * Set the 'PricingInfo' element value.
             * 
             * @param pricingInfo
             */
            public void setPricingInfo(PricingInfoType pricingInfo) {
                this.pricingInfo = pricingInfo;
            }
            /** 
             * Booking and Servicing Agent information.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AgentIDs" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element ref="ns:AgentID" maxOccurs="2"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class AgentIDs implements Serializable
            {
                private List<CouponAgentType> agentIDList = new ArrayList<CouponAgentType>();

                /** 
                 * Get the list of 'AgentID' element items.
                 * 
                 * @return list
                 */
                public List<CouponAgentType> getAgentIDList() {
                    return agentIDList;
                }

                /** 
                 * Set the list of 'AgentID' element items.
                 * 
                 * @param list
                 */
                public void setAgentIDList(List<CouponAgentType> list) {
                    agentIDList = list;
                }
            }
            /** 
             * Payment information.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Payments" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="ns:PaymentMethodType" name="Payment" maxOccurs="unbounded"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Payments implements Serializable
            {
                private List<PaymentMethodType> paymentList = new ArrayList<PaymentMethodType>();

                /** 
                 * Get the list of 'Payment' element items. Payment detail.
                 * 
                 * @return list
                 */
                public List<PaymentMethodType> getPaymentList() {
                    return paymentList;
                }

                /** 
                 * Set the list of 'Payment' element items. Payment detail.
                 * 
                 * @param list
                 */
                public void setPaymentList(List<PaymentMethodType> list) {
                    paymentList = list;
                }
            }
            /** 
             * Origin and Destination Airport/ City.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginDestination" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="Origin"/>
             *       &lt;xs:element type="xs:string" name="Destination"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class OriginDestination implements Serializable
            {
                private String origin;
                private String destination;

                /** 
                 * Get the 'Origin' element value. The origin city code.
                 * 
                 * @return value
                 */
                public String getOrigin() {
                    return origin;
                }

                /** 
                 * Set the 'Origin' element value. The origin city code.
                 * 
                 * @param origin
                 */
                public void setOrigin(String origin) {
                    this.origin = origin;
                }

                /** 
                 * Get the 'Destination' element value. The destination city code.
                 * 
                 * @return value
                 */
                public String getDestination() {
                    return destination;
                }

                /** 
                 * Set the 'Destination' element value. The destination city code.
                 * 
                 * @param destination
                 */
                public void setDestination(String destination) {
                    this.destination = destination;
                }
            }
            /** 
             * Additional Reference information.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AddlReferenceIDs" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element ref="ns:AddlReferenceID" maxOccurs="5"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class AddlReferenceIDs implements Serializable
            {
                private List<AdditionalReferenceType> addlReferenceIDList = new ArrayList<AdditionalReferenceType>();

                /** 
                 * Get the list of 'AddlReferenceID' element items.
                 * 
                 * @return list
                 */
                public List<AdditionalReferenceType> getAddlReferenceIDList() {
                    return addlReferenceIDList;
                }

                /** 
                 * Set the list of 'AddlReferenceID' element items.
                 * 
                 * @param list
                 */
                public void setAddlReferenceIDList(
                        List<AdditionalReferenceType> list) {
                    addlReferenceIDList = list;
                }
            }
            /** 
             * Fare Information
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareInfo" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element ref="ns:BaseFare" minOccurs="0" maxOccurs="3"/>
             *       &lt;xs:element ref="ns:EquivFare" minOccurs="0" maxOccurs="3"/>
             *       &lt;xs:element ref="ns:Total" minOccurs="0" maxOccurs="3"/>
             *       &lt;xs:element type="ns:TaxDetailType" name="Taxes" minOccurs="0"/>
             *       &lt;xs:element ref="ns:UnstructuredFareCalcInfo" minOccurs="0" maxOccurs="3"/>
             *       &lt;xs:element ref="ns:FareInfo" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class FareInfo implements Serializable
            {
                private List<BaseFareTransactionType> baseFareList = new ArrayList<BaseFareTransactionType>();
                private List<EquivFareTransactionType> equivFareList = new ArrayList<EquivFareTransactionType>();
                private List<TotalFareTransactionType> totalList = new ArrayList<TotalFareTransactionType>();
                private TaxDetailType taxes;
                private List<UnstructuredFareCalcType> unstructuredFareCalcInfoList = new ArrayList<UnstructuredFareCalcType>();
                private ETFareInfoType fareInfo;

                /** 
                 * Get the list of 'BaseFare' element items.
                 * 
                 * @return list
                 */
                public List<BaseFareTransactionType> getBaseFareList() {
                    return baseFareList;
                }

                /** 
                 * Set the list of 'BaseFare' element items.
                 * 
                 * @param list
                 */
                public void setBaseFareList(List<BaseFareTransactionType> list) {
                    baseFareList = list;
                }

                /** 
                 * Get the list of 'EquivFare' element items.
                 * 
                 * @return list
                 */
                public List<EquivFareTransactionType> getEquivFareList() {
                    return equivFareList;
                }

                /** 
                 * Set the list of 'EquivFare' element items.
                 * 
                 * @param list
                 */
                public void setEquivFareList(List<EquivFareTransactionType> list) {
                    equivFareList = list;
                }

                /** 
                 * Get the list of 'Total' element items.
                 * 
                 * @return list
                 */
                public List<TotalFareTransactionType> getTotalList() {
                    return totalList;
                }

                /** 
                 * Set the list of 'Total' element items.
                 * 
                 * @param list
                 */
                public void setTotalList(List<TotalFareTransactionType> list) {
                    totalList = list;
                }

                /** 
                 * Get the 'Taxes' element value. Fare Tax information.
                 * 
                 * @return value
                 */
                public TaxDetailType getTaxes() {
                    return taxes;
                }

                /** 
                 * Set the 'Taxes' element value. Fare Tax information.
                 * 
                 * @param taxes
                 */
                public void setTaxes(TaxDetailType taxes) {
                    this.taxes = taxes;
                }

                /** 
                 * Get the list of 'UnstructuredFareCalcInfo' element items.
                 * 
                 * @return list
                 */
                public List<UnstructuredFareCalcType> getUnstructuredFareCalcInfoList() {
                    return unstructuredFareCalcInfoList;
                }

                /** 
                 * Set the list of 'UnstructuredFareCalcInfo' element items.
                 * 
                 * @param list
                 */
                public void setUnstructuredFareCalcInfoList(
                        List<UnstructuredFareCalcType> list) {
                    unstructuredFareCalcInfoList = list;
                }

                /** 
                 * Get the 'FareInfo' element value.
                 * 
                 * @return value
                 */
                public ETFareInfoType getFareInfo() {
                    return fareInfo;
                }

                /** 
                 * Set the 'FareInfo' element value.
                 * 
                 * @param fareInfo
                 */
                public void setFareInfo(ETFareInfoType fareInfo) {
                    this.fareInfo = fareInfo;
                }
            }
        }
    }
}
