
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * The OrderChange/ OrderView transaction set requests modifications to an Order by specifying which order items to change and what to change them to. The updated view of the Order is returned.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OrderChangeRQ">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element ref="ns:PointOfSale" minOccurs="0"/>
 *       &lt;xs:element ref="ns:Document"/>
 *       &lt;xs:element ref="ns:Party"/>
 *       &lt;xs:element ref="ns:OrderChangeParameters" minOccurs="0"/>
 *       &lt;xs:element name="Query">
 *         &lt;xs:complexType>
 *           &lt;xs:sequence>
 *             &lt;xs:element name="Passengers" minOccurs="0">
 *               &lt;!-- Reference to inner class Passengers -->
 *             &lt;/xs:element>
 *             &lt;xs:element name="Order">
 *               &lt;xs:complexType>
 *                 &lt;xs:complexContent>
 *                   &lt;xs:extension base="ns:OrderCoreChangeType">
 *                     &lt;xs:sequence>
 *                       &lt;xs:element type="ns:OrderItemRepriceType" name="OrderItems"/>
 *                     &lt;/xs:sequence>
 *                   &lt;/xs:extension>
 *                 &lt;/xs:complexContent>
 *               &lt;/xs:complexType>
 *             &lt;/xs:element>
 *             &lt;xs:element name="Payments" minOccurs="0">
 *               &lt;!-- Reference to inner class Payments -->
 *             &lt;/xs:element>
 *             &lt;xs:element ref="ns:BookingReferences" minOccurs="0"/>
 *             &lt;xs:element ref="ns:OrderChangeMetadata" minOccurs="0"/>
 *           &lt;/xs:sequence>
 *         &lt;/xs:complexType>
 *       &lt;/xs:element>
 *       &lt;xs:element type="ns:DataListType" name="DataList" minOccurs="0"/>
 *     &lt;/xs:sequence>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class OrderChangeRQ implements Serializable
{
    private PointOfSaleType pointOfSale;
    private MsgDocumentType document;
    private MsgPartiesType party;
    private OrdChangeParamsType orderChangeParameters;
    private Passengers passengers;
    private OrderCoreChangeType queryOrderOrderCoreChangeType;
    private OrderItemRepriceType queryOrderOrderItems;
    private Payments payments;
    private BookingReferences queryBookingReferences;
    private OrdChangeMetadataType queryOrderChangeMetadata;
    private DataListType dataList;

    /** 
     * Get the 'PointOfSale' element value.
     * 
     * @return value
     */
    public PointOfSaleType getPointOfSale() {
        return pointOfSale;
    }

    /** 
     * Set the 'PointOfSale' element value.
     * 
     * @param pointOfSale
     */
    public void setPointOfSale(PointOfSaleType pointOfSale) {
        this.pointOfSale = pointOfSale;
    }

    /** 
     * Get the 'Document' element value.
     * 
     * @return value
     */
    public MsgDocumentType getDocument() {
        return document;
    }

    /** 
     * Set the 'Document' element value.
     * 
     * @param document
     */
    public void setDocument(MsgDocumentType document) {
        this.document = document;
    }

    /** 
     * Get the 'Party' element value.
     * 
     * @return value
     */
    public MsgPartiesType getParty() {
        return party;
    }

    /** 
     * Set the 'Party' element value.
     * 
     * @param party
     */
    public void setParty(MsgPartiesType party) {
        this.party = party;
    }

    /** 
     * Get the 'OrderChangeParameters' element value.
     * 
     * @return value
     */
    public OrdChangeParamsType getOrderChangeParameters() {
        return orderChangeParameters;
    }

    /** 
     * Set the 'OrderChangeParameters' element value.
     * 
     * @param orderChangeParameters
     */
    public void setOrderChangeParameters(
            OrdChangeParamsType orderChangeParameters) {
        this.orderChangeParameters = orderChangeParameters;
    }

    /** 
     * Get the 'Passengers' element value. Order Change Query.
     * 
     * @return value
     */
    public Passengers getPassengers() {
        return passengers;
    }

    /** 
     * Set the 'Passengers' element value. Order Change Query.
     * 
     * @param passengers
     */
    public void setPassengers(Passengers passengers) {
        this.passengers = passengers;
    }

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public OrderCoreChangeType getQueryOrderOrderCoreChangeType() {
        return queryOrderOrderCoreChangeType;
    }

    /** 
     * Set the extension value.
     * 
     * @param queryOrderOrderCoreChangeType
     */
    public void setQueryOrderOrderCoreChangeType(
            OrderCoreChangeType queryOrderOrderCoreChangeType) {
        this.queryOrderOrderCoreChangeType = queryOrderOrderCoreChangeType;
    }

    /** 
     * Get the 'OrderItems' element value. Order Item Detail.
     * 
     * @return value
     */
    public OrderItemRepriceType getQueryOrderOrderItems() {
        return queryOrderOrderItems;
    }

    /** 
     * Set the 'OrderItems' element value. Order Item Detail.
     * 
     * @param queryOrderOrderItems
     */
    public void setQueryOrderOrderItems(
            OrderItemRepriceType queryOrderOrderItems) {
        this.queryOrderOrderItems = queryOrderOrderItems;
    }

    /** 
     * Get the 'Payments' element value. Order Change Query.
     * 
     * @return value
     */
    public Payments getPayments() {
        return payments;
    }

    /** 
     * Set the 'Payments' element value. Order Change Query.
     * 
     * @param payments
     */
    public void setPayments(Payments payments) {
        this.payments = payments;
    }

    /** 
     * Get the 'BookingReferences' element value. Existing Booking Reference (e.g. PNR Record Locator). Example: R1A3SK
     * 
     * @return value
     */
    public BookingReferences getQueryBookingReferences() {
        return queryBookingReferences;
    }

    /** 
     * Set the 'BookingReferences' element value. Existing Booking Reference (e.g. PNR Record Locator). Example: R1A3SK
     * 
     * @param queryBookingReferences
     */
    public void setQueryBookingReferences(
            BookingReferences queryBookingReferences) {
        this.queryBookingReferences = queryBookingReferences;
    }

    /** 
     * Get the 'OrderChangeMetadata' element value.
     * 
     * @return value
     */
    public OrdChangeMetadataType getQueryOrderChangeMetadata() {
        return queryOrderChangeMetadata;
    }

    /** 
     * Set the 'OrderChangeMetadata' element value.
     * 
     * @param queryOrderChangeMetadata
     */
    public void setQueryOrderChangeMetadata(
            OrdChangeMetadataType queryOrderChangeMetadata) {
        this.queryOrderChangeMetadata = queryOrderChangeMetadata;
    }

    /** 
     * Get the 'DataList' element value.
     * 
     * @return value
     */
    public DataListType getDataList() {
        return dataList;
    }

    /** 
     * Set the 'DataList' element value.
     * 
     * @param dataList
     */
    public void setDataList(DataListType dataList) {
        this.dataList = dataList;
    }
    /** 
     * Passenger and Group information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Passengers" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Passenger" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class Passenger -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="Group" minOccurs="0">
     *         &lt;!-- Reference to inner class Group -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Passengers implements Serializable
    {
        private List<Passenger> passengerList = new ArrayList<Passenger>();
        private Group group;

        /** 
         * Get the list of 'Passenger' element items.
         * 
         * @return list
         */
        public List<Passenger> getPassengerList() {
            return passengerList;
        }

        /** 
         * Set the list of 'Passenger' element items.
         * 
         * @param list
         */
        public void setPassengerList(List<Passenger> list) {
            passengerList = list;
        }

        /** 
         * Get the 'Group' element value.
         * 
         * @return value
         */
        public Group getGroup() {
            return group;
        }

        /** 
         * Set the 'Group' element value.
         * 
         * @param group
         */
        public void setGroup(Group group) {
            this.group = group;
        }
        /** 
         * Passenger and Action.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Passenger" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:complexContent>
         *       &lt;xs:extension base="ns:PassengerSummaryType">
         *         &lt;xs:sequence>
         *           &lt;xs:element name="ActionType" minOccurs="0">
         *             &lt;!-- Reference to inner class ActionType -->
         *           &lt;/xs:element>
         *           &lt;xs:element name="AdditionalRoles" minOccurs="0">
         *             &lt;!-- Reference to inner class AdditionalRoles -->
         *           &lt;/xs:element>
         *         &lt;/xs:sequence>
         *       &lt;/xs:extension>
         *     &lt;/xs:complexContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Passenger extends PassengerSummaryType implements
            Serializable
        {
            private ActionType actionType;
            private AdditionalRoles additionalRoles;

            /** 
             * Get the 'ActionType' element value.
             * 
             * @return value
             */
            public ActionType getActionType() {
                return actionType;
            }

            /** 
             * Set the 'ActionType' element value.
             * 
             * @param actionType
             */
            public void setActionType(ActionType actionType) {
                this.actionType = actionType;
            }

            /** 
             * Get the 'AdditionalRoles' element value.
             * 
             * @return value
             */
            public AdditionalRoles getAdditionalRoles() {
                return additionalRoles;
            }

            /** 
             * Set the 'AdditionalRoles' element value.
             * 
             * @param additionalRoles
             */
            public void setAdditionalRoles(AdditionalRoles additionalRoles) {
                this.additionalRoles = additionalRoles;
            }
            /** 
             * Order Action. Examples: Cancel, Create, Divide, Delete, Reissue, Reprice, Update
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ActionType" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:string">
             *         &lt;xs:attribute type="xs:string" use="optional" name="Context"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class ActionType implements Serializable
            {
                private String string;
                private String context;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public String getString() {
                    return string;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param string
                 */
                public void setString(String string) {
                    this.string = string;
                }

                /** 
                 * Get the 'Context' attribute value. Action Type Context.
                 * 
                 * @return value
                 */
                public String getContext() {
                    return context;
                }

                /** 
                 * Set the 'Context' attribute value. Action Type Context.
                 * 
                 * @param context
                 */
                public void setContext(String context) {
                    this.context = context;
                }
            }
            /** 
             * Additional Passenger Role(s), including Primary Contact and Payment Contact.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AdditionalRoles" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:boolean" use="optional" name="PrimaryContactInd"/>
             *     &lt;xs:attribute type="xs:boolean" use="optional" name="PaymentContactInd"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class AdditionalRoles implements Serializable
            {
                private Boolean primaryContactInd;
                private Boolean paymentContactInd;

                /** 
                 * Get the 'PrimaryContactInd' attribute value. When TRUE, this person is a PRIMARY CONTACT, e.g. for a group, for an order, for an itinerary, etc.
                 * 
                 * @return value
                 */
                public Boolean getPrimaryContactInd() {
                    return primaryContactInd;
                }

                /** 
                 * Set the 'PrimaryContactInd' attribute value. When TRUE, this person is a PRIMARY CONTACT, e.g. for a group, for an order, for an itinerary, etc.
                 * 
                 * @param primaryContactInd
                 */
                public void setPrimaryContactInd(Boolean primaryContactInd) {
                    this.primaryContactInd = primaryContactInd;
                }

                /** 
                 * Get the 'PaymentContactInd' attribute value. When TRUE, this Passenger is responsible for payment.
                 * 
                 * @return value
                 */
                public Boolean getPaymentContactInd() {
                    return paymentContactInd;
                }

                /** 
                 * Set the 'PaymentContactInd' attribute value. When TRUE, this Passenger is responsible for payment.
                 * 
                 * @param paymentContactInd
                 */
                public void setPaymentContactInd(Boolean paymentContactInd) {
                    this.paymentContactInd = paymentContactInd;
                }
            }
        }
        /** 
         * Group and Action.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Group" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:complexContent>
         *       &lt;xs:extension base="ns:GroupType">
         *         &lt;xs:sequence>
         *           &lt;xs:element name="ActionType" minOccurs="0">
         *             &lt;!-- Reference to inner class ActionType -->
         *           &lt;/xs:element>
         *         &lt;/xs:sequence>
         *       &lt;/xs:extension>
         *     &lt;/xs:complexContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Group extends GroupType implements Serializable
        {
            private ActionType actionType;

            /** 
             * Get the 'ActionType' element value.
             * 
             * @return value
             */
            public ActionType getActionType() {
                return actionType;
            }

            /** 
             * Set the 'ActionType' element value.
             * 
             * @param actionType
             */
            public void setActionType(ActionType actionType) {
                this.actionType = actionType;
            }
            /** 
             * Order Action. Examples: Cancel, Create, Divide, Delete, Reissue, Reprice, Update
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ActionType" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:string">
             *         &lt;xs:attribute type="xs:string" use="optional" name="Context"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class ActionType implements Serializable
            {
                private String string;
                private String context;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public String getString() {
                    return string;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param string
                 */
                public void setString(String string) {
                    this.string = string;
                }

                /** 
                 * Get the 'Context' attribute value. Action Type Context.
                 * 
                 * @return value
                 */
                public String getContext() {
                    return context;
                }

                /** 
                 * Set the 'Context' attribute value. Action Type Context.
                 * 
                 * @param context
                 */
                public void setContext(String context) {
                    this.context = context;
                }
            }
        }
    }
    /** 
     * Payment information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Payments" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Payment" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class Payment -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Payments implements Serializable
    {
        private List<Payment> paymentList = new ArrayList<Payment>();

        /** 
         * Get the list of 'Payment' element items.
         * 
         * @return list
         */
        public List<Payment> getPaymentList() {
            return paymentList;
        }

        /** 
         * Set the list of 'Payment' element items.
         * 
         * @param list
         */
        public void setPaymentList(List<Payment> list) {
            paymentList = list;
        }
        /** 
         * Payment detail, including association(s).
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Payment" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:complexContent>
         *       &lt;xs:extension base="ns:OrderPaymentFormType">
         *         &lt;xs:sequence>
         *           &lt;xs:element name="ActionType" minOccurs="0">
         *             &lt;!-- Reference to inner class ActionType -->
         *           &lt;/xs:element>
         *         &lt;/xs:sequence>
         *       &lt;/xs:extension>
         *     &lt;/xs:complexContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Payment extends OrderPaymentFormType implements
            Serializable
        {
            private ActionType actionType;

            /** 
             * Get the 'ActionType' element value.
             * 
             * @return value
             */
            public ActionType getActionType() {
                return actionType;
            }

            /** 
             * Set the 'ActionType' element value.
             * 
             * @param actionType
             */
            public void setActionType(ActionType actionType) {
                this.actionType = actionType;
            }
            /** 
             * Order Action. Examples: Cancel, Create, Divide, Delete, Reissue, Reprice, Update
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ActionType" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:string">
             *         &lt;xs:attribute type="xs:string" use="optional" name="Context"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class ActionType implements Serializable
            {
                private String string;
                private String context;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public String getString() {
                    return string;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param string
                 */
                public void setString(String string) {
                    this.string = string;
                }

                /** 
                 * Get the 'Context' attribute value. Action Type Context.
                 * 
                 * @return value
                 */
                public String getContext() {
                    return context;
                }

                /** 
                 * Set the 'Context' attribute value. Action Type Context.
                 * 
                 * @param context
                 */
                public void setContext(String context) {
                    this.context = context;
                }
            }
        }
    }
}
