
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * CORE ORDER CHANGE definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OrderCoreChangeType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:KeyWithMetaObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element ref="ns:OrderID"/>
 *         &lt;xs:element type="xs:string" name="TotalOrderItemQuantity" minOccurs="0"/>
 *         &lt;xs:element type="ns:DetailCurrencyPriceType" name="TotalOrderPrice" minOccurs="0"/>
 *         &lt;xs:element type="ns:OrderTimeLimitsType" name="TimeLimits" minOccurs="0"/>
 *         &lt;xs:element name="Associations" minOccurs="0">
 *           &lt;!-- Reference to inner class Associations -->
 *         &lt;/xs:element>
 *         &lt;xs:element name="Details" minOccurs="0">
 *           &lt;!-- Reference to inner class Details -->
 *         &lt;/xs:element>
 *         &lt;xs:element name="ActionType" minOccurs="0">
 *           &lt;!-- Reference to inner class ActionType -->
 *         &lt;/xs:element>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class OrderCoreChangeType extends KeyWithMetaObjectBaseType implements
    Serializable
{
    private OrderIDType orderID;
    private String totalOrderItemQuantity;
    private DetailCurrencyPriceType totalOrderPrice;
    private OrderTimeLimitsType timeLimits;
    private Associations associations;
    private Details details;
    private ActionType actionType;

    /** 
     * Get the 'OrderID' element value.
     * 
     * @return value
     */
    public OrderIDType getOrderID() {
        return orderID;
    }

    /** 
     * Set the 'OrderID' element value.
     * 
     * @param orderID
     */
    public void setOrderID(OrderIDType orderID) {
        this.orderID = orderID;
    }

    /** 
     * Get the 'TotalOrderItemQuantity' element value. 
                  The total number of Order Items included in this Order. Example: 3
                
     * 
     * @return value
     */
    public String getTotalOrderItemQuantity() {
        return totalOrderItemQuantity;
    }

    /** 
     * Set the 'TotalOrderItemQuantity' element value. 
                  The total number of Order Items included in this Order. Example: 3
                
     * 
     * @param totalOrderItemQuantity
     */
    public void setTotalOrderItemQuantity(String totalOrderItemQuantity) {
        this.totalOrderItemQuantity = totalOrderItemQuantity;
    }

    /** 
     * Get the 'TotalOrderPrice' element value. 
                  Total Order Price. Example: 3400 USD Note: This is a sub-total of all associated Order Item prices.
                Currency, Redemption and Partial Pricing
     * 
     * @return value
     */
    public DetailCurrencyPriceType getTotalOrderPrice() {
        return totalOrderPrice;
    }

    /** 
     * Set the 'TotalOrderPrice' element value. 
                  Total Order Price. Example: 3400 USD Note: This is a sub-total of all associated Order Item prices.
                Currency, Redemption and Partial Pricing
     * 
     * @param totalOrderPrice
     */
    public void setTotalOrderPrice(DetailCurrencyPriceType totalOrderPrice) {
        this.totalOrderPrice = totalOrderPrice;
    }

    /** 
     * Get the 'TimeLimits' element value. Order-Level Time Limits.
     * 
     * @return value
     */
    public OrderTimeLimitsType getTimeLimits() {
        return timeLimits;
    }

    /** 
     * Set the 'TimeLimits' element value. Order-Level Time Limits.
     * 
     * @param timeLimits
     */
    public void setTimeLimits(OrderTimeLimitsType timeLimits) {
        this.timeLimits = timeLimits;
    }

    /** 
     * Get the 'Associations' element value.
     * 
     * @return value
     */
    public Associations getAssociations() {
        return associations;
    }

    /** 
     * Set the 'Associations' element value.
     * 
     * @param associations
     */
    public void setAssociations(Associations associations) {
        this.associations = associations;
    }

    /** 
     * Get the 'Details' element value.
     * 
     * @return value
     */
    public Details getDetails() {
        return details;
    }

    /** 
     * Set the 'Details' element value.
     * 
     * @param details
     */
    public void setDetails(Details details) {
        this.details = details;
    }

    /** 
     * Get the 'ActionType' element value.
     * 
     * @return value
     */
    public ActionType getActionType() {
        return actionType;
    }

    /** 
     * Set the 'ActionType' element value.
     * 
     * @param actionType
     */
    public void setActionType(ActionType actionType) {
        this.actionType = actionType;
    }
    /** 
     * Order Association(s).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Associations" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element ref="ns:OrderItemID" minOccurs="0" maxOccurs="unbounded"/>
     *       &lt;xs:element name="Passengers" minOccurs="0">
     *         &lt;!-- Reference to inner class Passengers -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="OtherAssociation" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class OtherAssociation -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Associations implements Serializable
    {
        private List<OrderItemID> orderItemIDList = new ArrayList<OrderItemID>();
        private Passengers passengers;
        private List<OtherAssociation> otherAssociationList = new ArrayList<OtherAssociation>();

        /** 
         * Get the list of 'OrderItemID' element items. Associated Order Item ID(s). Example: ORD7333-001
         * 
         * @return list
         */
        public List<OrderItemID> getOrderItemIDList() {
            return orderItemIDList;
        }

        /** 
         * Set the list of 'OrderItemID' element items. Associated Order Item ID(s). Example: ORD7333-001
         * 
         * @param list
         */
        public void setOrderItemIDList(List<OrderItemID> list) {
            orderItemIDList = list;
        }

        /** 
         * Get the 'Passengers' element value.
         * 
         * @return value
         */
        public Passengers getPassengers() {
            return passengers;
        }

        /** 
         * Set the 'Passengers' element value.
         * 
         * @param passengers
         */
        public void setPassengers(Passengers passengers) {
            this.passengers = passengers;
        }

        /** 
         * Get the list of 'OtherAssociation' element items.
         * 
         * @return list
         */
        public List<OtherAssociation> getOtherAssociationList() {
            return otherAssociationList;
        }

        /** 
         * Set the list of 'OtherAssociation' element items.
         * 
         * @param list
         */
        public void setOtherAssociationList(List<OtherAssociation> list) {
            otherAssociationList = list;
        }
        /** 
         * 
                          Passenger(s)/ Group associated with the Offer Item. Note: This contains references to Passenger and Group instance(s) defined in the Passengers node.
                        
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Passengers" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:choice>
         *       &lt;xs:element ref="ns:PassengerReferences"/>
         *       &lt;xs:element ref="ns:GroupReference"/>
         *     &lt;/xs:choice>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Passengers implements Serializable
        {
            private int passengersSelect = -1;
            private static final int PASSENGER_REFERENCES_CHOICE = 0;
            private static final int GROUP_REFERENCE_CHOICE = 1;
            private PassengerReferences passengerReferences;
            private GroupReference groupReference;

            private void setPassengersSelect(int choice) {
                if (passengersSelect == -1) {
                    passengersSelect = choice;
                } else if (passengersSelect != choice) {
                    throw new IllegalStateException(
                            "Need to call clearPassengersSelect() before changing existing choice");
                }
            }

            /** 
             * Clear the choice selection.
             */
            public void clearPassengersSelect() {
                passengersSelect = -1;
            }

            /** 
             * Check if PassengerReferences is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifPassengerReferences() {
                return passengersSelect == PASSENGER_REFERENCES_CHOICE;
            }

            /** 
             * Get the 'PassengerReferences' element value. 
                                  Association to multiple Passenger instance(s). Example: pax1 pax2
                                
             * 
             * @return value
             */
            public PassengerReferences getPassengerReferences() {
                return passengerReferences;
            }

            /** 
             * Set the 'PassengerReferences' element value. 
                                  Association to multiple Passenger instance(s). Example: pax1 pax2
                                
             * 
             * @param passengerReferences
             */
            public void setPassengerReferences(
                    PassengerReferences passengerReferences) {
                setPassengersSelect(PASSENGER_REFERENCES_CHOICE);
                this.passengerReferences = passengerReferences;
            }

            /** 
             * Check if GroupReference is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifGroupReference() {
                return passengersSelect == GROUP_REFERENCE_CHOICE;
            }

            /** 
             * Get the 'GroupReference' element value.
             * 
             * @return value
             */
            public GroupReference getGroupReference() {
                return groupReference;
            }

            /** 
             * Set the 'GroupReference' element value.
             * 
             * @param groupReference
             */
            public void setGroupReference(GroupReference groupReference) {
                setPassengersSelect(GROUP_REFERENCE_CHOICE);
                this.groupReference = groupReference;
            }
        }
        /** 
         * 
                          Other Named Association(s). Note: Includes an association type choice (e.g. MediaGroup) and an instance association value (e.g. mediagrp1).
                        
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OtherAssociation" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="required" name="Type"/>
         *     &lt;xs:attribute type="xs:string" use="required" name="ReferenceValue"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class OtherAssociation implements Serializable
        {
            private String type;
            private String referenceValue;

            /** 
             * Get the 'Type' attribute value. 
                                Named Instance Association Type. Examples: CarryOnAllowance, MediaGroup
                              
             * 
             * @return value
             */
            public String getType() {
                return type;
            }

            /** 
             * Set the 'Type' attribute value. 
                                Named Instance Association Type. Examples: CarryOnAllowance, MediaGroup
                              
             * 
             * @param type
             */
            public void setType(String type) {
                this.type = type;
            }

            /** 
             * Get the 'ReferenceValue' attribute value. 
                                Associated object instance value. Example: mediagrp1
                              
             * 
             * @return value
             */
            public String getReferenceValue() {
                return referenceValue;
            }

            /** 
             * Set the 'ReferenceValue' attribute value. 
                                Associated object instance value. Example: mediagrp1
                              
             * 
             * @param referenceValue
             */
            public void setReferenceValue(String referenceValue) {
                this.referenceValue = referenceValue;
            }
        }
    }
    /** 
     * 
                  Order details, including original order ID and original shopping response ID.
                
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Details" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:OrderID_Type" name="OriginalOrderID" minOccurs="0"/>
     *       &lt;xs:element name="ShoppingResponse" minOccurs="0">
     *         &lt;!-- Reference to inner class ShoppingResponse -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="Amendments" minOccurs="0">
     *         &lt;!-- Reference to inner class Amendments -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Details implements Serializable
    {
        private OrderIDType originalOrderID;
        private ShoppingResponse shoppingResponse;
        private Amendments amendments;

        /** 
         * Get the 'OriginalOrderID' element value. 
                          The Original airline-assigned unique Order ID. Example: ORDER-q988-ac01-a20b Note: This may be used when an Order has been sub-divided into associated Orders (eg because a change creates non-homogeneity in a PNR), and serves as a cross reference for the original Order ID.
                        
         * 
         * @return value
         */
        public OrderIDType getOriginalOrderID() {
            return originalOrderID;
        }

        /** 
         * Set the 'OriginalOrderID' element value. 
                          The Original airline-assigned unique Order ID. Example: ORDER-q988-ac01-a20b Note: This may be used when an Order has been sub-divided into associated Orders (eg because a change creates non-homogeneity in a PNR), and serves as a cross reference for the original Order ID.
                        
         * 
         * @param originalOrderID
         */
        public void setOriginalOrderID(OrderIDType originalOrderID) {
            this.originalOrderID = originalOrderID;
        }

        /** 
         * Get the 'ShoppingResponse' element value.
         * 
         * @return value
         */
        public ShoppingResponse getShoppingResponse() {
            return shoppingResponse;
        }

        /** 
         * Set the 'ShoppingResponse' element value.
         * 
         * @param shoppingResponse
         */
        public void setShoppingResponse(ShoppingResponse shoppingResponse) {
            this.shoppingResponse = shoppingResponse;
        }

        /** 
         * Get the 'Amendments' element value.
         * 
         * @return value
         */
        public Amendments getAmendments() {
            return amendments;
        }

        /** 
         * Set the 'Amendments' element value.
         * 
         * @param amendments
         */
        public void setAmendments(Amendments amendments) {
            this.amendments = amendments;
        }
        /** 
         * Original Shopping Response ID(s), used to reference previously received shopping responses in order change transactions
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ShoppingResponse" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:complexContent>
         *       &lt;xs:extension base="ns:AssociatedObjectBaseType">
         *         &lt;xs:sequence>
         *           &lt;xs:element type="xs:string" name="Owner"/>
         *           &lt;xs:element name="ResponseID">
         *             &lt;xs:complexType>
         *               &lt;xs:simpleContent>
         *                 &lt;xs:extension base="xs:string">
         *                   &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
         *                 &lt;/xs:extension>
         *               &lt;/xs:simpleContent>
         *             &lt;/xs:complexType>
         *           &lt;/xs:element>
         *           &lt;xs:element type="ns:ItemID_Type" name="OfferID" minOccurs="0" maxOccurs="unbounded"/>
         *           &lt;xs:element name="OfferItems" minOccurs="0">
         *             &lt;!-- Reference to inner class OfferItems -->
         *           &lt;/xs:element>
         *         &lt;/xs:sequence>
         *       &lt;/xs:extension>
         *     &lt;/xs:complexContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * 
         * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
         *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
         * &lt;/xs:attributeGroup>
         * </pre>
         */
        public static class ShoppingResponse extends AssociatedObjectBaseType
            implements Serializable
        {
            private String owner;
            private String responseIDString;
            private String responseIDRefs;
            private List<ItemIDType> offerIDList = new ArrayList<ItemIDType>();
            private OfferItems offerItems;

            /** 
             * Get the 'Owner' element value. 
                                      Designator of Airline that owns/ assigned these IDs. Examples: BA Encoding Scheme: IATA/ A4A (two or three character) Airline Designator Code
                                    
             * 
             * @return value
             */
            public String getOwner() {
                return owner;
            }

            /** 
             * Set the 'Owner' element value. 
                                      Designator of Airline that owns/ assigned these IDs. Examples: BA Encoding Scheme: IATA/ A4A (two or three character) Airline Designator Code
                                    
             * 
             * @param owner
             */
            public void setOwner(String owner) {
                this.owner = owner;
            }

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getResponseIDString() {
                return responseIDString;
            }

            /** 
             * Set the extension value.
             * 
             * @param responseIDString
             */
            public void setResponseIDString(String responseIDString) {
                this.responseIDString = responseIDString;
            }

            /** 
             * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
             * 
             * @return value
             */
            public String getResponseIDRefs() {
                return responseIDRefs;
            }

            /** 
             * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
             * 
             * @param responseIDRefs
             */
            public void setResponseIDRefs(String responseIDRefs) {
                this.responseIDRefs = responseIDRefs;
            }

            /** 
             * Get the list of 'OfferID' element items. The airline-assigned unique Offer Item ID. Example: OFFER769-A850-4EC4-8F46-02293F72D7E6
             * 
             * @return list
             */
            public List<ItemIDType> getOfferIDList() {
                return offerIDList;
            }

            /** 
             * Set the list of 'OfferID' element items. The airline-assigned unique Offer Item ID. Example: OFFER769-A850-4EC4-8F46-02293F72D7E6
             * 
             * @param list
             */
            public void setOfferIDList(List<ItemIDType> list) {
                offerIDList = list;
            }

            /** 
             * Get the 'OfferItems' element value.
             * 
             * @return value
             */
            public OfferItems getOfferItems() {
                return offerItems;
            }

            /** 
             * Set the 'OfferItems' element value.
             * 
             * @param offerItems
             */
            public void setOfferItems(OfferItems offerItems) {
                this.offerItems = offerItems;
            }
            /** 
             * Associated Offer Item(s) and Optional Service(s).
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OfferItems" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="OfferItem" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class OfferItem -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class OfferItems implements Serializable
            {
                private List<OfferItem> offerItemList = new ArrayList<OfferItem>();

                /** 
                 * Get the list of 'OfferItem' element items.
                 * 
                 * @return list
                 */
                public List<OfferItem> getOfferItemList() {
                    return offerItemList;
                }

                /** 
                 * Set the list of 'OfferItem' element items.
                 * 
                 * @param list
                 */
                public void setOfferItemList(List<OfferItem> list) {
                    offerItemList = list;
                }
                /** 
                 * Offer Item ID with optional Service ID(s).
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OfferItem" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:complexContent>
                 *       &lt;xs:extension base="ns:AssociatedObjectBaseType">
                 *         &lt;xs:sequence>
                 *           &lt;xs:element ref="ns:OfferItemID"/>
                 *           &lt;xs:element ref="ns:ServiceID" minOccurs="0" maxOccurs="unbounded"/>
                 *         &lt;/xs:sequence>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:complexContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class OfferItem extends AssociatedObjectBaseType
                    implements Serializable
                {
                    private OfferItemID offerItemID;
                    private List<ServiceIDType> serviceIDList = new ArrayList<ServiceIDType>();

                    /** 
                     * Get the 'OfferItemID' element value.
                     * 
                     * @return value
                     */
                    public OfferItemID getOfferItemID() {
                        return offerItemID;
                    }

                    /** 
                     * Set the 'OfferItemID' element value.
                     * 
                     * @param offerItemID
                     */
                    public void setOfferItemID(OfferItemID offerItemID) {
                        this.offerItemID = offerItemID;
                    }

                    /** 
                     * Get the list of 'ServiceID' element items.
                     * 
                     * @return list
                     */
                    public List<ServiceIDType> getServiceIDList() {
                        return serviceIDList;
                    }

                    /** 
                     * Set the list of 'ServiceID' element items.
                     * 
                     * @param list
                     */
                    public void setServiceIDList(List<ServiceIDType> list) {
                        serviceIDList = list;
                    }
                }
            }
        }
        /** 
         * Order Amendment information.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Amendments" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Amendment" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class Amendment -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Amendments implements Serializable
        {
            private List<Amendment> amendmentList = new ArrayList<Amendment>();

            /** 
             * Get the list of 'Amendment' element items.
             * 
             * @return list
             */
            public List<Amendment> getAmendmentList() {
                return amendmentList;
            }

            /** 
             * Set the list of 'Amendment' element items.
             * 
             * @param list
             */
            public void setAmendmentList(List<Amendment> list) {
                amendmentList = list;
            }
            /** 
             * Amendment Detail.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Amendment" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="ActionType">
             *         &lt;xs:complexType>
             *           &lt;xs:simpleContent>
             *             &lt;xs:extension base="xs:string">
             *               &lt;xs:attribute type="xs:string" use="optional" name="Context"/>
             *             &lt;/xs:extension>
             *           &lt;/xs:simpleContent>
             *         &lt;/xs:complexType>
             *       &lt;/xs:element>
             *       &lt;xs:element name="TicketDocInfo" minOccurs="0">
             *         &lt;!-- Reference to inner class TicketDocInfo -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="OrderItem" minOccurs="0">
             *         &lt;!-- Reference to inner class OrderItem -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Amendment implements Serializable
            {
                private String actionTypeString;
                private String actionTypeContext;
                private TicketDocInfo ticketDocInfo;
                private OrderItem orderItem;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public String getActionTypeString() {
                    return actionTypeString;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param actionTypeString
                 */
                public void setActionTypeString(String actionTypeString) {
                    this.actionTypeString = actionTypeString;
                }

                /** 
                 * Get the 'Context' attribute value. Action Type Context.
                 * 
                 * @return value
                 */
                public String getActionTypeContext() {
                    return actionTypeContext;
                }

                /** 
                 * Set the 'Context' attribute value. Action Type Context.
                 * 
                 * @param actionTypeContext
                 */
                public void setActionTypeContext(String actionTypeContext) {
                    this.actionTypeContext = actionTypeContext;
                }

                /** 
                 * Get the 'TicketDocInfo' element value.
                 * 
                 * @return value
                 */
                public TicketDocInfo getTicketDocInfo() {
                    return ticketDocInfo;
                }

                /** 
                 * Set the 'TicketDocInfo' element value.
                 * 
                 * @param ticketDocInfo
                 */
                public void setTicketDocInfo(TicketDocInfo ticketDocInfo) {
                    this.ticketDocInfo = ticketDocInfo;
                }

                /** 
                 * Get the 'OrderItem' element value.
                 * 
                 * @return value
                 */
                public OrderItem getOrderItem() {
                    return orderItem;
                }

                /** 
                 * Set the 'OrderItem' element value.
                 * 
                 * @param orderItem
                 */
                public void setOrderItem(OrderItem orderItem) {
                    this.orderItem = orderItem;
                }
                /** 
                 * Ticket/document information.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TicketDocInfo" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="AgentIDs" minOccurs="0">
                 *         &lt;!-- Reference to inner class AgentIDs -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element ref="ns:IssuingAirlineInfo" minOccurs="0"/>
                 *       &lt;xs:element ref="ns:TicketDocument" maxOccurs="4"/>
                 *       &lt;xs:element ref="ns:CarrierFeeInfo" minOccurs="0"/>
                 *       &lt;xs:element ref="ns:OriginalIssueInfo" minOccurs="0"/>
                 *       &lt;xs:element name="Passengers" minOccurs="0">
                 *         &lt;!-- Reference to inner class Passengers -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class TicketDocInfo implements Serializable
                {
                    private AgentIDs agentIDs;
                    private AirlineIssuanceType issuingAirlineInfo;
                    private List<TicketDocument> ticketDocumentList = new ArrayList<TicketDocument>();
                    private CarrierFeeInfoType carrierFeeInfo;
                    private OriginalIssueType originalIssueInfo;
                    private Passengers passengers;

                    /** 
                     * Get the 'AgentIDs' element value.
                     * 
                     * @return value
                     */
                    public AgentIDs getAgentIDs() {
                        return agentIDs;
                    }

                    /** 
                     * Set the 'AgentIDs' element value.
                     * 
                     * @param agentIDs
                     */
                    public void setAgentIDs(AgentIDs agentIDs) {
                        this.agentIDs = agentIDs;
                    }

                    /** 
                     * Get the 'IssuingAirlineInfo' element value. Place of Issue of the agency or airline issuing the document followed by the name of the agency or airline issuing the document.
                     * 
                     * @return value
                     */
                    public AirlineIssuanceType getIssuingAirlineInfo() {
                        return issuingAirlineInfo;
                    }

                    /** 
                     * Set the 'IssuingAirlineInfo' element value. Place of Issue of the agency or airline issuing the document followed by the name of the agency or airline issuing the document.
                     * 
                     * @param issuingAirlineInfo
                     */
                    public void setIssuingAirlineInfo(
                            AirlineIssuanceType issuingAirlineInfo) {
                        this.issuingAirlineInfo = issuingAirlineInfo;
                    }

                    /** 
                     * Get the list of 'TicketDocument' element items.
                     * 
                     * @return list
                     */
                    public List<TicketDocument> getTicketDocumentList() {
                        return ticketDocumentList;
                    }

                    /** 
                     * Set the list of 'TicketDocument' element items.
                     * 
                     * @param list
                     */
                    public void setTicketDocumentList(List<TicketDocument> list) {
                        ticketDocumentList = list;
                    }

                    /** 
                     * Get the 'CarrierFeeInfo' element value.
                     * 
                     * @return value
                     */
                    public CarrierFeeInfoType getCarrierFeeInfo() {
                        return carrierFeeInfo;
                    }

                    /** 
                     * Set the 'CarrierFeeInfo' element value.
                     * 
                     * @param carrierFeeInfo
                     */
                    public void setCarrierFeeInfo(
                            CarrierFeeInfoType carrierFeeInfo) {
                        this.carrierFeeInfo = carrierFeeInfo;
                    }

                    /** 
                     * Get the 'OriginalIssueInfo' element value.
                     * 
                     * @return value
                     */
                    public OriginalIssueType getOriginalIssueInfo() {
                        return originalIssueInfo;
                    }

                    /** 
                     * Set the 'OriginalIssueInfo' element value.
                     * 
                     * @param originalIssueInfo
                     */
                    public void setOriginalIssueInfo(
                            OriginalIssueType originalIssueInfo) {
                        this.originalIssueInfo = originalIssueInfo;
                    }

                    /** 
                     * Get the 'Passengers' element value.
                     * 
                     * @return value
                     */
                    public Passengers getPassengers() {
                        return passengers;
                    }

                    /** 
                     * Set the 'Passengers' element value.
                     * 
                     * @param passengers
                     */
                    public void setPassengers(Passengers passengers) {
                        this.passengers = passengers;
                    }
                    /** 
                     * Booking and Servicing Agent information.
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AgentIDs" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element ref="ns:AgentID" maxOccurs="2"/>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class AgentIDs implements Serializable
                    {
                        private List<CouponAgentType> agentIDList = new ArrayList<CouponAgentType>();

                        /** 
                         * Get the list of 'AgentID' element items.
                         * 
                         * @return list
                         */
                        public List<CouponAgentType> getAgentIDList() {
                            return agentIDList;
                        }

                        /** 
                         * Set the list of 'AgentID' element items.
                         * 
                         * @param list
                         */
                        public void setAgentIDList(List<CouponAgentType> list) {
                            agentIDList = list;
                        }
                    }
                    /** 
                     * 
                                                  Passenger(s)/ Group associated with the Offer Item. Note: This contains references to Passenger and Group instance(s) defined in the Passengers node.
                                                
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Passengers" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:choice>
                     *       &lt;xs:element ref="ns:PassengerReferences"/>
                     *       &lt;xs:element ref="ns:GroupReference"/>
                     *     &lt;/xs:choice>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Passengers implements Serializable
                    {
                        private int passengersSelect = -1;
                        private static final int PASSENGER_REFERENCES_CHOICE = 0;
                        private static final int GROUP_REFERENCE_CHOICE = 1;
                        private PassengerReferences passengerReferences;
                        private GroupReference groupReference;

                        private void setPassengersSelect(int choice) {
                            if (passengersSelect == -1) {
                                passengersSelect = choice;
                            } else if (passengersSelect != choice) {
                                throw new IllegalStateException(
                                        "Need to call clearPassengersSelect() before changing existing choice");
                            }
                        }

                        /** 
                         * Clear the choice selection.
                         */
                        public void clearPassengersSelect() {
                            passengersSelect = -1;
                        }

                        /** 
                         * Check if PassengerReferences is current selection for choice.
                         * 
                         * @return <code>true</code> if selection, <code>false</code> if not
                         */
                        public boolean ifPassengerReferences() {
                            return passengersSelect == PASSENGER_REFERENCES_CHOICE;
                        }

                        /** 
                         * Get the 'PassengerReferences' element value. 
                                                          Association to multiple Passenger instance(s). Example: pax1 pax2
                                                        
                         * 
                         * @return value
                         */
                        public PassengerReferences getPassengerReferences() {
                            return passengerReferences;
                        }

                        /** 
                         * Set the 'PassengerReferences' element value. 
                                                          Association to multiple Passenger instance(s). Example: pax1 pax2
                                                        
                         * 
                         * @param passengerReferences
                         */
                        public void setPassengerReferences(
                                PassengerReferences passengerReferences) {
                            setPassengersSelect(PASSENGER_REFERENCES_CHOICE);
                            this.passengerReferences = passengerReferences;
                        }

                        /** 
                         * Check if GroupReference is current selection for choice.
                         * 
                         * @return <code>true</code> if selection, <code>false</code> if not
                         */
                        public boolean ifGroupReference() {
                            return passengersSelect == GROUP_REFERENCE_CHOICE;
                        }

                        /** 
                         * Get the 'GroupReference' element value.
                         * 
                         * @return value
                         */
                        public GroupReference getGroupReference() {
                            return groupReference;
                        }

                        /** 
                         * Set the 'GroupReference' element value.
                         * 
                         * @param groupReference
                         */
                        public void setGroupReference(
                                GroupReference groupReference) {
                            setPassengersSelect(GROUP_REFERENCE_CHOICE);
                            this.groupReference = groupReference;
                        }
                    }
                }
                /** 
                 * 
                                          Order Item ID with optional Offer Item ID(s) and Service ID(s).
                                        
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OrderItem" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:complexContent>
                 *       &lt;xs:extension base="ns:AssociatedObjectBaseType">
                 *         &lt;xs:sequence>
                 *           &lt;xs:element ref="ns:OrderItemID"/>
                 *           &lt;xs:element name="OfferItem" minOccurs="0">
                 *             &lt;!-- Reference to inner class OfferItem -->
                 *           &lt;/xs:element>
                 *           &lt;xs:element name="Passengers" minOccurs="0">
                 *             &lt;!-- Reference to inner class Passengers -->
                 *           &lt;/xs:element>
                 *           &lt;xs:element name="OtherAssociation" minOccurs="0" maxOccurs="unbounded">
                 *             &lt;!-- Reference to inner class OtherAssociation -->
                 *           &lt;/xs:element>
                 *         &lt;/xs:sequence>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:complexContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class OrderItem extends AssociatedObjectBaseType
                    implements Serializable
                {
                    private OrderItemID orderItemID;
                    private OfferItem offerItem;
                    private Passengers passengers;
                    private List<OtherAssociation> otherAssociationList = new ArrayList<OtherAssociation>();

                    /** 
                     * Get the 'OrderItemID' element value.
                     * 
                     * @return value
                     */
                    public OrderItemID getOrderItemID() {
                        return orderItemID;
                    }

                    /** 
                     * Set the 'OrderItemID' element value.
                     * 
                     * @param orderItemID
                     */
                    public void setOrderItemID(OrderItemID orderItemID) {
                        this.orderItemID = orderItemID;
                    }

                    /** 
                     * Get the 'OfferItem' element value.
                     * 
                     * @return value
                     */
                    public OfferItem getOfferItem() {
                        return offerItem;
                    }

                    /** 
                     * Set the 'OfferItem' element value.
                     * 
                     * @param offerItem
                     */
                    public void setOfferItem(OfferItem offerItem) {
                        this.offerItem = offerItem;
                    }

                    /** 
                     * Get the 'Passengers' element value.
                     * 
                     * @return value
                     */
                    public Passengers getPassengers() {
                        return passengers;
                    }

                    /** 
                     * Set the 'Passengers' element value.
                     * 
                     * @param passengers
                     */
                    public void setPassengers(Passengers passengers) {
                        this.passengers = passengers;
                    }

                    /** 
                     * Get the list of 'OtherAssociation' element items.
                     * 
                     * @return list
                     */
                    public List<OtherAssociation> getOtherAssociationList() {
                        return otherAssociationList;
                    }

                    /** 
                     * Set the list of 'OtherAssociation' element items.
                     * 
                     * @param list
                     */
                    public void setOtherAssociationList(
                            List<OtherAssociation> list) {
                        otherAssociationList = list;
                    }
                    /** 
                     * Offer Item ID with optional Service ID(s).
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OfferItem" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:complexContent>
                     *       &lt;xs:extension base="ns:AssociatedObjectBaseType">
                     *         &lt;xs:sequence>
                     *           &lt;xs:element ref="ns:OfferItemID"/>
                     *           &lt;xs:element name="Passengers" minOccurs="0">
                     *             &lt;!-- Reference to inner class Passengers -->
                     *           &lt;/xs:element>
                     *           &lt;xs:element name="Services" minOccurs="0">
                     *             &lt;!-- Reference to inner class Services -->
                     *           &lt;/xs:element>
                     *           &lt;xs:element name="OtherAssociation" minOccurs="0" maxOccurs="unbounded">
                     *             &lt;!-- Reference to inner class OtherAssociation -->
                     *           &lt;/xs:element>
                     *         &lt;/xs:sequence>
                     *       &lt;/xs:extension>
                     *     &lt;/xs:complexContent>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class OfferItem
                            extends
                                AssociatedObjectBaseType implements
                        Serializable
                    {
                        private OfferItemID offerItemID;
                        private Passengers passengers;
                        private Services services;
                        private List<OtherAssociation> otherAssociationList = new ArrayList<OtherAssociation>();

                        /** 
                         * Get the 'OfferItemID' element value.
                         * 
                         * @return value
                         */
                        public OfferItemID getOfferItemID() {
                            return offerItemID;
                        }

                        /** 
                         * Set the 'OfferItemID' element value.
                         * 
                         * @param offerItemID
                         */
                        public void setOfferItemID(OfferItemID offerItemID) {
                            this.offerItemID = offerItemID;
                        }

                        /** 
                         * Get the 'Passengers' element value.
                         * 
                         * @return value
                         */
                        public Passengers getPassengers() {
                            return passengers;
                        }

                        /** 
                         * Set the 'Passengers' element value.
                         * 
                         * @param passengers
                         */
                        public void setPassengers(Passengers passengers) {
                            this.passengers = passengers;
                        }

                        /** 
                         * Get the 'Services' element value.
                         * 
                         * @return value
                         */
                        public Services getServices() {
                            return services;
                        }

                        /** 
                         * Set the 'Services' element value.
                         * 
                         * @param services
                         */
                        public void setServices(Services services) {
                            this.services = services;
                        }

                        /** 
                         * Get the list of 'OtherAssociation' element items.
                         * 
                         * @return list
                         */
                        public List<OtherAssociation> getOtherAssociationList() {
                            return otherAssociationList;
                        }

                        /** 
                         * Set the list of 'OtherAssociation' element items.
                         * 
                         * @param list
                         */
                        public void setOtherAssociationList(
                                List<OtherAssociation> list) {
                            otherAssociationList = list;
                        }
                        /** 
                         * 
                                                                  Passenger(s)/ Group associated with the Offer Item. Note: This contains references to Passenger and Group instance(s) defined in the Passengers node.
                                                                
                         * 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Passengers" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:choice>
                         *       &lt;xs:element ref="ns:PassengerReferences"/>
                         *       &lt;xs:element ref="ns:GroupReference"/>
                         *     &lt;/xs:choice>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class Passengers implements Serializable
                        {
                            private int passengersSelect = -1;
                            private static final int PASSENGER_REFERENCES_CHOICE = 0;
                            private static final int GROUP_REFERENCE_CHOICE = 1;
                            private PassengerReferences passengerReferences;
                            private GroupReference groupReference;

                            private void setPassengersSelect(int choice) {
                                if (passengersSelect == -1) {
                                    passengersSelect = choice;
                                } else if (passengersSelect != choice) {
                                    throw new IllegalStateException(
                                            "Need to call clearPassengersSelect() before changing existing choice");
                                }
                            }

                            /** 
                             * Clear the choice selection.
                             */
                            public void clearPassengersSelect() {
                                passengersSelect = -1;
                            }

                            /** 
                             * Check if PassengerReferences is current selection for choice.
                             * 
                             * @return <code>true</code> if selection, <code>false</code> if not
                             */
                            public boolean ifPassengerReferences() {
                                return passengersSelect == PASSENGER_REFERENCES_CHOICE;
                            }

                            /** 
                             * Get the 'PassengerReferences' element value. 
                                                                          Association to multiple Passenger instance(s). Example: pax1 pax2
                                                                        
                             * 
                             * @return value
                             */
                            public PassengerReferences getPassengerReferences() {
                                return passengerReferences;
                            }

                            /** 
                             * Set the 'PassengerReferences' element value. 
                                                                          Association to multiple Passenger instance(s). Example: pax1 pax2
                                                                        
                             * 
                             * @param passengerReferences
                             */
                            public void setPassengerReferences(
                                    PassengerReferences passengerReferences) {
                                setPassengersSelect(PASSENGER_REFERENCES_CHOICE);
                                this.passengerReferences = passengerReferences;
                            }

                            /** 
                             * Check if GroupReference is current selection for choice.
                             * 
                             * @return <code>true</code> if selection, <code>false</code> if not
                             */
                            public boolean ifGroupReference() {
                                return passengersSelect == GROUP_REFERENCE_CHOICE;
                            }

                            /** 
                             * Get the 'GroupReference' element value.
                             * 
                             * @return value
                             */
                            public GroupReference getGroupReference() {
                                return groupReference;
                            }

                            /** 
                             * Set the 'GroupReference' element value.
                             * 
                             * @param groupReference
                             */
                            public void setGroupReference(
                                    GroupReference groupReference) {
                                setPassengersSelect(GROUP_REFERENCE_CHOICE);
                                this.groupReference = groupReference;
                            }
                        }
                        /** 
                         * Associated Optional Service(s).
                         * 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Services" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element ref="ns:ServiceID" maxOccurs="unbounded"/>
                         *       &lt;xs:element name="Passengers" minOccurs="0">
                         *         &lt;!-- Reference to inner class Passengers -->
                         *       &lt;/xs:element>
                         *     &lt;/xs:sequence>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class Services implements Serializable
                        {
                            private List<ServiceIDType> serviceIDList = new ArrayList<ServiceIDType>();
                            private Passengers passengers;

                            /** 
                             * Get the list of 'ServiceID' element items.
                             * 
                             * @return list
                             */
                            public List<ServiceIDType> getServiceIDList() {
                                return serviceIDList;
                            }

                            /** 
                             * Set the list of 'ServiceID' element items.
                             * 
                             * @param list
                             */
                            public void setServiceIDList(
                                    List<ServiceIDType> list) {
                                serviceIDList = list;
                            }

                            /** 
                             * Get the 'Passengers' element value.
                             * 
                             * @return value
                             */
                            public Passengers getPassengers() {
                                return passengers;
                            }

                            /** 
                             * Set the 'Passengers' element value.
                             * 
                             * @param passengers
                             */
                            public void setPassengers(Passengers passengers) {
                                this.passengers = passengers;
                            }
                            /** 
                             * 
                                                                          Passenger(s)/ Group associated with the Offer Item. Note: This contains references to Passenger and Group instance(s) defined in the Passengers node.
                                                                        
                             * 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Passengers" minOccurs="0">
                             *   &lt;xs:complexType>
                             *     &lt;xs:choice>
                             *       &lt;xs:element ref="ns:PassengerReferences"/>
                             *       &lt;xs:element ref="ns:GroupReference"/>
                             *     &lt;/xs:choice>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class Passengers implements
                                Serializable
                            {
                                private int passengersSelect = -1;
                                private static final int PASSENGER_REFERENCES_CHOICE = 0;
                                private static final int GROUP_REFERENCE_CHOICE = 1;
                                private PassengerReferences passengerReferences;
                                private GroupReference groupReference;

                                private void setPassengersSelect(int choice) {
                                    if (passengersSelect == -1) {
                                        passengersSelect = choice;
                                    } else if (passengersSelect != choice) {
                                        throw new IllegalStateException(
                                                "Need to call clearPassengersSelect() before changing existing choice");
                                    }
                                }

                                /** 
                                 * Clear the choice selection.
                                 */
                                public void clearPassengersSelect() {
                                    passengersSelect = -1;
                                }

                                /** 
                                 * Check if PassengerReferences is current selection for choice.
                                 * 
                                 * @return <code>true</code> if selection, <code>false</code> if not
                                 */
                                public boolean ifPassengerReferences() {
                                    return passengersSelect == PASSENGER_REFERENCES_CHOICE;
                                }

                                /** 
                                 * Get the 'PassengerReferences' element value. 
                                                                                  Association to multiple Passenger instance(s). Example: pax1 pax2
                                                                                
                                 * 
                                 * @return value
                                 */
                                public PassengerReferences getPassengerReferences() {
                                    return passengerReferences;
                                }

                                /** 
                                 * Set the 'PassengerReferences' element value. 
                                                                                  Association to multiple Passenger instance(s). Example: pax1 pax2
                                                                                
                                 * 
                                 * @param passengerReferences
                                 */
                                public void setPassengerReferences(
                                        PassengerReferences passengerReferences) {
                                    setPassengersSelect(PASSENGER_REFERENCES_CHOICE);
                                    this.passengerReferences = passengerReferences;
                                }

                                /** 
                                 * Check if GroupReference is current selection for choice.
                                 * 
                                 * @return <code>true</code> if selection, <code>false</code> if not
                                 */
                                public boolean ifGroupReference() {
                                    return passengersSelect == GROUP_REFERENCE_CHOICE;
                                }

                                /** 
                                 * Get the 'GroupReference' element value.
                                 * 
                                 * @return value
                                 */
                                public GroupReference getGroupReference() {
                                    return groupReference;
                                }

                                /** 
                                 * Set the 'GroupReference' element value.
                                 * 
                                 * @param groupReference
                                 */
                                public void setGroupReference(
                                        GroupReference groupReference) {
                                    setPassengersSelect(GROUP_REFERENCE_CHOICE);
                                    this.groupReference = groupReference;
                                }
                            }
                        }
                        /** 
                         * 
                                                                  Other Named Association(s). Note: Includes an association type choice (e.g. MediaGroup) and an instance association value (e.g. mediagrp1).
                                                                
                         * 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OtherAssociation" minOccurs="0" maxOccurs="unbounded">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="required" name="Type"/>
                         *     &lt;xs:attribute type="xs:string" use="required" name="ReferenceValue"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class OtherAssociation implements
                            Serializable
                        {
                            private String type;
                            private String referenceValue;

                            /** 
                             * Get the 'Type' attribute value. 
                                                                        Named Instance Association Type. Examples: CarryOnAllowance, MediaGroup
                                                                      
                             * 
                             * @return value
                             */
                            public String getType() {
                                return type;
                            }

                            /** 
                             * Set the 'Type' attribute value. 
                                                                        Named Instance Association Type. Examples: CarryOnAllowance, MediaGroup
                                                                      
                             * 
                             * @param type
                             */
                            public void setType(String type) {
                                this.type = type;
                            }

                            /** 
                             * Get the 'ReferenceValue' attribute value. 
                                                                        Associated object instance value. Example: mediagrp1
                                                                      
                             * 
                             * @return value
                             */
                            public String getReferenceValue() {
                                return referenceValue;
                            }

                            /** 
                             * Set the 'ReferenceValue' attribute value. 
                                                                        Associated object instance value. Example: mediagrp1
                                                                      
                             * 
                             * @param referenceValue
                             */
                            public void setReferenceValue(String referenceValue) {
                                this.referenceValue = referenceValue;
                            }
                        }
                    }
                    /** 
                     * 
                                                      Passenger(s)/ Group associated with the Offer Item. Note: This contains references to Passenger and Group instance(s) defined in the Passengers node.
                                                    
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Passengers" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:choice>
                     *       &lt;xs:element ref="ns:PassengerReferences"/>
                     *       &lt;xs:element ref="ns:GroupReference"/>
                     *     &lt;/xs:choice>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Passengers implements Serializable
                    {
                        private int passengersSelect = -1;
                        private static final int PASSENGER_REFERENCES_CHOICE = 0;
                        private static final int GROUP_REFERENCE_CHOICE = 1;
                        private PassengerReferences passengerReferences;
                        private GroupReference groupReference;

                        private void setPassengersSelect(int choice) {
                            if (passengersSelect == -1) {
                                passengersSelect = choice;
                            } else if (passengersSelect != choice) {
                                throw new IllegalStateException(
                                        "Need to call clearPassengersSelect() before changing existing choice");
                            }
                        }

                        /** 
                         * Clear the choice selection.
                         */
                        public void clearPassengersSelect() {
                            passengersSelect = -1;
                        }

                        /** 
                         * Check if PassengerReferences is current selection for choice.
                         * 
                         * @return <code>true</code> if selection, <code>false</code> if not
                         */
                        public boolean ifPassengerReferences() {
                            return passengersSelect == PASSENGER_REFERENCES_CHOICE;
                        }

                        /** 
                         * Get the 'PassengerReferences' element value. 
                                                              Association to multiple Passenger instance(s). Example: pax1 pax2
                                                            
                         * 
                         * @return value
                         */
                        public PassengerReferences getPassengerReferences() {
                            return passengerReferences;
                        }

                        /** 
                         * Set the 'PassengerReferences' element value. 
                                                              Association to multiple Passenger instance(s). Example: pax1 pax2
                                                            
                         * 
                         * @param passengerReferences
                         */
                        public void setPassengerReferences(
                                PassengerReferences passengerReferences) {
                            setPassengersSelect(PASSENGER_REFERENCES_CHOICE);
                            this.passengerReferences = passengerReferences;
                        }

                        /** 
                         * Check if GroupReference is current selection for choice.
                         * 
                         * @return <code>true</code> if selection, <code>false</code> if not
                         */
                        public boolean ifGroupReference() {
                            return passengersSelect == GROUP_REFERENCE_CHOICE;
                        }

                        /** 
                         * Get the 'GroupReference' element value.
                         * 
                         * @return value
                         */
                        public GroupReference getGroupReference() {
                            return groupReference;
                        }

                        /** 
                         * Set the 'GroupReference' element value.
                         * 
                         * @param groupReference
                         */
                        public void setGroupReference(
                                GroupReference groupReference) {
                            setPassengersSelect(GROUP_REFERENCE_CHOICE);
                            this.groupReference = groupReference;
                        }
                    }
                    /** 
                     * 
                                                      Other Named Association(s). Note: Includes an association type choice (e.g. MediaGroup) and an instance association value (e.g. mediagrp1).
                                                    
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OtherAssociation" minOccurs="0" maxOccurs="unbounded">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="required" name="Type"/>
                     *     &lt;xs:attribute type="xs:string" use="required" name="ReferenceValue"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class OtherAssociation implements
                        Serializable
                    {
                        private String type;
                        private String referenceValue;

                        /** 
                         * Get the 'Type' attribute value. 
                                                            Named Instance Association Type. Examples: CarryOnAllowance, MediaGroup
                                                          
                         * 
                         * @return value
                         */
                        public String getType() {
                            return type;
                        }

                        /** 
                         * Set the 'Type' attribute value. 
                                                            Named Instance Association Type. Examples: CarryOnAllowance, MediaGroup
                                                          
                         * 
                         * @param type
                         */
                        public void setType(String type) {
                            this.type = type;
                        }

                        /** 
                         * Get the 'ReferenceValue' attribute value. 
                                                            Associated object instance value. Example: mediagrp1
                                                          
                         * 
                         * @return value
                         */
                        public String getReferenceValue() {
                            return referenceValue;
                        }

                        /** 
                         * Set the 'ReferenceValue' attribute value. 
                                                            Associated object instance value. Example: mediagrp1
                                                          
                         * 
                         * @param referenceValue
                         */
                        public void setReferenceValue(String referenceValue) {
                            this.referenceValue = referenceValue;
                        }
                    }
                }
            }
        }
    }
    /** 
     * 
                  Order Action. Examples: Cancel, Create, Update, Delete, Reissue, Reprice
                
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ActionType" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:string">
     *         &lt;xs:attribute type="xs:string" use="optional" name="Context"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class ActionType implements Serializable
    {
        private String string;
        private String context;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getString() {
            return string;
        }

        /** 
         * Set the extension value.
         * 
         * @param string
         */
        public void setString(String string) {
            this.string = string;
        }

        /** 
         * Get the 'Context' attribute value. Action Type Context.
         * 
         * @return value
         */
        public String getContext() {
            return context;
        }

        /** 
         * Set the 'Context' attribute value. Action Type Context.
         * 
         * @param context
         */
        public void setContext(String context) {
            this.context = context;
        }
    }
}
