
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Order FARE DETAIL definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OrderFareDetailType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:KeyWithMetaObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:choice>
 *           &lt;xs:element ref="ns:FareComponent" maxOccurs="unbounded"/>
 *           &lt;xs:element type="ns:OrderFareRulesType" name="FareRules" minOccurs="0"/>
 *         &lt;/xs:choice>
 *         &lt;xs:element ref="ns:TourCode" minOccurs="0"/>
 *         &lt;xs:element ref="ns:Remarks" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class OrderFareDetailType extends KeyWithMetaObjectBaseType implements
    Serializable
{
    private int choiceSelect = -1;
    private static final int FARE_COMPONENT_LIST_CHOICE = 0;
    private static final int FARE_RULES_CHOICE = 1;
    private List<FareComponentType> fareComponentList = new ArrayList<FareComponentType>();
    private OrderFareRulesType fareRules;
    private TourCode tourCode;
    private Remarks remarks;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if FareComponentList is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifFareComponentList() {
        return choiceSelect == FARE_COMPONENT_LIST_CHOICE;
    }

    /** 
     * Get the list of 'FareComponent' element items. Fare Component information with Price Breakdown.
     * 
     * @return list
     */
    public List<FareComponentType> getFareComponentList() {
        return fareComponentList;
    }

    /** 
     * Set the list of 'FareComponent' element items. Fare Component information with Price Breakdown.
     * 
     * @param list
     */
    public void setFareComponentList(List<FareComponentType> list) {
        setChoiceSelect(FARE_COMPONENT_LIST_CHOICE);
        fareComponentList = list;
    }

    /** 
     * Check if FareRules is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifFareRules() {
        return choiceSelect == FARE_RULES_CHOICE;
    }

    /** 
     * Get the 'FareRules' element value. Fare Rules.
     * 
     * @return value
     */
    public OrderFareRulesType getFareRules() {
        return fareRules;
    }

    /** 
     * Set the 'FareRules' element value. Fare Rules.
     * 
     * @param fareRules
     */
    public void setFareRules(OrderFareRulesType fareRules) {
        setChoiceSelect(FARE_RULES_CHOICE);
        this.fareRules = fareRules;
    }

    /** 
     * Get the 'TourCode' element value.
     * 
     * @return value
     */
    public TourCode getTourCode() {
        return tourCode;
    }

    /** 
     * Set the 'TourCode' element value.
     * 
     * @param tourCode
     */
    public void setTourCode(TourCode tourCode) {
        this.tourCode = tourCode;
    }

    /** 
     * Get the 'Remarks' element value.
     * 
     * @return value
     */
    public Remarks getRemarks() {
        return remarks;
    }

    /** 
     * Set the 'Remarks' element value.
     * 
     * @param remarks
     */
    public void setRemarks(Remarks remarks) {
        this.remarks = remarks;
    }
}
