
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * CORE ORDER ITEM definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OrderItemCoreType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="OrderItem" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class OrderItem -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class OrderItemCoreType implements Serializable
{
    private List<OrderItem> orderItemList = new ArrayList<OrderItem>();

    /** 
     * Get the list of 'OrderItem' element items.
     * 
     * @return list
     */
    public List<OrderItem> getOrderItemList() {
        return orderItemList;
    }

    /** 
     * Set the list of 'OrderItem' element items.
     * 
     * @param list
     */
    public void setOrderItemList(List<OrderItem> list) {
        orderItemList = list;
    }
    /** 
     * Order Item details.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OrderItem" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="ns:KeyWithMetaObjectBaseType">
     *         &lt;xs:sequence>
     *           &lt;xs:element ref="ns:OrderItemID" minOccurs="0"/>
     *           &lt;xs:element ref="ns:SeatItem" minOccurs="0"/>
     *           &lt;xs:element ref="ns:OtherItem" minOccurs="0"/>
     *           &lt;xs:element ref="ns:FlightItem" minOccurs="0"/>
     *           &lt;xs:element ref="ns:BaggageItem" minOccurs="0"/>
     *           &lt;xs:element type="ns:OrderItemTimeLimitsType" name="TimeLimits" minOccurs="0"/>
     *           &lt;xs:element name="InventoryGuarantee" minOccurs="0">
     *             &lt;!-- Reference to inner class InventoryGuarantee -->
     *           &lt;/xs:element>
     *           &lt;xs:element name="Associations" minOccurs="0">
     *             &lt;!-- Reference to inner class Associations -->
     *           &lt;/xs:element>
     *           &lt;xs:element ref="ns:Disclosures" minOccurs="0"/>
     *           &lt;xs:element type="ns:PenaltyType" name="Penalty" minOccurs="0"/>
     *           &lt;xs:element ref="ns:OrderItemDetails" minOccurs="0"/>
     *         &lt;/xs:sequence>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class OrderItem extends KeyWithMetaObjectBaseType implements
        Serializable
    {
        private OrderItemID orderItemID;
        private SeatItem seatItem;
        private OtherItem otherItem;
        private FlightItem flightItem;
        private BaggageItem baggageItem;
        private OrderItemTimeLimitsType timeLimits;
        private InventoryGuarantee inventoryGuarantee;
        private Associations associations;
        private DisclosureType disclosures;
        private PenaltyType penalty;
        private OrderItemDetails orderItemDetails;

        /** 
         * Get the 'OrderItemID' element value.
         * 
         * @return value
         */
        public OrderItemID getOrderItemID() {
            return orderItemID;
        }

        /** 
         * Set the 'OrderItemID' element value.
         * 
         * @param orderItemID
         */
        public void setOrderItemID(OrderItemID orderItemID) {
            this.orderItemID = orderItemID;
        }

        /** 
         * Get the 'SeatItem' element value.
         * 
         * @return value
         */
        public SeatItem getSeatItem() {
            return seatItem;
        }

        /** 
         * Set the 'SeatItem' element value.
         * 
         * @param seatItem
         */
        public void setSeatItem(SeatItem seatItem) {
            this.seatItem = seatItem;
        }

        /** 
         * Get the 'OtherItem' element value.
         * 
         * @return value
         */
        public OtherItem getOtherItem() {
            return otherItem;
        }

        /** 
         * Set the 'OtherItem' element value.
         * 
         * @param otherItem
         */
        public void setOtherItem(OtherItem otherItem) {
            this.otherItem = otherItem;
        }

        /** 
         * Get the 'FlightItem' element value.
         * 
         * @return value
         */
        public FlightItem getFlightItem() {
            return flightItem;
        }

        /** 
         * Set the 'FlightItem' element value.
         * 
         * @param flightItem
         */
        public void setFlightItem(FlightItem flightItem) {
            this.flightItem = flightItem;
        }

        /** 
         * Get the 'BaggageItem' element value.
         * 
         * @return value
         */
        public BaggageItem getBaggageItem() {
            return baggageItem;
        }

        /** 
         * Set the 'BaggageItem' element value.
         * 
         * @param baggageItem
         */
        public void setBaggageItem(BaggageItem baggageItem) {
            this.baggageItem = baggageItem;
        }

        /** 
         * Get the 'TimeLimits' element value. Order item-associated Time Limit(s).
         * 
         * @return value
         */
        public OrderItemTimeLimitsType getTimeLimits() {
            return timeLimits;
        }

        /** 
         * Set the 'TimeLimits' element value. Order item-associated Time Limit(s).
         * 
         * @param timeLimits
         */
        public void setTimeLimits(OrderItemTimeLimitsType timeLimits) {
            this.timeLimits = timeLimits;
        }

        /** 
         * Get the 'InventoryGuarantee' element value.
         * 
         * @return value
         */
        public InventoryGuarantee getInventoryGuarantee() {
            return inventoryGuarantee;
        }

        /** 
         * Set the 'InventoryGuarantee' element value.
         * 
         * @param inventoryGuarantee
         */
        public void setInventoryGuarantee(InventoryGuarantee inventoryGuarantee) {
            this.inventoryGuarantee = inventoryGuarantee;
        }

        /** 
         * Get the 'Associations' element value.
         * 
         * @return value
         */
        public Associations getAssociations() {
            return associations;
        }

        /** 
         * Set the 'Associations' element value.
         * 
         * @param associations
         */
        public void setAssociations(Associations associations) {
            this.associations = associations;
        }

        /** 
         * Get the 'Disclosures' element value.
         * 
         * @return value
         */
        public DisclosureType getDisclosures() {
            return disclosures;
        }

        /** 
         * Set the 'Disclosures' element value.
         * 
         * @param disclosures
         */
        public void setDisclosures(DisclosureType disclosures) {
            this.disclosures = disclosures;
        }

        /** 
         * Get the 'Penalty' element value. Penalty information.
         * 
         * @return value
         */
        public PenaltyType getPenalty() {
            return penalty;
        }

        /** 
         * Set the 'Penalty' element value. Penalty information.
         * 
         * @param penalty
         */
        public void setPenalty(PenaltyType penalty) {
            this.penalty = penalty;
        }

        /** 
         * Get the 'OrderItemDetails' element value.
         * 
         * @return value
         */
        public OrderItemDetails getOrderItemDetails() {
            return orderItemDetails;
        }

        /** 
         * Set the 'OrderItemDetails' element value.
         * 
         * @param orderItemDetails
         */
        public void setOrderItemDetails(OrderItemDetails orderItemDetails) {
            this.orderItemDetails = orderItemDetails;
        }
        /** 
         * Inventory Guarantee 
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="InventoryGuarantee" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:string" name="InvGuaranteeID"/>
         *       &lt;xs:element ref="ns:InvGuaranteeTimeLimits"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class InventoryGuarantee implements Serializable
        {
            private String invGuaranteeID;
            private CoreDateGrpType invGuaranteeTimeLimits;

            /** 
             * Get the 'InvGuaranteeID' element value. 
                                  Unique Inventory Guarantee ID. Examples: INVREF123456, 68E0-675C Note: This is a unique identifier issued by an Airline to reference that inventory for a specified offer will be guaranteed as available for a period.
                                
             * 
             * @return value
             */
            public String getInvGuaranteeID() {
                return invGuaranteeID;
            }

            /** 
             * Set the 'InvGuaranteeID' element value. 
                                  Unique Inventory Guarantee ID. Examples: INVREF123456, 68E0-675C Note: This is a unique identifier issued by an Airline to reference that inventory for a specified offer will be guaranteed as available for a period.
                                
             * 
             * @param invGuaranteeID
             */
            public void setInvGuaranteeID(String invGuaranteeID) {
                this.invGuaranteeID = invGuaranteeID;
            }

            /** 
             * Get the 'InvGuaranteeTimeLimits' element value.
             * 
             * @return value
             */
            public CoreDateGrpType getInvGuaranteeTimeLimits() {
                return invGuaranteeTimeLimits;
            }

            /** 
             * Set the 'InvGuaranteeTimeLimits' element value.
             * 
             * @param invGuaranteeTimeLimits
             */
            public void setInvGuaranteeTimeLimits(
                    CoreDateGrpType invGuaranteeTimeLimits) {
                this.invGuaranteeTimeLimits = invGuaranteeTimeLimits;
            }
        }
        /** 
         * Order Association(s).
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Associations" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element ref="ns:OrderID" minOccurs="0"/>
         *       &lt;xs:element ref="ns:OrderItemID" minOccurs="0" maxOccurs="unbounded"/>
         *       &lt;xs:element name="Passengers" minOccurs="0">
         *         &lt;!-- Reference to inner class Passengers -->
         *       &lt;/xs:element>
         *       &lt;xs:element ref="ns:IncludedService" minOccurs="0"/>
         *       &lt;xs:element ref="ns:AssociatedService" minOccurs="0"/>
         *       &lt;xs:element name="OtherAssociation" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class OtherAssociation -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Associations implements Serializable
        {
            private OrderIDType orderID;
            private List<OrderItemID> orderItemIDList = new ArrayList<OrderItemID>();
            private Passengers passengers;
            private IncludedService includedService;
            private AssociatedService associatedService;
            private List<OtherAssociation> otherAssociationList = new ArrayList<OtherAssociation>();

            /** 
             * Get the 'OrderID' element value. Associated Order ID Example: ORDER7333
             * 
             * @return value
             */
            public OrderIDType getOrderID() {
                return orderID;
            }

            /** 
             * Set the 'OrderID' element value. Associated Order ID Example: ORDER7333
             * 
             * @param orderID
             */
            public void setOrderID(OrderIDType orderID) {
                this.orderID = orderID;
            }

            /** 
             * Get the list of 'OrderItemID' element items. Associated Order Item ID(s). Example: ORD7333-001
             * 
             * @return list
             */
            public List<OrderItemID> getOrderItemIDList() {
                return orderItemIDList;
            }

            /** 
             * Set the list of 'OrderItemID' element items. Associated Order Item ID(s). Example: ORD7333-001
             * 
             * @param list
             */
            public void setOrderItemIDList(List<OrderItemID> list) {
                orderItemIDList = list;
            }

            /** 
             * Get the 'Passengers' element value.
             * 
             * @return value
             */
            public Passengers getPassengers() {
                return passengers;
            }

            /** 
             * Set the 'Passengers' element value.
             * 
             * @param passengers
             */
            public void setPassengers(Passengers passengers) {
                this.passengers = passengers;
            }

            /** 
             * Get the 'IncludedService' element value.
             * 
             * @return value
             */
            public IncludedService getIncludedService() {
                return includedService;
            }

            /** 
             * Set the 'IncludedService' element value.
             * 
             * @param includedService
             */
            public void setIncludedService(IncludedService includedService) {
                this.includedService = includedService;
            }

            /** 
             * Get the 'AssociatedService' element value.
             * 
             * @return value
             */
            public AssociatedService getAssociatedService() {
                return associatedService;
            }

            /** 
             * Set the 'AssociatedService' element value.
             * 
             * @param associatedService
             */
            public void setAssociatedService(AssociatedService associatedService) {
                this.associatedService = associatedService;
            }

            /** 
             * Get the list of 'OtherAssociation' element items.
             * 
             * @return list
             */
            public List<OtherAssociation> getOtherAssociationList() {
                return otherAssociationList;
            }

            /** 
             * Set the list of 'OtherAssociation' element items.
             * 
             * @param list
             */
            public void setOtherAssociationList(List<OtherAssociation> list) {
                otherAssociationList = list;
            }
            /** 
             * 
                                  Passenger(s)/ Groups associated with the Offer Item. Note: This contains references to Passenger and Group instance(s) defined in the Passengers node.
                                
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Passengers" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:choice>
             *       &lt;xs:element ref="ns:PassengerReferences"/>
             *       &lt;xs:element ref="ns:GroupReference"/>
             *     &lt;/xs:choice>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Passengers implements Serializable
            {
                private int passengersSelect = -1;
                private static final int PASSENGER_REFERENCES_CHOICE = 0;
                private static final int GROUP_REFERENCE_CHOICE = 1;
                private PassengerReferences passengerReferences;
                private GroupReference groupReference;

                private void setPassengersSelect(int choice) {
                    if (passengersSelect == -1) {
                        passengersSelect = choice;
                    } else if (passengersSelect != choice) {
                        throw new IllegalStateException(
                                "Need to call clearPassengersSelect() before changing existing choice");
                    }
                }

                /** 
                 * Clear the choice selection.
                 */
                public void clearPassengersSelect() {
                    passengersSelect = -1;
                }

                /** 
                 * Check if PassengerReferences is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifPassengerReferences() {
                    return passengersSelect == PASSENGER_REFERENCES_CHOICE;
                }

                /** 
                 * Get the 'PassengerReferences' element value. 
                                          Association to multiple Passenger instance(s). Example: pax1 pax2
                                        
                 * 
                 * @return value
                 */
                public PassengerReferences getPassengerReferences() {
                    return passengerReferences;
                }

                /** 
                 * Set the 'PassengerReferences' element value. 
                                          Association to multiple Passenger instance(s). Example: pax1 pax2
                                        
                 * 
                 * @param passengerReferences
                 */
                public void setPassengerReferences(
                        PassengerReferences passengerReferences) {
                    setPassengersSelect(PASSENGER_REFERENCES_CHOICE);
                    this.passengerReferences = passengerReferences;
                }

                /** 
                 * Check if GroupReference is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifGroupReference() {
                    return passengersSelect == GROUP_REFERENCE_CHOICE;
                }

                /** 
                 * Get the 'GroupReference' element value.
                 * 
                 * @return value
                 */
                public GroupReference getGroupReference() {
                    return groupReference;
                }

                /** 
                 * Set the 'GroupReference' element value.
                 * 
                 * @param groupReference
                 */
                public void setGroupReference(GroupReference groupReference) {
                    setPassengersSelect(GROUP_REFERENCE_CHOICE);
                    this.groupReference = groupReference;
                }
            }
            /** 
             * 
                                  Other Named Association(s). Note: Includes an association type choice (e.g. MediaGroup) and an instance association value (e.g. mediagrp1).
                                
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OtherAssociation" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="required" name="Type"/>
             *     &lt;xs:attribute type="xs:string" use="required" name="ReferenceValue"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class OtherAssociation implements Serializable
            {
                private String type;
                private String referenceValue;

                /** 
                 * Get the 'Type' attribute value. 
                                        Named Instance Association Type. Examples: CarryOnAllowance, MediaGroup
                                      
                 * 
                 * @return value
                 */
                public String getType() {
                    return type;
                }

                /** 
                 * Set the 'Type' attribute value. 
                                        Named Instance Association Type. Examples: CarryOnAllowance, MediaGroup
                                      
                 * 
                 * @param type
                 */
                public void setType(String type) {
                    this.type = type;
                }

                /** 
                 * Get the 'ReferenceValue' attribute value. 
                                        Associated object instance value. Example: mediagrp1
                                      
                 * 
                 * @return value
                 */
                public String getReferenceValue() {
                    return referenceValue;
                }

                /** 
                 * Set the 'ReferenceValue' attribute value. 
                                        Associated object instance value. Example: mediagrp1
                                      
                 * 
                 * @param referenceValue
                 */
                public void setReferenceValue(String referenceValue) {
                    this.referenceValue = referenceValue;
                }
            }
        }
    }
}
