
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.math.BigInteger;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

/** 
 * The OrderRetrieve/ OrderView transaction set retrieves a specified order that matches one or more search criteria.

 Search criteria may include any supported Order Reference information, which may be the Order ID, a PNR reference, a ticket or coupon/ document number, or other Airline supported order reference and a Traveler Surname and Given Name.

 Note that if the order retrieval request is initiated from the party that originally requested the order creation, then an Order Reference is sufficient with the identity of the requesting party.

 If the order retrieval request is initiated from a party that did not originally request the order creation, then an extended security mechanism may be used to extend order view access to the party (e.g. using a CustomerInputRQ/RS for an additional security challenge (e.g. custom security question and answers.)

 The requestor may additionally specify filters to constrain the response information sets, including: Trip itinerary, Flight segment, Passenger, Payment and Accountable document information. If no filters are specified, all order information is returned.

 If a matching order is found, the OrderView response will contain all order information or filtered information (if filters were requested in the order retrieval request.) If no matching Order is located, the OrderView response will include processing condition information and no order information.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OrderRetrieveRQ">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element ref="ns:PointOfSale" minOccurs="0"/>
 *       &lt;xs:element ref="ns:Document"/>
 *       &lt;xs:element ref="ns:Party"/>
 *       &lt;xs:element ref="ns:OrderRetrieveParameters" minOccurs="0"/>
 *       &lt;xs:element name="Query">
 *         &lt;xs:complexType>
 *           &lt;xs:sequence>
 *             &lt;xs:element name="Filters">
 *               &lt;xs:complexType>
 *                 &lt;xs:sequence>
 *                   &lt;xs:element ref="ns:OrderID" minOccurs="0"/>
 *                   &lt;xs:element name="Flight" minOccurs="0">
 *                     &lt;!-- Reference to inner class Flight -->
 *                   &lt;/xs:element>
 *                   &lt;xs:element name="Passengers" minOccurs="0">
 *                     &lt;!-- Reference to inner class Passengers -->
 *                   &lt;/xs:element>
 *                   &lt;xs:element name="TicketDocument" minOccurs="0">
 *                     &lt;!-- Reference to inner class TicketDocument -->
 *                   &lt;/xs:element>
 *                   &lt;xs:element name="Group" minOccurs="0">
 *                     &lt;!-- Reference to inner class Group -->
 *                   &lt;/xs:element>
 *                   &lt;xs:element name="Payments" minOccurs="0">
 *                     &lt;!-- Reference to inner class Payments -->
 *                   &lt;/xs:element>
 *                   &lt;xs:element ref="ns:BookingReferences" minOccurs="0"/>
 *                 &lt;/xs:sequence>
 *               &lt;/xs:complexType>
 *             &lt;/xs:element>
 *           &lt;/xs:sequence>
 *         &lt;/xs:complexType>
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *     &lt;xs:attributeGroup ref="ns:IATA_PayloadStdAttributes"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class OrderRetrieveRQ implements Serializable
{
    private PointOfSaleType pointOfSale;
    private MsgDocumentType document;
    private MsgPartiesType party;
    private OrdRetrieveParamsType orderRetrieveParameters;
    private OrderIDType queryOrderID;
    private Flight flight;
    private Passengers passengers;
    private TicketDocument ticketDocument;
    private Group group;
    private Payments payments;
    private BookingReferences queryBookingReferences;
    private IATAPayloadStdAttributes IATAPayloadStdAttributes;

    /** 
     * Get the 'PointOfSale' element value.
     * 
     * @return value
     */
    public PointOfSaleType getPointOfSale() {
        return pointOfSale;
    }

    /** 
     * Set the 'PointOfSale' element value.
     * 
     * @param pointOfSale
     */
    public void setPointOfSale(PointOfSaleType pointOfSale) {
        this.pointOfSale = pointOfSale;
    }

    /** 
     * Get the 'Document' element value.
     * 
     * @return value
     */
    public MsgDocumentType getDocument() {
        return document;
    }

    /** 
     * Set the 'Document' element value.
     * 
     * @param document
     */
    public void setDocument(MsgDocumentType document) {
        this.document = document;
    }

    /** 
     * Get the 'Party' element value.
     * 
     * @return value
     */
    public MsgPartiesType getParty() {
        return party;
    }

    /** 
     * Set the 'Party' element value.
     * 
     * @param party
     */
    public void setParty(MsgPartiesType party) {
        this.party = party;
    }

    /** 
     * Get the 'OrderRetrieveParameters' element value.
     * 
     * @return value
     */
    public OrdRetrieveParamsType getOrderRetrieveParameters() {
        return orderRetrieveParameters;
    }

    /** 
     * Set the 'OrderRetrieveParameters' element value.
     * 
     * @param orderRetrieveParameters
     */
    public void setOrderRetrieveParameters(
            OrdRetrieveParamsType orderRetrieveParameters) {
        this.orderRetrieveParameters = orderRetrieveParameters;
    }

    /** 
     * Get the 'OrderID' element value.
     * 
     * @return value
     */
    public OrderIDType getQueryOrderID() {
        return queryOrderID;
    }

    /** 
     * Set the 'OrderID' element value.
     * 
     * @param queryOrderID
     */
    public void setQueryOrderID(OrderIDType queryOrderID) {
        this.queryOrderID = queryOrderID;
    }

    /** 
     * Get the 'Flight' element value. Query Filters.
     * 
     * @return value
     */
    public Flight getFlight() {
        return flight;
    }

    /** 
     * Set the 'Flight' element value. Query Filters.
     * 
     * @param flight
     */
    public void setFlight(Flight flight) {
        this.flight = flight;
    }

    /** 
     * Get the 'Passengers' element value. Query Filters.
     * 
     * @return value
     */
    public Passengers getPassengers() {
        return passengers;
    }

    /** 
     * Set the 'Passengers' element value. Query Filters.
     * 
     * @param passengers
     */
    public void setPassengers(Passengers passengers) {
        this.passengers = passengers;
    }

    /** 
     * Get the 'TicketDocument' element value. Query Filters.
     * 
     * @return value
     */
    public TicketDocument getTicketDocument() {
        return ticketDocument;
    }

    /** 
     * Set the 'TicketDocument' element value. Query Filters.
     * 
     * @param ticketDocument
     */
    public void setTicketDocument(TicketDocument ticketDocument) {
        this.ticketDocument = ticketDocument;
    }

    /** 
     * Get the 'Group' element value. Query Filters.
     * 
     * @return value
     */
    public Group getGroup() {
        return group;
    }

    /** 
     * Set the 'Group' element value. Query Filters.
     * 
     * @param group
     */
    public void setGroup(Group group) {
        this.group = group;
    }

    /** 
     * Get the 'Payments' element value. Query Filters.
     * 
     * @return value
     */
    public Payments getPayments() {
        return payments;
    }

    /** 
     * Set the 'Payments' element value. Query Filters.
     * 
     * @param payments
     */
    public void setPayments(Payments payments) {
        this.payments = payments;
    }

    /** 
     * Get the 'BookingReferences' element value. Existing Booking Reference (e.g. PNR Record Locator). Example: R1A3SK
     * 
     * @return value
     */
    public BookingReferences getQueryBookingReferences() {
        return queryBookingReferences;
    }

    /** 
     * Set the 'BookingReferences' element value. Existing Booking Reference (e.g. PNR Record Locator). Example: R1A3SK
     * 
     * @param queryBookingReferences
     */
    public void setQueryBookingReferences(
            BookingReferences queryBookingReferences) {
        this.queryBookingReferences = queryBookingReferences;
    }

    /** 
     * Get the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @return value
     */
    public IATAPayloadStdAttributes getIATAPayloadStdAttributes() {
        return IATAPayloadStdAttributes;
    }

    /** 
     * Set the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @param IATAPayloadStdAttributes
     */
    public void setIATAPayloadStdAttributes(
            IATAPayloadStdAttributes IATAPayloadStdAttributes) {
        this.IATAPayloadStdAttributes = IATAPayloadStdAttributes;
    }
    /** 
     * Flight Filters.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Flight" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element ref="ns:ClassOfService" minOccurs="0"/>
     *       &lt;xs:element ref="ns:FareBasisCode" minOccurs="0"/>
     *       &lt;xs:element name="OriginDestination" minOccurs="0">
     *         &lt;!-- Reference to inner class OriginDestination -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="Segment" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class Segment -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Flight implements Serializable
    {
        private FlightCOSCoreType classOfService;
        private FareBasisCodeType fareBasisCode;
        private OriginDestination originDestination;
        private List<Segment> segmentList = new ArrayList<Segment>();

        /** 
         * Get the 'ClassOfService' element value.
         * 
         * @return value
         */
        public FlightCOSCoreType getClassOfService() {
            return classOfService;
        }

        /** 
         * Set the 'ClassOfService' element value.
         * 
         * @param classOfService
         */
        public void setClassOfService(FlightCOSCoreType classOfService) {
            this.classOfService = classOfService;
        }

        /** 
         * Get the 'FareBasisCode' element value.
         * 
         * @return value
         */
        public FareBasisCodeType getFareBasisCode() {
            return fareBasisCode;
        }

        /** 
         * Set the 'FareBasisCode' element value.
         * 
         * @param fareBasisCode
         */
        public void setFareBasisCode(FareBasisCodeType fareBasisCode) {
            this.fareBasisCode = fareBasisCode;
        }

        /** 
         * Get the 'OriginDestination' element value.
         * 
         * @return value
         */
        public OriginDestination getOriginDestination() {
            return originDestination;
        }

        /** 
         * Set the 'OriginDestination' element value.
         * 
         * @param originDestination
         */
        public void setOriginDestination(OriginDestination originDestination) {
            this.originDestination = originDestination;
        }

        /** 
         * Get the list of 'Segment' element items.
         * 
         * @return list
         */
        public List<Segment> getSegmentList() {
            return segmentList;
        }

        /** 
         * Set the list of 'Segment' element items.
         * 
         * @param list
         */
        public void setSegmentList(List<Segment> list) {
            segmentList = list;
        }
        /** 
         * Flight origin/ destination information.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginDestination" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Departure">
         *         &lt;xs:complexType>
         *           &lt;xs:sequence>
         *             &lt;xs:element name="AirportCode">
         *               &lt;xs:complexType>
         *                 &lt;xs:simpleContent>
         *                   &lt;xs:extension base="xs:string">
         *                     &lt;xs:attributeGroup ref="ns:RadiusAttrGroup"/>
         *                   &lt;/xs:extension>
         *                 &lt;/xs:simpleContent>
         *               &lt;/xs:complexType>
         *             &lt;/xs:element>
         *             &lt;xs:element type="xs:date" name="Date"/>
         *           &lt;/xs:sequence>
         *         &lt;/xs:complexType>
         *       &lt;/xs:element>
         *       &lt;xs:element name="Arrival">
         *         &lt;xs:complexType>
         *           &lt;xs:sequence>
         *             &lt;xs:element name="AirportCode">
         *               &lt;xs:complexType>
         *                 &lt;xs:simpleContent>
         *                   &lt;xs:extension base="xs:string">
         *                     &lt;xs:attributeGroup ref="ns:RadiusAttrGroup"/>
         *                   &lt;/xs:extension>
         *                 &lt;/xs:simpleContent>
         *               &lt;/xs:complexType>
         *             &lt;/xs:element>
         *             &lt;xs:element type="xs:date" name="Date"/>
         *           &lt;/xs:sequence>
         *         &lt;/xs:complexType>
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * 
         * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
         *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
         * &lt;/xs:attributeGroup>
         * </pre>
         */
        public static class OriginDestination implements Serializable
        {
            private String departureAirportCodeString;
            private RadiusAttrGroup departureAirportCodeRadiusAttrGroup;
            private Date departureDate;
            private String arrivalAirportCodeString;
            private RadiusAttrGroup arrivalAirportCodeRadiusAttrGroup;
            private Date arrivalDate;
            private String refs;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getDepartureAirportCodeString() {
                return departureAirportCodeString;
            }

            /** 
             * Set the extension value.
             * 
             * @param departureAirportCodeString
             */
            public void setDepartureAirportCodeString(
                    String departureAirportCodeString) {
                this.departureAirportCodeString = departureAirportCodeString;
            }

            /** 
             * Get the 'RadiusAttrGroup' attributeGroup value. Search Radius for specified Airport or City code.
             * 
             * @return value
             */
            public RadiusAttrGroup getDepartureAirportCodeRadiusAttrGroup() {
                return departureAirportCodeRadiusAttrGroup;
            }

            /** 
             * Set the 'RadiusAttrGroup' attributeGroup value. Search Radius for specified Airport or City code.
             * 
             * @param departureAirportCodeRadiusAttrGroup
             */
            public void setDepartureAirportCodeRadiusAttrGroup(
                    RadiusAttrGroup departureAirportCodeRadiusAttrGroup) {
                this.departureAirportCodeRadiusAttrGroup = departureAirportCodeRadiusAttrGroup;
            }

            /** 
             * Get the 'Date' element value. Departure date. Example: 2017-01-13

            Encoding Scheme: ISO 8601 Date Format (YYYY-MM-DD)
             * 
             * @return value
             */
            public Date getDepartureDate() {
                return departureDate;
            }

            /** 
             * Set the 'Date' element value. Departure date. Example: 2017-01-13

            Encoding Scheme: ISO 8601 Date Format (YYYY-MM-DD)
             * 
             * @param departureDate
             */
            public void setDepartureDate(Date departureDate) {
                this.departureDate = departureDate;
            }

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getArrivalAirportCodeString() {
                return arrivalAirportCodeString;
            }

            /** 
             * Set the extension value.
             * 
             * @param arrivalAirportCodeString
             */
            public void setArrivalAirportCodeString(
                    String arrivalAirportCodeString) {
                this.arrivalAirportCodeString = arrivalAirportCodeString;
            }

            /** 
             * Get the 'RadiusAttrGroup' attributeGroup value. Search Radius for specified Airport or City code.
             * 
             * @return value
             */
            public RadiusAttrGroup getArrivalAirportCodeRadiusAttrGroup() {
                return arrivalAirportCodeRadiusAttrGroup;
            }

            /** 
             * Set the 'RadiusAttrGroup' attributeGroup value. Search Radius for specified Airport or City code.
             * 
             * @param arrivalAirportCodeRadiusAttrGroup
             */
            public void setArrivalAirportCodeRadiusAttrGroup(
                    RadiusAttrGroup arrivalAirportCodeRadiusAttrGroup) {
                this.arrivalAirportCodeRadiusAttrGroup = arrivalAirportCodeRadiusAttrGroup;
            }

            /** 
             * Get the 'Date' element value. Arrival date. Example: 2017-01-14

            Encoding Scheme: ISO 8601 Date Format (YYYY-MM-DD)
             * 
             * @return value
             */
            public Date getArrivalDate() {
                return arrivalDate;
            }

            /** 
             * Set the 'Date' element value. Arrival date. Example: 2017-01-14

            Encoding Scheme: ISO 8601 Date Format (YYYY-MM-DD)
             * 
             * @param arrivalDate
             */
            public void setArrivalDate(Date arrivalDate) {
                this.arrivalDate = arrivalDate;
            }

            /** 
             * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
             * 
             * @return value
             */
            public String getRefs() {
                return refs;
            }

            /** 
             * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
             * 
             * @param refs
             */
            public void setRefs(String refs) {
                this.refs = refs;
            }
        }
        /** 
         * Flight segment information.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Segment" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Departure">
         *         &lt;xs:complexType>
         *           &lt;xs:sequence>
         *             &lt;xs:element name="AirportCode">
         *               &lt;xs:complexType>
         *                 &lt;xs:simpleContent>
         *                   &lt;xs:extension base="xs:string">
         *                     &lt;xs:attributeGroup ref="ns:RadiusAttrGroup"/>
         *                   &lt;/xs:extension>
         *                 &lt;/xs:simpleContent>
         *               &lt;/xs:complexType>
         *             &lt;/xs:element>
         *             &lt;xs:element type="xs:date" name="Date"/>
         *           &lt;/xs:sequence>
         *         &lt;/xs:complexType>
         *       &lt;/xs:element>
         *       &lt;xs:element name="Arrival">
         *         &lt;xs:complexType>
         *           &lt;xs:sequence>
         *             &lt;xs:element name="AirportCode">
         *               &lt;xs:complexType>
         *                 &lt;xs:simpleContent>
         *                   &lt;xs:extension base="xs:string">
         *                     &lt;xs:attributeGroup ref="ns:RadiusAttrGroup"/>
         *                   &lt;/xs:extension>
         *                 &lt;/xs:simpleContent>
         *               &lt;/xs:complexType>
         *             &lt;/xs:element>
         *             &lt;xs:element type="xs:date" name="Date"/>
         *           &lt;/xs:sequence>
         *         &lt;/xs:complexType>
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * 
         * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
         *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
         * &lt;/xs:attributeGroup>
         * </pre>
         */
        public static class Segment implements Serializable
        {
            private String departureAirportCodeString;
            private RadiusAttrGroup departureAirportCodeRadiusAttrGroup;
            private Date departureDate;
            private String arrivalAirportCodeString;
            private RadiusAttrGroup arrivalAirportCodeRadiusAttrGroup;
            private Date arrivalDate;
            private String refs;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getDepartureAirportCodeString() {
                return departureAirportCodeString;
            }

            /** 
             * Set the extension value.
             * 
             * @param departureAirportCodeString
             */
            public void setDepartureAirportCodeString(
                    String departureAirportCodeString) {
                this.departureAirportCodeString = departureAirportCodeString;
            }

            /** 
             * Get the 'RadiusAttrGroup' attributeGroup value. Search Radius for specified Airport or City code.
             * 
             * @return value
             */
            public RadiusAttrGroup getDepartureAirportCodeRadiusAttrGroup() {
                return departureAirportCodeRadiusAttrGroup;
            }

            /** 
             * Set the 'RadiusAttrGroup' attributeGroup value. Search Radius for specified Airport or City code.
             * 
             * @param departureAirportCodeRadiusAttrGroup
             */
            public void setDepartureAirportCodeRadiusAttrGroup(
                    RadiusAttrGroup departureAirportCodeRadiusAttrGroup) {
                this.departureAirportCodeRadiusAttrGroup = departureAirportCodeRadiusAttrGroup;
            }

            /** 
             * Get the 'Date' element value. Departure date. Example: 2017-01-13

            Encoding Scheme: ISO 8601 Date Format (YYYY-MM-DD)
             * 
             * @return value
             */
            public Date getDepartureDate() {
                return departureDate;
            }

            /** 
             * Set the 'Date' element value. Departure date. Example: 2017-01-13

            Encoding Scheme: ISO 8601 Date Format (YYYY-MM-DD)
             * 
             * @param departureDate
             */
            public void setDepartureDate(Date departureDate) {
                this.departureDate = departureDate;
            }

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getArrivalAirportCodeString() {
                return arrivalAirportCodeString;
            }

            /** 
             * Set the extension value.
             * 
             * @param arrivalAirportCodeString
             */
            public void setArrivalAirportCodeString(
                    String arrivalAirportCodeString) {
                this.arrivalAirportCodeString = arrivalAirportCodeString;
            }

            /** 
             * Get the 'RadiusAttrGroup' attributeGroup value. Search Radius for specified Airport or City code.
             * 
             * @return value
             */
            public RadiusAttrGroup getArrivalAirportCodeRadiusAttrGroup() {
                return arrivalAirportCodeRadiusAttrGroup;
            }

            /** 
             * Set the 'RadiusAttrGroup' attributeGroup value. Search Radius for specified Airport or City code.
             * 
             * @param arrivalAirportCodeRadiusAttrGroup
             */
            public void setArrivalAirportCodeRadiusAttrGroup(
                    RadiusAttrGroup arrivalAirportCodeRadiusAttrGroup) {
                this.arrivalAirportCodeRadiusAttrGroup = arrivalAirportCodeRadiusAttrGroup;
            }

            /** 
             * Get the 'Date' element value. Arrival date. Example: 2017-01-14

            Encoding Scheme: ISO 8601 Date Format (YYYY-MM-DD)
             * 
             * @return value
             */
            public Date getArrivalDate() {
                return arrivalDate;
            }

            /** 
             * Set the 'Date' element value. Arrival date. Example: 2017-01-14

            Encoding Scheme: ISO 8601 Date Format (YYYY-MM-DD)
             * 
             * @param arrivalDate
             */
            public void setArrivalDate(Date arrivalDate) {
                this.arrivalDate = arrivalDate;
            }

            /** 
             * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
             * 
             * @return value
             */
            public String getRefs() {
                return refs;
            }

            /** 
             * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
             * 
             * @param refs
             */
            public void setRefs(String refs) {
                this.refs = refs;
            }
        }
    }
    /** 
     * Passenger and Group information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Passengers" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Name" minOccurs="0">
     *         &lt;!-- Reference to inner class Name -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="ProfileID" minOccurs="0">
     *         &lt;!-- Reference to inner class ProfileID -->
     *       &lt;/xs:element>
     *       &lt;xs:element type="ns:TravelerFQTV_Type" name="FQTV" minOccurs="0"/>
     *       &lt;xs:element ref="ns:Contacts" minOccurs="0"/>
     *       &lt;xs:element name="PassengerIDInfo" minOccurs="0">
     *         &lt;!-- Reference to inner class PassengerIDInfo -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Passengers implements Serializable
    {
        private Name name;
        private ProfileID profileID;
        private TravelerFQTVType FQTV;
        private Contacts contacts;
        private PassengerIDInfo passengerIDInfo;

        /** 
         * Get the 'Name' element value.
         * 
         * @return value
         */
        public Name getName() {
            return name;
        }

        /** 
         * Set the 'Name' element value.
         * 
         * @param name
         */
        public void setName(Name name) {
            this.name = name;
        }

        /** 
         * Get the 'ProfileID' element value.
         * 
         * @return value
         */
        public ProfileID getProfileID() {
            return profileID;
        }

        /** 
         * Set the 'ProfileID' element value.
         * 
         * @param profileID
         */
        public void setProfileID(ProfileID profileID) {
            this.profileID = profileID;
        }

        /** 
         * Get the 'FQTV' element value. Shopper Frequent Traveler Program(s).
         * 
         * @return value
         */
        public TravelerFQTVType getFQTV() {
            return FQTV;
        }

        /** 
         * Set the 'FQTV' element value. Shopper Frequent Traveler Program(s).
         * 
         * @param FQTV
         */
        public void setFQTV(TravelerFQTVType FQTV) {
            this.FQTV = FQTV;
        }

        /** 
         * Get the 'Contacts' element value.
         * 
         * @return value
         */
        public Contacts getContacts() {
            return contacts;
        }

        /** 
         * Set the 'Contacts' element value.
         * 
         * @param contacts
         */
        public void setContacts(Contacts contacts) {
            this.contacts = contacts;
        }

        /** 
         * Get the 'PassengerIDInfo' element value.
         * 
         * @return value
         */
        public PassengerIDInfo getPassengerIDInfo() {
            return passengerIDInfo;
        }

        /** 
         * Set the 'PassengerIDInfo' element value.
         * 
         * @param passengerIDInfo
         */
        public void setPassengerIDInfo(PassengerIDInfo passengerIDInfo) {
            this.passengerIDInfo = passengerIDInfo;
        }
        /** 
         * Passenger Name information.

        Note: Detailed Name information, such as prefix, title and suffix, are specified in PassengerMetadata.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Name" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Surname">
         *         &lt;xs:complexType>
         *           &lt;xs:simpleContent>
         *             &lt;xs:extension base="xs:string">
         *               &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
         *             &lt;/xs:extension>
         *           &lt;/xs:simpleContent>
         *         &lt;/xs:complexType>
         *       &lt;/xs:element>
         *       &lt;xs:element name="Given" minOccurs="0" maxOccurs="5">
         *         &lt;!-- Reference to inner class Given -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Middle" minOccurs="0" maxOccurs="3">
         *         &lt;!-- Reference to inner class Middle -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attributeGroup ref="ns:ObjectPolicyMetaAttrGroup"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * 
         * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
         *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
         * &lt;/xs:attributeGroup>
         * </pre>
         */
        public static class Name implements Serializable
        {
            private String surnameString;
            private String surnameRefs;
            private List<Given> givenList = new ArrayList<Given>();
            private List<Middle> middleList = new ArrayList<Middle>();
            private ObjectPolicyMetaAttrGroup objectPolicyMetaAttrGroup;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getSurnameString() {
                return surnameString;
            }

            /** 
             * Set the extension value.
             * 
             * @param surnameString
             */
            public void setSurnameString(String surnameString) {
                this.surnameString = surnameString;
            }

            /** 
             * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
             * 
             * @return value
             */
            public String getSurnameRefs() {
                return surnameRefs;
            }

            /** 
             * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
             * 
             * @param surnameRefs
             */
            public void setSurnameRefs(String surnameRefs) {
                this.surnameRefs = surnameRefs;
            }

            /** 
             * Get the list of 'Given' element items.
             * 
             * @return list
             */
            public List<Given> getGivenList() {
                return givenList;
            }

            /** 
             * Set the list of 'Given' element items.
             * 
             * @param list
             */
            public void setGivenList(List<Given> list) {
                givenList = list;
            }

            /** 
             * Get the list of 'Middle' element items.
             * 
             * @return list
             */
            public List<Middle> getMiddleList() {
                return middleList;
            }

            /** 
             * Set the list of 'Middle' element items.
             * 
             * @param list
             */
            public void setMiddleList(List<Middle> list) {
                middleList = list;
            }

            /** 
             * Get the 'ObjectPolicyMetaAttrGroup' attributeGroup value.
             * 
             * @return value
             */
            public ObjectPolicyMetaAttrGroup getObjectPolicyMetaAttrGroup() {
                return objectPolicyMetaAttrGroup;
            }

            /** 
             * Set the 'ObjectPolicyMetaAttrGroup' attributeGroup value.
             * 
             * @param objectPolicyMetaAttrGroup
             */
            public void setObjectPolicyMetaAttrGroup(
                    ObjectPolicyMetaAttrGroup objectPolicyMetaAttrGroup) {
                this.objectPolicyMetaAttrGroup = objectPolicyMetaAttrGroup;
            }
            /** 
             * Family (first or given) name.  Example: JOHN
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Given" minOccurs="0" maxOccurs="5">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:string">
             *         &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * 
             * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
             *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
             * &lt;/xs:attributeGroup>
             * </pre>
             */
            public static class Given implements Serializable
            {
                private String string;
                private String refs;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public String getString() {
                    return string;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param string
                 */
                public void setString(String string) {
                    this.string = string;
                }

                /** 
                 * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
                 * 
                 * @return value
                 */
                public String getRefs() {
                    return refs;
                }

                /** 
                 * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
                 * 
                 * @param refs
                 */
                public void setRefs(String refs) {
                    this.refs = refs;
                }
            }
            /** 
             * Middle name or initial.  Examples: G, GEORGE
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Middle" minOccurs="0" maxOccurs="3">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:string">
             *         &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * 
             * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
             *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
             * &lt;/xs:attributeGroup>
             * </pre>
             */
            public static class Middle implements Serializable
            {
                private String string;
                private String refs;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public String getString() {
                    return string;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param string
                 */
                public void setString(String string) {
                    this.string = string;
                }

                /** 
                 * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
                 * 
                 * @return value
                 */
                public String getRefs() {
                    return refs;
                }

                /** 
                 * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
                 * 
                 * @param refs
                 */
                public void setRefs(String refs) {
                    this.refs = refs;
                }
            }
        }
        /** 
         * Agent customer profile ID.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ProfileID" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:simpleContent>
         *       &lt;xs:extension base="xs:string">
         *         &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:simpleContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * 
         * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
         *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
         * &lt;/xs:attributeGroup>
         * </pre>
         */
        public static class ProfileID implements Serializable
        {
            private String string;
            private String refs;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getString() {
                return string;
            }

            /** 
             * Set the extension value.
             * 
             * @param string
             */
            public void setString(String string) {
                this.string = string;
            }

            /** 
             * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
             * 
             * @return value
             */
            public String getRefs() {
                return refs;
            }

            /** 
             * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
             * 
             * @param refs
             */
            public void setRefs(String refs) {
                this.refs = refs;
            }
        }
        /** 
         * Passenger FOID information
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PassengerIDInfo" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="FOID" minOccurs="0">
         *         &lt;!-- Reference to inner class FOID -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="xs:date" name="DateOfIssue" minOccurs="0"/>
         *       &lt;xs:element type="xs:date" name="DateOfExpiration" minOccurs="0"/>
         *       &lt;xs:element type="xs:date" name="CountryOfIssuance" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="ApplicabilityLocation" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="CountryOfResidence" minOccurs="0"/>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="AllowDocumentInd"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PassengerIDInfo implements Serializable
        {
            private FOID FOID1;
            private Date dateOfIssue;
            private Date dateOfExpiration;
            private Date countryOfIssuance;
            private String applicabilityLocation;
            private String countryOfResidence;
            private Boolean allowDocumentInd;

            /** 
             * Get the 'FOID' element value.
             * 
             * @return value
             */
            public FOID getFOID1() {
                return FOID1;
            }

            /** 
             * Set the 'FOID' element value.
             * 
             * @param FOID1
             */
            public void setFOID1(FOID FOID1) {
                this.FOID1 = FOID1;
            }

            /** 
             * Get the 'DateOfIssue' element value. Date of Issue. Example: 2017-01-13
             * 
             * @return value
             */
            public Date getDateOfIssue() {
                return dateOfIssue;
            }

            /** 
             * Set the 'DateOfIssue' element value. Date of Issue. Example: 2017-01-13
             * 
             * @param dateOfIssue
             */
            public void setDateOfIssue(Date dateOfIssue) {
                this.dateOfIssue = dateOfIssue;
            }

            /** 
             * Get the 'DateOfExpiration' element value. Date of expiration. Example: 2017-01-13
             * 
             * @return value
             */
            public Date getDateOfExpiration() {
                return dateOfExpiration;
            }

            /** 
             * Set the 'DateOfExpiration' element value. Date of expiration. Example: 2017-01-13
             * 
             * @param dateOfExpiration
             */
            public void setDateOfExpiration(Date dateOfExpiration) {
                this.dateOfExpiration = dateOfExpiration;
            }

            /** 
             * Get the 'CountryOfIssuance' element value. Country name from where the document has been issued.
             * 
             * @return value
             */
            public Date getCountryOfIssuance() {
                return countryOfIssuance;
            }

            /** 
             * Set the 'CountryOfIssuance' element value. Country name from where the document has been issued.
             * 
             * @param countryOfIssuance
             */
            public void setCountryOfIssuance(Date countryOfIssuance) {
                this.countryOfIssuance = countryOfIssuance;
            }

            /** 
             * Get the 'ApplicabilityLocation' element value. The location where the document is applicable.
             * 
             * @return value
             */
            public String getApplicabilityLocation() {
                return applicabilityLocation;
            }

            /** 
             * Set the 'ApplicabilityLocation' element value. The location where the document is applicable.
             * 
             * @param applicabilityLocation
             */
            public void setApplicabilityLocation(String applicabilityLocation) {
                this.applicabilityLocation = applicabilityLocation;
            }

            /** 
             * Get the 'CountryOfResidence' element value. Country where passenger resides.
             * 
             * @return value
             */
            public String getCountryOfResidence() {
                return countryOfResidence;
            }

            /** 
             * Set the 'CountryOfResidence' element value. Country where passenger resides.
             * 
             * @param countryOfResidence
             */
            public void setCountryOfResidence(String countryOfResidence) {
                this.countryOfResidence = countryOfResidence;
            }

            /** 
             * Get the 'AllowDocumentInd' attribute value. An indicator, allowing use the document number
             * 
             * @return value
             */
            public Boolean getAllowDocumentInd() {
                return allowDocumentInd;
            }

            /** 
             * Set the 'AllowDocumentInd' attribute value. An indicator, allowing use the document number
             * 
             * @param allowDocumentInd
             */
            public void setAllowDocumentInd(Boolean allowDocumentInd) {
                this.allowDocumentInd = allowDocumentInd;
            }
            /** 
             * Passenger Form of Identification.

            Note: This is the type of FOID as defined in IATA AIRIMP.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FOID" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:complexContent>
             *       &lt;xs:extension base="ns:KeyWithMetaObjectBaseType">
             *         &lt;xs:sequence>
             *           &lt;xs:element type="xs:string" name="Type"/>
             *           &lt;xs:element type="xs:string" name="ID"/>
             *         &lt;/xs:sequence>
             *       &lt;/xs:extension>
             *     &lt;/xs:complexContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class FOID extends KeyWithMetaObjectBaseType
                implements Serializable
            {
                private String type;
                private String ID;

                /** 
                 * Get the 'Type' element value. ID form. Examples: PP (passport), CC (credit card), FF (frequent flyer), DL (drivers license)
                 * 
                 * @return value
                 */
                public String getType() {
                    return type;
                }

                /** 
                 * Set the 'Type' element value. ID form. Examples: PP (passport), CC (credit card), FF (frequent flyer), DL (drivers license)
                 * 
                 * @param type
                 */
                public void setType(String type) {
                    this.type = type;
                }

                /** 
                 * Get the 'ID' element value. FOID ID value. Example: NY122345
                 * 
                 * @return value
                 */
                public String getID() {
                    return ID;
                }

                /** 
                 * Set the 'ID' element value. FOID ID value. Example: NY122345
                 * 
                 * @param ID
                 */
                public void setID(String ID) {
                    this.ID = ID;
                }
            }
        }
    }
    /** 
     * Ticket document numbers.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TicketDocument" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="TicketDocNbr"/>
     *       &lt;xs:element type="xs:date" name="DateOfIssue" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="TicketingLocation" minOccurs="0"/>
     *       &lt;xs:element type="xs:integer" name="CouponNumber" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class TicketDocument implements Serializable
    {
        private String ticketDocNbr;
        private Date dateOfIssue;
        private String ticketingLocation;
        private BigInteger couponNumber;

        /** 
         * Get the 'TicketDocNbr' element value. Coupon Document Number.

        Note: This is the document number comprised of the airline code, form code, and serial number.
         * 
         * @return value
         */
        public String getTicketDocNbr() {
            return ticketDocNbr;
        }

        /** 
         * Set the 'TicketDocNbr' element value. Coupon Document Number.

        Note: This is the document number comprised of the airline code, form code, and serial number.
         * 
         * @param ticketDocNbr
         */
        public void setTicketDocNbr(String ticketDocNbr) {
            this.ticketDocNbr = ticketDocNbr;
        }

        /** 
         * Get the 'DateOfIssue' element value. Date of Issue. Example: 2017-01-13
         * 
         * @return value
         */
        public Date getDateOfIssue() {
            return dateOfIssue;
        }

        /** 
         * Set the 'DateOfIssue' element value. Date of Issue. Example: 2017-01-13
         * 
         * @param dateOfIssue
         */
        public void setDateOfIssue(Date dateOfIssue) {
            this.dateOfIssue = dateOfIssue;
        }

        /** 
         * Get the 'TicketingLocation' element value. Airport or City Code. Example: JFK

        Encoding Scheme: IATA/ A4A (three character) Airport or City Code
         * 
         * @return value
         */
        public String getTicketingLocation() {
            return ticketingLocation;
        }

        /** 
         * Set the 'TicketingLocation' element value. Airport or City Code. Example: JFK

        Encoding Scheme: IATA/ A4A (three character) Airport or City Code
         * 
         * @param ticketingLocation
         */
        public void setTicketingLocation(String ticketingLocation) {
            this.ticketingLocation = ticketingLocation;
        }

        /** 
         * Get the 'CouponNumber' element value. Applicable coupon number. Example: 1234
         * 
         * @return value
         */
        public BigInteger getCouponNumber() {
            return couponNumber;
        }

        /** 
         * Set the 'CouponNumber' element value. Applicable coupon number. Example: 1234
         * 
         * @param couponNumber
         */
        public void setCouponNumber(BigInteger couponNumber) {
            this.couponNumber = couponNumber;
        }
    }
    /** 
     * Group Information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Group" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="Name" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="TotalPartySize" minOccurs="0"/>
     *       &lt;xs:element ref="ns:Contacts" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Group implements Serializable
    {
        private String name;
        private String totalPartySize;
        private Contacts contacts;

        /** 
         * Get the 'Name' element value. Group Name. Example: ABC Tour Club
         * 
         * @return value
         */
        public String getName() {
            return name;
        }

        /** 
         * Set the 'Name' element value. Group Name. Example: ABC Tour Club
         * 
         * @param name
         */
        public void setName(String name) {
            this.name = name;
        }

        /** 
         * Get the 'TotalPartySize' element value. The Complete Party (TCP) indicating total party size. Example: 12
         * 
         * @return value
         */
        public String getTotalPartySize() {
            return totalPartySize;
        }

        /** 
         * Set the 'TotalPartySize' element value. The Complete Party (TCP) indicating total party size. Example: 12
         * 
         * @param totalPartySize
         */
        public void setTotalPartySize(String totalPartySize) {
            this.totalPartySize = totalPartySize;
        }

        /** 
         * Get the 'Contacts' element value.
         * 
         * @return value
         */
        public Contacts getContacts() {
            return contacts;
        }

        /** 
         * Set the 'Contacts' element value.
         * 
         * @param contacts
         */
        public void setContacts(Contacts contacts) {
            this.contacts = contacts;
        }
    }
    /** 
     * Payment information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Payments" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Method" minOccurs="0">
     *         &lt;!-- Reference to inner class Method -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Payments implements Serializable
    {
        private Method method;

        /** 
         * Get the 'Method' element value.
         * 
         * @return value
         */
        public Method getMethod() {
            return method;
        }

        /** 
         * Set the 'Method' element value.
         * 
         * @param method
         */
        public void setMethod(Method method) {
            this.method = method;
        }
        /** 
         * Payment Method detail.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Method" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:complexContent>
         *       &lt;xs:extension base="ns:KeyWithMetaObjectBaseType">
         *         &lt;xs:sequence>
         *           &lt;xs:element type="xs:string" name="CardCode" minOccurs="0"/>
         *           &lt;xs:element name="MaskedCardNumber" minOccurs="0">
         *             &lt;!-- Reference to inner class MaskedCardNumber -->
         *           &lt;/xs:element>
         *           &lt;xs:element type="xs:string" name="TokenizedCardNumber" minOccurs="0"/>
         *           &lt;xs:element name="EffectiveExpireDate" minOccurs="0">
         *             &lt;!-- Reference to inner class EffectiveExpireDate -->
         *           &lt;/xs:element>
         *           &lt;xs:element name="CardHolderName" minOccurs="0">
         *             &lt;!-- Reference to inner class CardHolderName -->
         *           &lt;/xs:element>
         *         &lt;/xs:sequence>
         *       &lt;/xs:extension>
         *     &lt;/xs:complexContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Method extends KeyWithMetaObjectBaseType implements
            Serializable
        {
            private String cardCode;
            private MaskedCardNumber maskedCardNumber;
            private String tokenizedCardNumber;
            private EffectiveExpireDate effectiveExpireDate;
            private CardHolderName cardHolderName;

            /** 
             * Get the 'CardCode' element value. Credit card issuer code. Example: MC

            Note: This is the 2 character code of the credit card issuer.
             * 
             * @return value
             */
            public String getCardCode() {
                return cardCode;
            }

            /** 
             * Set the 'CardCode' element value. Credit card issuer code. Example: MC

            Note: This is the 2 character code of the credit card issuer.
             * 
             * @param cardCode
             */
            public void setCardCode(String cardCode) {
                this.cardCode = cardCode;
            }

            /** 
             * Get the 'MaskedCardNumber' element value.
             * 
             * @return value
             */
            public MaskedCardNumber getMaskedCardNumber() {
                return maskedCardNumber;
            }

            /** 
             * Set the 'MaskedCardNumber' element value.
             * 
             * @param maskedCardNumber
             */
            public void setMaskedCardNumber(MaskedCardNumber maskedCardNumber) {
                this.maskedCardNumber = maskedCardNumber;
            }

            /** 
             * Get the 'TokenizedCardNumber' element value. Tokenized card number.

            Note: This capability may not be supported by all EDIST-enabled systems or may be supported by bilateral agreement only. If supported, the technical implementation of this capability is not dictated by this specification.
             * 
             * @return value
             */
            public String getTokenizedCardNumber() {
                return tokenizedCardNumber;
            }

            /** 
             * Set the 'TokenizedCardNumber' element value. Tokenized card number.

            Note: This capability may not be supported by all EDIST-enabled systems or may be supported by bilateral agreement only. If supported, the technical implementation of this capability is not dictated by this specification.
             * 
             * @param tokenizedCardNumber
             */
            public void setTokenizedCardNumber(String tokenizedCardNumber) {
                this.tokenizedCardNumber = tokenizedCardNumber;
            }

            /** 
             * Get the 'EffectiveExpireDate' element value.
             * 
             * @return value
             */
            public EffectiveExpireDate getEffectiveExpireDate() {
                return effectiveExpireDate;
            }

            /** 
             * Set the 'EffectiveExpireDate' element value.
             * 
             * @param effectiveExpireDate
             */
            public void setEffectiveExpireDate(
                    EffectiveExpireDate effectiveExpireDate) {
                this.effectiveExpireDate = effectiveExpireDate;
            }

            /** 
             * Get the 'CardHolderName' element value.
             * 
             * @return value
             */
            public CardHolderName getCardHolderName() {
                return cardHolderName;
            }

            /** 
             * Set the 'CardHolderName' element value.
             * 
             * @param cardHolderName
             */
            public void setCardHolderName(CardHolderName cardHolderName) {
                this.cardHolderName = cardHolderName;
            }
            /** 
             * Concealed credit card number, Example: xxxxxxxxxxxx9922
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MaskedCardNumber" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:string">
             *         &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * 
             * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
             *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
             * &lt;/xs:attributeGroup>
             * </pre>
             */
            public static class MaskedCardNumber implements Serializable
            {
                private String string;
                private String refs;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public String getString() {
                    return string;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param string
                 */
                public void setString(String string) {
                    this.string = string;
                }

                /** 
                 * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
                 * 
                 * @return value
                 */
                public String getRefs() {
                    return refs;
                }

                /** 
                 * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
                 * 
                 * @param refs
                 */
                public void setRefs(String refs) {
                    this.refs = refs;
                }
            }
            /** 
             * Payment Card Effective and/ or Expiration date(s).
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EffectiveExpireDate" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="Effective" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="Expiration" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * 
             * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
             *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
             * &lt;/xs:attributeGroup>
             * </pre>
             */
            public static class EffectiveExpireDate implements Serializable
            {
                private String effective;
                private String expiration;
                private String refs;

                /** 
                 * Get the 'Effective' element value. Payment Card Effective Date. Example: 0116
                 * 
                 * @return value
                 */
                public String getEffective() {
                    return effective;
                }

                /** 
                 * Set the 'Effective' element value. Payment Card Effective Date. Example: 0116
                 * 
                 * @param effective
                 */
                public void setEffective(String effective) {
                    this.effective = effective;
                }

                /** 
                 * Get the 'Expiration' element value. Payment Card Expiration Date. Example: 0119
                 * 
                 * @return value
                 */
                public String getExpiration() {
                    return expiration;
                }

                /** 
                 * Set the 'Expiration' element value. Payment Card Expiration Date. Example: 0119
                 * 
                 * @param expiration
                 */
                public void setExpiration(String expiration) {
                    this.expiration = expiration;
                }

                /** 
                 * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
                 * 
                 * @return value
                 */
                public String getRefs() {
                    return refs;
                }

                /** 
                 * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
                 * 
                 * @param refs
                 */
                public void setRefs(String refs) {
                    this.refs = refs;
                }
            }
            /** 
             * Name of credit card holder. Example: JOHN SMITH
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CardHolderName" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:string">
             *         &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * 
             * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
             *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
             * &lt;/xs:attributeGroup>
             * </pre>
             */
            public static class CardHolderName implements Serializable
            {
                private String string;
                private String refs;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public String getString() {
                    return string;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param string
                 */
                public void setString(String string) {
                    this.string = string;
                }

                /** 
                 * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
                 * 
                 * @return value
                 */
                public String getRefs() {
                    return refs;
                }

                /** 
                 * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
                 * 
                 * @param refs
                 */
                public void setRefs(String refs) {
                    this.refs = refs;
                }
            }
        }
    }
}
