
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * The OrderCreate/ OrderView transaction is a multi-function message that may:

 1) Request specified inventory to be held (and returns a reference to the held inventory)

 2) Request that an order to be created (returning the complete view of the Order)

 3) Request additions to order data elements (e.g. add frequent flyer data)
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OrderViewRS">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element ref="ns:Document"/>
 *       &lt;xs:element ref="ns:Party" minOccurs="0"/>
 *       &lt;xs:choice>
 *         &lt;xs:sequence>
 *           &lt;xs:element type="ns:SuccessType" name="Success"/>
 *           &lt;xs:element type="ns:WarningsType" name="Warnings" minOccurs="0"/>
 *           &lt;xs:element name="Response">
 *             &lt;xs:complexType>
 *               &lt;xs:sequence>
 *                 &lt;xs:element ref="ns:OrderViewProcessing"/>
 *                 &lt;xs:element name="Passengers">
 *                   &lt;xs:complexType>
 *                     &lt;xs:sequence>
 *                       &lt;xs:element ref="ns:Passenger" minOccurs="0" maxOccurs="unbounded"/>
 *                       &lt;xs:element type="ns:GroupType" name="Group" minOccurs="0"/>
 *                     &lt;/xs:sequence>
 *                   &lt;/xs:complexType>
 *                 &lt;/xs:element>
 *                 &lt;xs:element name="Order" maxOccurs="unbounded">
 *                   &lt;!-- Reference to inner class Order -->
 *                 &lt;/xs:element>
 *                 &lt;xs:element name="Payments" minOccurs="0">
 *                   &lt;!-- Reference to inner class Payments -->
 *                 &lt;/xs:element>
 *                 &lt;xs:element name="TicketDocInfos" minOccurs="0">
 *                   &lt;!-- Reference to inner class TicketDocInfos -->
 *                 &lt;/xs:element>
 *                 &lt;xs:element type="ns:CommissionType" name="Commission" minOccurs="0"/>
 *                 &lt;xs:element name="Amendments" minOccurs="0">
 *                   &lt;!-- Reference to inner class Amendments -->
 *                 &lt;/xs:element>
 *                 &lt;xs:element type="ns:DataListType" name="DataList" minOccurs="0"/>
 *                 &lt;xs:element type="ns:OrdViewMetadataType" name="Metadata" minOccurs="0"/>
 *               &lt;/xs:sequence>
 *             &lt;/xs:complexType>
 *           &lt;/xs:element>
 *         &lt;/xs:sequence>
 *         &lt;xs:element ref="ns:Errors"/>
 *       &lt;/xs:choice>
 *     &lt;/xs:sequence>
 *     &lt;xs:attributeGroup ref="ns:IATA_PayloadStdAttributes"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class OrderViewRS implements Serializable
{
    private MsgDocumentType document;
    private MsgPartiesType party;
    private int choiceSelect = -1;
    private static final int SUCCESS_CHOICE = 0;
    private static final int ERRORS_CHOICE = 1;
    private SuccessType success;
    private WarningsType warnings;
    private OrderViewProcessType responseOrderViewProcessing;
    private List<Passenger> responsePassengerList = new ArrayList<Passenger>();
    private GroupType responseGroup;
    private List<Order> orderList = new ArrayList<Order>();
    private Payments payments;
    private TicketDocInfos ticketDocInfos;
    private CommissionType responseCommission;
    private Amendments amendments;
    private DataListType responseDataList;
    private OrdViewMetadataType responseMetadata;
    private ErrorsType errors;
    private IATAPayloadStdAttributes IATAPayloadStdAttributes;

    /** 
     * Get the 'Document' element value.
     * 
     * @return value
     */
    public MsgDocumentType getDocument() {
        return document;
    }

    /** 
     * Set the 'Document' element value.
     * 
     * @param document
     */
    public void setDocument(MsgDocumentType document) {
        this.document = document;
    }

    /** 
     * Get the 'Party' element value.
     * 
     * @return value
     */
    public MsgPartiesType getParty() {
        return party;
    }

    /** 
     * Set the 'Party' element value.
     * 
     * @param party
     */
    public void setParty(MsgPartiesType party) {
        this.party = party;
    }

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if Success is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifSuccess() {
        return choiceSelect == SUCCESS_CHOICE;
    }

    /** 
     * Get the 'Success' element value. The presence of the empty Success element explicitly indicates that the message succeeded.
     * 
     * @return value
     */
    public SuccessType getSuccess() {
        return success;
    }

    /** 
     * Set the 'Success' element value. The presence of the empty Success element explicitly indicates that the message succeeded.
     * 
     * @param success
     */
    public void setSuccess(SuccessType success) {
        setChoiceSelect(SUCCESS_CHOICE);
        this.success = success;
    }

    /** 
     * Get the 'Warnings' element value. Used in conjunction with the Success element to define one or more business errors.
     * 
     * @return value
     */
    public WarningsType getWarnings() {
        return warnings;
    }

    /** 
     * Set the 'Warnings' element value. Used in conjunction with the Success element to define one or more business errors.
     * 
     * @param warnings
     */
    public void setWarnings(WarningsType warnings) {
        setChoiceSelect(SUCCESS_CHOICE);
        this.warnings = warnings;
    }

    /** 
     * Get the 'OrderViewProcessing' element value. Transaction Processing Results, including processing status, alerts, notices, business warnings, supplemental marketing messages and policy.
     * 
     * @return value
     */
    public OrderViewProcessType getResponseOrderViewProcessing() {
        return responseOrderViewProcessing;
    }

    /** 
     * Set the 'OrderViewProcessing' element value. Transaction Processing Results, including processing status, alerts, notices, business warnings, supplemental marketing messages and policy.
     * 
     * @param responseOrderViewProcessing
     */
    public void setResponseOrderViewProcessing(
            OrderViewProcessType responseOrderViewProcessing) {
        setChoiceSelect(SUCCESS_CHOICE);
        this.responseOrderViewProcessing = responseOrderViewProcessing;
    }

    /** 
     * Get the list of 'Passenger' element items.
     * 
     * @return list
     */
    public List<Passenger> getResponsePassengerList() {
        return responsePassengerList;
    }

    /** 
     * Set the list of 'Passenger' element items.
     * 
     * @param list
     */
    public void setResponsePassengerList(List<Passenger> list) {
        setChoiceSelect(SUCCESS_CHOICE);
        responsePassengerList = list;
    }

    /** 
     * Get the 'Group' element value. Group Information.
     * 
     * @return value
     */
    public GroupType getResponseGroup() {
        return responseGroup;
    }

    /** 
     * Set the 'Group' element value. Group Information.
     * 
     * @param responseGroup
     */
    public void setResponseGroup(GroupType responseGroup) {
        setChoiceSelect(SUCCESS_CHOICE);
        this.responseGroup = responseGroup;
    }

    /** 
     * Get the list of 'Order' element items. Query Results.
     * 
     * @return list
     */
    public List<Order> getOrderList() {
        return orderList;
    }

    /** 
     * Set the list of 'Order' element items. Query Results.
     * 
     * @param list
     */
    public void setOrderList(List<Order> list) {
        setChoiceSelect(SUCCESS_CHOICE);
        orderList = list;
    }

    /** 
     * Get the 'Payments' element value. Query Results.
     * 
     * @return value
     */
    public Payments getPayments() {
        return payments;
    }

    /** 
     * Set the 'Payments' element value. Query Results.
     * 
     * @param payments
     */
    public void setPayments(Payments payments) {
        setChoiceSelect(SUCCESS_CHOICE);
        this.payments = payments;
    }

    /** 
     * Get the 'TicketDocInfos' element value. Query Results.
     * 
     * @return value
     */
    public TicketDocInfos getTicketDocInfos() {
        return ticketDocInfos;
    }

    /** 
     * Set the 'TicketDocInfos' element value. Query Results.
     * 
     * @param ticketDocInfos
     */
    public void setTicketDocInfos(TicketDocInfos ticketDocInfos) {
        setChoiceSelect(SUCCESS_CHOICE);
        this.ticketDocInfos = ticketDocInfos;
    }

    /** 
     * Get the 'Commission' element value. Commission information.
     * 
     * @return value
     */
    public CommissionType getResponseCommission() {
        return responseCommission;
    }

    /** 
     * Set the 'Commission' element value. Commission information.
     * 
     * @param responseCommission
     */
    public void setResponseCommission(CommissionType responseCommission) {
        setChoiceSelect(SUCCESS_CHOICE);
        this.responseCommission = responseCommission;
    }

    /** 
     * Get the 'Amendments' element value. Query Results.
     * 
     * @return value
     */
    public Amendments getAmendments() {
        return amendments;
    }

    /** 
     * Set the 'Amendments' element value. Query Results.
     * 
     * @param amendments
     */
    public void setAmendments(Amendments amendments) {
        setChoiceSelect(SUCCESS_CHOICE);
        this.amendments = amendments;
    }

    /** 
     * Get the 'DataList' element value. Data List(s)
     * 
     * @return value
     */
    public DataListType getResponseDataList() {
        return responseDataList;
    }

    /** 
     * Set the 'DataList' element value. Data List(s)
     * 
     * @param responseDataList
     */
    public void setResponseDataList(DataListType responseDataList) {
        setChoiceSelect(SUCCESS_CHOICE);
        this.responseDataList = responseDataList;
    }

    /** 
     * Get the 'Metadata' element value. Metadata List(s).
     * 
     * @return value
     */
    public OrdViewMetadataType getResponseMetadata() {
        return responseMetadata;
    }

    /** 
     * Set the 'Metadata' element value. Metadata List(s).
     * 
     * @param responseMetadata
     */
    public void setResponseMetadata(OrdViewMetadataType responseMetadata) {
        setChoiceSelect(SUCCESS_CHOICE);
        this.responseMetadata = responseMetadata;
    }

    /** 
     * Check if Errors is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifErrors() {
        return choiceSelect == ERRORS_CHOICE;
    }

    /** 
     * Get the 'Errors' element value.
     * 
     * @return value
     */
    public ErrorsType getErrors() {
        return errors;
    }

    /** 
     * Set the 'Errors' element value.
     * 
     * @param errors
     */
    public void setErrors(ErrorsType errors) {
        setChoiceSelect(ERRORS_CHOICE);
        this.errors = errors;
    }

    /** 
     * Get the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @return value
     */
    public IATAPayloadStdAttributes getIATAPayloadStdAttributes() {
        return IATAPayloadStdAttributes;
    }

    /** 
     * Set the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @param IATAPayloadStdAttributes
     */
    public void setIATAPayloadStdAttributes(
            IATAPayloadStdAttributes IATAPayloadStdAttributes) {
        this.IATAPayloadStdAttributes = IATAPayloadStdAttributes;
    }
    /** 
     * Order information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Order" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="ns:OrderCoreType">
     *         &lt;xs:sequence>
     *           &lt;xs:element type="ns:OrderItemCoreType" name="OrderItems"/>
     *         &lt;/xs:sequence>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Order extends OrderCoreType implements Serializable
    {
        private OrderItemCoreType orderItems;

        /** 
         * Get the 'OrderItems' element value. Order Item Detail.
         * 
         * @return value
         */
        public OrderItemCoreType getOrderItems() {
            return orderItems;
        }

        /** 
         * Set the 'OrderItems' element value. Order Item Detail.
         * 
         * @param orderItems
         */
        public void setOrderItems(OrderItemCoreType orderItems) {
            this.orderItems = orderItems;
        }
    }
    /** 
     * Payment information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Payments" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:OrderPaymentMethodType" name="Payment" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Payments implements Serializable
    {
        private List<OrderPaymentMethodType> paymentList = new ArrayList<OrderPaymentMethodType>();

        /** 
         * Get the list of 'Payment' element items. Payment detail.
         * 
         * @return list
         */
        public List<OrderPaymentMethodType> getPaymentList() {
            return paymentList;
        }

        /** 
         * Set the list of 'Payment' element items. Payment detail.
         * 
         * @param list
         */
        public void setPaymentList(List<OrderPaymentMethodType> list) {
            paymentList = list;
        }
    }
    /** 
     * Ticket/ Document Information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TicketDocInfos" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="TicketDocInfo" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class TicketDocInfo -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class TicketDocInfos implements Serializable
    {
        private List<TicketDocInfo> ticketDocInfoList = new ArrayList<TicketDocInfo>();

        /** 
         * Get the list of 'TicketDocInfo' element items.
         * 
         * @return list
         */
        public List<TicketDocInfo> getTicketDocInfoList() {
            return ticketDocInfoList;
        }

        /** 
         * Set the list of 'TicketDocInfo' element items.
         * 
         * @param list
         */
        public void setTicketDocInfoList(List<TicketDocInfo> list) {
            ticketDocInfoList = list;
        }
        /** 
         * Ticket/document information.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TicketDocInfo" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="AgentIDs" minOccurs="0">
         *         &lt;!-- Reference to inner class AgentIDs -->
         *       &lt;/xs:element>
         *       &lt;xs:element ref="ns:IssuingAirlineInfo" minOccurs="0"/>
         *       &lt;xs:element ref="ns:TicketDocument" maxOccurs="unbounded"/>
         *       &lt;xs:element ref="ns:CarrierFeeInfo" minOccurs="0"/>
         *       &lt;xs:element ref="ns:OriginalIssueInfo" minOccurs="0"/>
         *       &lt;xs:element ref="ns:PassengerReference"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class TicketDocInfo implements Serializable
        {
            private AgentIDs agentIDs;
            private AirlineIssuanceType issuingAirlineInfo;
            private List<TicketDocument> ticketDocumentList = new ArrayList<TicketDocument>();
            private CarrierFeeInfoType carrierFeeInfo;
            private OriginalIssueType originalIssueInfo;
            private PassengerReference passengerReference;

            /** 
             * Get the 'AgentIDs' element value.
             * 
             * @return value
             */
            public AgentIDs getAgentIDs() {
                return agentIDs;
            }

            /** 
             * Set the 'AgentIDs' element value.
             * 
             * @param agentIDs
             */
            public void setAgentIDs(AgentIDs agentIDs) {
                this.agentIDs = agentIDs;
            }

            /** 
             * Get the 'IssuingAirlineInfo' element value.
             * 
             * @return value
             */
            public AirlineIssuanceType getIssuingAirlineInfo() {
                return issuingAirlineInfo;
            }

            /** 
             * Set the 'IssuingAirlineInfo' element value.
             * 
             * @param issuingAirlineInfo
             */
            public void setIssuingAirlineInfo(
                    AirlineIssuanceType issuingAirlineInfo) {
                this.issuingAirlineInfo = issuingAirlineInfo;
            }

            /** 
             * Get the list of 'TicketDocument' element items.
             * 
             * @return list
             */
            public List<TicketDocument> getTicketDocumentList() {
                return ticketDocumentList;
            }

            /** 
             * Set the list of 'TicketDocument' element items.
             * 
             * @param list
             */
            public void setTicketDocumentList(List<TicketDocument> list) {
                ticketDocumentList = list;
            }

            /** 
             * Get the 'CarrierFeeInfo' element value.
             * 
             * @return value
             */
            public CarrierFeeInfoType getCarrierFeeInfo() {
                return carrierFeeInfo;
            }

            /** 
             * Set the 'CarrierFeeInfo' element value.
             * 
             * @param carrierFeeInfo
             */
            public void setCarrierFeeInfo(CarrierFeeInfoType carrierFeeInfo) {
                this.carrierFeeInfo = carrierFeeInfo;
            }

            /** 
             * Get the 'OriginalIssueInfo' element value.
             * 
             * @return value
             */
            public OriginalIssueType getOriginalIssueInfo() {
                return originalIssueInfo;
            }

            /** 
             * Set the 'OriginalIssueInfo' element value.
             * 
             * @param originalIssueInfo
             */
            public void setOriginalIssueInfo(OriginalIssueType originalIssueInfo) {
                this.originalIssueInfo = originalIssueInfo;
            }

            /** 
             * Get the 'PassengerReference' element value.
             * 
             * @return value
             */
            public PassengerReference getPassengerReference() {
                return passengerReference;
            }

            /** 
             * Set the 'PassengerReference' element value.
             * 
             * @param passengerReference
             */
            public void setPassengerReference(
                    PassengerReference passengerReference) {
                this.passengerReference = passengerReference;
            }
            /** 
             * Booking and Servicing Agent information.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AgentIDs" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element ref="ns:AgentID" maxOccurs="2"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class AgentIDs implements Serializable
            {
                private List<CouponAgentType> agentIDList = new ArrayList<CouponAgentType>();

                /** 
                 * Get the list of 'AgentID' element items.
                 * 
                 * @return list
                 */
                public List<CouponAgentType> getAgentIDList() {
                    return agentIDList;
                }

                /** 
                 * Set the list of 'AgentID' element items.
                 * 
                 * @param list
                 */
                public void setAgentIDList(List<CouponAgentType> list) {
                    agentIDList = list;
                }
            }
        }
    }
    /** 
     * Order Amendment information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Amendments" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Amendment" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class Amendment -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Amendments implements Serializable
    {
        private List<Amendment> amendmentList = new ArrayList<Amendment>();

        /** 
         * Get the list of 'Amendment' element items.
         * 
         * @return list
         */
        public List<Amendment> getAmendmentList() {
            return amendmentList;
        }

        /** 
         * Set the list of 'Amendment' element items.
         * 
         * @param list
         */
        public void setAmendmentList(List<Amendment> list) {
            amendmentList = list;
        }
        /** 
         * Amendment Detail.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Amendment" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="ActionType">
         *         &lt;xs:complexType>
         *           &lt;xs:simpleContent>
         *             &lt;xs:extension base="xs:string">
         *               &lt;xs:attribute type="xs:string" use="optional" name="Context"/>
         *             &lt;/xs:extension>
         *           &lt;/xs:simpleContent>
         *         &lt;/xs:complexType>
         *       &lt;/xs:element>
         *       &lt;xs:element name="OfferItem" minOccurs="0">
         *         &lt;!-- Reference to inner class OfferItem -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="TicketDocInfo" minOccurs="0">
         *         &lt;!-- Reference to inner class TicketDocInfo -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Amendment implements Serializable
        {
            private String actionTypeString;
            private String actionTypeContext;
            private OfferItem offerItem;
            private TicketDocInfo ticketDocInfo;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getActionTypeString() {
                return actionTypeString;
            }

            /** 
             * Set the extension value.
             * 
             * @param actionTypeString
             */
            public void setActionTypeString(String actionTypeString) {
                this.actionTypeString = actionTypeString;
            }

            /** 
             * Get the 'Context' attribute value. Action Type Context.
             * 
             * @return value
             */
            public String getActionTypeContext() {
                return actionTypeContext;
            }

            /** 
             * Set the 'Context' attribute value. Action Type Context.
             * 
             * @param actionTypeContext
             */
            public void setActionTypeContext(String actionTypeContext) {
                this.actionTypeContext = actionTypeContext;
            }

            /** 
             * Get the 'OfferItem' element value.
             * 
             * @return value
             */
            public OfferItem getOfferItem() {
                return offerItem;
            }

            /** 
             * Set the 'OfferItem' element value.
             * 
             * @param offerItem
             */
            public void setOfferItem(OfferItem offerItem) {
                this.offerItem = offerItem;
            }

            /** 
             * Get the 'TicketDocInfo' element value.
             * 
             * @return value
             */
            public TicketDocInfo getTicketDocInfo() {
                return ticketDocInfo;
            }

            /** 
             * Set the 'TicketDocInfo' element value.
             * 
             * @param ticketDocInfo
             */
            public void setTicketDocInfo(TicketDocInfo ticketDocInfo) {
                this.ticketDocInfo = ticketDocInfo;
            }
            /** 
             * Offer Item ID with optional Service ID(s).
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OfferItem" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:complexContent>
             *       &lt;xs:extension base="ns:AssociatedObjectBaseType">
             *         &lt;xs:sequence>
             *           &lt;xs:element ref="ns:OfferItemID"/>
             *           &lt;xs:element name="Passengers" minOccurs="0">
             *             &lt;!-- Reference to inner class Passengers -->
             *           &lt;/xs:element>
             *           &lt;xs:element name="Services" minOccurs="0">
             *             &lt;!-- Reference to inner class Services -->
             *           &lt;/xs:element>
             *           &lt;xs:element name="OtherAssociation" minOccurs="0" maxOccurs="unbounded">
             *             &lt;!-- Reference to inner class OtherAssociation -->
             *           &lt;/xs:element>
             *         &lt;/xs:sequence>
             *       &lt;/xs:extension>
             *     &lt;/xs:complexContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class OfferItem extends AssociatedObjectBaseType
                implements Serializable
            {
                private OfferItemID offerItemID;
                private Passengers passengers;
                private Services services;
                private List<OtherAssociation> otherAssociationList = new ArrayList<OtherAssociation>();

                /** 
                 * Get the 'OfferItemID' element value.
                 * 
                 * @return value
                 */
                public OfferItemID getOfferItemID() {
                    return offerItemID;
                }

                /** 
                 * Set the 'OfferItemID' element value.
                 * 
                 * @param offerItemID
                 */
                public void setOfferItemID(OfferItemID offerItemID) {
                    this.offerItemID = offerItemID;
                }

                /** 
                 * Get the 'Passengers' element value.
                 * 
                 * @return value
                 */
                public Passengers getPassengers() {
                    return passengers;
                }

                /** 
                 * Set the 'Passengers' element value.
                 * 
                 * @param passengers
                 */
                public void setPassengers(Passengers passengers) {
                    this.passengers = passengers;
                }

                /** 
                 * Get the 'Services' element value.
                 * 
                 * @return value
                 */
                public Services getServices() {
                    return services;
                }

                /** 
                 * Set the 'Services' element value.
                 * 
                 * @param services
                 */
                public void setServices(Services services) {
                    this.services = services;
                }

                /** 
                 * Get the list of 'OtherAssociation' element items.
                 * 
                 * @return list
                 */
                public List<OtherAssociation> getOtherAssociationList() {
                    return otherAssociationList;
                }

                /** 
                 * Set the list of 'OtherAssociation' element items.
                 * 
                 * @param list
                 */
                public void setOtherAssociationList(List<OtherAssociation> list) {
                    otherAssociationList = list;
                }
                /** 
                 * Passenger(s)/ Group associated with the Offer Item.

                Note: This contains references to Passenger and Group instance(s) defined in the  Passengers node.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Passengers" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:choice>
                 *       &lt;xs:element ref="ns:PassengerReferences"/>
                 *       &lt;xs:element ref="ns:GroupReference"/>
                 *     &lt;/xs:choice>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Passengers implements Serializable
                {
                    private int passengersSelect = -1;
                    private static final int PASSENGER_REFERENCES_CHOICE = 0;
                    private static final int GROUP_REFERENCE_CHOICE = 1;
                    private PassengerReferences passengerReferences;
                    private GroupReference groupReference;

                    private void setPassengersSelect(int choice) {
                        if (passengersSelect == -1) {
                            passengersSelect = choice;
                        } else if (passengersSelect != choice) {
                            throw new IllegalStateException(
                                    "Need to call clearPassengersSelect() before changing existing choice");
                        }
                    }

                    /** 
                     * Clear the choice selection.
                     */
                    public void clearPassengersSelect() {
                        passengersSelect = -1;
                    }

                    /** 
                     * Check if PassengerReferences is current selection for choice.
                     * 
                     * @return <code>true</code> if selection, <code>false</code> if not
                     */
                    public boolean ifPassengerReferences() {
                        return passengersSelect == PASSENGER_REFERENCES_CHOICE;
                    }

                    /** 
                     * Get the 'PassengerReferences' element value. Association to multiple Passenger instance(s). Example: pax1 pax2
                     * 
                     * @return value
                     */
                    public PassengerReferences getPassengerReferences() {
                        return passengerReferences;
                    }

                    /** 
                     * Set the 'PassengerReferences' element value. Association to multiple Passenger instance(s). Example: pax1 pax2
                     * 
                     * @param passengerReferences
                     */
                    public void setPassengerReferences(
                            PassengerReferences passengerReferences) {
                        setPassengersSelect(PASSENGER_REFERENCES_CHOICE);
                        this.passengerReferences = passengerReferences;
                    }

                    /** 
                     * Check if GroupReference is current selection for choice.
                     * 
                     * @return <code>true</code> if selection, <code>false</code> if not
                     */
                    public boolean ifGroupReference() {
                        return passengersSelect == GROUP_REFERENCE_CHOICE;
                    }

                    /** 
                     * Get the 'GroupReference' element value.
                     * 
                     * @return value
                     */
                    public GroupReference getGroupReference() {
                        return groupReference;
                    }

                    /** 
                     * Set the 'GroupReference' element value.
                     * 
                     * @param groupReference
                     */
                    public void setGroupReference(GroupReference groupReference) {
                        setPassengersSelect(GROUP_REFERENCE_CHOICE);
                        this.groupReference = groupReference;
                    }
                }
                /** 
                 * Associated Optional Service(s).
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Services" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element ref="ns:ServiceID" maxOccurs="unbounded"/>
                 *       &lt;xs:element name="Passengers" minOccurs="0">
                 *         &lt;!-- Reference to inner class Passengers -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Services implements Serializable
                {
                    private List<ServiceIDType> serviceIDList = new ArrayList<ServiceIDType>();
                    private Passengers passengers;

                    /** 
                     * Get the list of 'ServiceID' element items.
                     * 
                     * @return list
                     */
                    public List<ServiceIDType> getServiceIDList() {
                        return serviceIDList;
                    }

                    /** 
                     * Set the list of 'ServiceID' element items.
                     * 
                     * @param list
                     */
                    public void setServiceIDList(List<ServiceIDType> list) {
                        serviceIDList = list;
                    }

                    /** 
                     * Get the 'Passengers' element value.
                     * 
                     * @return value
                     */
                    public Passengers getPassengers() {
                        return passengers;
                    }

                    /** 
                     * Set the 'Passengers' element value.
                     * 
                     * @param passengers
                     */
                    public void setPassengers(Passengers passengers) {
                        this.passengers = passengers;
                    }
                    /** 
                     * Passenger(s)/ Group associated with the Offer Item.

                    Note: This contains references to Passenger and Group instance(s) defined in the  Passengers node.
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Passengers" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:choice>
                     *       &lt;xs:element ref="ns:PassengerReferences"/>
                     *       &lt;xs:element ref="ns:GroupReference"/>
                     *     &lt;/xs:choice>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Passengers implements Serializable
                    {
                        private int passengersSelect = -1;
                        private static final int PASSENGER_REFERENCES_CHOICE = 0;
                        private static final int GROUP_REFERENCE_CHOICE = 1;
                        private PassengerReferences passengerReferences;
                        private GroupReference groupReference;

                        private void setPassengersSelect(int choice) {
                            if (passengersSelect == -1) {
                                passengersSelect = choice;
                            } else if (passengersSelect != choice) {
                                throw new IllegalStateException(
                                        "Need to call clearPassengersSelect() before changing existing choice");
                            }
                        }

                        /** 
                         * Clear the choice selection.
                         */
                        public void clearPassengersSelect() {
                            passengersSelect = -1;
                        }

                        /** 
                         * Check if PassengerReferences is current selection for choice.
                         * 
                         * @return <code>true</code> if selection, <code>false</code> if not
                         */
                        public boolean ifPassengerReferences() {
                            return passengersSelect == PASSENGER_REFERENCES_CHOICE;
                        }

                        /** 
                         * Get the 'PassengerReferences' element value. Association to multiple Passenger instance(s). Example: pax1 pax2
                         * 
                         * @return value
                         */
                        public PassengerReferences getPassengerReferences() {
                            return passengerReferences;
                        }

                        /** 
                         * Set the 'PassengerReferences' element value. Association to multiple Passenger instance(s). Example: pax1 pax2
                         * 
                         * @param passengerReferences
                         */
                        public void setPassengerReferences(
                                PassengerReferences passengerReferences) {
                            setPassengersSelect(PASSENGER_REFERENCES_CHOICE);
                            this.passengerReferences = passengerReferences;
                        }

                        /** 
                         * Check if GroupReference is current selection for choice.
                         * 
                         * @return <code>true</code> if selection, <code>false</code> if not
                         */
                        public boolean ifGroupReference() {
                            return passengersSelect == GROUP_REFERENCE_CHOICE;
                        }

                        /** 
                         * Get the 'GroupReference' element value.
                         * 
                         * @return value
                         */
                        public GroupReference getGroupReference() {
                            return groupReference;
                        }

                        /** 
                         * Set the 'GroupReference' element value.
                         * 
                         * @param groupReference
                         */
                        public void setGroupReference(
                                GroupReference groupReference) {
                            setPassengersSelect(GROUP_REFERENCE_CHOICE);
                            this.groupReference = groupReference;
                        }
                    }
                }
                /** 
                 * Other Named Association(s).

                Note: Includes an association type choice (e.g. MediaGroup) and an instance association value (e.g. mediagrp1).
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OtherAssociation" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="required" name="Type"/>
                 *     &lt;xs:attribute type="xs:string" use="required" name="ReferenceValue"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class OtherAssociation implements Serializable
                {
                    private String type;
                    private String referenceValue;

                    /** 
                     * Get the 'Type' attribute value. Named Instance Association Type. Examples: CarryOnAllowance, MediaGroup
                     * 
                     * @return value
                     */
                    public String getType() {
                        return type;
                    }

                    /** 
                     * Set the 'Type' attribute value. Named Instance Association Type. Examples: CarryOnAllowance, MediaGroup
                     * 
                     * @param type
                     */
                    public void setType(String type) {
                        this.type = type;
                    }

                    /** 
                     * Get the 'ReferenceValue' attribute value. Associated object instance value.
                    Example: mediagrp1
                     * 
                     * @return value
                     */
                    public String getReferenceValue() {
                        return referenceValue;
                    }

                    /** 
                     * Set the 'ReferenceValue' attribute value. Associated object instance value.
                    Example: mediagrp1
                     * 
                     * @param referenceValue
                     */
                    public void setReferenceValue(String referenceValue) {
                        this.referenceValue = referenceValue;
                    }
                }
            }
            /** 
             * Ticket/document information.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TicketDocInfo" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="AgentIDs" minOccurs="0">
             *         &lt;!-- Reference to inner class AgentIDs -->
             *       &lt;/xs:element>
             *       &lt;xs:element ref="ns:IssuingAirlineInfo" minOccurs="0"/>
             *       &lt;xs:element ref="ns:TicketDocument" maxOccurs="4"/>
             *       &lt;xs:element ref="ns:CarrierFeeInfo" minOccurs="0"/>
             *       &lt;xs:element ref="ns:OriginalIssueInfo" minOccurs="0"/>
             *       &lt;xs:element name="Passengers" minOccurs="0">
             *         &lt;!-- Reference to inner class Passengers -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class TicketDocInfo implements Serializable
            {
                private AgentIDs agentIDs;
                private AirlineIssuanceType issuingAirlineInfo;
                private List<TicketDocument> ticketDocumentList = new ArrayList<TicketDocument>();
                private CarrierFeeInfoType carrierFeeInfo;
                private OriginalIssueType originalIssueInfo;
                private Passengers passengers;

                /** 
                 * Get the 'AgentIDs' element value.
                 * 
                 * @return value
                 */
                public AgentIDs getAgentIDs() {
                    return agentIDs;
                }

                /** 
                 * Set the 'AgentIDs' element value.
                 * 
                 * @param agentIDs
                 */
                public void setAgentIDs(AgentIDs agentIDs) {
                    this.agentIDs = agentIDs;
                }

                /** 
                 * Get the 'IssuingAirlineInfo' element value.
                 * 
                 * @return value
                 */
                public AirlineIssuanceType getIssuingAirlineInfo() {
                    return issuingAirlineInfo;
                }

                /** 
                 * Set the 'IssuingAirlineInfo' element value.
                 * 
                 * @param issuingAirlineInfo
                 */
                public void setIssuingAirlineInfo(
                        AirlineIssuanceType issuingAirlineInfo) {
                    this.issuingAirlineInfo = issuingAirlineInfo;
                }

                /** 
                 * Get the list of 'TicketDocument' element items.
                 * 
                 * @return list
                 */
                public List<TicketDocument> getTicketDocumentList() {
                    return ticketDocumentList;
                }

                /** 
                 * Set the list of 'TicketDocument' element items.
                 * 
                 * @param list
                 */
                public void setTicketDocumentList(List<TicketDocument> list) {
                    ticketDocumentList = list;
                }

                /** 
                 * Get the 'CarrierFeeInfo' element value.
                 * 
                 * @return value
                 */
                public CarrierFeeInfoType getCarrierFeeInfo() {
                    return carrierFeeInfo;
                }

                /** 
                 * Set the 'CarrierFeeInfo' element value.
                 * 
                 * @param carrierFeeInfo
                 */
                public void setCarrierFeeInfo(CarrierFeeInfoType carrierFeeInfo) {
                    this.carrierFeeInfo = carrierFeeInfo;
                }

                /** 
                 * Get the 'OriginalIssueInfo' element value.
                 * 
                 * @return value
                 */
                public OriginalIssueType getOriginalIssueInfo() {
                    return originalIssueInfo;
                }

                /** 
                 * Set the 'OriginalIssueInfo' element value.
                 * 
                 * @param originalIssueInfo
                 */
                public void setOriginalIssueInfo(
                        OriginalIssueType originalIssueInfo) {
                    this.originalIssueInfo = originalIssueInfo;
                }

                /** 
                 * Get the 'Passengers' element value.
                 * 
                 * @return value
                 */
                public Passengers getPassengers() {
                    return passengers;
                }

                /** 
                 * Set the 'Passengers' element value.
                 * 
                 * @param passengers
                 */
                public void setPassengers(Passengers passengers) {
                    this.passengers = passengers;
                }
                /** 
                 * Booking and Servicing Agent information.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AgentIDs" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element ref="ns:AgentID" maxOccurs="2"/>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class AgentIDs implements Serializable
                {
                    private List<CouponAgentType> agentIDList = new ArrayList<CouponAgentType>();

                    /** 
                     * Get the list of 'AgentID' element items.
                     * 
                     * @return list
                     */
                    public List<CouponAgentType> getAgentIDList() {
                        return agentIDList;
                    }

                    /** 
                     * Set the list of 'AgentID' element items.
                     * 
                     * @param list
                     */
                    public void setAgentIDList(List<CouponAgentType> list) {
                        agentIDList = list;
                    }
                }
                /** 
                 * Passenger(s)/ Group associated with the Offer Item.

                Note: This contains references to Passenger and Group instance(s) defined in the  Passengers node.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Passengers" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:choice>
                 *       &lt;xs:element ref="ns:PassengerReferences"/>
                 *       &lt;xs:element ref="ns:GroupReference"/>
                 *     &lt;/xs:choice>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Passengers implements Serializable
                {
                    private int passengersSelect = -1;
                    private static final int PASSENGER_REFERENCES_CHOICE = 0;
                    private static final int GROUP_REFERENCE_CHOICE = 1;
                    private PassengerReferences passengerReferences;
                    private GroupReference groupReference;

                    private void setPassengersSelect(int choice) {
                        if (passengersSelect == -1) {
                            passengersSelect = choice;
                        } else if (passengersSelect != choice) {
                            throw new IllegalStateException(
                                    "Need to call clearPassengersSelect() before changing existing choice");
                        }
                    }

                    /** 
                     * Clear the choice selection.
                     */
                    public void clearPassengersSelect() {
                        passengersSelect = -1;
                    }

                    /** 
                     * Check if PassengerReferences is current selection for choice.
                     * 
                     * @return <code>true</code> if selection, <code>false</code> if not
                     */
                    public boolean ifPassengerReferences() {
                        return passengersSelect == PASSENGER_REFERENCES_CHOICE;
                    }

                    /** 
                     * Get the 'PassengerReferences' element value. Association to multiple Passenger instance(s). Example: pax1 pax2
                     * 
                     * @return value
                     */
                    public PassengerReferences getPassengerReferences() {
                        return passengerReferences;
                    }

                    /** 
                     * Set the 'PassengerReferences' element value. Association to multiple Passenger instance(s). Example: pax1 pax2
                     * 
                     * @param passengerReferences
                     */
                    public void setPassengerReferences(
                            PassengerReferences passengerReferences) {
                        setPassengersSelect(PASSENGER_REFERENCES_CHOICE);
                        this.passengerReferences = passengerReferences;
                    }

                    /** 
                     * Check if GroupReference is current selection for choice.
                     * 
                     * @return <code>true</code> if selection, <code>false</code> if not
                     */
                    public boolean ifGroupReference() {
                        return passengersSelect == GROUP_REFERENCE_CHOICE;
                    }

                    /** 
                     * Get the 'GroupReference' element value.
                     * 
                     * @return value
                     */
                    public GroupReference getGroupReference() {
                        return groupReference;
                    }

                    /** 
                     * Set the 'GroupReference' element value.
                     * 
                     * @param groupReference
                     */
                    public void setGroupReference(GroupReference groupReference) {
                        setPassengersSelect(GROUP_REFERENCE_CHOICE);
                        this.groupReference = groupReference;
                    }
                }
            }
        }
    }
}
