
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * OTHER ORDER ITEM definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OtherItemType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:KeyWithMetaObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element name="Price">
 *           &lt;xs:complexType>
 *             &lt;xs:choice>
 *               &lt;xs:element ref="ns:SimpleCurrencyPrice"/>
 *               &lt;xs:element ref="ns:EncodedCurrencyPrice"/>
 *               &lt;xs:element ref="ns:DetailCurrencyPrice"/>
 *               &lt;xs:element ref="ns:CombinationPricing"/>
 *               &lt;xs:element ref="ns:AwardPricing"/>
 *             &lt;/xs:choice>
 *           &lt;/xs:complexType>
 *         &lt;/xs:element>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class OtherItemType extends KeyWithMetaObjectBaseType implements
    Serializable
{
    private int priceSelect = -1;
    private static final int PRICE_SIMPLE_CURRENCY_PRICE_CHOICE = 0;
    private static final int PRICE_ENCODED_CURRENCY_PRICE_CHOICE = 1;
    private static final int PRICE_DETAIL_CURRENCY_PRICE_CHOICE = 2;
    private static final int PRICE_COMBINATION_PRICING_CHOICE = 3;
    private static final int PRICE_AWARD_PRICING_CHOICE = 4;
    private SimpleCurrencyPrice priceSimpleCurrencyPrice;
    private EncodedCurrencyPrice priceEncodedCurrencyPrice;
    private DetailCurrencyPriceType priceDetailCurrencyPrice;
    private CombinationPriceType priceCombinationPricing;
    private AwardPriceUnitType priceAwardPricing;

    private void setPriceSelect(int choice) {
        if (priceSelect == -1) {
            priceSelect = choice;
        } else if (priceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearPriceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearPriceSelect() {
        priceSelect = -1;
    }

    /** 
     * Check if PriceSimpleCurrencyPrice is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifPriceSimpleCurrencyPrice() {
        return priceSelect == PRICE_SIMPLE_CURRENCY_PRICE_CHOICE;
    }

    /** 
     * Get the 'SimpleCurrencyPrice' element value.
     * 
     * @return value
     */
    public SimpleCurrencyPrice getPriceSimpleCurrencyPrice() {
        return priceSimpleCurrencyPrice;
    }

    /** 
     * Set the 'SimpleCurrencyPrice' element value.
     * 
     * @param priceSimpleCurrencyPrice
     */
    public void setPriceSimpleCurrencyPrice(
            SimpleCurrencyPrice priceSimpleCurrencyPrice) {
        setPriceSelect(PRICE_SIMPLE_CURRENCY_PRICE_CHOICE);
        this.priceSimpleCurrencyPrice = priceSimpleCurrencyPrice;
    }

    /** 
     * Check if PriceEncodedCurrencyPrice is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifPriceEncodedCurrencyPrice() {
        return priceSelect == PRICE_ENCODED_CURRENCY_PRICE_CHOICE;
    }

    /** 
     * Get the 'EncodedCurrencyPrice' element value.
     * 
     * @return value
     */
    public EncodedCurrencyPrice getPriceEncodedCurrencyPrice() {
        return priceEncodedCurrencyPrice;
    }

    /** 
     * Set the 'EncodedCurrencyPrice' element value.
     * 
     * @param priceEncodedCurrencyPrice
     */
    public void setPriceEncodedCurrencyPrice(
            EncodedCurrencyPrice priceEncodedCurrencyPrice) {
        setPriceSelect(PRICE_ENCODED_CURRENCY_PRICE_CHOICE);
        this.priceEncodedCurrencyPrice = priceEncodedCurrencyPrice;
    }

    /** 
     * Check if PriceDetailCurrencyPrice is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifPriceDetailCurrencyPrice() {
        return priceSelect == PRICE_DETAIL_CURRENCY_PRICE_CHOICE;
    }

    /** 
     * Get the 'DetailCurrencyPrice' element value.
     * 
     * @return value
     */
    public DetailCurrencyPriceType getPriceDetailCurrencyPrice() {
        return priceDetailCurrencyPrice;
    }

    /** 
     * Set the 'DetailCurrencyPrice' element value.
     * 
     * @param priceDetailCurrencyPrice
     */
    public void setPriceDetailCurrencyPrice(
            DetailCurrencyPriceType priceDetailCurrencyPrice) {
        setPriceSelect(PRICE_DETAIL_CURRENCY_PRICE_CHOICE);
        this.priceDetailCurrencyPrice = priceDetailCurrencyPrice;
    }

    /** 
     * Check if PriceCombinationPricing is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifPriceCombinationPricing() {
        return priceSelect == PRICE_COMBINATION_PRICING_CHOICE;
    }

    /** 
     * Get the 'CombinationPricing' element value.
     * 
     * @return value
     */
    public CombinationPriceType getPriceCombinationPricing() {
        return priceCombinationPricing;
    }

    /** 
     * Set the 'CombinationPricing' element value.
     * 
     * @param priceCombinationPricing
     */
    public void setPriceCombinationPricing(
            CombinationPriceType priceCombinationPricing) {
        setPriceSelect(PRICE_COMBINATION_PRICING_CHOICE);
        this.priceCombinationPricing = priceCombinationPricing;
    }

    /** 
     * Check if PriceAwardPricing is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifPriceAwardPricing() {
        return priceSelect == PRICE_AWARD_PRICING_CHOICE;
    }

    /** 
     * Get the 'AwardPricing' element value.
     * 
     * @return value
     */
    public AwardPriceUnitType getPriceAwardPricing() {
        return priceAwardPricing;
    }

    /** 
     * Set the 'AwardPricing' element value.
     * 
     * @param priceAwardPricing
     */
    public void setPriceAwardPricing(AwardPriceUnitType priceAwardPricing) {
        setPriceSelect(PRICE_AWARD_PRICING_CHOICE);
        this.priceAwardPricing = priceAwardPricing;
    }
}
