
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * A data type for Requested and Priced Passenger Type Code(s) and Quantity.

 Passenger type code and Traveler quantity.  Example: ADT

 Encoding scheme:  IATA (three character) Passenger Type Code
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PTC_QuantityPricedType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:AssociatedObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="ns:PTC_QuantityType" name="Requested" minOccurs="0"/>
 *         &lt;xs:element type="ns:PTC_QuantityType" name="Priced" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PTCQuantityPricedType extends AssociatedObjectBaseType implements
    Serializable
{
    private PTCQuantityType requested;
    private PTCQuantityType priced;

    /** 
     * Get the 'Requested' element value. Requested passenger type code for pricing. Example: CHD

    Encoding scheme: IATA (three character) Passenger Type Code
     * 
     * @return value
     */
    public PTCQuantityType getRequested() {
        return requested;
    }

    /** 
     * Set the 'Requested' element value. Requested passenger type code for pricing. Example: CHD

    Encoding scheme: IATA (three character) Passenger Type Code
     * 
     * @param requested
     */
    public void setRequested(PTCQuantityType requested) {
        this.requested = requested;
    }

    /** 
     * Get the 'Priced' element value. Actual passenger type code used for for pricing.  Example: ADT

    Encoding scheme: IATA (three character) Passenger Type Code
     * 
     * @return value
     */
    public PTCQuantityType getPriced() {
        return priced;
    }

    /** 
     * Set the 'Priced' element value. Actual passenger type code used for for pricing.  Example: ADT

    Encoding scheme: IATA (three character) Passenger Type Code
     * 
     * @param priced
     */
    public void setPriced(PTCQuantityType priced) {
        this.priced = priced;
    }
}
