
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * Passenger.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Passenger">
 *   &lt;xs:complexType>
 *     &lt;xs:complexContent>
 *       &lt;xs:extension base="ns:PassengerSummaryType">
 *         &lt;xs:sequence>
 *           &lt;xs:element name="AdditionalRoles" minOccurs="0">
 *             &lt;!-- Reference to inner class AdditionalRoles -->
 *           &lt;/xs:element>
 *         &lt;/xs:sequence>
 *       &lt;/xs:extension>
 *     &lt;/xs:complexContent>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class Passenger extends PassengerSummaryType implements Serializable
{
    private AdditionalRoles additionalRoles;

    /** 
     * Get the 'AdditionalRoles' element value.
     * 
     * @return value
     */
    public AdditionalRoles getAdditionalRoles() {
        return additionalRoles;
    }

    /** 
     * Set the 'AdditionalRoles' element value.
     * 
     * @param additionalRoles
     */
    public void setAdditionalRoles(AdditionalRoles additionalRoles) {
        this.additionalRoles = additionalRoles;
    }
    /** 
     * Additional Passenger Role(s), including Primary Contact and Payment Contact.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AdditionalRoles" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:boolean" use="optional" name="PrimaryContactInd"/>
     *     &lt;xs:attribute type="xs:boolean" use="optional" name="PaymentContactInd"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class AdditionalRoles implements Serializable
    {
        private Boolean primaryContactInd;
        private Boolean paymentContactInd;

        /** 
         * Get the 'PrimaryContactInd' attribute value. When TRUE, this person is a PRIMARY CONTACT, e.g. for a group, for an order, for an itinerary, etc.
         * 
         * @return value
         */
        public Boolean getPrimaryContactInd() {
            return primaryContactInd;
        }

        /** 
         * Set the 'PrimaryContactInd' attribute value. When TRUE, this person is a PRIMARY CONTACT, e.g. for a group, for an order, for an itinerary, etc.
         * 
         * @param primaryContactInd
         */
        public void setPrimaryContactInd(Boolean primaryContactInd) {
            this.primaryContactInd = primaryContactInd;
        }

        /** 
         * Get the 'PaymentContactInd' attribute value. When TRUE, this Passenger is responsible for payment.
         * 
         * @return value
         */
        public Boolean getPaymentContactInd() {
            return paymentContactInd;
        }

        /** 
         * Set the 'PaymentContactInd' attribute value. When TRUE, this Passenger is responsible for payment.
         * 
         * @param paymentContactInd
         */
        public void setPaymentContactInd(Boolean paymentContactInd) {
            this.paymentContactInd = paymentContactInd;
        }
    }
}
