
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

/** 
 * A data type for SUMMARY PASSENGER representation.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PassengerSummaryType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:TravelerSummaryType">
 *       &lt;xs:sequence>
 *         &lt;xs:element ref="ns:Contacts" minOccurs="0"/>
 *         &lt;xs:element name="FQTVs" minOccurs="0">
 *           &lt;!-- Reference to inner class FQTVs -->
 *         &lt;/xs:element>
 *         &lt;xs:element name="Gender" minOccurs="0">
 *           &lt;!-- Reference to inner class Gender -->
 *         &lt;/xs:element>
 *         &lt;xs:element ref="ns:Remarks" minOccurs="0"/>
 *         &lt;xs:element name="PassengerIDInfo" minOccurs="0">
 *           &lt;!-- Reference to inner class PassengerIDInfo -->
 *         &lt;/xs:element>
 *       &lt;/xs:sequence>
 *       &lt;xs:attribute type="xs:boolean" use="optional" name="ConsentInd"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PassengerSummaryType extends TravelerSummaryType implements
    Serializable
{
    private Contacts contacts;
    private FQTVs FQTVs1;
    private Gender gender;
    private Remarks remarks;
    private PassengerIDInfo passengerIDInfo;
    private Boolean consentInd;

    /** 
     * Get the 'Contacts' element value.
     * 
     * @return value
     */
    public Contacts getContacts() {
        return contacts;
    }

    /** 
     * Set the 'Contacts' element value.
     * 
     * @param contacts
     */
    public void setContacts(Contacts contacts) {
        this.contacts = contacts;
    }

    /** 
     * Get the 'FQTVs' element value.
     * 
     * @return value
     */
    public FQTVs getFQTVs1() {
        return FQTVs1;
    }

    /** 
     * Set the 'FQTVs' element value.
     * 
     * @param FQTVs1
     */
    public void setFQTVs1(FQTVs FQTVs1) {
        this.FQTVs1 = FQTVs1;
    }

    /** 
     * Get the 'Gender' element value.
     * 
     * @return value
     */
    public Gender getGender() {
        return gender;
    }

    /** 
     * Set the 'Gender' element value.
     * 
     * @param gender
     */
    public void setGender(Gender gender) {
        this.gender = gender;
    }

    /** 
     * Get the 'Remarks' element value.
     * 
     * @return value
     */
    public Remarks getRemarks() {
        return remarks;
    }

    /** 
     * Set the 'Remarks' element value.
     * 
     * @param remarks
     */
    public void setRemarks(Remarks remarks) {
        this.remarks = remarks;
    }

    /** 
     * Get the 'PassengerIDInfo' element value.
     * 
     * @return value
     */
    public PassengerIDInfo getPassengerIDInfo() {
        return passengerIDInfo;
    }

    /** 
     * Set the 'PassengerIDInfo' element value.
     * 
     * @param passengerIDInfo
     */
    public void setPassengerIDInfo(PassengerIDInfo passengerIDInfo) {
        this.passengerIDInfo = passengerIDInfo;
    }

    /** 
     * Get the 'ConsentInd' attribute value. When TRUE, passenger authorize the airline to share his/her profile information or send promotional emails.
     * 
     * @return value
     */
    public Boolean getConsentInd() {
        return consentInd;
    }

    /** 
     * Set the 'ConsentInd' attribute value. When TRUE, passenger authorize the airline to share his/her profile information or send promotional emails.
     * 
     * @param consentInd
     */
    public void setConsentInd(Boolean consentInd) {
        this.consentInd = consentInd;
    }
    /** 
     * Traveler Frequent Traveler Program(s).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FQTVs" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="ns:KeyWithMetaObjectBaseType">
     *         &lt;xs:sequence>
     *           &lt;xs:element ref="ns:FQTV_Alliance" minOccurs="0" maxOccurs="unbounded"/>
     *           &lt;xs:element ref="ns:FQTV_ProgramCore" minOccurs="0" maxOccurs="unbounded"/>
     *           &lt;xs:element ref="ns:FQTV_ProgramDetail" minOccurs="0" maxOccurs="unbounded"/>
     *           &lt;xs:element ref="ns:FQTV_ProgramSummary" minOccurs="0" maxOccurs="unbounded"/>
     *           &lt;xs:element ref="ns:TravelerFQTV_Information" minOccurs="0" maxOccurs="unbounded"/>
     *         &lt;/xs:sequence>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class FQTVs extends KeyWithMetaObjectBaseType implements
        Serializable
    {
        private List<FQTVAllianceType> FQTVAllianceList = new ArrayList<FQTVAllianceType>();
        private List<FQTVProgramCoreType> FQTVProgramCoreList = new ArrayList<FQTVProgramCoreType>();
        private List<FQTVProgramDetailType> FQTVProgramDetailList = new ArrayList<FQTVProgramDetailType>();
        private List<FQTVProgramSummaryType> FQTVProgramSummaryList = new ArrayList<FQTVProgramSummaryType>();
        private List<TravelerFQTVType> travelerFQTVInformationList = new ArrayList<TravelerFQTVType>();

        /** 
         * Get the list of 'FQTV_Alliance' element items.
         * 
         * @return list
         */
        public List<FQTVAllianceType> getFQTVAllianceList() {
            return FQTVAllianceList;
        }

        /** 
         * Set the list of 'FQTV_Alliance' element items.
         * 
         * @param list
         */
        public void setFQTVAllianceList(List<FQTVAllianceType> list) {
            FQTVAllianceList = list;
        }

        /** 
         * Get the list of 'FQTV_ProgramCore' element items. FQTV Program main information.
         * 
         * @return list
         */
        public List<FQTVProgramCoreType> getFQTVProgramCoreList() {
            return FQTVProgramCoreList;
        }

        /** 
         * Set the list of 'FQTV_ProgramCore' element items. FQTV Program main information.
         * 
         * @param list
         */
        public void setFQTVProgramCoreList(List<FQTVProgramCoreType> list) {
            FQTVProgramCoreList = list;
        }

        /** 
         * Get the list of 'FQTV_ProgramDetail' element items. FQTV Program information, details.
         * 
         * @return list
         */
        public List<FQTVProgramDetailType> getFQTVProgramDetailList() {
            return FQTVProgramDetailList;
        }

        /** 
         * Set the list of 'FQTV_ProgramDetail' element items. FQTV Program information, details.
         * 
         * @param list
         */
        public void setFQTVProgramDetailList(List<FQTVProgramDetailType> list) {
            FQTVProgramDetailList = list;
        }

        /** 
         * Get the list of 'FQTV_ProgramSummary' element items. FQTV Program information summary.
         * 
         * @return list
         */
        public List<FQTVProgramSummaryType> getFQTVProgramSummaryList() {
            return FQTVProgramSummaryList;
        }

        /** 
         * Set the list of 'FQTV_ProgramSummary' element items. FQTV Program information summary.
         * 
         * @param list
         */
        public void setFQTVProgramSummaryList(List<FQTVProgramSummaryType> list) {
            FQTVProgramSummaryList = list;
        }

        /** 
         * Get the list of 'TravelerFQTV_Information' element items. Traveler Frequent Flyer (FQTV) Account Information.

         * 
         * @return list
         */
        public List<TravelerFQTVType> getTravelerFQTVInformationList() {
            return travelerFQTVInformationList;
        }

        /** 
         * Set the list of 'TravelerFQTV_Information' element items. Traveler Frequent Flyer (FQTV) Account Information.

         * 
         * @param list
         */
        public void setTravelerFQTVInformationList(List<TravelerFQTVType> list) {
            travelerFQTVInformationList = list;
        }
    }
    /** 
     * Passenger Gender
    Example: Male
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Gender" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="ns:TravelerGenderSimpleType">
     *         &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * 
     * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
     *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
     * &lt;/xs:attributeGroup>
     * </pre>
     */
    public static class Gender implements Serializable
    {
        private TravelerGenderSimpleType travelerGenderSimpleType;
        private String refs;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public TravelerGenderSimpleType getTravelerGenderSimpleType() {
            return travelerGenderSimpleType;
        }

        /** 
         * Set the extension value.
         * 
         * @param travelerGenderSimpleType
         */
        public void setTravelerGenderSimpleType(
                TravelerGenderSimpleType travelerGenderSimpleType) {
            this.travelerGenderSimpleType = travelerGenderSimpleType;
        }

        /** 
         * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @return value
         */
        public String getRefs() {
            return refs;
        }

        /** 
         * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @param refs
         */
        public void setRefs(String refs) {
            this.refs = refs;
        }
    }
    /** 
     * Passenger FOID and other documents information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PassengerIDInfo" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="FOID" minOccurs="0">
     *         &lt;!-- Reference to inner class FOID -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="PassengerDocument" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class PassengerDocument -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:boolean" use="optional" name="AllowDocumentInd"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class PassengerIDInfo implements Serializable
    {
        private FOID FOID1;
        private List<PassengerDocument> passengerDocumentList = new ArrayList<PassengerDocument>();
        private Boolean allowDocumentInd;

        /** 
         * Get the 'FOID' element value.
         * 
         * @return value
         */
        public FOID getFOID1() {
            return FOID1;
        }

        /** 
         * Set the 'FOID' element value.
         * 
         * @param FOID1
         */
        public void setFOID1(FOID FOID1) {
            this.FOID1 = FOID1;
        }

        /** 
         * Get the list of 'PassengerDocument' element items.
         * 
         * @return list
         */
        public List<PassengerDocument> getPassengerDocumentList() {
            return passengerDocumentList;
        }

        /** 
         * Set the list of 'PassengerDocument' element items.
         * 
         * @param list
         */
        public void setPassengerDocumentList(List<PassengerDocument> list) {
            passengerDocumentList = list;
        }

        /** 
         * Get the 'AllowDocumentInd' attribute value. An indicator, allowing use the document number
         * 
         * @return value
         */
        public Boolean getAllowDocumentInd() {
            return allowDocumentInd;
        }

        /** 
         * Set the 'AllowDocumentInd' attribute value. An indicator, allowing use the document number
         * 
         * @param allowDocumentInd
         */
        public void setAllowDocumentInd(Boolean allowDocumentInd) {
            this.allowDocumentInd = allowDocumentInd;
        }
        /** 
         * Passenger Form of Identification.

        Note: This is the type of FOID as defined in IATA AIRIMP.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FOID" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:string" name="Type"/>
         *       &lt;xs:element name="ID">
         *         &lt;xs:complexType>
         *           &lt;xs:simpleContent>
         *             &lt;xs:extension base="xs:string">
         *               &lt;xs:attribute type="xs:string" use="optional" name="VendorCode"/>
         *             &lt;/xs:extension>
         *           &lt;/xs:simpleContent>
         *         &lt;/xs:complexType>
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class FOID implements Serializable
        {
            private String type;
            private String IDString;
            private String IDVendorCode;

            /** 
             * Get the 'Type' element value. ID form. Examples: PP (passport), CC (credit card), FF (frequent flyer), DL (drivers license)
             * 
             * @return value
             */
            public String getType() {
                return type;
            }

            /** 
             * Set the 'Type' element value. ID form. Examples: PP (passport), CC (credit card), FF (frequent flyer), DL (drivers license)
             * 
             * @param type
             */
            public void setType(String type) {
                this.type = type;
            }

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getIDString() {
                return IDString;
            }

            /** 
             * Set the extension value.
             * 
             * @param IDString
             */
            public void setIDString(String IDString) {
                this.IDString = IDString;
            }

            /** 
             * Get the 'VendorCode' attribute value. The vendor code for example for CC issuer
             * 
             * @return value
             */
            public String getIDVendorCode() {
                return IDVendorCode;
            }

            /** 
             * Set the 'VendorCode' attribute value. The vendor code for example for CC issuer
             * 
             * @param IDVendorCode
             */
            public void setIDVendorCode(String IDVendorCode) {
                this.IDVendorCode = IDVendorCode;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PassengerDocument" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:string" name="Type"/>
         *       &lt;xs:element type="xs:string" name="ID"/>
         *       &lt;xs:element type="xs:string" name="BirthCountry" minOccurs="0"/>
         *       &lt;xs:element type="xs:date" name="DateOfIssue" minOccurs="0"/>
         *       &lt;xs:element type="xs:date" name="DateOfExpiration" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="CountryOfIssuance" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="ApplicabilityLocation" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="CountryOfResidence" minOccurs="0"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PassengerDocument implements Serializable
        {
            private String type;
            private String ID;
            private String birthCountry;
            private Date dateOfIssue;
            private Date dateOfExpiration;
            private String countryOfIssuance;
            private String applicabilityLocation;
            private String countryOfResidence;

            /** 
             * Get the 'Type' element value. The type of passenger document. 
            Examples: PT (Passport), VI (Visa), 7TR (Transit visa)
            Encoding schema: PADIS 7365, Processing indicator, coded.
             * 
             * @return value
             */
            public String getType() {
                return type;
            }

            /** 
             * Set the 'Type' element value. The type of passenger document. 
            Examples: PT (Passport), VI (Visa), 7TR (Transit visa)
            Encoding schema: PADIS 7365, Processing indicator, coded.
             * 
             * @param type
             */
            public void setType(String type) {
                this.type = type;
            }

            /** 
             * Get the 'ID' element value. Document ID value. Example: NY122345
             * 
             * @return value
             */
            public String getID() {
                return ID;
            }

            /** 
             * Set the 'ID' element value. Document ID value. Example: NY122345
             * 
             * @param ID
             */
            public void setID(String ID) {
                this.ID = ID;
            }

            /** 
             * Get the 'BirthCountry' element value. Country of Birth. Country Name or Code. For Example. Germany, DE
             * 
             * @return value
             */
            public String getBirthCountry() {
                return birthCountry;
            }

            /** 
             * Set the 'BirthCountry' element value. Country of Birth. Country Name or Code. For Example. Germany, DE
             * 
             * @param birthCountry
             */
            public void setBirthCountry(String birthCountry) {
                this.birthCountry = birthCountry;
            }

            /** 
             * Get the 'DateOfIssue' element value. Date of Issue. Example: 2017-01-13
             * 
             * @return value
             */
            public Date getDateOfIssue() {
                return dateOfIssue;
            }

            /** 
             * Set the 'DateOfIssue' element value. Date of Issue. Example: 2017-01-13
             * 
             * @param dateOfIssue
             */
            public void setDateOfIssue(Date dateOfIssue) {
                this.dateOfIssue = dateOfIssue;
            }

            /** 
             * Get the 'DateOfExpiration' element value. Date of expiration. Example: 2017-01-13
             * 
             * @return value
             */
            public Date getDateOfExpiration() {
                return dateOfExpiration;
            }

            /** 
             * Set the 'DateOfExpiration' element value. Date of expiration. Example: 2017-01-13
             * 
             * @param dateOfExpiration
             */
            public void setDateOfExpiration(Date dateOfExpiration) {
                this.dateOfExpiration = dateOfExpiration;
            }

            /** 
             * Get the 'CountryOfIssuance' element value. Country name from where the document has been issued.
             * 
             * @return value
             */
            public String getCountryOfIssuance() {
                return countryOfIssuance;
            }

            /** 
             * Set the 'CountryOfIssuance' element value. Country name from where the document has been issued.
             * 
             * @param countryOfIssuance
             */
            public void setCountryOfIssuance(String countryOfIssuance) {
                this.countryOfIssuance = countryOfIssuance;
            }

            /** 
             * Get the 'ApplicabilityLocation' element value. The location where the document is applicable.
             * 
             * @return value
             */
            public String getApplicabilityLocation() {
                return applicabilityLocation;
            }

            /** 
             * Set the 'ApplicabilityLocation' element value. The location where the document is applicable.
             * 
             * @param applicabilityLocation
             */
            public void setApplicabilityLocation(String applicabilityLocation) {
                this.applicabilityLocation = applicabilityLocation;
            }

            /** 
             * Get the 'CountryOfResidence' element value. Country where passenger resides.
             * 
             * @return value
             */
            public String getCountryOfResidence() {
                return countryOfResidence;
            }

            /** 
             * Set the 'CountryOfResidence' element value. Country where passenger resides.
             * 
             * @param countryOfResidence
             */
            public void setCountryOfResidence(String countryOfResidence) {
                this.countryOfResidence = countryOfResidence;
            }
        }
    }
}
