
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * PAYMENT CARD Payment Method definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PaymentCardMethodType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:KeyWithMetaObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="xs:string" name="CardType" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="CardCode" minOccurs="0"/>
 *         &lt;xs:element name="MaskedCardNumber" minOccurs="0">
 *           &lt;!-- Reference to inner class MaskedCardNumber -->
 *         &lt;/xs:element>
 *         &lt;xs:element type="xs:string" name="TokenizedCardNumber" minOccurs="0"/>
 *         &lt;xs:element ref="ns:Contacts" minOccurs="0"/>
 *         &lt;xs:element name="CardHolderName" minOccurs="0">
 *           &lt;!-- Reference to inner class CardHolderName -->
 *         &lt;/xs:element>
 *         &lt;xs:element name="CardIssuerName" minOccurs="0">
 *           &lt;!-- Reference to inner class CardIssuerName -->
 *         &lt;/xs:element>
 *         &lt;xs:element name="CardholderAddress" minOccurs="0">
 *           &lt;!-- Reference to inner class CardholderAddress -->
 *         &lt;/xs:element>
 *         &lt;xs:element name="EffectiveExpireDate" minOccurs="0">
 *           &lt;!-- Reference to inner class EffectiveExpireDate -->
 *         &lt;/xs:element>
 *         &lt;xs:element type="ns:CodesetType" name="ApprovalType" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PaymentCardMethodType extends KeyWithMetaObjectBaseType implements
    Serializable
{
    private String cardType;
    private String cardCode;
    private MaskedCardNumber maskedCardNumber;
    private String tokenizedCardNumber;
    private Contacts contacts;
    private CardHolderName cardHolderName;
    private CardIssuerName cardIssuerName;
    private CardholderAddress cardholderAddress;
    private EffectiveExpireDate effectiveExpireDate;
    private CodesetType approvalType;

    /** 
     * Get the 'CardType' element value. Magnetic striped card type.
     * 
     * @return value
     */
    public String getCardType() {
        return cardType;
    }

    /** 
     * Set the 'CardType' element value. Magnetic striped card type.
     * 
     * @param cardType
     */
    public void setCardType(String cardType) {
        this.cardType = cardType;
    }

    /** 
     * Get the 'CardCode' element value. Credit card issuer code. Example: MC

    Note: This is the 2 character code of the credit card issuer.
     * 
     * @return value
     */
    public String getCardCode() {
        return cardCode;
    }

    /** 
     * Set the 'CardCode' element value. Credit card issuer code. Example: MC

    Note: This is the 2 character code of the credit card issuer.
     * 
     * @param cardCode
     */
    public void setCardCode(String cardCode) {
        this.cardCode = cardCode;
    }

    /** 
     * Get the 'MaskedCardNumber' element value.
     * 
     * @return value
     */
    public MaskedCardNumber getMaskedCardNumber() {
        return maskedCardNumber;
    }

    /** 
     * Set the 'MaskedCardNumber' element value.
     * 
     * @param maskedCardNumber
     */
    public void setMaskedCardNumber(MaskedCardNumber maskedCardNumber) {
        this.maskedCardNumber = maskedCardNumber;
    }

    /** 
     * Get the 'TokenizedCardNumber' element value. Tokenized card number.

    Note: This capability may not be supported by all NDC-enabled systems or may be supported by bilateral agreement only. If supported, the technical implementation of this capability is not dictated by this specification.
     * 
     * @return value
     */
    public String getTokenizedCardNumber() {
        return tokenizedCardNumber;
    }

    /** 
     * Set the 'TokenizedCardNumber' element value. Tokenized card number.

    Note: This capability may not be supported by all NDC-enabled systems or may be supported by bilateral agreement only. If supported, the technical implementation of this capability is not dictated by this specification.
     * 
     * @param tokenizedCardNumber
     */
    public void setTokenizedCardNumber(String tokenizedCardNumber) {
        this.tokenizedCardNumber = tokenizedCardNumber;
    }

    /** 
     * Get the 'Contacts' element value.
     * 
     * @return value
     */
    public Contacts getContacts() {
        return contacts;
    }

    /** 
     * Set the 'Contacts' element value.
     * 
     * @param contacts
     */
    public void setContacts(Contacts contacts) {
        this.contacts = contacts;
    }

    /** 
     * Get the 'CardHolderName' element value.
     * 
     * @return value
     */
    public CardHolderName getCardHolderName() {
        return cardHolderName;
    }

    /** 
     * Set the 'CardHolderName' element value.
     * 
     * @param cardHolderName
     */
    public void setCardHolderName(CardHolderName cardHolderName) {
        this.cardHolderName = cardHolderName;
    }

    /** 
     * Get the 'CardIssuerName' element value.
     * 
     * @return value
     */
    public CardIssuerName getCardIssuerName() {
        return cardIssuerName;
    }

    /** 
     * Set the 'CardIssuerName' element value.
     * 
     * @param cardIssuerName
     */
    public void setCardIssuerName(CardIssuerName cardIssuerName) {
        this.cardIssuerName = cardIssuerName;
    }

    /** 
     * Get the 'CardholderAddress' element value.
     * 
     * @return value
     */
    public CardholderAddress getCardholderAddress() {
        return cardholderAddress;
    }

    /** 
     * Set the 'CardholderAddress' element value.
     * 
     * @param cardholderAddress
     */
    public void setCardholderAddress(CardholderAddress cardholderAddress) {
        this.cardholderAddress = cardholderAddress;
    }

    /** 
     * Get the 'EffectiveExpireDate' element value.
     * 
     * @return value
     */
    public EffectiveExpireDate getEffectiveExpireDate() {
        return effectiveExpireDate;
    }

    /** 
     * Set the 'EffectiveExpireDate' element value.
     * 
     * @param effectiveExpireDate
     */
    public void setEffectiveExpireDate(EffectiveExpireDate effectiveExpireDate) {
        this.effectiveExpireDate = effectiveExpireDate;
    }

    /** 
     * Get the 'ApprovalType' element value. Approval Code Method. Example: M (Manual)

    Note: This is used to specify how the approval code for a credit card sale was obtained.

    Encoding Scheme: IATA PADIS Code List for data element 9890.
     * 
     * @return value
     */
    public CodesetType getApprovalType() {
        return approvalType;
    }

    /** 
     * Set the 'ApprovalType' element value. Approval Code Method. Example: M (Manual)

    Note: This is used to specify how the approval code for a credit card sale was obtained.

    Encoding Scheme: IATA PADIS Code List for data element 9890.
     * 
     * @param approvalType
     */
    public void setApprovalType(CodesetType approvalType) {
        this.approvalType = approvalType;
    }
    /** 
     * Concealed credit card number, Example: xxxxxxxxxxxx9922
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MaskedCardNumber" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:string">
     *         &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * 
     * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
     *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
     * &lt;/xs:attributeGroup>
     * </pre>
     */
    public static class MaskedCardNumber implements Serializable
    {
        private String string;
        private String refs;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getString() {
            return string;
        }

        /** 
         * Set the extension value.
         * 
         * @param string
         */
        public void setString(String string) {
            this.string = string;
        }

        /** 
         * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @return value
         */
        public String getRefs() {
            return refs;
        }

        /** 
         * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @param refs
         */
        public void setRefs(String refs) {
            this.refs = refs;
        }
    }
    /** 
     * Name of credit card holder. Example: JOHN SMITH
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CardHolderName" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:string">
     *         &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * 
     * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
     *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
     * &lt;/xs:attributeGroup>
     * </pre>
     */
    public static class CardHolderName implements Serializable
    {
        private String string;
        private String refs;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getString() {
            return string;
        }

        /** 
         * Set the extension value.
         * 
         * @param string
         */
        public void setString(String string) {
            this.string = string;
        }

        /** 
         * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @return value
         */
        public String getRefs() {
            return refs;
        }

        /** 
         * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @param refs
         */
        public void setRefs(String refs) {
            this.refs = refs;
        }
    }
    /** 
     * Credit card issuing company.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CardIssuerName" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="BankID"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class CardIssuerName implements Serializable
    {
        private String bankID;

        /** 
         * Get the 'BankID' element value. Issuer Name. Example: Bank of America

        Note: This is the name of bank or organization issuing the card (e.g., alumni association, bank, fraternal organization, etc.).
         * 
         * @return value
         */
        public String getBankID() {
            return bankID;
        }

        /** 
         * Set the 'BankID' element value. Issuer Name. Example: Bank of America

        Note: This is the name of bank or organization issuing the card (e.g., alumni association, bank, fraternal organization, etc.).
         * 
         * @param bankID
         */
        public void setBankID(String bankID) {
            this.bankID = bankID;
        }
    }
    /** 
     * Cardholder Address.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CardholderAddress" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:choice>
     *       &lt;xs:element ref="ns:SimpleAddress"/>
     *       &lt;xs:element ref="ns:StructuredAddress"/>
     *       &lt;xs:element ref="ns:PaymentAddress"/>
     *     &lt;/xs:choice>
     *     &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * 
     * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
     *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
     * &lt;/xs:attributeGroup>
     * </pre>
     */
    public static class CardholderAddress implements Serializable
    {
        private int choiceSelect = -1;
        private static final int SIMPLE_ADDRESS_CHOICE = 0;
        private static final int STRUCTURED_ADDRESS_CHOICE = 1;
        private static final int PAYMENT_ADDRESS_CHOICE = 2;
        private SimpleAddrType simpleAddress;
        private StructuredAddress structuredAddress;
        private PaymentAddrType paymentAddress;
        private String refs;

        private void setChoiceSelect(int choice) {
            if (choiceSelect == -1) {
                choiceSelect = choice;
            } else if (choiceSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearChoiceSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearChoiceSelect() {
            choiceSelect = -1;
        }

        /** 
         * Check if SimpleAddress is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifSimpleAddress() {
            return choiceSelect == SIMPLE_ADDRESS_CHOICE;
        }

        /** 
         * Get the 'SimpleAddress' element value.
         * 
         * @return value
         */
        public SimpleAddrType getSimpleAddress() {
            return simpleAddress;
        }

        /** 
         * Set the 'SimpleAddress' element value.
         * 
         * @param simpleAddress
         */
        public void setSimpleAddress(SimpleAddrType simpleAddress) {
            setChoiceSelect(SIMPLE_ADDRESS_CHOICE);
            this.simpleAddress = simpleAddress;
        }

        /** 
         * Check if StructuredAddress is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifStructuredAddress() {
            return choiceSelect == STRUCTURED_ADDRESS_CHOICE;
        }

        /** 
         * Get the 'StructuredAddress' element value.
         * 
         * @return value
         */
        public StructuredAddress getStructuredAddress() {
            return structuredAddress;
        }

        /** 
         * Set the 'StructuredAddress' element value.
         * 
         * @param structuredAddress
         */
        public void setStructuredAddress(StructuredAddress structuredAddress) {
            setChoiceSelect(STRUCTURED_ADDRESS_CHOICE);
            this.structuredAddress = structuredAddress;
        }

        /** 
         * Check if PaymentAddress is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifPaymentAddress() {
            return choiceSelect == PAYMENT_ADDRESS_CHOICE;
        }

        /** 
         * Get the 'PaymentAddress' element value.
         * 
         * @return value
         */
        public PaymentAddrType getPaymentAddress() {
            return paymentAddress;
        }

        /** 
         * Set the 'PaymentAddress' element value.
         * 
         * @param paymentAddress
         */
        public void setPaymentAddress(PaymentAddrType paymentAddress) {
            setChoiceSelect(PAYMENT_ADDRESS_CHOICE);
            this.paymentAddress = paymentAddress;
        }

        /** 
         * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @return value
         */
        public String getRefs() {
            return refs;
        }

        /** 
         * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @param refs
         */
        public void setRefs(String refs) {
            this.refs = refs;
        }
    }
    /** 
     * Payment Card Effective and/ or Expiration date(s).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EffectiveExpireDate" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="Effective" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="Expiration" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *     &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * 
     * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
     *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
     * &lt;/xs:attributeGroup>
     * </pre>
     */
    public static class EffectiveExpireDate implements Serializable
    {
        private String effective;
        private String expiration;
        private String refs;

        /** 
         * Get the 'Effective' element value. Payment Card Effective Date. Example: 0116
         * 
         * @return value
         */
        public String getEffective() {
            return effective;
        }

        /** 
         * Set the 'Effective' element value. Payment Card Effective Date. Example: 0116
         * 
         * @param effective
         */
        public void setEffective(String effective) {
            this.effective = effective;
        }

        /** 
         * Get the 'Expiration' element value. Payment Card Expiration Date. Example: 0119
         * 
         * @return value
         */
        public String getExpiration() {
            return expiration;
        }

        /** 
         * Set the 'Expiration' element value. Payment Card Expiration Date. Example: 0119
         * 
         * @param expiration
         */
        public void setExpiration(String expiration) {
            this.expiration = expiration;
        }

        /** 
         * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @return value
         */
        public String getRefs() {
            return refs;
        }

        /** 
         * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @param refs
         */
        public void setRefs(String refs) {
            this.refs = refs;
        }
    }
}
