
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * PAYMENT CARD definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PaymentCardType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:KeyWithMetaObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="xs:string" name="CardType" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="CardCode" minOccurs="0"/>
 *         &lt;xs:element name="CardNumber" minOccurs="0">
 *           &lt;!-- Reference to inner class CardNumber -->
 *         &lt;/xs:element>
 *         &lt;xs:element type="xs:int" name="IssueNumber" minOccurs="0"/>
 *         &lt;xs:element name="SeriesCode" minOccurs="0">
 *           &lt;!-- Reference to inner class SeriesCode -->
 *         &lt;/xs:element>
 *         &lt;xs:element name="CardHolderName" minOccurs="0">
 *           &lt;!-- Reference to inner class CardHolderName -->
 *         &lt;/xs:element>
 *         &lt;xs:element name="CardIssuerName" minOccurs="0">
 *           &lt;!-- Reference to inner class CardIssuerName -->
 *         &lt;/xs:element>
 *         &lt;xs:element type="ns:StructuredAddrType" name="CardHolderBillingAddress" minOccurs="0"/>
 *         &lt;xs:element name="MaskedCardNumber" minOccurs="0">
 *           &lt;!-- Reference to inner class MaskedCardNumber -->
 *         &lt;/xs:element>
 *         &lt;xs:element type="ns:CurrencyAmountOptType" name="Amount" minOccurs="0"/>
 *         &lt;xs:element name="Surcharge" minOccurs="0">
 *           &lt;!-- Reference to inner class Surcharge -->
 *         &lt;/xs:element>
 *         &lt;xs:element name="EffectiveExpireDate" minOccurs="0">
 *           &lt;!-- Reference to inner class EffectiveExpireDate -->
 *         &lt;/xs:element>
 *         &lt;xs:element type="xs:string" name="AddressValidation" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="TokenizedCardNumber" minOccurs="0"/>
 *         &lt;xs:element type="ns:CodesetType" name="ApprovalType" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PaymentCardType extends KeyWithMetaObjectBaseType implements
    Serializable
{
    private String cardType;
    private String cardCode;
    private CardNumber cardNumber;
    private Integer issueNumber;
    private SeriesCode seriesCode;
    private CardHolderName cardHolderName;
    private CardIssuerName cardIssuerName;
    private StructuredAddrType cardHolderBillingAddress;
    private MaskedCardNumber maskedCardNumber;
    private CurrencyAmountOptType amount;
    private Surcharge surcharge;
    private EffectiveExpireDate effectiveExpireDate;
    private String addressValidation;
    private String tokenizedCardNumber;
    private CodesetType approvalType;

    /** 
     * Get the 'CardType' element value. Magnetic striped card type.
     * 
     * @return value
     */
    public String getCardType() {
        return cardType;
    }

    /** 
     * Set the 'CardType' element value. Magnetic striped card type.
     * 
     * @param cardType
     */
    public void setCardType(String cardType) {
        this.cardType = cardType;
    }

    /** 
     * Get the 'CardCode' element value. Credit card issuer code. Example: MC

    Note: This is the 2 character code of the credit card issuer.
     * 
     * @return value
     */
    public String getCardCode() {
        return cardCode;
    }

    /** 
     * Set the 'CardCode' element value. Credit card issuer code. Example: MC

    Note: This is the 2 character code of the credit card issuer.
     * 
     * @param cardCode
     */
    public void setCardCode(String cardCode) {
        this.cardCode = cardCode;
    }

    /** 
     * Get the 'CardNumber' element value.
     * 
     * @return value
     */
    public CardNumber getCardNumber() {
        return cardNumber;
    }

    /** 
     * Set the 'CardNumber' element value.
     * 
     * @param cardNumber
     */
    public void setCardNumber(CardNumber cardNumber) {
        this.cardNumber = cardNumber;
    }

    /** 
     * Get the 'IssueNumber' element value. Debit card issue number
     * 
     * @return value
     */
    public Integer getIssueNumber() {
        return issueNumber;
    }

    /** 
     * Set the 'IssueNumber' element value. Debit card issue number
     * 
     * @param issueNumber
     */
    public void setIssueNumber(Integer issueNumber) {
        this.issueNumber = issueNumber;
    }

    /** 
     * Get the 'SeriesCode' element value.
     * 
     * @return value
     */
    public SeriesCode getSeriesCode() {
        return seriesCode;
    }

    /** 
     * Set the 'SeriesCode' element value.
     * 
     * @param seriesCode
     */
    public void setSeriesCode(SeriesCode seriesCode) {
        this.seriesCode = seriesCode;
    }

    /** 
     * Get the 'CardHolderName' element value.
     * 
     * @return value
     */
    public CardHolderName getCardHolderName() {
        return cardHolderName;
    }

    /** 
     * Set the 'CardHolderName' element value.
     * 
     * @param cardHolderName
     */
    public void setCardHolderName(CardHolderName cardHolderName) {
        this.cardHolderName = cardHolderName;
    }

    /** 
     * Get the 'CardIssuerName' element value.
     * 
     * @return value
     */
    public CardIssuerName getCardIssuerName() {
        return cardIssuerName;
    }

    /** 
     * Set the 'CardIssuerName' element value.
     * 
     * @param cardIssuerName
     */
    public void setCardIssuerName(CardIssuerName cardIssuerName) {
        this.cardIssuerName = cardIssuerName;
    }

    /** 
     * Get the 'CardHolderBillingAddress' element value. Cardholder Address.
     * 
     * @return value
     */
    public StructuredAddrType getCardHolderBillingAddress() {
        return cardHolderBillingAddress;
    }

    /** 
     * Set the 'CardHolderBillingAddress' element value. Cardholder Address.
     * 
     * @param cardHolderBillingAddress
     */
    public void setCardHolderBillingAddress(
            StructuredAddrType cardHolderBillingAddress) {
        this.cardHolderBillingAddress = cardHolderBillingAddress;
    }

    /** 
     * Get the 'MaskedCardNumber' element value.
     * 
     * @return value
     */
    public MaskedCardNumber getMaskedCardNumber() {
        return maskedCardNumber;
    }

    /** 
     * Set the 'MaskedCardNumber' element value.
     * 
     * @param maskedCardNumber
     */
    public void setMaskedCardNumber(MaskedCardNumber maskedCardNumber) {
        this.maskedCardNumber = maskedCardNumber;
    }

    /** 
     * Get the 'Amount' element value. Authorized credit card amount. Example: 500 USD
     * 
     * @return value
     */
    public CurrencyAmountOptType getAmount() {
        return amount;
    }

    /** 
     * Set the 'Amount' element value. Authorized credit card amount. Example: 500 USD
     * 
     * @param amount
     */
    public void setAmount(CurrencyAmountOptType amount) {
        this.amount = amount;
    }

    /** 
     * Get the 'Surcharge' element value.
     * 
     * @return value
     */
    public Surcharge getSurcharge() {
        return surcharge;
    }

    /** 
     * Set the 'Surcharge' element value.
     * 
     * @param surcharge
     */
    public void setSurcharge(Surcharge surcharge) {
        this.surcharge = surcharge;
    }

    /** 
     * Get the 'EffectiveExpireDate' element value.
     * 
     * @return value
     */
    public EffectiveExpireDate getEffectiveExpireDate() {
        return effectiveExpireDate;
    }

    /** 
     * Set the 'EffectiveExpireDate' element value.
     * 
     * @param effectiveExpireDate
     */
    public void setEffectiveExpireDate(EffectiveExpireDate effectiveExpireDate) {
        this.effectiveExpireDate = effectiveExpireDate;
    }

    /** 
     * Get the 'AddressValidation' element value. AVS Response Code. Example: Y (Street address and 5-digit ZIP code both match)

    Note: This is the address verification response code (AVS) when the ticketing agency performs address verification.
     * 
     * @return value
     */
    public String getAddressValidation() {
        return addressValidation;
    }

    /** 
     * Set the 'AddressValidation' element value. AVS Response Code. Example: Y (Street address and 5-digit ZIP code both match)

    Note: This is the address verification response code (AVS) when the ticketing agency performs address verification.
     * 
     * @param addressValidation
     */
    public void setAddressValidation(String addressValidation) {
        this.addressValidation = addressValidation;
    }

    /** 
     * Get the 'TokenizedCardNumber' element value. Tokenized card number.

    Note: This capability may not be supported by all NDC-enabled systems or may be supported by bilateral agreement only. If supported, the technical implementation of this capability is not dictated by this specification.
     * 
     * @return value
     */
    public String getTokenizedCardNumber() {
        return tokenizedCardNumber;
    }

    /** 
     * Set the 'TokenizedCardNumber' element value. Tokenized card number.

    Note: This capability may not be supported by all NDC-enabled systems or may be supported by bilateral agreement only. If supported, the technical implementation of this capability is not dictated by this specification.
     * 
     * @param tokenizedCardNumber
     */
    public void setTokenizedCardNumber(String tokenizedCardNumber) {
        this.tokenizedCardNumber = tokenizedCardNumber;
    }

    /** 
     * Get the 'ApprovalType' element value. Approval Code Method. Example: M (Manual)

    Note: This is used to specify how the approval code for a credit card sale was obtained.

    Encoding Scheme: IATA PADIS Code List for data element 9890.
     * 
     * @return value
     */
    public CodesetType getApprovalType() {
        return approvalType;
    }

    /** 
     * Set the 'ApprovalType' element value. Approval Code Method. Example: M (Manual)

    Note: This is used to specify how the approval code for a credit card sale was obtained.

    Encoding Scheme: IATA PADIS Code List for data element 9890.
     * 
     * @param approvalType
     */
    public void setApprovalType(CodesetType approvalType) {
        this.approvalType = approvalType;
    }
    /** 
     * The Credit Card Number embossed on the card. Example: 1111222233334444
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CardNumber" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:string">
     *         &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * 
     * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
     *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
     * &lt;/xs:attributeGroup>
     * </pre>
     */
    public static class CardNumber implements Serializable
    {
        private String string;
        private String refs;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getString() {
            return string;
        }

        /** 
         * Set the extension value.
         * 
         * @param string
         */
        public void setString(String string) {
            this.string = string;
        }

        /** 
         * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @return value
         */
        public String getRefs() {
            return refs;
        }

        /** 
         * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @param refs
         */
        public void setRefs(String refs) {
            this.refs = refs;
        }
    }
    /** 
     * Verification Digits. Example: 123

    Note: This is the verification digits printed on the card following the embossed number. This may also accommodate the customer identification/batch number (CID), card verification value (CVV2 ), card validation code number (CVC2) on credit card.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SeriesCode" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:string">
     *         &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * 
     * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
     *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
     * &lt;/xs:attributeGroup>
     * </pre>
     */
    public static class SeriesCode implements Serializable
    {
        private String string;
        private String refs;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getString() {
            return string;
        }

        /** 
         * Set the extension value.
         * 
         * @param string
         */
        public void setString(String string) {
            this.string = string;
        }

        /** 
         * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @return value
         */
        public String getRefs() {
            return refs;
        }

        /** 
         * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @param refs
         */
        public void setRefs(String refs) {
            this.refs = refs;
        }
    }
    /** 
     * Name of credit card holder. Example: JOHN SMITH
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CardHolderName" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:string">
     *         &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * 
     * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
     *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
     * &lt;/xs:attributeGroup>
     * </pre>
     */
    public static class CardHolderName implements Serializable
    {
        private String string;
        private String refs;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getString() {
            return string;
        }

        /** 
         * Set the extension value.
         * 
         * @param string
         */
        public void setString(String string) {
            this.string = string;
        }

        /** 
         * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @return value
         */
        public String getRefs() {
            return refs;
        }

        /** 
         * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @param refs
         */
        public void setRefs(String refs) {
            this.refs = refs;
        }
    }
    /** 
     * Credit card issuing company.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CardIssuerName" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="BankID"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class CardIssuerName implements Serializable
    {
        private String bankID;

        /** 
         * Get the 'BankID' element value. Issuer Name. Example: Bank of America

        Note: This is the name of bank or organization issuing the card (e.g., alumni association, bank, fraternal organization, etc.).
         * 
         * @return value
         */
        public String getBankID() {
            return bankID;
        }

        /** 
         * Set the 'BankID' element value. Issuer Name. Example: Bank of America

        Note: This is the name of bank or organization issuing the card (e.g., alumni association, bank, fraternal organization, etc.).
         * 
         * @param bankID
         */
        public void setBankID(String bankID) {
            this.bankID = bankID;
        }
    }
    /** 
     * Concealed credit card number, Example: xxxxxxxxxxxx9922
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MaskedCardNumber" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:string">
     *         &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * 
     * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
     *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
     * &lt;/xs:attributeGroup>
     * </pre>
     */
    public static class MaskedCardNumber implements Serializable
    {
        private String string;
        private String refs;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getString() {
            return string;
        }

        /** 
         * Set the extension value.
         * 
         * @param string
         */
        public void setString(String string) {
            this.string = string;
        }

        /** 
         * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @return value
         */
        public String getRefs() {
            return refs;
        }

        /** 
         * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @param refs
         */
        public void setRefs(String refs) {
            this.refs = refs;
        }
    }
    /** 
     * Surcharge Amount
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Surcharge" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:CurrencyAmountOptType" name="Amount"/>
     *       &lt;xs:element ref="ns:PercentageValue" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Surcharge implements Serializable
    {
        private CurrencyAmountOptType amount;
        private PercentageValue percentageValue;

        /** 
         * Get the 'Amount' element value. Authorized credit card amount. Example: 500 USD
         * 
         * @return value
         */
        public CurrencyAmountOptType getAmount() {
            return amount;
        }

        /** 
         * Set the 'Amount' element value. Authorized credit card amount. Example: 500 USD
         * 
         * @param amount
         */
        public void setAmount(CurrencyAmountOptType amount) {
            this.amount = amount;
        }

        /** 
         * Get the 'PercentageValue' element value.
         * 
         * @return value
         */
        public PercentageValue getPercentageValue() {
            return percentageValue;
        }

        /** 
         * Set the 'PercentageValue' element value.
         * 
         * @param percentageValue
         */
        public void setPercentageValue(PercentageValue percentageValue) {
            this.percentageValue = percentageValue;
        }
    }
    /** 
     * Payment Card Effective and/ or Expiration date(s).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EffectiveExpireDate" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="Effective" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="Expiration" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *     &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * 
     * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
     *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
     * &lt;/xs:attributeGroup>
     * </pre>
     */
    public static class EffectiveExpireDate implements Serializable
    {
        private String effective;
        private String expiration;
        private String refs;

        /** 
         * Get the 'Effective' element value. Payment Card Effective Date. Example: 0116
         * 
         * @return value
         */
        public String getEffective() {
            return effective;
        }

        /** 
         * Set the 'Effective' element value. Payment Card Effective Date. Example: 0116
         * 
         * @param effective
         */
        public void setEffective(String effective) {
            this.effective = effective;
        }

        /** 
         * Get the 'Expiration' element value. Payment Card Expiration Date. Example: 0119
         * 
         * @return value
         */
        public String getExpiration() {
            return expiration;
        }

        /** 
         * Set the 'Expiration' element value. Payment Card Expiration Date. Example: 0119
         * 
         * @param expiration
         */
        public void setExpiration(String expiration) {
            this.expiration = expiration;
        }

        /** 
         * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @return value
         */
        public String getRefs() {
            return refs;
        }

        /** 
         * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @param refs
         */
        public void setRefs(String refs) {
            this.refs = refs;
        }
    }
}
