
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Payment Form Information.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PaymentForms">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element name="PaymentForm" maxOccurs="unbounded">
 *         &lt;!-- Reference to inner class PaymentForm -->
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class PaymentForms implements Serializable
{
    private List<PaymentForm> paymentFormList = new ArrayList<PaymentForm>();

    /** 
     * Get the list of 'PaymentForm' element items.
     * 
     * @return list
     */
    public List<PaymentForm> getPaymentFormList() {
        return paymentFormList;
    }

    /** 
     * Set the list of 'PaymentForm' element items.
     * 
     * @param list
     */
    public void setPaymentFormList(List<PaymentForm> list) {
        paymentFormList = list;
    }
    /** 
     * Payment Form detail.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PaymentForm" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="ns:KeyWithMetaObjectBaseType">
     *         &lt;xs:sequence>
     *           &lt;xs:element ref="ns:BankAccount" minOccurs="0"/>
     *           &lt;xs:element ref="ns:Cash" minOccurs="0"/>
     *           &lt;xs:element ref="ns:DirectBill" minOccurs="0"/>
     *           &lt;xs:element ref="ns:LoyaltyRedemption" minOccurs="0"/>
     *           &lt;xs:element ref="ns:MiscChargeOrder" minOccurs="0"/>
     *           &lt;xs:element ref="ns:Other" minOccurs="0"/>
     *           &lt;xs:element ref="ns:PaymentCard" minOccurs="0"/>
     *           &lt;xs:element ref="ns:Voucher" minOccurs="0"/>
     *         &lt;/xs:sequence>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class PaymentForm extends KeyWithMetaObjectBaseType implements
        Serializable
    {
        private BankAccountType bankAccount;
        private Cash cash;
        private DirectBillType directBill;
        private LoyaltyRedemption loyaltyRedemption;
        private MiscChargeOrder miscChargeOrder;
        private Other other;
        private PaymentCardType paymentCard;
        private Voucher voucher;

        /** 
         * Get the 'BankAccount' element value.
         * 
         * @return value
         */
        public BankAccountType getBankAccount() {
            return bankAccount;
        }

        /** 
         * Set the 'BankAccount' element value.
         * 
         * @param bankAccount
         */
        public void setBankAccount(BankAccountType bankAccount) {
            this.bankAccount = bankAccount;
        }

        /** 
         * Get the 'Cash' element value.
         * 
         * @return value
         */
        public Cash getCash() {
            return cash;
        }

        /** 
         * Set the 'Cash' element value.
         * 
         * @param cash
         */
        public void setCash(Cash cash) {
            this.cash = cash;
        }

        /** 
         * Get the 'DirectBill' element value.
         * 
         * @return value
         */
        public DirectBillType getDirectBill() {
            return directBill;
        }

        /** 
         * Set the 'DirectBill' element value.
         * 
         * @param directBill
         */
        public void setDirectBill(DirectBillType directBill) {
            this.directBill = directBill;
        }

        /** 
         * Get the 'LoyaltyRedemption' element value.
         * 
         * @return value
         */
        public LoyaltyRedemption getLoyaltyRedemption() {
            return loyaltyRedemption;
        }

        /** 
         * Set the 'LoyaltyRedemption' element value.
         * 
         * @param loyaltyRedemption
         */
        public void setLoyaltyRedemption(LoyaltyRedemption loyaltyRedemption) {
            this.loyaltyRedemption = loyaltyRedemption;
        }

        /** 
         * Get the 'MiscChargeOrder' element value.
         * 
         * @return value
         */
        public MiscChargeOrder getMiscChargeOrder() {
            return miscChargeOrder;
        }

        /** 
         * Set the 'MiscChargeOrder' element value.
         * 
         * @param miscChargeOrder
         */
        public void setMiscChargeOrder(MiscChargeOrder miscChargeOrder) {
            this.miscChargeOrder = miscChargeOrder;
        }

        /** 
         * Get the 'Other' element value.
         * 
         * @return value
         */
        public Other getOther() {
            return other;
        }

        /** 
         * Set the 'Other' element value.
         * 
         * @param other
         */
        public void setOther(Other other) {
            this.other = other;
        }

        /** 
         * Get the 'PaymentCard' element value.
         * 
         * @return value
         */
        public PaymentCardType getPaymentCard() {
            return paymentCard;
        }

        /** 
         * Set the 'PaymentCard' element value.
         * 
         * @param paymentCard
         */
        public void setPaymentCard(PaymentCardType paymentCard) {
            this.paymentCard = paymentCard;
        }

        /** 
         * Get the 'Voucher' element value.
         * 
         * @return value
         */
        public Voucher getVoucher() {
            return voucher;
        }

        /** 
         * Set the 'Voucher' element value.
         * 
         * @param voucher
         */
        public void setVoucher(Voucher voucher) {
            this.voucher = voucher;
        }
    }
}
