
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Payment Form Issue Alert definition.
 Supported Use Cases:
 - Incomplete: Payment Failure (pre-authorized hold and payment)
 - Incomplete: Payment System Timeout, etc. (with RetryInd)
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PaymentIssueAlertType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:TrxProcessObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element name="Payment" minOccurs="0" maxOccurs="unbounded">
 *           &lt;!-- Reference to inner class Payment -->
 *         &lt;/xs:element>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PaymentIssueAlertType extends TrxProcessObjectBaseType implements
    Serializable
{
    private List<Payment> paymentList = new ArrayList<Payment>();

    /** 
     * Get the list of 'Payment' element items.
     * 
     * @return list
     */
    public List<Payment> getPaymentList() {
        return paymentList;
    }

    /** 
     * Set the list of 'Payment' element items.
     * 
     * @param list
     */
    public void setPaymentList(List<Payment> list) {
        paymentList = list;
    }
    /** 
     * Payment Form Detail.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Payment" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="ns:DataListObjectBaseType">
     *         &lt;xs:sequence>
     *           &lt;xs:element ref="ns:TrxProcessStatus" minOccurs="0"/>
     *           &lt;xs:element type="xs:string" name="InfoURL" minOccurs="0"/>
     *           &lt;xs:element type="ns:CodesetType" name="DataType" minOccurs="0"/>
     *           &lt;xs:element name="Status" minOccurs="0">
     *             &lt;!-- Reference to inner class Status -->
     *           &lt;/xs:element>
     *           &lt;xs:element name="Failed" minOccurs="0">
     *             &lt;!-- Reference to inner class Failed -->
     *           &lt;/xs:element>
     *           &lt;xs:element name="Incomplete" minOccurs="0">
     *             &lt;!-- Reference to inner class Incomplete -->
     *           &lt;/xs:element>
     *         &lt;/xs:sequence>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Payment extends DataListObjectBaseType implements
        Serializable
    {
        private TrxProcessStatus trxProcessStatus;
        private String infoURL;
        private CodesetType dataType;
        private Status status;
        private Failed failed;
        private Incomplete incomplete;

        /** 
         * Get the 'TrxProcessStatus' element value.
         * 
         * @return value
         */
        public TrxProcessStatus getTrxProcessStatus() {
            return trxProcessStatus;
        }

        /** 
         * Set the 'TrxProcessStatus' element value.
         * 
         * @param trxProcessStatus
         */
        public void setTrxProcessStatus(TrxProcessStatus trxProcessStatus) {
            this.trxProcessStatus = trxProcessStatus;
        }

        /** 
         * Get the 'InfoURL' element value. URL to an online description of the alert.
        Example: http://www.airline.com/AlertPage
         * 
         * @return value
         */
        public String getInfoURL() {
            return infoURL;
        }

        /** 
         * Set the 'InfoURL' element value. URL to an online description of the alert.
        Example: http://www.airline.com/AlertPage
         * 
         * @param infoURL
         */
        public void setInfoURL(String infoURL) {
            this.infoURL = infoURL;
        }

        /** 
         * Get the 'DataType' element value. The processing status for this Payment Form. Examples: Success With Warnings, More Information Required

        Encoding Scheme: IATA Padis Codeset - Data Element [4343] Response Type, coded
         * 
         * @return value
         */
        public CodesetType getDataType() {
            return dataType;
        }

        /** 
         * Set the 'DataType' element value. The processing status for this Payment Form. Examples: Success With Warnings, More Information Required

        Encoding Scheme: IATA Padis Codeset - Data Element [4343] Response Type, coded
         * 
         * @param dataType
         */
        public void setDataType(CodesetType dataType) {
            this.dataType = dataType;
        }

        /** 
         * Get the 'Status' element value.
         * 
         * @return value
         */
        public Status getStatus() {
            return status;
        }

        /** 
         * Set the 'Status' element value.
         * 
         * @param status
         */
        public void setStatus(Status status) {
            this.status = status;
        }

        /** 
         * Get the 'Failed' element value.
         * 
         * @return value
         */
        public Failed getFailed() {
            return failed;
        }

        /** 
         * Set the 'Failed' element value.
         * 
         * @param failed
         */
        public void setFailed(Failed failed) {
            this.failed = failed;
        }

        /** 
         * Get the 'Incomplete' element value.
         * 
         * @return value
         */
        public Incomplete getIncomplete() {
            return incomplete;
        }

        /** 
         * Set the 'Incomplete' element value.
         * 
         * @param incomplete
         */
        public void setIncomplete(Incomplete incomplete) {
            this.incomplete = incomplete;
        }
        /** 
         * Status for this Payment Form. Examples: Canceled, Complete, Incomplete, Partial
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Status" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:simpleContent>
         *       &lt;xs:extension base="xs:string">
         *         &lt;xs:attribute type="xs:string" use="optional" name="Context"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:simpleContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Status implements Serializable
        {
            private String string;
            private String context;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getString() {
                return string;
            }

            /** 
             * Set the extension value.
             * 
             * @param string
             */
            public void setString(String string) {
                this.string = string;
            }

            /** 
             * Get the 'Context' attribute value. Payment Alert Status context.
             * 
             * @return value
             */
            public String getContext() {
                return context;
            }

            /** 
             * Set the 'Context' attribute value. Payment Alert Status context.
             * 
             * @param context
             */
            public void setContext(String context) {
                this.context = context;
            }
        }
        /** 
         * Payment Authorization Failure information.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Failed" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:CodesetType" name="Code"/>
         *       &lt;xs:element ref="ns:Associations" minOccurs="0"/>
         *       &lt;xs:element ref="ns:Remarks" minOccurs="0"/>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="FailedInd"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Failed implements Serializable
        {
            private CodesetType code;
            private Associations associations;
            private Remarks remarks;
            private Boolean failedInd;

            /** 
             * Get the 'Code' element value. Payment Failure Code (and optional definition.)

            Encoding Scheme: IATA Padis Codeset - List for data element [9321] Application Error, coded
             * 
             * @return value
             */
            public CodesetType getCode() {
                return code;
            }

            /** 
             * Set the 'Code' element value. Payment Failure Code (and optional definition.)

            Encoding Scheme: IATA Padis Codeset - List for data element [9321] Application Error, coded
             * 
             * @param code
             */
            public void setCode(CodesetType code) {
                this.code = code;
            }

            /** 
             * Get the 'Associations' element value.
             * 
             * @return value
             */
            public Associations getAssociations() {
                return associations;
            }

            /** 
             * Set the 'Associations' element value.
             * 
             * @param associations
             */
            public void setAssociations(Associations associations) {
                this.associations = associations;
            }

            /** 
             * Get the 'Remarks' element value. Payment Remark(s).
             * 
             * @return value
             */
            public Remarks getRemarks() {
                return remarks;
            }

            /** 
             * Set the 'Remarks' element value. Payment Remark(s).
             * 
             * @param remarks
             */
            public void setRemarks(Remarks remarks) {
                this.remarks = remarks;
            }

            /** 
             * Get the 'FailedInd' attribute value. When TRUE, this payment form has failed.
             * 
             * @return value
             */
            public Boolean getFailedInd() {
                return failedInd;
            }

            /** 
             * Set the 'FailedInd' attribute value. When TRUE, this payment form has failed.
             * 
             * @param failedInd
             */
            public void setFailedInd(Boolean failedInd) {
                this.failedInd = failedInd;
            }
        }
        /** 
         * Incomplete Payment information.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Incomplete" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:CodesetType" name="Code"/>
         *       &lt;xs:element ref="ns:Associations" minOccurs="0"/>
         *       &lt;xs:element ref="ns:Remarks" minOccurs="0"/>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="PriceVarianceInd"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Incomplete implements Serializable
        {
            private CodesetType code;
            private Associations associations;
            private Remarks remarks;
            private Boolean priceVarianceInd;

            /** 
             * Get the 'Code' element value. Incomplete Payment Status Code.  
            IATA Padis Codeset - List for data element 9321.  Used in conjunction with Association(s) (Passenger, Group, Order Item, Offer Item and Optional Service) and Remarks (Payment remarks(s)).
             * 
             * @return value
             */
            public CodesetType getCode() {
                return code;
            }

            /** 
             * Set the 'Code' element value. Incomplete Payment Status Code.  
            IATA Padis Codeset - List for data element 9321.  Used in conjunction with Association(s) (Passenger, Group, Order Item, Offer Item and Optional Service) and Remarks (Payment remarks(s)).
             * 
             * @param code
             */
            public void setCode(CodesetType code) {
                this.code = code;
            }

            /** 
             * Get the 'Associations' element value.
             * 
             * @return value
             */
            public Associations getAssociations() {
                return associations;
            }

            /** 
             * Set the 'Associations' element value.
             * 
             * @param associations
             */
            public void setAssociations(Associations associations) {
                this.associations = associations;
            }

            /** 
             * Get the 'Remarks' element value. Payment Remark(s).
             * 
             * @return value
             */
            public Remarks getRemarks() {
                return remarks;
            }

            /** 
             * Set the 'Remarks' element value. Payment Remark(s).
             * 
             * @param remarks
             */
            public void setRemarks(Remarks remarks) {
                this.remarks = remarks;
            }

            /** 
             * Get the 'PriceVarianceInd' attribute value. When TRUE, the payment could not be processed due to a price differential (between the specified Offer Item price and the calculated order price) that exceeds specified rules.
             * 
             * @return value
             */
            public Boolean getPriceVarianceInd() {
                return priceVarianceInd;
            }

            /** 
             * Set the 'PriceVarianceInd' attribute value. When TRUE, the payment could not be processed due to a price differential (between the specified Offer Item price and the calculated order price) that exceeds specified rules.
             * 
             * @param priceVarianceInd
             */
            public void setPriceVarianceInd(Boolean priceVarianceInd) {
                this.priceVarianceInd = priceVarianceInd;
            }
        }
    }
}
