
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * A data type for Offer Penalty Amount Application list constraint.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PenaltyAppListType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="MaximumPenaltyAmount"/>
 *     &lt;xs:enumeration value="MinimumPenaltyAmount"/>
 *     &lt;xs:enumeration value="Other"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum PenaltyAppListType implements Serializable {
    MAXIMUM_PENALTY_AMOUNT("MaximumPenaltyAmount"), MINIMUM_PENALTY_AMOUNT(
            "MinimumPenaltyAmount"), OTHER("Other");
    private final String value;

    private PenaltyAppListType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static PenaltyAppListType convert(String value) {
        for (PenaltyAppListType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
