
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * PHONE NUMBER helper object.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PhoneType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:KeyWithMetaObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="xs:string" name="Application" minOccurs="0"/>
 *         &lt;xs:element name="Number" minOccurs="0" maxOccurs="unbounded">
 *           &lt;!-- Reference to inner class _Number -->
 *         &lt;/xs:element>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PhoneType extends KeyWithMetaObjectBaseType implements
    Serializable
{
    private String application;
    private List<_Number> numberList = new ArrayList<_Number>();

    /** 
     * Get the 'Application' element value. Phone number application. Examples: Billing, Business, Home, Mobile
     * 
     * @return value
     */
    public String getApplication() {
        return application;
    }

    /** 
     * Set the 'Application' element value. Phone number application. Examples: Billing, Business, Home, Mobile
     * 
     * @param application
     */
    public void setApplication(String application) {
        this.application = application;
    }

    /** 
     * Get the list of 'Number' element items.
     * 
     * @return list
     */
    public List<_Number> getNumberList() {
        return numberList;
    }

    /** 
     * Set the list of 'Number' element items.
     * 
     * @param list
     */
    public void setNumberList(List<_Number> list) {
        numberList = list;
    }
    /** 
     * Phone number text.
    Examples:
    +01 999-999-9999 ext 1234, 
    617-9976

    Note: This may be a simple, un-structured phone number, such as +01 999-999-9999 ext 1234 or combined with child attributes to create a structured phone number.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Number" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:string">
     *         &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
     *         &lt;xs:attribute type="xs:string" use="optional" name="CountryCode"/>
     *         &lt;xs:attribute type="xs:string" use="optional" name="AreaCode"/>
     *         &lt;xs:attribute type="xs:string" use="optional" name="Extension"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * 
     * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
     *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
     * &lt;/xs:attributeGroup>
     * </pre>
     */
    public static class _Number implements Serializable
    {
        private String string;
        private String refs;
        private String countryCode;
        private String areaCode;
        private String extension;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getString() {
            return string;
        }

        /** 
         * Set the extension value.
         * 
         * @param string
         */
        public void setString(String string) {
            this.string = string;
        }

        /** 
         * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @return value
         */
        public String getRefs() {
            return refs;
        }

        /** 
         * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @param refs
         */
        public void setRefs(String refs) {
            this.refs = refs;
        }

        /** 
         * Get the 'CountryCode' attribute value. Phone number country code. Examples: 1, 01, +1
         * 
         * @return value
         */
        public String getCountryCode() {
            return countryCode;
        }

        /** 
         * Set the 'CountryCode' attribute value. Phone number country code. Examples: 1, 01, +1
         * 
         * @param countryCode
         */
        public void setCountryCode(String countryCode) {
            this.countryCode = countryCode;
        }

        /** 
         * Get the 'AreaCode' attribute value. Phone number area code.  Example: 813
         * 
         * @return value
         */
        public String getAreaCode() {
            return areaCode;
        }

        /** 
         * Set the 'AreaCode' attribute value. Phone number area code.  Example: 813
         * 
         * @param areaCode
         */
        public void setAreaCode(String areaCode) {
            this.areaCode = areaCode;
        }

        /** 
         * Get the 'Extension' attribute value. Phone extension number.  Examples: 1234, ext 1234
         * 
         * @return value
         */
        public String getExtension() {
            return extension;
        }

        /** 
         * Set the 'Extension' attribute value. Phone extension number.  Examples: 1234, ext 1234
         * 
         * @param extension
         */
        public void setExtension(String extension) {
            this.extension = extension;
        }
    }
}
