
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.Date;

/** 
 * A data type for Point of Sale.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PointOfSaleType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Location" minOccurs="0">
 *       &lt;!-- Reference to inner class Location -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="RequestTime" minOccurs="0">
 *       &lt;!-- Reference to inner class RequestTime -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="TouchPoint" minOccurs="0">
 *       &lt;!-- Reference to inner class TouchPoint -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="Metadata" minOccurs="0">
 *       &lt;!-- Reference to inner class Metadata -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="id"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 *   &lt;xs:attribute type="xs:string" name="AgentDutyCode"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PointOfSaleType implements Serializable
{
    private Location location;
    private RequestTime requestTime;
    private TouchPoint touchPoint;
    private Metadata metadata;
    private String id;
    private String refs;
    private String agentDutyCode;

    /** 
     * Get the 'Location' element value.
     * 
     * @return value
     */
    public Location getLocation() {
        return location;
    }

    /** 
     * Set the 'Location' element value.
     * 
     * @param location
     */
    public void setLocation(Location location) {
        this.location = location;
    }

    /** 
     * Get the 'RequestTime' element value.
     * 
     * @return value
     */
    public RequestTime getRequestTime() {
        return requestTime;
    }

    /** 
     * Set the 'RequestTime' element value.
     * 
     * @param requestTime
     */
    public void setRequestTime(RequestTime requestTime) {
        this.requestTime = requestTime;
    }

    /** 
     * Get the 'TouchPoint' element value.
     * 
     * @return value
     */
    public TouchPoint getTouchPoint() {
        return touchPoint;
    }

    /** 
     * Set the 'TouchPoint' element value.
     * 
     * @param touchPoint
     */
    public void setTouchPoint(TouchPoint touchPoint) {
        this.touchPoint = touchPoint;
    }

    /** 
     * Get the 'Metadata' element value.
     * 
     * @return value
     */
    public Metadata getMetadata() {
        return metadata;
    }

    /** 
     * Set the 'Metadata' element value.
     * 
     * @param metadata
     */
    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    /** 
     * Get the 'id' attribute value. A globally unique identifier for this object instance. 
     * 
     * @return value
     */
    public String getId() {
        return id;
    }

    /** 
     * Set the 'id' attribute value. A globally unique identifier for this object instance. 
     * 
     * @param id
     */
    public void setId(String id) {
        this.id = id;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any object instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any object instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }

    /** 
     * Get the 'AgentDutyCode' attribute value. Internally define agent authority to request changes.
     * 
     * @return value
     */
    public String getAgentDutyCode() {
        return agentDutyCode;
    }

    /** 
     * Set the 'AgentDutyCode' attribute value. Internally define agent authority to request changes.
     * 
     * @param agentDutyCode
     */
    public void setAgentDutyCode(String agentDutyCode) {
        this.agentDutyCode = agentDutyCode;
    }
    /** 
     * Point of sale location information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Location" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element ref="ns:CountryCode" minOccurs="0"/>
     *       &lt;xs:element ref="ns:CityCode" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Location implements Serializable
    {
        private CountryCodeType countryCode;
        private CityCodeType cityCode;

        /** 
         * Get the 'CountryCode' element value.
         * 
         * @return value
         */
        public CountryCodeType getCountryCode() {
            return countryCode;
        }

        /** 
         * Set the 'CountryCode' element value.
         * 
         * @param countryCode
         */
        public void setCountryCode(CountryCodeType countryCode) {
            this.countryCode = countryCode;
        }

        /** 
         * Get the 'CityCode' element value.
         * 
         * @return value
         */
        public CityCodeType getCityCode() {
            return cityCode;
        }

        /** 
         * Set the 'CityCode' element value.
         * 
         * @param cityCode
         */
        public void setCityCode(CityCodeType cityCode) {
            this.cityCode = cityCode;
        }
    }
    /** 
     * Point of sale timestamp value.  Example: 2017-01-13T13:59:38Z

    Note: This may be used if the point of sale time zone differs from the message creation timestamp.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RequestTime" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:dateTime">
     *         &lt;xs:attribute type="xs:string" use="optional" name="Zone"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class RequestTime implements Serializable
    {
        private Date dateTime;
        private String zone;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public Date getDateTime() {
            return dateTime;
        }

        /** 
         * Set the extension value.
         * 
         * @param dateTime
         */
        public void setDateTime(Date dateTime) {
            this.dateTime = dateTime;
        }

        /** 
         * Get the 'Zone' attribute value. Point of sale time zone.
        Example: UTC
         * 
         * @return value
         */
        public String getZone() {
            return zone;
        }

        /** 
         * Set the 'Zone' attribute value. Point of sale time zone.
        Example: UTC
         * 
         * @param zone
         */
        public void setZone(String zone) {
            this.zone = zone;
        }
    }
    /** 
     * Message Touchpoint information, including initiating device and event.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TouchPoint" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Device" minOccurs="0">
     *         &lt;!-- Reference to inner class Device -->
     *       &lt;/xs:element>
     *       &lt;xs:element type="ns:CodesetType" name="Event" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class TouchPoint implements Serializable
    {
        private Device device;
        private CodesetType event;

        /** 
         * Get the 'Device' element value.
         * 
         * @return value
         */
        public Device getDevice() {
            return device;
        }

        /** 
         * Set the 'Device' element value.
         * 
         * @param device
         */
        public void setDevice(Device device) {
            this.device = device;
        }

        /** 
         * Get the 'Event' element value. The travel event that triggered the request.
        Example: Order/Buy, Check-In, In Flight

        Encoding Scheme: IATA Padis Codeset - List for data element TTT (Touchpoint Transaction Type)
         * 
         * @return value
         */
        public CodesetType getEvent() {
            return event;
        }

        /** 
         * Set the 'Event' element value. The travel event that triggered the request.
        Example: Order/Buy, Check-In, In Flight

        Encoding Scheme: IATA Padis Codeset - List for data element TTT (Touchpoint Transaction Type)
         * 
         * @param event
         */
        public void setEvent(CodesetType event) {
            this.event = event;
        }
        /** 
         * The device from which the request was initiated. Examples: Agent Terminal, Web Browser, Mobile Device

        Encoding Scheme: IATA Padis Codeset - List for data element TDT (Touchpoint Device Type)
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Device" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:complexContent>
         *       &lt;xs:extension base="ns:CodesetType">
         *         &lt;xs:sequence>
         *           &lt;xs:element ref="ns:Position" minOccurs="0"/>
         *         &lt;/xs:sequence>
         *       &lt;/xs:extension>
         *     &lt;/xs:complexContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Device extends CodesetType implements Serializable
        {
            private PositionType position;

            /** 
             * Get the 'Position' element value. Device position and geocoding coordinates.
             * 
             * @return value
             */
            public PositionType getPosition() {
                return position;
            }

            /** 
             * Set the 'Position' element value. Device position and geocoding coordinates.
             * 
             * @param position
             */
            public void setPosition(PositionType position) {
                this.position = position;
            }
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Metadata" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="ns:MetaBaseType">
     *         &lt;xs:attribute type="xs:anySimpleType" name="DepartmentName"/>
     *         &lt;xs:attribute type="xs:anySimpleType" name="DepartmentCode"/>
     *         &lt;xs:attribute type="xs:anySimpleType" name="Terminal"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Metadata extends MetaBaseType implements Serializable
    {
        private String departmentName;
        private String departmentCode;
        private String terminal;

        /** 
         * Get the 'DepartmentName' attribute value.
         * 
         * @return value
         */
        public String getDepartmentName() {
            return departmentName;
        }

        /** 
         * Set the 'DepartmentName' attribute value.
         * 
         * @param departmentName
         */
        public void setDepartmentName(String departmentName) {
            this.departmentName = departmentName;
        }

        /** 
         * Get the 'DepartmentCode' attribute value.
         * 
         * @return value
         */
        public String getDepartmentCode() {
            return departmentCode;
        }

        /** 
         * Set the 'DepartmentCode' attribute value.
         * 
         * @param departmentCode
         */
        public void setDepartmentCode(String departmentCode) {
            this.departmentCode = departmentCode;
        }

        /** 
         * Get the 'Terminal' attribute value.
         * 
         * @return value
         */
        public String getTerminal() {
            return terminal;
        }

        /** 
         * Set the 'Terminal' attribute value.
         * 
         * @param terminal
         */
        public void setTerminal(String terminal) {
            this.terminal = terminal;
        }
    }
}
