
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * POSITION AND GEOCODING helper object.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PositionType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:KeyWithMetaObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element name="Latitude" minOccurs="0">
 *           &lt;!-- Reference to inner class Latitude -->
 *         &lt;/xs:element>
 *         &lt;xs:element name="Longitude" minOccurs="0">
 *           &lt;!-- Reference to inner class Longitude -->
 *         &lt;/xs:element>
 *         &lt;xs:element name="Altitude" minOccurs="0">
 *           &lt;!-- Reference to inner class Altitude -->
 *         &lt;/xs:element>
 *         &lt;xs:element type="xs:string" name="NAC" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PositionType extends KeyWithMetaObjectBaseType implements
    Serializable
{
    private Latitude latitude;
    private Longitude longitude;
    private Altitude altitude;
    private String NAC;

    /** 
     * Get the 'Latitude' element value.
     * 
     * @return value
     */
    public Latitude getLatitude() {
        return latitude;
    }

    /** 
     * Set the 'Latitude' element value.
     * 
     * @param latitude
     */
    public void setLatitude(Latitude latitude) {
        this.latitude = latitude;
    }

    /** 
     * Get the 'Longitude' element value.
     * 
     * @return value
     */
    public Longitude getLongitude() {
        return longitude;
    }

    /** 
     * Set the 'Longitude' element value.
     * 
     * @param longitude
     */
    public void setLongitude(Longitude longitude) {
        this.longitude = longitude;
    }

    /** 
     * Get the 'Altitude' element value.
     * 
     * @return value
     */
    public Altitude getAltitude() {
        return altitude;
    }

    /** 
     * Set the 'Altitude' element value.
     * 
     * @param altitude
     */
    public void setAltitude(Altitude altitude) {
        this.altitude = altitude;
    }

    /** 
     * Get the 'NAC' element value. Natural area geocode (NAC).  Example: 8KDB PGFD
     * 
     * @return value
     */
    public String getNAC() {
        return NAC;
    }

    /** 
     * Set the 'NAC' element value. Natural area geocode (NAC).  Example: 8KDB PGFD
     * 
     * @param NAC
     */
    public void setNAC(String NAC) {
        this.NAC = NAC;
    }
    /** 
     * Latitude value. Example: 49.9856
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Latitude" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:string">
     *         &lt;xs:attribute use="optional" name="Sign">
     *           &lt;xs:simpleType>
     *             &lt;!-- Reference to inner class Sign -->
     *           &lt;/xs:simpleType>
     *         &lt;/xs:attribute>
     *         &lt;xs:attribute type="xs:string" use="optional" name="Minute"/>
     *         &lt;xs:attribute type="xs:string" use="optional" name="Second"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Latitude implements Serializable
    {
        private String string;
        private Sign sign;
        private String minute;
        private String second;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getString() {
            return string;
        }

        /** 
         * Set the extension value.
         * 
         * @param string
         */
        public void setString(String string) {
            this.string = string;
        }

        /** 
         * Get the 'Sign' attribute value. Latitude sign. Example: SOUTH (South of Meridian)
         * 
         * @return value
         */
        public Sign getSign() {
            return sign;
        }

        /** 
         * Set the 'Sign' attribute value. Latitude sign. Example: SOUTH (South of Meridian)
         * 
         * @param sign
         */
        public void setSign(Sign sign) {
            this.sign = sign;
        }

        /** 
         * Get the 'Minute' attribute value. Latitude degree minute value. Example: 45
         * 
         * @return value
         */
        public String getMinute() {
            return minute;
        }

        /** 
         * Set the 'Minute' attribute value. Latitude degree minute value. Example: 45
         * 
         * @param minute
         */
        public void setMinute(String minute) {
            this.minute = minute;
        }

        /** 
         * Get the 'Second' attribute value. Latitude degree second value. Example: 30
         * 
         * @return value
         */
        public String getSecond() {
            return second;
        }

        /** 
         * Set the 'Second' attribute value. Latitude degree second value. Example: 30
         * 
         * @param second
         */
        public void setSecond(String second) {
            this.second = second;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
         *   &lt;xs:restriction base="xs:string">
         *     &lt;xs:enumeration value="SOUTH"/>
         *     &lt;xs:enumeration value="NORTH"/>
         *   &lt;/xs:restriction>
         * &lt;/xs:simpleType>
         * </pre>
         */
        public static enum Sign implements Serializable {
            SOUTH, NORTH
        }
    }
    /** 
     * Longitude value. Example: 9.1220
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Longitude" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:string">
     *         &lt;xs:attribute use="optional" name="Sign">
     *           &lt;xs:simpleType>
     *             &lt;!-- Reference to inner class Sign -->
     *           &lt;/xs:simpleType>
     *         &lt;/xs:attribute>
     *         &lt;xs:attribute type="xs:string" use="optional" name="Minute"/>
     *         &lt;xs:attribute type="xs:string" use="optional" name="Second"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Longitude implements Serializable
    {
        private String string;
        private Sign sign;
        private String minute;
        private String second;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getString() {
            return string;
        }

        /** 
         * Set the extension value.
         * 
         * @param string
         */
        public void setString(String string) {
            this.string = string;
        }

        /** 
         * Get the 'Sign' attribute value. Longitude sign. Example: EAST (East of Meridian)
         * 
         * @return value
         */
        public Sign getSign() {
            return sign;
        }

        /** 
         * Set the 'Sign' attribute value. Longitude sign. Example: EAST (East of Meridian)
         * 
         * @param sign
         */
        public void setSign(Sign sign) {
            this.sign = sign;
        }

        /** 
         * Get the 'Minute' attribute value. Longitude degree minute value. Example: 130
         * 
         * @return value
         */
        public String getMinute() {
            return minute;
        }

        /** 
         * Set the 'Minute' attribute value. Longitude degree minute value. Example: 130
         * 
         * @param minute
         */
        public void setMinute(String minute) {
            this.minute = minute;
        }

        /** 
         * Get the 'Second' attribute value. Longitude degree second value. Example: 69
         * 
         * @return value
         */
        public String getSecond() {
            return second;
        }

        /** 
         * Set the 'Second' attribute value. Longitude degree second value. Example: 69
         * 
         * @param second
         */
        public void setSecond(String second) {
            this.second = second;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
         *   &lt;xs:restriction base="xs:string">
         *     &lt;xs:enumeration value="EAST"/>
         *     &lt;xs:enumeration value="WEST"/>
         *   &lt;/xs:restriction>
         * &lt;/xs:simpleType>
         * </pre>
         */
        public static enum Sign implements Serializable {
            EAST, WEST
        }
    }
    /** 
     * Altitude value. Example: 9.1220
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Altitude" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:string">
     *         &lt;xs:attribute type="xs:string" use="optional" name="Unit"/>
     *         &lt;xs:attribute type="xs:string" use="optional" name="Context"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Altitude implements Serializable
    {
        private String string;
        private String unit;
        private String context;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getString() {
            return string;
        }

        /** 
         * Set the extension value.
         * 
         * @param string
         */
        public void setString(String string) {
            this.string = string;
        }

        /** 
         * Get the 'Unit' attribute value. Altitude unit of measure.
        Example: Feet, Meters
         * 
         * @return value
         */
        public String getUnit() {
            return unit;
        }

        /** 
         * Set the 'Unit' attribute value. Altitude unit of measure.
        Example: Feet, Meters
         * 
         * @param unit
         */
        public void setUnit(String unit) {
            this.unit = unit;
        }

        /** 
         * Get the 'Context' attribute value. Other altitude unit of measure context. Example: MyContext
         * 
         * @return value
         */
        public String getContext() {
            return context;
        }

        /** 
         * Set the 'Context' attribute value. Other altitude unit of measure context. Example: MyContext
         * 
         * @param context
         */
        public void setContext(String context) {
            this.context = context;
        }
    }
}
