
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Shopping Preference(s), including Airline Supplier, Alliance Program, Fare, Flight and Transfer/ Connection Points.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Preferences">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element name="Preference" maxOccurs="unbounded">
 *         &lt;!-- Reference to inner class Preference -->
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class Preferences implements Serializable
{
    private List<Preference> preferenceList = new ArrayList<Preference>();

    /** 
     * Get the list of 'Preference' element items.
     * 
     * @return list
     */
    public List<Preference> getPreferenceList() {
        return preferenceList;
    }

    /** 
     * Set the list of 'Preference' element items.
     * 
     * @param list
     */
    public void setPreferenceList(List<Preference> list) {
        preferenceList = list;
    }
    /** 
     * Contains Shopping Preference choices, ie allowing to specify Airline, Alliance, Flight, Transfer and other shopping preferences.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Preference" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:choice>
     *       &lt;xs:element ref="ns:AirlinePreferences"/>
     *       &lt;xs:element ref="ns:AlliancePreferences"/>
     *       &lt;xs:element ref="ns:FarePreferences"/>
     *       &lt;xs:element ref="ns:FlightPreferences"/>
     *       &lt;xs:element ref="ns:PricingMethodPreference"/>
     *       &lt;xs:element ref="ns:SegMaxTimePreferences"/>
     *       &lt;xs:element ref="ns:ServicePricingOnlyPreference"/>
     *       &lt;xs:element ref="ns:TransferPreferences"/>
     *     &lt;/xs:choice>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Preference implements Serializable
    {
        private int preferenceListSelect = -1;
        private static final int AIRLINE_PREFERENCES_CHOICE = 0;
        private static final int ALLIANCE_PREFERENCES_CHOICE = 1;
        private static final int FARE_PREFERENCES_CHOICE = 2;
        private static final int FLIGHT_PREFERENCES_CHOICE = 3;
        private static final int PRICING_METHOD_PREFERENCE_CHOICE = 4;
        private static final int SEG_MAX_TIME_PREFERENCES_CHOICE = 5;
        private static final int SERVICE_PRICING_ONLY_PREFERENCE_CHOICE = 6;
        private static final int TRANSFER_PREFERENCES_CHOICE = 7;
        private AirlinePreferencesType airlinePreferences;
        private AlliancePreferencesType alliancePreferences;
        private FarePreferencesType farePreferences;
        private FlightPreferencesType flightPreferences;
        private BestPricingPreferencesType pricingMethodPreference;
        private FltSegmentMaxTimePreferencesType segMaxTimePreferences;
        private ServicePricingOnlyPreference servicePricingOnlyPreference;
        private TransferPreferencesType transferPreferences;

        private void setPreferenceListSelect(int choice) {
            if (preferenceListSelect == -1) {
                preferenceListSelect = choice;
            } else if (preferenceListSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearPreferenceListSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearPreferenceListSelect() {
            preferenceListSelect = -1;
        }

        /** 
         * Check if AirlinePreferences is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifAirlinePreferences() {
            return preferenceListSelect == AIRLINE_PREFERENCES_CHOICE;
        }

        /** 
         * Get the 'AirlinePreferences' element value.
         * 
         * @return value
         */
        public AirlinePreferencesType getAirlinePreferences() {
            return airlinePreferences;
        }

        /** 
         * Set the 'AirlinePreferences' element value.
         * 
         * @param airlinePreferences
         */
        public void setAirlinePreferences(
                AirlinePreferencesType airlinePreferences) {
            setPreferenceListSelect(AIRLINE_PREFERENCES_CHOICE);
            this.airlinePreferences = airlinePreferences;
        }

        /** 
         * Check if AlliancePreferences is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifAlliancePreferences() {
            return preferenceListSelect == ALLIANCE_PREFERENCES_CHOICE;
        }

        /** 
         * Get the 'AlliancePreferences' element value.
         * 
         * @return value
         */
        public AlliancePreferencesType getAlliancePreferences() {
            return alliancePreferences;
        }

        /** 
         * Set the 'AlliancePreferences' element value.
         * 
         * @param alliancePreferences
         */
        public void setAlliancePreferences(
                AlliancePreferencesType alliancePreferences) {
            setPreferenceListSelect(ALLIANCE_PREFERENCES_CHOICE);
            this.alliancePreferences = alliancePreferences;
        }

        /** 
         * Check if FarePreferences is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifFarePreferences() {
            return preferenceListSelect == FARE_PREFERENCES_CHOICE;
        }

        /** 
         * Get the 'FarePreferences' element value.
         * 
         * @return value
         */
        public FarePreferencesType getFarePreferences() {
            return farePreferences;
        }

        /** 
         * Set the 'FarePreferences' element value.
         * 
         * @param farePreferences
         */
        public void setFarePreferences(FarePreferencesType farePreferences) {
            setPreferenceListSelect(FARE_PREFERENCES_CHOICE);
            this.farePreferences = farePreferences;
        }

        /** 
         * Check if FlightPreferences is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifFlightPreferences() {
            return preferenceListSelect == FLIGHT_PREFERENCES_CHOICE;
        }

        /** 
         * Get the 'FlightPreferences' element value.
         * 
         * @return value
         */
        public FlightPreferencesType getFlightPreferences() {
            return flightPreferences;
        }

        /** 
         * Set the 'FlightPreferences' element value.
         * 
         * @param flightPreferences
         */
        public void setFlightPreferences(FlightPreferencesType flightPreferences) {
            setPreferenceListSelect(FLIGHT_PREFERENCES_CHOICE);
            this.flightPreferences = flightPreferences;
        }

        /** 
         * Check if PricingMethodPreference is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifPricingMethodPreference() {
            return preferenceListSelect == PRICING_METHOD_PREFERENCE_CHOICE;
        }

        /** 
         * Get the 'PricingMethodPreference' element value. Contains information to identify how reservation was re-priced to obtain best published fare (Eg. best fare in same cabin, best fare in all cabins, other parameters to select best fare).
         * 
         * @return value
         */
        public BestPricingPreferencesType getPricingMethodPreference() {
            return pricingMethodPreference;
        }

        /** 
         * Set the 'PricingMethodPreference' element value. Contains information to identify how reservation was re-priced to obtain best published fare (Eg. best fare in same cabin, best fare in all cabins, other parameters to select best fare).
         * 
         * @param pricingMethodPreference
         */
        public void setPricingMethodPreference(
                BestPricingPreferencesType pricingMethodPreference) {
            setPreferenceListSelect(PRICING_METHOD_PREFERENCE_CHOICE);
            this.pricingMethodPreference = pricingMethodPreference;
        }

        /** 
         * Check if SegMaxTimePreferences is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifSegMaxTimePreferences() {
            return preferenceListSelect == SEG_MAX_TIME_PREFERENCES_CHOICE;
        }

        /** 
         * Get the 'SegMaxTimePreferences' element value.
         * 
         * @return value
         */
        public FltSegmentMaxTimePreferencesType getSegMaxTimePreferences() {
            return segMaxTimePreferences;
        }

        /** 
         * Set the 'SegMaxTimePreferences' element value.
         * 
         * @param segMaxTimePreferences
         */
        public void setSegMaxTimePreferences(
                FltSegmentMaxTimePreferencesType segMaxTimePreferences) {
            setPreferenceListSelect(SEG_MAX_TIME_PREFERENCES_CHOICE);
            this.segMaxTimePreferences = segMaxTimePreferences;
        }

        /** 
         * Check if ServicePricingOnlyPreference is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifServicePricingOnlyPreference() {
            return preferenceListSelect == SERVICE_PRICING_ONLY_PREFERENCE_CHOICE;
        }

        /** 
         * Get the 'ServicePricingOnlyPreference' element value.
         * 
         * @return value
         */
        public ServicePricingOnlyPreference getServicePricingOnlyPreference() {
            return servicePricingOnlyPreference;
        }

        /** 
         * Set the 'ServicePricingOnlyPreference' element value.
         * 
         * @param servicePricingOnlyPreference
         */
        public void setServicePricingOnlyPreference(
                ServicePricingOnlyPreference servicePricingOnlyPreference) {
            setPreferenceListSelect(SERVICE_PRICING_ONLY_PREFERENCE_CHOICE);
            this.servicePricingOnlyPreference = servicePricingOnlyPreference;
        }

        /** 
         * Check if TransferPreferences is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifTransferPreferences() {
            return preferenceListSelect == TRANSFER_PREFERENCES_CHOICE;
        }

        /** 
         * Get the 'TransferPreferences' element value.
         * 
         * @return value
         */
        public TransferPreferencesType getTransferPreferences() {
            return transferPreferences;
        }

        /** 
         * Set the 'TransferPreferences' element value.
         * 
         * @param transferPreferences
         */
        public void setTransferPreferences(
                TransferPreferencesType transferPreferences) {
            setPreferenceListSelect(TRANSFER_PREFERENCES_CHOICE);
            this.transferPreferences = transferPreferences;
        }
    }
}
