
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * 
 Acceptable Price Variance Rule definition. Note: This is the acceptable amount and/or percentage of the total amount by which the Order item price can vary from the Offer price for Order creation to proceed, for example to cover minor currency exchange rate fluctuations for taxes quoted in a different currency.

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceVarianceRuleNoticeType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:TrxProcessObjectBaseType">
 *       &lt;xs:choice>
 *         &lt;xs:element name="Query">
 *           &lt;xs:complexType>
 *             &lt;xs:sequence>
 *               &lt;xs:element name="PriceVarianceRule" maxOccurs="unbounded">
 *                 &lt;!-- Reference to inner class PriceVarianceRule -->
 *               &lt;/xs:element>
 *             &lt;/xs:sequence>
 *             &lt;xs:attribute type="xs:boolean" use="optional" name="VarianceRuleInd"/>
 *           &lt;/xs:complexType>
 *         &lt;/xs:element>
 *         &lt;xs:element name="Results">
 *           &lt;!-- Reference to inner class Results -->
 *         &lt;/xs:element>
 *       &lt;/xs:choice>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PriceVarianceRuleNoticeType extends TrxProcessObjectBaseType
    implements Serializable
{
    private int choiceSelect = -1;
    private static final int QUERY_CHOICE = 0;
    private static final int RESULTS_CHOICE = 1;
    private List<PriceVarianceRule> priceVarianceRuleList = new ArrayList<PriceVarianceRule>();
    private Boolean queryVarianceRuleInd;
    private Results results;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if Query is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifQuery() {
        return choiceSelect == QUERY_CHOICE;
    }

    /** 
     * Get the list of 'PriceVarianceRule' element items. Price Variance Order Creation Rule(s).
     * 
     * @return list
     */
    public List<PriceVarianceRule> getPriceVarianceRuleList() {
        return priceVarianceRuleList;
    }

    /** 
     * Set the list of 'PriceVarianceRule' element items. Price Variance Order Creation Rule(s).
     * 
     * @param list
     */
    public void setPriceVarianceRuleList(List<PriceVarianceRule> list) {
        setChoiceSelect(QUERY_CHOICE);
        priceVarianceRuleList = list;
    }

    /** 
     * Get the 'VarianceRuleInd' attribute value. 
                      When TRUE, price variance rule(s) have been specified.
                    
     * 
     * @return value
     */
    public Boolean getQueryVarianceRuleInd() {
        return queryVarianceRuleInd;
    }

    /** 
     * Set the 'VarianceRuleInd' attribute value. 
                      When TRUE, price variance rule(s) have been specified.
                    
     * 
     * @param queryVarianceRuleInd
     */
    public void setQueryVarianceRuleInd(Boolean queryVarianceRuleInd) {
        setChoiceSelect(QUERY_CHOICE);
        this.queryVarianceRuleInd = queryVarianceRuleInd;
    }

    /** 
     * Check if Results is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifResults() {
        return choiceSelect == RESULTS_CHOICE;
    }

    /** 
     * Get the 'Results' element value.
     * 
     * @return value
     */
    public Results getResults() {
        return results;
    }

    /** 
     * Set the 'Results' element value.
     * 
     * @param results
     */
    public void setResults(Results results) {
        setChoiceSelect(RESULTS_CHOICE);
        this.results = results;
    }
    /** 
     * Price Variance Rule detail.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceVarianceRule" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="SequenceNbr" minOccurs="0"/>
     *       &lt;xs:element name="RuleID">
     *         &lt;xs:complexType>
     *           &lt;xs:simpleContent>
     *             &lt;xs:extension base="xs:string">
     *               &lt;xs:attribute type="xs:string" use="optional" name="Context"/>
     *               &lt;xs:attribute type="xs:anySimpleType" name="Name"/>
     *             &lt;/xs:extension>
     *           &lt;/xs:simpleContent>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *       &lt;xs:element name="AcceptableVariance">
     *         &lt;xs:complexType>
     *           &lt;xs:sequence>
     *             &lt;xs:element ref="ns:CurrencyAmountValue"/>
     *             &lt;xs:element ref="ns:PercentageValue"/>
     *           &lt;/xs:sequence>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *       &lt;xs:element type="xs:string" name="Name" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="Owner" minOccurs="0"/>
     *       &lt;xs:element name="RuleValid" minOccurs="0">
     *         &lt;!-- Reference to inner class RuleValid -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="Currencies" minOccurs="0">
     *         &lt;!-- Reference to inner class Currencies -->
     *       &lt;/xs:element>
     *       &lt;xs:element ref="ns:Associations" minOccurs="0"/>
     *       &lt;xs:element ref="ns:Remarks" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class PriceVarianceRule implements Serializable
    {
        private String sequenceNbr;
        private String ruleIDString;
        private String ruleIDContext;
        private String ruleIDName;
        private CurrencyAmountValue acceptableVarianceCurrencyAmountValue;
        private PercentageValue acceptableVariancePercentageValue;
        private String name;
        private String owner;
        private RuleValid ruleValid;
        private Currencies currencies;
        private Associations associations;
        private Remarks remarks;

        /** 
         * Get the 'SequenceNbr' element value. Rule sequence (or order) number. Example: 1
         * 
         * @return value
         */
        public String getSequenceNbr() {
            return sequenceNbr;
        }

        /** 
         * Set the 'SequenceNbr' element value. Rule sequence (or order) number. Example: 1
         * 
         * @param sequenceNbr
         */
        public void setSequenceNbr(String sequenceNbr) {
            this.sequenceNbr = sequenceNbr;
        }

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getRuleIDString() {
            return ruleIDString;
        }

        /** 
         * Set the extension value.
         * 
         * @param ruleIDString
         */
        public void setRuleIDString(String ruleIDString) {
            this.ruleIDString = ruleIDString;
        }

        /** 
         * Get the 'Context' attribute value. Rule ID Context.
         * 
         * @return value
         */
        public String getRuleIDContext() {
            return ruleIDContext;
        }

        /** 
         * Set the 'Context' attribute value. Rule ID Context.
         * 
         * @param ruleIDContext
         */
        public void setRuleIDContext(String ruleIDContext) {
            this.ruleIDContext = ruleIDContext;
        }

        /** 
         * Get the 'Name' attribute value. 
                                        Rule Name. Example: Acceptable Order Item Price Variance
                                      
         * 
         * @return value
         */
        public String getRuleIDName() {
            return ruleIDName;
        }

        /** 
         * Set the 'Name' attribute value. 
                                        Rule Name. Example: Acceptable Order Item Price Variance
                                      
         * 
         * @param ruleIDName
         */
        public void setRuleIDName(String ruleIDName) {
            this.ruleIDName = ruleIDName;
        }

        /** 
         * Get the 'CurrencyAmountValue' element value.
         * 
         * @return value
         */
        public CurrencyAmountValue getAcceptableVarianceCurrencyAmountValue() {
            return acceptableVarianceCurrencyAmountValue;
        }

        /** 
         * Set the 'CurrencyAmountValue' element value.
         * 
         * @param acceptableVarianceCurrencyAmountValue
         */
        public void setAcceptableVarianceCurrencyAmountValue(
                CurrencyAmountValue acceptableVarianceCurrencyAmountValue) {
            this.acceptableVarianceCurrencyAmountValue = acceptableVarianceCurrencyAmountValue;
        }

        /** 
         * Get the 'PercentageValue' element value.
         * 
         * @return value
         */
        public PercentageValue getAcceptableVariancePercentageValue() {
            return acceptableVariancePercentageValue;
        }

        /** 
         * Set the 'PercentageValue' element value.
         * 
         * @param acceptableVariancePercentageValue
         */
        public void setAcceptableVariancePercentageValue(
                PercentageValue acceptableVariancePercentageValue) {
            this.acceptableVariancePercentageValue = acceptableVariancePercentageValue;
        }

        /** 
         * Get the 'Name' element value. Rule Name. Example: Acceptable Price variance
         * 
         * @return value
         */
        public String getName() {
            return name;
        }

        /** 
         * Set the 'Name' element value. Rule Name. Example: Acceptable Price variance
         * 
         * @param name
         */
        public void setName(String name) {
            this.name = name;
        }

        /** 
         * Get the 'Owner' element value. 
                                Entity that owns/ assigned this Rule. Example: BA Note: If this is an airline, the IATA/ A4A (two or three character) Airline Designator Code should be used.
                              
         * 
         * @return value
         */
        public String getOwner() {
            return owner;
        }

        /** 
         * Set the 'Owner' element value. 
                                Entity that owns/ assigned this Rule. Example: BA Note: If this is an airline, the IATA/ A4A (two or three character) Airline Designator Code should be used.
                              
         * 
         * @param owner
         */
        public void setOwner(String owner) {
            this.owner = owner;
        }

        /** 
         * Get the 'RuleValid' element value.
         * 
         * @return value
         */
        public RuleValid getRuleValid() {
            return ruleValid;
        }

        /** 
         * Set the 'RuleValid' element value.
         * 
         * @param ruleValid
         */
        public void setRuleValid(RuleValid ruleValid) {
            this.ruleValid = ruleValid;
        }

        /** 
         * Get the 'Currencies' element value.
         * 
         * @return value
         */
        public Currencies getCurrencies() {
            return currencies;
        }

        /** 
         * Set the 'Currencies' element value.
         * 
         * @param currencies
         */
        public void setCurrencies(Currencies currencies) {
            this.currencies = currencies;
        }

        /** 
         * Get the 'Associations' element value.
         * 
         * @return value
         */
        public Associations getAssociations() {
            return associations;
        }

        /** 
         * Set the 'Associations' element value.
         * 
         * @param associations
         */
        public void setAssociations(Associations associations) {
            this.associations = associations;
        }

        /** 
         * Get the 'Remarks' element value.
         * 
         * @return value
         */
        public Remarks getRemarks() {
            return remarks;
        }

        /** 
         * Set the 'Remarks' element value.
         * 
         * @param remarks
         */
        public void setRemarks(Remarks remarks) {
            this.remarks = remarks;
        }
        /** 
         * Rule Effective Period.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RuleValid" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element ref="ns:DatePeriod"/>
         *       &lt;xs:element ref="ns:DateTimePeriod"/>
         *       &lt;xs:element ref="ns:DayPeriod"/>
         *       &lt;xs:element ref="ns:MonthPeriod"/>
         *       &lt;xs:element ref="ns:QuarterPeriod"/>
         *       &lt;xs:element ref="ns:TimePeriod"/>
         *       &lt;xs:element ref="ns:YearMonthPeriod"/>
         *       &lt;xs:element ref="ns:YearPeriod"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class RuleValid implements Serializable
        {
            private DatePeriodRepType datePeriod;
            private DateTimePeriodRepType dateTimePeriod;
            private DayPeriodRepType dayPeriod;
            private MonthPeriodRepType monthPeriod;
            private QuarterPeriodRepType quarterPeriod;
            private TimePeriodRepType timePeriod;
            private YearMonthPeriodRepType yearMonthPeriod;
            private YearPeriodRepType yearPeriod;

            /** 
             * Get the 'DatePeriod' element value.
             * 
             * @return value
             */
            public DatePeriodRepType getDatePeriod() {
                return datePeriod;
            }

            /** 
             * Set the 'DatePeriod' element value.
             * 
             * @param datePeriod
             */
            public void setDatePeriod(DatePeriodRepType datePeriod) {
                this.datePeriod = datePeriod;
            }

            /** 
             * Get the 'DateTimePeriod' element value.
             * 
             * @return value
             */
            public DateTimePeriodRepType getDateTimePeriod() {
                return dateTimePeriod;
            }

            /** 
             * Set the 'DateTimePeriod' element value.
             * 
             * @param dateTimePeriod
             */
            public void setDateTimePeriod(DateTimePeriodRepType dateTimePeriod) {
                this.dateTimePeriod = dateTimePeriod;
            }

            /** 
             * Get the 'DayPeriod' element value.
             * 
             * @return value
             */
            public DayPeriodRepType getDayPeriod() {
                return dayPeriod;
            }

            /** 
             * Set the 'DayPeriod' element value.
             * 
             * @param dayPeriod
             */
            public void setDayPeriod(DayPeriodRepType dayPeriod) {
                this.dayPeriod = dayPeriod;
            }

            /** 
             * Get the 'MonthPeriod' element value.
             * 
             * @return value
             */
            public MonthPeriodRepType getMonthPeriod() {
                return monthPeriod;
            }

            /** 
             * Set the 'MonthPeriod' element value.
             * 
             * @param monthPeriod
             */
            public void setMonthPeriod(MonthPeriodRepType monthPeriod) {
                this.monthPeriod = monthPeriod;
            }

            /** 
             * Get the 'QuarterPeriod' element value.
             * 
             * @return value
             */
            public QuarterPeriodRepType getQuarterPeriod() {
                return quarterPeriod;
            }

            /** 
             * Set the 'QuarterPeriod' element value.
             * 
             * @param quarterPeriod
             */
            public void setQuarterPeriod(QuarterPeriodRepType quarterPeriod) {
                this.quarterPeriod = quarterPeriod;
            }

            /** 
             * Get the 'TimePeriod' element value.
             * 
             * @return value
             */
            public TimePeriodRepType getTimePeriod() {
                return timePeriod;
            }

            /** 
             * Set the 'TimePeriod' element value.
             * 
             * @param timePeriod
             */
            public void setTimePeriod(TimePeriodRepType timePeriod) {
                this.timePeriod = timePeriod;
            }

            /** 
             * Get the 'YearMonthPeriod' element value.
             * 
             * @return value
             */
            public YearMonthPeriodRepType getYearMonthPeriod() {
                return yearMonthPeriod;
            }

            /** 
             * Set the 'YearMonthPeriod' element value.
             * 
             * @param yearMonthPeriod
             */
            public void setYearMonthPeriod(
                    YearMonthPeriodRepType yearMonthPeriod) {
                this.yearMonthPeriod = yearMonthPeriod;
            }

            /** 
             * Get the 'YearPeriod' element value.
             * 
             * @return value
             */
            public YearPeriodRepType getYearPeriod() {
                return yearPeriod;
            }

            /** 
             * Set the 'YearPeriod' element value.
             * 
             * @param yearPeriod
             */
            public void setYearPeriod(YearPeriodRepType yearPeriod) {
                this.yearPeriod = yearPeriod;
            }
        }
        /** 
         * Price Variance Rule applicable Input and Settlement Currency(s). 

        Note: This contains one or multiple input and settlement currency codes that this rule applies to. In addition to the specified currency code, an Application of InputCurrency and/ or SettlementCurrency should be specified.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Currencies" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:CurrencyCodeType" name="InputCode" minOccurs="0" maxOccurs="unbounded"/>
         *       &lt;xs:element type="ns:CurrencyCodeType" name="SettlementCode" minOccurs="0" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Currencies implements Serializable
        {
            private List<CurrencyCodeType> inputCodeList = new ArrayList<CurrencyCodeType>();
            private List<CurrencyCodeType> settlementCodeList = new ArrayList<CurrencyCodeType>();

            /** 
             * Get the list of 'InputCode' element items. 
                                        Input Payment Currency code. Example: USD Encoding Scheme: ISO 4217 (three alpha character) Currency Code
                                      
             * 
             * @return list
             */
            public List<CurrencyCodeType> getInputCodeList() {
                return inputCodeList;
            }

            /** 
             * Set the list of 'InputCode' element items. 
                                        Input Payment Currency code. Example: USD Encoding Scheme: ISO 4217 (three alpha character) Currency Code
                                      
             * 
             * @param list
             */
            public void setInputCodeList(List<CurrencyCodeType> list) {
                inputCodeList = list;
            }

            /** 
             * Get the list of 'SettlementCode' element items. 
                                        Settlement Payment Currency code. Example: CHF Encoding Scheme: ISO 4217 (three alpha character) Currency Code
                                      
             * 
             * @return list
             */
            public List<CurrencyCodeType> getSettlementCodeList() {
                return settlementCodeList;
            }

            /** 
             * Set the list of 'SettlementCode' element items. 
                                        Settlement Payment Currency code. Example: CHF Encoding Scheme: ISO 4217 (three alpha character) Currency Code
                                      
             * 
             * @param list
             */
            public void setSettlementCodeList(List<CurrencyCodeType> list) {
                settlementCodeList = list;
            }
        }
    }
    /** 
     * 
                  Price Variance Order Creation Rule(s) Usage during transaction processing.
                
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Results">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="PriceVariance" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class PriceVariance -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:boolean" use="optional" name="VarianceAppliedInd"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Results implements Serializable
    {
        private List<PriceVariance> priceVarianceList = new ArrayList<PriceVariance>();
        private Boolean varianceAppliedInd;

        /** 
         * Get the list of 'PriceVariance' element items.
         * 
         * @return list
         */
        public List<PriceVariance> getPriceVarianceList() {
            return priceVarianceList;
        }

        /** 
         * Set the list of 'PriceVariance' element items.
         * 
         * @param list
         */
        public void setPriceVarianceList(List<PriceVariance> list) {
            priceVarianceList = list;
        }

        /** 
         * Get the 'VarianceAppliedInd' attribute value. 
                        When TRUE, a pricing variant was applied to the total order price or one or more priced Order Items.
                      
         * 
         * @return value
         */
        public Boolean getVarianceAppliedInd() {
            return varianceAppliedInd;
        }

        /** 
         * Set the 'VarianceAppliedInd' attribute value. 
                        When TRUE, a pricing variant was applied to the total order price or one or more priced Order Items.
                      
         * 
         * @param varianceAppliedInd
         */
        public void setVarianceAppliedInd(Boolean varianceAppliedInd) {
            this.varianceAppliedInd = varianceAppliedInd;
        }
        /** 
         * Applied Price Variance Rule(s).
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceVariance" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="RuleID" minOccurs="0">
         *         &lt;!-- Reference to inner class RuleID -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Amount">
         *         &lt;xs:complexType>
         *           &lt;xs:sequence>
         *             &lt;xs:element ref="ns:CurrencyAmountValue"/>
         *             &lt;xs:element ref="ns:PercentageValue"/>
         *           &lt;/xs:sequence>
         *         &lt;/xs:complexType>
         *       &lt;/xs:element>
         *       &lt;xs:element ref="ns:Associations" minOccurs="0"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PriceVariance implements Serializable
        {
            private RuleID ruleID;
            private CurrencyAmountValue amountCurrencyAmountValue;
            private PercentageValue amountPercentageValue;
            private Associations associations;

            /** 
             * Get the 'RuleID' element value.
             * 
             * @return value
             */
            public RuleID getRuleID() {
                return ruleID;
            }

            /** 
             * Set the 'RuleID' element value.
             * 
             * @param ruleID
             */
            public void setRuleID(RuleID ruleID) {
                this.ruleID = ruleID;
            }

            /** 
             * Get the 'CurrencyAmountValue' element value.
             * 
             * @return value
             */
            public CurrencyAmountValue getAmountCurrencyAmountValue() {
                return amountCurrencyAmountValue;
            }

            /** 
             * Set the 'CurrencyAmountValue' element value.
             * 
             * @param amountCurrencyAmountValue
             */
            public void setAmountCurrencyAmountValue(
                    CurrencyAmountValue amountCurrencyAmountValue) {
                this.amountCurrencyAmountValue = amountCurrencyAmountValue;
            }

            /** 
             * Get the 'PercentageValue' element value.
             * 
             * @return value
             */
            public PercentageValue getAmountPercentageValue() {
                return amountPercentageValue;
            }

            /** 
             * Set the 'PercentageValue' element value.
             * 
             * @param amountPercentageValue
             */
            public void setAmountPercentageValue(
                    PercentageValue amountPercentageValue) {
                this.amountPercentageValue = amountPercentageValue;
            }

            /** 
             * Get the 'Associations' element value. 
                                  Order ID, Order Item and other associations where a price variance was applied.
                                
             * 
             * @return value
             */
            public Associations getAssociations() {
                return associations;
            }

            /** 
             * Set the 'Associations' element value. 
                                  Order ID, Order Item and other associations where a price variance was applied.
                                
             * 
             * @param associations
             */
            public void setAssociations(Associations associations) {
                this.associations = associations;
            }
            /** 
             * Unique Rule ID which was applied during transaction processing. Example: PRICERULE001 Note: Optional rule context and name may also be specified.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RuleID" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:string">
             *         &lt;xs:attribute type="xs:string" use="optional" name="Context"/>
             *         &lt;xs:attribute type="xs:anySimpleType" name="Name"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class RuleID implements Serializable
            {
                private String string;
                private String context;
                private String name;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public String getString() {
                    return string;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param string
                 */
                public void setString(String string) {
                    this.string = string;
                }

                /** 
                 * Get the 'Context' attribute value. Rule ID Context.
                 * 
                 * @return value
                 */
                public String getContext() {
                    return context;
                }

                /** 
                 * Set the 'Context' attribute value. Rule ID Context.
                 * 
                 * @param context
                 */
                public void setContext(String context) {
                    this.context = context;
                }

                /** 
                 * Get the 'Name' attribute value. 
                                            Rule Name. Example: Acceptable Order Item Price Variance
                                          
                 * 
                 * @return value
                 */
                public String getName() {
                    return name;
                }

                /** 
                 * Set the 'Name' attribute value. 
                                            Rule Name. Example: Acceptable Order Item Price Variance
                                          
                 * 
                 * @param name
                 */
                public void setName(String name) {
                    this.name = name;
                }
            }
        }
    }
}
