
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * ORDER CREATION PRICE VARIANCE RULE definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceVarianceRuleType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="RuleID"/>
 *     &lt;xs:element name="AcceptableVariance">
 *       &lt;xs:complexType>
 *         &lt;xs:sequence>
 *           &lt;xs:element ref="ns:CurrencyAmountValue"/>
 *           &lt;xs:element ref="ns:PercentageValue" minOccurs="0"/>
 *         &lt;/xs:sequence>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:string" name="Name" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Owner" minOccurs="0"/>
 *     &lt;xs:element name="EffectivePeriod" minOccurs="0">
 *       &lt;!-- Reference to inner class EffectivePeriod -->
 *     &lt;/xs:element>
 *     &lt;xs:element ref="ns:Remarks" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ns:ObjectKeyAttrGroup"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PriceVarianceRuleType implements Serializable
{
    private String ruleID;
    private CurrencyAmountValue acceptableVarianceCurrencyAmountValue;
    private PercentageValue acceptableVariancePercentageValue;
    private String name;
    private String owner;
    private EffectivePeriod effectivePeriod;
    private Remarks remarks;
    private ObjectKeyAttrGroup objectKeyAttrGroup;

    /** 
     * Get the 'RuleID' element value. Unique Rule ID. Example: RULE001
     * 
     * @return value
     */
    public String getRuleID() {
        return ruleID;
    }

    /** 
     * Set the 'RuleID' element value. Unique Rule ID. Example: RULE001
     * 
     * @param ruleID
     */
    public void setRuleID(String ruleID) {
        this.ruleID = ruleID;
    }

    /** 
     * Get the 'CurrencyAmountValue' element value.
     * 
     * @return value
     */
    public CurrencyAmountValue getAcceptableVarianceCurrencyAmountValue() {
        return acceptableVarianceCurrencyAmountValue;
    }

    /** 
     * Set the 'CurrencyAmountValue' element value.
     * 
     * @param acceptableVarianceCurrencyAmountValue
     */
    public void setAcceptableVarianceCurrencyAmountValue(
            CurrencyAmountValue acceptableVarianceCurrencyAmountValue) {
        this.acceptableVarianceCurrencyAmountValue = acceptableVarianceCurrencyAmountValue;
    }

    /** 
     * Get the 'PercentageValue' element value.
     * 
     * @return value
     */
    public PercentageValue getAcceptableVariancePercentageValue() {
        return acceptableVariancePercentageValue;
    }

    /** 
     * Set the 'PercentageValue' element value.
     * 
     * @param acceptableVariancePercentageValue
     */
    public void setAcceptableVariancePercentageValue(
            PercentageValue acceptableVariancePercentageValue) {
        this.acceptableVariancePercentageValue = acceptableVariancePercentageValue;
    }

    /** 
     * Get the 'Name' element value. Rule Name. Example: Acceptable Price variance
     * 
     * @return value
     */
    public String getName() {
        return name;
    }

    /** 
     * Set the 'Name' element value. Rule Name. Example: Acceptable Price variance
     * 
     * @param name
     */
    public void setName(String name) {
        this.name = name;
    }

    /** 
     * Get the 'Owner' element value. Entity that owns/ assigned this Rule. Example: BA

    Note: If this is an airline, the IATA/ A4A (two or three character) Airline Designator Code should be used.
     * 
     * @return value
     */
    public String getOwner() {
        return owner;
    }

    /** 
     * Set the 'Owner' element value. Entity that owns/ assigned this Rule. Example: BA

    Note: If this is an airline, the IATA/ A4A (two or three character) Airline Designator Code should be used.
     * 
     * @param owner
     */
    public void setOwner(String owner) {
        this.owner = owner;
    }

    /** 
     * Get the 'EffectivePeriod' element value.
     * 
     * @return value
     */
    public EffectivePeriod getEffectivePeriod() {
        return effectivePeriod;
    }

    /** 
     * Set the 'EffectivePeriod' element value.
     * 
     * @param effectivePeriod
     */
    public void setEffectivePeriod(EffectivePeriod effectivePeriod) {
        this.effectivePeriod = effectivePeriod;
    }

    /** 
     * Get the 'Remarks' element value.
     * 
     * @return value
     */
    public Remarks getRemarks() {
        return remarks;
    }

    /** 
     * Set the 'Remarks' element value.
     * 
     * @param remarks
     */
    public void setRemarks(Remarks remarks) {
        this.remarks = remarks;
    }

    /** 
     * Get the 'ObjectKeyAttrGroup' attributeGroup value.
     * 
     * @return value
     */
    public ObjectKeyAttrGroup getObjectKeyAttrGroup() {
        return objectKeyAttrGroup;
    }

    /** 
     * Set the 'ObjectKeyAttrGroup' attributeGroup value.
     * 
     * @param objectKeyAttrGroup
     */
    public void setObjectKeyAttrGroup(ObjectKeyAttrGroup objectKeyAttrGroup) {
        this.objectKeyAttrGroup = objectKeyAttrGroup;
    }
    /** 
     * Rule Effective Period.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EffectivePeriod" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:choice>
     *       &lt;xs:element ref="ns:DatePeriod"/>
     *       &lt;xs:element ref="ns:DateTimePeriod"/>
     *       &lt;xs:element ref="ns:QuarterPeriod"/>
     *       &lt;xs:element ref="ns:DayPeriod"/>
     *       &lt;xs:element ref="ns:MonthPeriod"/>
     *       &lt;xs:element ref="ns:YearPeriod"/>
     *       &lt;xs:element ref="ns:YearMonthPeriod"/>
     *       &lt;xs:element ref="ns:TimePeriod"/>
     *     &lt;/xs:choice>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class EffectivePeriod implements Serializable
    {
        private int effectivePeriodSelect = -1;
        private static final int DATE_PERIOD_CHOICE = 0;
        private static final int DATE_TIME_PERIOD_CHOICE = 1;
        private static final int QUARTER_PERIOD_CHOICE = 2;
        private static final int DAY_PERIOD_CHOICE = 3;
        private static final int MONTH_PERIOD_CHOICE = 4;
        private static final int YEAR_PERIOD_CHOICE = 5;
        private static final int YEAR_MONTH_PERIOD_CHOICE = 6;
        private static final int TIME_PERIOD_CHOICE = 7;
        private DatePeriodRepType datePeriod;
        private DateTimePeriodRepType dateTimePeriod;
        private QuarterPeriodRepType quarterPeriod;
        private DayPeriodRepType dayPeriod;
        private MonthPeriodRepType monthPeriod;
        private YearPeriodRepType yearPeriod;
        private YearMonthPeriodRepType yearMonthPeriod;
        private TimePeriodRepType timePeriod;

        private void setEffectivePeriodSelect(int choice) {
            if (effectivePeriodSelect == -1) {
                effectivePeriodSelect = choice;
            } else if (effectivePeriodSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearEffectivePeriodSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearEffectivePeriodSelect() {
            effectivePeriodSelect = -1;
        }

        /** 
         * Check if DatePeriod is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifDatePeriod() {
            return effectivePeriodSelect == DATE_PERIOD_CHOICE;
        }

        /** 
         * Get the 'DatePeriod' element value.
         * 
         * @return value
         */
        public DatePeriodRepType getDatePeriod() {
            return datePeriod;
        }

        /** 
         * Set the 'DatePeriod' element value.
         * 
         * @param datePeriod
         */
        public void setDatePeriod(DatePeriodRepType datePeriod) {
            setEffectivePeriodSelect(DATE_PERIOD_CHOICE);
            this.datePeriod = datePeriod;
        }

        /** 
         * Check if DateTimePeriod is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifDateTimePeriod() {
            return effectivePeriodSelect == DATE_TIME_PERIOD_CHOICE;
        }

        /** 
         * Get the 'DateTimePeriod' element value.
         * 
         * @return value
         */
        public DateTimePeriodRepType getDateTimePeriod() {
            return dateTimePeriod;
        }

        /** 
         * Set the 'DateTimePeriod' element value.
         * 
         * @param dateTimePeriod
         */
        public void setDateTimePeriod(DateTimePeriodRepType dateTimePeriod) {
            setEffectivePeriodSelect(DATE_TIME_PERIOD_CHOICE);
            this.dateTimePeriod = dateTimePeriod;
        }

        /** 
         * Check if QuarterPeriod is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifQuarterPeriod() {
            return effectivePeriodSelect == QUARTER_PERIOD_CHOICE;
        }

        /** 
         * Get the 'QuarterPeriod' element value.
         * 
         * @return value
         */
        public QuarterPeriodRepType getQuarterPeriod() {
            return quarterPeriod;
        }

        /** 
         * Set the 'QuarterPeriod' element value.
         * 
         * @param quarterPeriod
         */
        public void setQuarterPeriod(QuarterPeriodRepType quarterPeriod) {
            setEffectivePeriodSelect(QUARTER_PERIOD_CHOICE);
            this.quarterPeriod = quarterPeriod;
        }

        /** 
         * Check if DayPeriod is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifDayPeriod() {
            return effectivePeriodSelect == DAY_PERIOD_CHOICE;
        }

        /** 
         * Get the 'DayPeriod' element value.
         * 
         * @return value
         */
        public DayPeriodRepType getDayPeriod() {
            return dayPeriod;
        }

        /** 
         * Set the 'DayPeriod' element value.
         * 
         * @param dayPeriod
         */
        public void setDayPeriod(DayPeriodRepType dayPeriod) {
            setEffectivePeriodSelect(DAY_PERIOD_CHOICE);
            this.dayPeriod = dayPeriod;
        }

        /** 
         * Check if MonthPeriod is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifMonthPeriod() {
            return effectivePeriodSelect == MONTH_PERIOD_CHOICE;
        }

        /** 
         * Get the 'MonthPeriod' element value.
         * 
         * @return value
         */
        public MonthPeriodRepType getMonthPeriod() {
            return monthPeriod;
        }

        /** 
         * Set the 'MonthPeriod' element value.
         * 
         * @param monthPeriod
         */
        public void setMonthPeriod(MonthPeriodRepType monthPeriod) {
            setEffectivePeriodSelect(MONTH_PERIOD_CHOICE);
            this.monthPeriod = monthPeriod;
        }

        /** 
         * Check if YearPeriod is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifYearPeriod() {
            return effectivePeriodSelect == YEAR_PERIOD_CHOICE;
        }

        /** 
         * Get the 'YearPeriod' element value.
         * 
         * @return value
         */
        public YearPeriodRepType getYearPeriod() {
            return yearPeriod;
        }

        /** 
         * Set the 'YearPeriod' element value.
         * 
         * @param yearPeriod
         */
        public void setYearPeriod(YearPeriodRepType yearPeriod) {
            setEffectivePeriodSelect(YEAR_PERIOD_CHOICE);
            this.yearPeriod = yearPeriod;
        }

        /** 
         * Check if YearMonthPeriod is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifYearMonthPeriod() {
            return effectivePeriodSelect == YEAR_MONTH_PERIOD_CHOICE;
        }

        /** 
         * Get the 'YearMonthPeriod' element value.
         * 
         * @return value
         */
        public YearMonthPeriodRepType getYearMonthPeriod() {
            return yearMonthPeriod;
        }

        /** 
         * Set the 'YearMonthPeriod' element value.
         * 
         * @param yearMonthPeriod
         */
        public void setYearMonthPeriod(YearMonthPeriodRepType yearMonthPeriod) {
            setEffectivePeriodSelect(YEAR_MONTH_PERIOD_CHOICE);
            this.yearMonthPeriod = yearMonthPeriod;
        }

        /** 
         * Check if TimePeriod is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifTimePeriod() {
            return effectivePeriodSelect == TIME_PERIOD_CHOICE;
        }

        /** 
         * Get the 'TimePeriod' element value.
         * 
         * @return value
         */
        public TimePeriodRepType getTimePeriod() {
            return timePeriod;
        }

        /** 
         * Set the 'TimePeriod' element value.
         * 
         * @param timePeriod
         */
        public void setTimePeriod(TimePeriodRepType timePeriod) {
            setEffectivePeriodSelect(TIME_PERIOD_CHOICE);
            this.timePeriod = timePeriod;
        }
    }
}
