
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Acceptable Price Variance Rule(s).

 Note: This is the acceptable amount and/or percentage of the total amount by which the Order item price can vary from the Offer price for Order creation to proceed, for example to cover minor currency exchange rate fluctuations for taxes quoted in a different currency. 
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceVarianceRules">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element type="ns:PriceVarianceRuleType" name="PriceVarianceRule" maxOccurs="unbounded"/>
 *     &lt;/xs:sequence>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class PriceVarianceRules implements Serializable
{
    private List<PriceVarianceRuleType> priceVarianceRuleList = new ArrayList<PriceVarianceRuleType>();

    /** 
     * Get the list of 'PriceVarianceRule' element items. Price Variance Rule detail.
     * 
     * @return list
     */
    public List<PriceVarianceRuleType> getPriceVarianceRuleList() {
        return priceVarianceRuleList;
    }

    /** 
     * Set the list of 'PriceVarianceRule' element items. Price Variance Rule detail.
     * 
     * @param list
     */
    public void setPriceVarianceRuleList(List<PriceVarianceRuleType> list) {
        priceVarianceRuleList = list;
    }
}
