
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * A PRICED FLIGHT Offer.

 Notes:
 1. A Priced Flight Offer may contain Branded Fare information. If it is a Branded Fare, Price Class-association will be specified.

 2. Additionally, Lead Pricing Calendar fares (prior to and/ or after the specified departure date) may be specified by passenger type.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PricedFlightOffer">
 *   &lt;xs:complexType>
 *     &lt;xs:complexContent>
 *       &lt;xs:extension base="ns:KeyWithMetaObjectBaseType">
 *         &lt;xs:sequence>
 *           &lt;xs:element name="Parameters" minOccurs="0">
 *             &lt;!-- Reference to inner class Parameters -->
 *           &lt;/xs:element>
 *           &lt;xs:element type="ns:ItemID_Type" name="OfferID"/>
 *           &lt;xs:element type="ns:OfferPriceLeadType" name="OfferPrice" maxOccurs="unbounded"/>
 *           &lt;xs:element type="ns:OfferTimeLimitSetType" name="TimeLimits"/>
 *           &lt;xs:element type="ns:PricedFlightOfferAssocType" name="Associations" maxOccurs="unbounded"/>
 *           &lt;xs:element ref="ns:DescriptionReferences" minOccurs="0"/>
 *           &lt;xs:element type="ns:DisclosureType" name="Disclosure" minOccurs="0"/>
 *           &lt;xs:element type="ns:PenaltyType" name="Penalty" minOccurs="0"/>
 *           &lt;xs:element ref="ns:FareDetail" minOccurs="0"/>
 *         &lt;/xs:sequence>
 *       &lt;/xs:extension>
 *     &lt;/xs:complexContent>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class PricedFlightOffer extends KeyWithMetaObjectBaseType implements
    Serializable
{
    private Parameters parameters;
    private ItemIDType offerID;
    private List<OfferPriceLeadType> offerPriceList = new ArrayList<OfferPriceLeadType>();
    private OfferTimeLimitSetType timeLimits;
    private List<PricedFlightOfferAssocType> associationList = new ArrayList<PricedFlightOfferAssocType>();
    private DescriptionReferences descriptionReferences;
    private DisclosureType disclosure;
    private PenaltyType penalty;
    private FareDetailType fareDetail;

    /** 
     * Get the 'Parameters' element value.
     * 
     * @return value
     */
    public Parameters getParameters() {
        return parameters;
    }

    /** 
     * Set the 'Parameters' element value.
     * 
     * @param parameters
     */
    public void setParameters(Parameters parameters) {
        this.parameters = parameters;
    }

    /** 
     * Get the 'OfferID' element value. Globally unique Offer instance ID. length should not be exceed 64 character and it is recommended to not use dash char in it.Example: QWASZXERDFCVTYGHBNUIJKNMF67D5F9GHR567SWER41SD458F9456FMDIRTN34DF
     * 
     * @return value
     */
    public ItemIDType getOfferID() {
        return offerID;
    }

    /** 
     * Set the 'OfferID' element value. Globally unique Offer instance ID. length should not be exceed 64 character and it is recommended to not use dash char in it.Example: QWASZXERDFCVTYGHBNUIJKNMF67D5F9GHR567SWER41SD458F9456FMDIRTN34DF
     * 
     * @param offerID
     */
    public void setOfferID(ItemIDType offerID) {
        this.offerID = offerID;
    }

    /** 
     * Get the list of 'OfferPrice' element items. Fare Offer and Lead Calendar Pricing information.
     * 
     * @return list
     */
    public List<OfferPriceLeadType> getOfferPriceList() {
        return offerPriceList;
    }

    /** 
     * Set the list of 'OfferPrice' element items. Fare Offer and Lead Calendar Pricing information.
     * 
     * @param list
     */
    public void setOfferPriceList(List<OfferPriceLeadType> list) {
        offerPriceList = list;
    }

    /** 
     * Get the 'TimeLimits' element value. Offer-Level Time Limits, including Offer Expiration, Payment and Bilateral Time Limits.

    Note: If specified, these time limits are at the OFFER-LEVEL and will apply by default to any relevant (child) Offer Items. These time limits may also be specified at a (child) OFFER ITEM-level where it will apply to that one instance of the Offer Item (and override the Offer-level time limit if one has been specified.)
     * 
     * @return value
     */
    public OfferTimeLimitSetType getTimeLimits() {
        return timeLimits;
    }

    /** 
     * Set the 'TimeLimits' element value. Offer-Level Time Limits, including Offer Expiration, Payment and Bilateral Time Limits.

    Note: If specified, these time limits are at the OFFER-LEVEL and will apply by default to any relevant (child) Offer Items. These time limits may also be specified at a (child) OFFER ITEM-level where it will apply to that one instance of the Offer Item (and override the Offer-level time limit if one has been specified.)
     * 
     * @param timeLimits
     */
    public void setTimeLimits(OfferTimeLimitSetType timeLimits) {
        this.timeLimits = timeLimits;
    }

    /** 
     * Get the list of 'Associations' element items. Priced Flight Offer Association(s), including Traveler, Flight, Baggage, Included Optional Services, Associated Optional Services, Price Class and other miscellaneous association.
     * 
     * @return list
     */
    public List<PricedFlightOfferAssocType> getAssociationList() {
        return associationList;
    }

    /** 
     * Set the list of 'Associations' element items. Priced Flight Offer Association(s), including Traveler, Flight, Baggage, Included Optional Services, Associated Optional Services, Price Class and other miscellaneous association.
     * 
     * @param list
     */
    public void setAssociationList(List<PricedFlightOfferAssocType> list) {
        associationList = list;
    }

    /** 
     * Get the 'DescriptionReferences' element value.
     * 
     * @return value
     */
    public DescriptionReferences getDescriptionReferences() {
        return descriptionReferences;
    }

    /** 
     * Set the 'DescriptionReferences' element value.
     * 
     * @param descriptionReferences
     */
    public void setDescriptionReferences(
            DescriptionReferences descriptionReferences) {
        this.descriptionReferences = descriptionReferences;
    }

    /** 
     * Get the 'Disclosure' element value. Disclosure information.
     * 
     * @return value
     */
    public DisclosureType getDisclosure() {
        return disclosure;
    }

    /** 
     * Set the 'Disclosure' element value. Disclosure information.
     * 
     * @param disclosure
     */
    public void setDisclosure(DisclosureType disclosure) {
        this.disclosure = disclosure;
    }

    /** 
     * Get the 'Penalty' element value. Penalty information.
     * 
     * @return value
     */
    public PenaltyType getPenalty() {
        return penalty;
    }

    /** 
     * Set the 'Penalty' element value. Penalty information.
     * 
     * @param penalty
     */
    public void setPenalty(PenaltyType penalty) {
        this.penalty = penalty;
    }

    /** 
     * Get the 'FareDetail' element value.
     * 
     * @return value
     */
    public FareDetailType getFareDetail() {
        return fareDetail;
    }

    /** 
     * Set the 'FareDetail' element value.
     * 
     * @param fareDetail
     */
    public void setFareDetail(FareDetailType fareDetail) {
        this.fareDetail = fareDetail;
    }
    /** 
     * Offer-wide parameters, including Traveler Applicability; Total Offer Quantity; Passenger Pricing Method; Inventory Guarantee.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Parameters" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="TotalItemQuantity" minOccurs="0"/>
     *       &lt;xs:element ref="ns:PTC_Priced" minOccurs="0" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:boolean" use="optional" name="ApplyToAllInd"/>
     *     &lt;xs:attribute type="xs:boolean" use="optional" name="RedemptionOnlyInd"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Parameters implements Serializable
    {
        private String totalItemQuantity;
        private List<PTCQuantityPricedType> PTCPricedList = new ArrayList<PTCQuantityPricedType>();
        private Boolean applyToAllInd;
        private Boolean redemptionOnlyInd;

        /** 
         * Get the 'TotalItemQuantity' element value. Total Offer Items in this Offer. Example: 3
         * 
         * @return value
         */
        public String getTotalItemQuantity() {
            return totalItemQuantity;
        }

        /** 
         * Set the 'TotalItemQuantity' element value. Total Offer Items in this Offer. Example: 3
         * 
         * @param totalItemQuantity
         */
        public void setTotalItemQuantity(String totalItemQuantity) {
            this.totalItemQuantity = totalItemQuantity;
        }

        /** 
         * Get the list of 'PTC_Priced' element items. Requested and Priced PTC (passenger type code) and associated Traveler quantity.
         * 
         * @return list
         */
        public List<PTCQuantityPricedType> getPTCPricedList() {
            return PTCPricedList;
        }

        /** 
         * Set the list of 'PTC_Priced' element items. Requested and Priced PTC (passenger type code) and associated Traveler quantity.
         * 
         * @param list
         */
        public void setPTCPricedList(List<PTCQuantityPricedType> list) {
            PTCPricedList = list;
        }

        /** 
         * Get the 'ApplyToAllInd' attribute value. When TRUE, this Offer applies to all Travelers.
         * 
         * @return value
         */
        public Boolean getApplyToAllInd() {
            return applyToAllInd;
        }

        /** 
         * Set the 'ApplyToAllInd' attribute value. When TRUE, this Offer applies to all Travelers.
         * 
         * @param applyToAllInd
         */
        public void setApplyToAllInd(Boolean applyToAllInd) {
            this.applyToAllInd = applyToAllInd;
        }

        /** 
         * Get the 'RedemptionOnlyInd' attribute value. When TRUE, this Offer must be redeemed, e.g. it cannot be purchased.

        Note: Taxes may still apply.
         * 
         * @return value
         */
        public Boolean getRedemptionOnlyInd() {
            return redemptionOnlyInd;
        }

        /** 
         * Set the 'RedemptionOnlyInd' attribute value. When TRUE, this Offer must be redeemed, e.g. it cannot be purchased.

        Note: Taxes may still apply.
         * 
         * @param redemptionOnlyInd
         */
        public void setRedemptionOnlyInd(Boolean redemptionOnlyInd) {
            this.redemptionOnlyInd = redemptionOnlyInd;
        }
    }
}
