
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Priced Flight Offer with Association definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PricedFlightOfferType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:KeyWithMetaOfferBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="ns:OfferPriceLeadType" name="OfferPrice" maxOccurs="unbounded"/>
 *         &lt;xs:element type="ns:PricedFlightOfferAssocType" name="Associations" minOccurs="0" maxOccurs="unbounded"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PricedFlightOfferType extends KeyWithMetaOfferBaseType implements
    Serializable
{
    private List<OfferPriceLeadType> offerPriceList = new ArrayList<OfferPriceLeadType>();
    private List<PricedFlightOfferAssocType> associationList = new ArrayList<PricedFlightOfferAssocType>();

    /** 
     * Get the list of 'OfferPrice' element items. Fare Offer and Lead Calendar Pricing information.
     * 
     * @return list
     */
    public List<OfferPriceLeadType> getOfferPriceList() {
        return offerPriceList;
    }

    /** 
     * Set the list of 'OfferPrice' element items. Fare Offer and Lead Calendar Pricing information.
     * 
     * @param list
     */
    public void setOfferPriceList(List<OfferPriceLeadType> list) {
        offerPriceList = list;
    }

    /** 
     * Get the list of 'Associations' element items. Priced Flight Offer Association(s), including Traveler, Flight, Baggage, Included Optional Services, Associated Optional Services, Price Class and other miscellaneous association.
     * 
     * @return list
     */
    public List<PricedFlightOfferAssocType> getAssociationList() {
        return associationList;
    }

    /** 
     * Set the list of 'Associations' element items. Priced Flight Offer Association(s), including Traveler, Flight, Baggage, Included Optional Services, Associated Optional Services, Price Class and other miscellaneous association.
     * 
     * @param list
     */
    public void setAssociationList(List<PricedFlightOfferAssocType> list) {
        associationList = list;
    }
}
