
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * Pricing Parameters Notice definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PricingParametersNoticeType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:TrxProcessObjectBaseType">
 *       &lt;xs:choice>
 *         &lt;xs:element name="Query">
 *           &lt;!-- Reference to inner class Query -->
 *         &lt;/xs:element>
 *         &lt;xs:element name="Results">
 *           &lt;!-- Reference to inner class Results -->
 *         &lt;/xs:element>
 *       &lt;/xs:choice>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PricingParametersNoticeType extends TrxProcessObjectBaseType
    implements Serializable
{
    private int choiceSelect = -1;
    private static final int QUERY_CHOICE = 0;
    private static final int RESULTS_CHOICE = 1;
    private Query query;
    private Results results;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if Query is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifQuery() {
        return choiceSelect == QUERY_CHOICE;
    }

    /** 
     * Get the 'Query' element value.
     * 
     * @return value
     */
    public Query getQuery() {
        return query;
    }

    /** 
     * Set the 'Query' element value.
     * 
     * @param query
     */
    public void setQuery(Query query) {
        setChoiceSelect(QUERY_CHOICE);
        this.query = query;
    }

    /** 
     * Check if Results is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifResults() {
        return choiceSelect == RESULTS_CHOICE;
    }

    /** 
     * Get the 'Results' element value.
     * 
     * @return value
     */
    public Results getResults() {
        return results;
    }

    /** 
     * Set the 'Results' element value.
     * 
     * @param results
     */
    public void setResults(Results results) {
        setChoiceSelect(RESULTS_CHOICE);
        this.results = results;
    }
    /** 
     * Requested Pricing Parameter(s).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Query">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:boolean" use="optional" name="AutoExchangeReqInd"/>
     *     &lt;xs:attribute type="xs:boolean" use="optional" name="IncludeAwardReqInd"/>
     *     &lt;xs:attribute type="xs:boolean" use="optional" name="AwardOnlyReqInd"/>
     *     &lt;xs:attribute type="xs:boolean" use="optional" name="SimpleReqInd"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Query implements Serializable
    {
        private Boolean autoExchangeReqInd;
        private Boolean includeAwardReqInd;
        private Boolean awardOnlyReqInd;
        private Boolean simpleReqInd;

        /** 
         * Get the 'AutoExchangeReqInd' attribute value. When TRUE, this request is to be handled by an auto-exchange process.
                      
         * 
         * @return value
         */
        public Boolean getAutoExchangeReqInd() {
            return autoExchangeReqInd;
        }

        /** 
         * Set the 'AutoExchangeReqInd' attribute value. When TRUE, this request is to be handled by an auto-exchange process.
                      
         * 
         * @param autoExchangeReqInd
         */
        public void setAutoExchangeReqInd(Boolean autoExchangeReqInd) {
            this.autoExchangeReqInd = autoExchangeReqInd;
        }

        /** 
         * Get the 'IncludeAwardReqInd' attribute value. When TRUE, award eligible in addition to priced offers and fares is requested.
                      
         * 
         * @return value
         */
        public Boolean getIncludeAwardReqInd() {
            return includeAwardReqInd;
        }

        /** 
         * Set the 'IncludeAwardReqInd' attribute value. When TRUE, award eligible in addition to priced offers and fares is requested.
                      
         * 
         * @param includeAwardReqInd
         */
        public void setIncludeAwardReqInd(Boolean includeAwardReqInd) {
            this.includeAwardReqInd = includeAwardReqInd;
        }

        /** 
         * Get the 'AwardOnlyReqInd' attribute value. When TRUE, only award eligible offers/ fares are requested.
                      
         * 
         * @return value
         */
        public Boolean getAwardOnlyReqInd() {
            return awardOnlyReqInd;
        }

        /** 
         * Set the 'AwardOnlyReqInd' attribute value. When TRUE, only award eligible offers/ fares are requested.
                      
         * 
         * @param awardOnlyReqInd
         */
        public void setAwardOnlyReqInd(Boolean awardOnlyReqInd) {
            this.awardOnlyReqInd = awardOnlyReqInd;
        }

        /** 
         * Get the 'SimpleReqInd' attribute value. When TRUE, Simple Pricing for flight offers is requested.
                      
         * 
         * @return value
         */
        public Boolean getSimpleReqInd() {
            return simpleReqInd;
        }

        /** 
         * Set the 'SimpleReqInd' attribute value. When TRUE, Simple Pricing for flight offers is requested.
                      
         * 
         * @param simpleReqInd
         */
        public void setSimpleReqInd(Boolean simpleReqInd) {
            this.simpleReqInd = simpleReqInd;
        }
    }
    /** 
     * 
                  Pricing Parameter application in transaction processing.
                
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Results">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:boolean" use="optional" name="AutoExchangeInd"/>
     *     &lt;xs:attribute type="xs:boolean" use="optional" name="AwardIncludedInd"/>
     *     &lt;xs:attribute type="xs:boolean" use="optional" name="AwardOnlyInd"/>
     *     &lt;xs:attribute type="xs:boolean" use="optional" name="SimpleInd"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Results implements Serializable
    {
        private Boolean autoExchangeInd;
        private Boolean awardIncludedInd;
        private Boolean awardOnlyInd;
        private Boolean simpleInd;

        /** 
         * Get the 'AutoExchangeInd' attribute value. When TRUE, this request was handled by an auto-exchange process.
                      
         * 
         * @return value
         */
        public Boolean getAutoExchangeInd() {
            return autoExchangeInd;
        }

        /** 
         * Set the 'AutoExchangeInd' attribute value. When TRUE, this request was handled by an auto-exchange process.
                      
         * 
         * @param autoExchangeInd
         */
        public void setAutoExchangeInd(Boolean autoExchangeInd) {
            this.autoExchangeInd = autoExchangeInd;
        }

        /** 
         * Get the 'AwardIncludedInd' attribute value. When TRUE, award eligible in addition to priced offers and fares are included in the results.
                      
         * 
         * @return value
         */
        public Boolean getAwardIncludedInd() {
            return awardIncludedInd;
        }

        /** 
         * Set the 'AwardIncludedInd' attribute value. When TRUE, award eligible in addition to priced offers and fares are included in the results.
                      
         * 
         * @param awardIncludedInd
         */
        public void setAwardIncludedInd(Boolean awardIncludedInd) {
            this.awardIncludedInd = awardIncludedInd;
        }

        /** 
         * Get the 'AwardOnlyInd' attribute value. When TRUE, only award eligible offers/ fares have been returned.
                      
         * 
         * @return value
         */
        public Boolean getAwardOnlyInd() {
            return awardOnlyInd;
        }

        /** 
         * Set the 'AwardOnlyInd' attribute value. When TRUE, only award eligible offers/ fares have been returned.
                      
         * 
         * @param awardOnlyInd
         */
        public void setAwardOnlyInd(Boolean awardOnlyInd) {
            this.awardOnlyInd = awardOnlyInd;
        }

        /** 
         * Get the 'SimpleInd' attribute value. When TRUE, Simple Pricing for flight offers was applied.
                      
         * 
         * @return value
         */
        public Boolean getSimpleInd() {
            return simpleInd;
        }

        /** 
         * Set the 'SimpleInd' attribute value. When TRUE, Simple Pricing for flight offers was applied.
                      
         * 
         * @param simpleInd
         */
        public void setSimpleInd(Boolean simpleInd) {
            this.simpleInd = simpleInd;
        }
    }
}
