
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Primary Contact Information.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PrimaryContact">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element name="Name">
 *         &lt;xs:complexType>
 *           &lt;xs:sequence>
 *             &lt;xs:element name="Surname">
 *               &lt;xs:complexType>
 *                 &lt;xs:simpleContent>
 *                   &lt;xs:extension base="xs:string">
 *                     &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
 *                   &lt;/xs:extension>
 *                 &lt;/xs:simpleContent>
 *               &lt;/xs:complexType>
 *             &lt;/xs:element>
 *             &lt;xs:element name="Given" minOccurs="0" maxOccurs="5">
 *               &lt;!-- Reference to inner class Given -->
 *             &lt;/xs:element>
 *             &lt;xs:element name="Middle" minOccurs="0" maxOccurs="3">
 *               &lt;!-- Reference to inner class Middle -->
 *             &lt;/xs:element>
 *           &lt;/xs:sequence>
 *           &lt;xs:attributeGroup ref="ns:ObjectPolicyMetaAttrGroup"/>
 *         &lt;/xs:complexType>
 *       &lt;/xs:element>
 *       &lt;xs:element name="Contact" maxOccurs="unbounded">
 *         &lt;!-- Reference to inner class Contact -->
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class PrimaryContact implements Serializable
{
    private String nameSurnameString;
    private String nameSurnameRefs;
    private List<Given> givenList = new ArrayList<Given>();
    private List<Middle> middleList = new ArrayList<Middle>();
    private ObjectPolicyMetaAttrGroup nameObjectPolicyMetaAttrGroup;
    private List<Contact> contactList = new ArrayList<Contact>();

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getNameSurnameString() {
        return nameSurnameString;
    }

    /** 
     * Set the extension value.
     * 
     * @param nameSurnameString
     */
    public void setNameSurnameString(String nameSurnameString) {
        this.nameSurnameString = nameSurnameString;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getNameSurnameRefs() {
        return nameSurnameRefs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param nameSurnameRefs
     */
    public void setNameSurnameRefs(String nameSurnameRefs) {
        this.nameSurnameRefs = nameSurnameRefs;
    }

    /** 
     * Get the list of 'Given' element items. Passenger Name information.

    Note: Detailed Name information, such as prefix, title and suffix, are specified in PassengerMetadata.
     * 
     * @return list
     */
    public List<Given> getGivenList() {
        return givenList;
    }

    /** 
     * Set the list of 'Given' element items. Passenger Name information.

    Note: Detailed Name information, such as prefix, title and suffix, are specified in PassengerMetadata.
     * 
     * @param list
     */
    public void setGivenList(List<Given> list) {
        givenList = list;
    }

    /** 
     * Get the list of 'Middle' element items. Passenger Name information.

    Note: Detailed Name information, such as prefix, title and suffix, are specified in PassengerMetadata.
     * 
     * @return list
     */
    public List<Middle> getMiddleList() {
        return middleList;
    }

    /** 
     * Set the list of 'Middle' element items. Passenger Name information.

    Note: Detailed Name information, such as prefix, title and suffix, are specified in PassengerMetadata.
     * 
     * @param list
     */
    public void setMiddleList(List<Middle> list) {
        middleList = list;
    }

    /** 
     * Get the 'ObjectPolicyMetaAttrGroup' attributeGroup value.
     * 
     * @return value
     */
    public ObjectPolicyMetaAttrGroup getNameObjectPolicyMetaAttrGroup() {
        return nameObjectPolicyMetaAttrGroup;
    }

    /** 
     * Set the 'ObjectPolicyMetaAttrGroup' attributeGroup value.
     * 
     * @param nameObjectPolicyMetaAttrGroup
     */
    public void setNameObjectPolicyMetaAttrGroup(
            ObjectPolicyMetaAttrGroup nameObjectPolicyMetaAttrGroup) {
        this.nameObjectPolicyMetaAttrGroup = nameObjectPolicyMetaAttrGroup;
    }

    /** 
     * Get the list of 'Contact' element items.
     * 
     * @return list
     */
    public List<Contact> getContactList() {
        return contactList;
    }

    /** 
     * Set the list of 'Contact' element items.
     * 
     * @param list
     */
    public void setContactList(List<Contact> list) {
        contactList = list;
    }
    /** 
     * Given name, first name or names
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Given" minOccurs="0" maxOccurs="5">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:string">
     *         &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * 
     * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
     *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
     * &lt;/xs:attributeGroup>
     * </pre>
     */
    public static class Given implements Serializable
    {
        private String string;
        private String refs;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getString() {
            return string;
        }

        /** 
         * Set the extension value.
         * 
         * @param string
         */
        public void setString(String string) {
            this.string = string;
        }

        /** 
         * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @return value
         */
        public String getRefs() {
            return refs;
        }

        /** 
         * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @param refs
         */
        public void setRefs(String refs) {
            this.refs = refs;
        }
    }
    /** 
     * Middle name or initial.  Examples: G, GEORGE
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Middle" minOccurs="0" maxOccurs="3">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:string">
     *         &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * 
     * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
     *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
     * &lt;/xs:attributeGroup>
     * </pre>
     */
    public static class Middle implements Serializable
    {
        private String string;
        private String refs;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getString() {
            return string;
        }

        /** 
         * Set the extension value.
         * 
         * @param string
         */
        public void setString(String string) {
            this.string = string;
        }

        /** 
         * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @return value
         */
        public String getRefs() {
            return refs;
        }

        /** 
         * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @param refs
         */
        public void setRefs(String refs) {
            this.refs = refs;
        }
    }
    /** 
     * Contact(s).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Contact" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="ns:KeyObjectBaseType">
     *         &lt;xs:choice>
     *           &lt;xs:element ref="ns:PhoneContact"/>
     *           &lt;xs:element ref="ns:OtherContactMethod"/>
     *           &lt;xs:element ref="ns:EmailContact"/>
     *           &lt;xs:element ref="ns:AddressContact"/>
     *         &lt;/xs:choice>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Contact extends KeyObjectBaseType implements
        Serializable
    {
        private int choiceSelect = -1;
        private static final int PHONE_CONTACT_CHOICE = 0;
        private static final int OTHER_CONTACT_METHOD_CHOICE = 1;
        private static final int EMAIL_CONTACT_CHOICE = 2;
        private static final int ADDRESS_CONTACT_CHOICE = 3;
        private PhoneContact phoneContact;
        private OtherContactMethodType otherContactMethod;
        private EmailContact emailContact;
        private AddressContact addressContact;

        private void setChoiceSelect(int choice) {
            if (choiceSelect == -1) {
                choiceSelect = choice;
            } else if (choiceSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearChoiceSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearChoiceSelect() {
            choiceSelect = -1;
        }

        /** 
         * Check if PhoneContact is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifPhoneContact() {
            return choiceSelect == PHONE_CONTACT_CHOICE;
        }

        /** 
         * Get the 'PhoneContact' element value.
         * 
         * @return value
         */
        public PhoneContact getPhoneContact() {
            return phoneContact;
        }

        /** 
         * Set the 'PhoneContact' element value.
         * 
         * @param phoneContact
         */
        public void setPhoneContact(PhoneContact phoneContact) {
            setChoiceSelect(PHONE_CONTACT_CHOICE);
            this.phoneContact = phoneContact;
        }

        /** 
         * Check if OtherContactMethod is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifOtherContactMethod() {
            return choiceSelect == OTHER_CONTACT_METHOD_CHOICE;
        }

        /** 
         * Get the 'OtherContactMethod' element value.
         * 
         * @return value
         */
        public OtherContactMethodType getOtherContactMethod() {
            return otherContactMethod;
        }

        /** 
         * Set the 'OtherContactMethod' element value.
         * 
         * @param otherContactMethod
         */
        public void setOtherContactMethod(
                OtherContactMethodType otherContactMethod) {
            setChoiceSelect(OTHER_CONTACT_METHOD_CHOICE);
            this.otherContactMethod = otherContactMethod;
        }

        /** 
         * Check if EmailContact is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifEmailContact() {
            return choiceSelect == EMAIL_CONTACT_CHOICE;
        }

        /** 
         * Get the 'EmailContact' element value.
         * 
         * @return value
         */
        public EmailContact getEmailContact() {
            return emailContact;
        }

        /** 
         * Set the 'EmailContact' element value.
         * 
         * @param emailContact
         */
        public void setEmailContact(EmailContact emailContact) {
            setChoiceSelect(EMAIL_CONTACT_CHOICE);
            this.emailContact = emailContact;
        }

        /** 
         * Check if AddressContact is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifAddressContact() {
            return choiceSelect == ADDRESS_CONTACT_CHOICE;
        }

        /** 
         * Get the 'AddressContact' element value.
         * 
         * @return value
         */
        public AddressContact getAddressContact() {
            return addressContact;
        }

        /** 
         * Set the 'AddressContact' element value.
         * 
         * @param addressContact
         */
        public void setAddressContact(AddressContact addressContact) {
            setChoiceSelect(ADDRESS_CONTACT_CHOICE);
            this.addressContact = addressContact;
        }
    }
}
