
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * A data type for a Fatal Processing Error.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ProcessingErrorType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Error" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class _Error -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="RetryInd"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ProcessingErrorType implements Serializable
{
    private List<_Error> errorList = new ArrayList<_Error>();
    private Boolean retryInd;

    /** 
     * Get the list of 'Error' element items.
     * 
     * @return list
     */
    public List<_Error> getErrorList() {
        return errorList;
    }

    /** 
     * Set the list of 'Error' element items.
     * 
     * @param list
     */
    public void setErrorList(List<_Error> list) {
        errorList = list;
    }

    /** 
     * Get the 'RetryInd' attribute value. When TRUE, the request message may be resent.

    Note: This is typically used for a processing timeout condition.
     * 
     * @return value
     */
    public Boolean getRetryInd() {
        return retryInd;
    }

    /** 
     * Set the 'RetryInd' attribute value. When TRUE, the request message may be resent.

    Note: This is typically used for a processing timeout condition.
     * 
     * @param retryInd
     */
    public void setRetryInd(Boolean retryInd) {
        this.retryInd = retryInd;
    }
    /** 
     * Error detail.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Error" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="ns:KeyWithMetaObjectBaseType">
     *         &lt;xs:sequence>
     *           &lt;xs:element type="xs:string" name="Type"/>
     *           &lt;xs:element type="xs:string" name="Code"/>
     *           &lt;xs:element type="xs:string" name="Description" minOccurs="0"/>
     *           &lt;xs:element type="xs:string" name="InfoURL" minOccurs="0"/>
     *           &lt;xs:element ref="ns:NodePath" minOccurs="0"/>
     *         &lt;/xs:sequence>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class _Error extends KeyWithMetaObjectBaseType implements
        Serializable
    {
        private String type;
        private String code;
        private String description;
        private String infoURL;
        private NodePathType nodePath;

        /** 
         * Get the 'Type' element value. Error type.
        Example: Authentication, ExpiredCredential, FieldValidation, Unknown
         * 
         * @return value
         */
        public String getType() {
            return type;
        }

        /** 
         * Set the 'Type' element value. Error type.
        Example: Authentication, ExpiredCredential, FieldValidation, Unknown
         * 
         * @param type
         */
        public void setType(String type) {
            this.type = type;
        }

        /** 
         * Get the 'Code' element value. Error code. Example: NOAUTH
         * 
         * @return value
         */
        public String getCode() {
            return code;
        }

        /** 
         * Set the 'Code' element value. Error code. Example: NOAUTH
         * 
         * @param code
         */
        public void setCode(String code) {
            this.code = code;
        }

        /** 
         * Get the 'Description' element value. Error Code Definition.  Example: Invalid Point of Sale Credentials
         * 
         * @return value
         */
        public String getDescription() {
            return description;
        }

        /** 
         * Set the 'Description' element value. Error Code Definition.  Example: Invalid Point of Sale Credentials
         * 
         * @param description
         */
        public void setDescription(String description) {
            this.description = description;
        }

        /** 
         * Get the 'InfoURL' element value. URL to an online description of the error.
        Example: http://www.airline.com/ErrorCodes
         * 
         * @return value
         */
        public String getInfoURL() {
            return infoURL;
        }

        /** 
         * Set the 'InfoURL' element value. URL to an online description of the error.
        Example: http://www.airline.com/ErrorCodes
         * 
         * @param infoURL
         */
        public void setInfoURL(String infoURL) {
            this.infoURL = infoURL;
        }

        /** 
         * Get the 'NodePath' element value.
         * 
         * @return value
         */
        public NodePathType getNodePath() {
            return nodePath;
        }

        /** 
         * Set the 'NodePath' element value.
         * 
         * @param nodePath
         */
        public void setNodePath(NodePathType nodePath) {
            this.nodePath = nodePath;
        }
    }
}
