
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * A data type for Message Processing Results.

 May include errors, business warnings, alternate offers indicator, supplemental marketing messages and/ or additional information required to complete a transaction.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ProcessingResultType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:KeyWithMetaObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="ns:MarketingInfoType" name="Marketing" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ProcessingResultType extends KeyWithMetaObjectBaseType implements
    Serializable
{
    private MarketingInfoType marketing;

    /** 
     * Get the 'Marketing' element value. Marketing Messages and Information.

    Notes: Marketing messages specified here apply to all message results, e.g. they are at a message-wide level.
     * 
     * @return value
     */
    public MarketingInfoType getMarketing() {
        return marketing;
    }

    /** 
     * Set the 'Marketing' element value. Marketing Messages and Information.

    Notes: Marketing messages specified here apply to all message results, e.g. they are at a message-wide level.
     * 
     * @param marketing
     */
    public void setMarketing(MarketingInfoType marketing) {
        this.marketing = marketing;
    }
}
