
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Shopping Qualifier-related Metadata, including Air Pass, Shopping Qualifier.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Qualifiers">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element name="Qualifier" maxOccurs="unbounded">
 *         &lt;!-- Reference to inner class Qualifier -->
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class Qualifiers implements Serializable
{
    private List<Qualifier> qualifierList = new ArrayList<Qualifier>();

    /** 
     * Get the list of 'Qualifier' element items.
     * 
     * @return list
     */
    public List<Qualifier> getQualifierList() {
        return qualifierList;
    }

    /** 
     * Set the list of 'Qualifier' element items.
     * 
     * @param list
     */
    public void setQualifierList(List<Qualifier> list) {
        qualifierList = list;
    }
    /** 
     * Qualifier choices.

    These capabilities may not be supported by all NDC-enabled systems or may be supported by bilateral agreement only. If supported, the technical implementation of the capability is not dictated by this specification. 
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Qualifier" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:choice>
     *       &lt;xs:element ref="ns:BaggagePricingQualifier"/>
     *       &lt;xs:element ref="ns:ExistingOrderQualifier"/>
     *       &lt;xs:element ref="ns:PaymentCardQualifiers"/>
     *       &lt;xs:element ref="ns:ProgramQualifiers"/>
     *       &lt;xs:element ref="ns:PromotionQualifiers"/>
     *       &lt;xs:element ref="ns:SeatQualifier"/>
     *       &lt;xs:element ref="ns:ServiceQualifier"/>
     *       &lt;xs:element ref="ns:SocialMediaQualifiers"/>
     *       &lt;xs:element ref="ns:SpecialFareQualifiers"/>
     *       &lt;xs:element ref="ns:SpecialNeedQualifiers"/>
     *       &lt;xs:element ref="ns:TripPurposeQualifier"/>
     *     &lt;/xs:choice>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Qualifier implements Serializable
    {
        private int qualifierListSelect = -1;
        private static final int BAGGAGE_PRICING_QUALIFIER_CHOICE = 0;
        private static final int EXISTING_ORDER_QUALIFIER_CHOICE = 1;
        private static final int PAYMENT_CARD_QUALIFIERS_CHOICE = 2;
        private static final int PROGRAM_QUALIFIERS_CHOICE = 3;
        private static final int PROMOTION_QUALIFIERS_CHOICE = 4;
        private static final int SEAT_QUALIFIER_CHOICE = 5;
        private static final int SERVICE_QUALIFIER_CHOICE = 6;
        private static final int SOCIAL_MEDIA_QUALIFIERS_CHOICE = 7;
        private static final int SPECIAL_FARE_QUALIFIERS_CHOICE = 8;
        private static final int SPECIAL_NEED_QUALIFIERS_CHOICE = 9;
        private static final int TRIP_PURPOSE_QUALIFIER_CHOICE = 10;
        private BaggagePricingQualifierType baggagePricingQualifier;
        private ExistingOrderQualifier existingOrderQualifier;
        private CardQualifierType paymentCardQualifiers;
        private ProgramQualifiers programQualifiers;
        private PromotionQualifiers promotionQualifiers;
        private SeatQualifier seatQualifier;
        private ServiceQualifierPriceType serviceQualifier;
        private SocialMediaQualifierType socialMediaQualifiers;
        private FareQualifierType specialFareQualifiers;
        private SpecialType specialNeedQualifiers;
        private TripPurposeQualifier tripPurposeQualifier;

        private void setQualifierListSelect(int choice) {
            if (qualifierListSelect == -1) {
                qualifierListSelect = choice;
            } else if (qualifierListSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearQualifierListSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearQualifierListSelect() {
            qualifierListSelect = -1;
        }

        /** 
         * Check if BaggagePricingQualifier is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifBaggagePricingQualifier() {
            return qualifierListSelect == BAGGAGE_PRICING_QUALIFIER_CHOICE;
        }

        /** 
         * Get the 'BaggagePricingQualifier' element value.
         * 
         * @return value
         */
        public BaggagePricingQualifierType getBaggagePricingQualifier() {
            return baggagePricingQualifier;
        }

        /** 
         * Set the 'BaggagePricingQualifier' element value.
         * 
         * @param baggagePricingQualifier
         */
        public void setBaggagePricingQualifier(
                BaggagePricingQualifierType baggagePricingQualifier) {
            setQualifierListSelect(BAGGAGE_PRICING_QUALIFIER_CHOICE);
            this.baggagePricingQualifier = baggagePricingQualifier;
        }

        /** 
         * Check if ExistingOrderQualifier is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifExistingOrderQualifier() {
            return qualifierListSelect == EXISTING_ORDER_QUALIFIER_CHOICE;
        }

        /** 
         * Get the 'ExistingOrderQualifier' element value.
         * 
         * @return value
         */
        public ExistingOrderQualifier getExistingOrderQualifier() {
            return existingOrderQualifier;
        }

        /** 
         * Set the 'ExistingOrderQualifier' element value.
         * 
         * @param existingOrderQualifier
         */
        public void setExistingOrderQualifier(
                ExistingOrderQualifier existingOrderQualifier) {
            setQualifierListSelect(EXISTING_ORDER_QUALIFIER_CHOICE);
            this.existingOrderQualifier = existingOrderQualifier;
        }

        /** 
         * Check if PaymentCardQualifiers is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifPaymentCardQualifiers() {
            return qualifierListSelect == PAYMENT_CARD_QUALIFIERS_CHOICE;
        }

        /** 
         * Get the 'PaymentCardQualifiers' element value. Contains card type, and Issuer Identification Number. 
         * 
         * @return value
         */
        public CardQualifierType getPaymentCardQualifiers() {
            return paymentCardQualifiers;
        }

        /** 
         * Set the 'PaymentCardQualifiers' element value. Contains card type, and Issuer Identification Number. 
         * 
         * @param paymentCardQualifiers
         */
        public void setPaymentCardQualifiers(
                CardQualifierType paymentCardQualifiers) {
            setQualifierListSelect(PAYMENT_CARD_QUALIFIERS_CHOICE);
            this.paymentCardQualifiers = paymentCardQualifiers;
        }

        /** 
         * Check if ProgramQualifiers is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifProgramQualifiers() {
            return qualifierListSelect == PROGRAM_QUALIFIERS_CHOICE;
        }

        /** 
         * Get the 'ProgramQualifiers' element value.
         * 
         * @return value
         */
        public ProgramQualifiers getProgramQualifiers() {
            return programQualifiers;
        }

        /** 
         * Set the 'ProgramQualifiers' element value.
         * 
         * @param programQualifiers
         */
        public void setProgramQualifiers(ProgramQualifiers programQualifiers) {
            setQualifierListSelect(PROGRAM_QUALIFIERS_CHOICE);
            this.programQualifiers = programQualifiers;
        }

        /** 
         * Check if PromotionQualifiers is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifPromotionQualifiers() {
            return qualifierListSelect == PROMOTION_QUALIFIERS_CHOICE;
        }

        /** 
         * Get the 'PromotionQualifiers' element value.
         * 
         * @return value
         */
        public PromotionQualifiers getPromotionQualifiers() {
            return promotionQualifiers;
        }

        /** 
         * Set the 'PromotionQualifiers' element value.
         * 
         * @param promotionQualifiers
         */
        public void setPromotionQualifiers(
                PromotionQualifiers promotionQualifiers) {
            setQualifierListSelect(PROMOTION_QUALIFIERS_CHOICE);
            this.promotionQualifiers = promotionQualifiers;
        }

        /** 
         * Check if SeatQualifier is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifSeatQualifier() {
            return qualifierListSelect == SEAT_QUALIFIER_CHOICE;
        }

        /** 
         * Get the 'SeatQualifier' element value.
         * 
         * @return value
         */
        public SeatQualifier getSeatQualifier() {
            return seatQualifier;
        }

        /** 
         * Set the 'SeatQualifier' element value.
         * 
         * @param seatQualifier
         */
        public void setSeatQualifier(SeatQualifier seatQualifier) {
            setQualifierListSelect(SEAT_QUALIFIER_CHOICE);
            this.seatQualifier = seatQualifier;
        }

        /** 
         * Check if ServiceQualifier is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifServiceQualifier() {
            return qualifierListSelect == SERVICE_QUALIFIER_CHOICE;
        }

        /** 
         * Get the 'ServiceQualifier' element value.
         * 
         * @return value
         */
        public ServiceQualifierPriceType getServiceQualifier() {
            return serviceQualifier;
        }

        /** 
         * Set the 'ServiceQualifier' element value.
         * 
         * @param serviceQualifier
         */
        public void setServiceQualifier(
                ServiceQualifierPriceType serviceQualifier) {
            setQualifierListSelect(SERVICE_QUALIFIER_CHOICE);
            this.serviceQualifier = serviceQualifier;
        }

        /** 
         * Check if SocialMediaQualifiers is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifSocialMediaQualifiers() {
            return qualifierListSelect == SOCIAL_MEDIA_QUALIFIERS_CHOICE;
        }

        /** 
         * Get the 'SocialMediaQualifiers' element value.
         * 
         * @return value
         */
        public SocialMediaQualifierType getSocialMediaQualifiers() {
            return socialMediaQualifiers;
        }

        /** 
         * Set the 'SocialMediaQualifiers' element value.
         * 
         * @param socialMediaQualifiers
         */
        public void setSocialMediaQualifiers(
                SocialMediaQualifierType socialMediaQualifiers) {
            setQualifierListSelect(SOCIAL_MEDIA_QUALIFIERS_CHOICE);
            this.socialMediaQualifiers = socialMediaQualifiers;
        }

        /** 
         * Check if SpecialFareQualifiers is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifSpecialFareQualifiers() {
            return qualifierListSelect == SPECIAL_FARE_QUALIFIERS_CHOICE;
        }

        /** 
         * Get the 'SpecialFareQualifiers' element value. Contains elements identifying eligibility for special pricing, which may be private or negotiated.

        Notes:
        1. Supports pricing discounts and/ or other benefits for Travelers affiliated with companies with private fare and/ or negotiated rate contracts.

        2. Private Fares apply to ALL Travelers.
         * 
         * @return value
         */
        public FareQualifierType getSpecialFareQualifiers() {
            return specialFareQualifiers;
        }

        /** 
         * Set the 'SpecialFareQualifiers' element value. Contains elements identifying eligibility for special pricing, which may be private or negotiated.

        Notes:
        1. Supports pricing discounts and/ or other benefits for Travelers affiliated with companies with private fare and/ or negotiated rate contracts.

        2. Private Fares apply to ALL Travelers.
         * 
         * @param specialFareQualifiers
         */
        public void setSpecialFareQualifiers(
                FareQualifierType specialFareQualifiers) {
            setQualifierListSelect(SPECIAL_FARE_QUALIFIERS_CHOICE);
            this.specialFareQualifiers = specialFareQualifiers;
        }

        /** 
         * Check if SpecialNeedQualifiers is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifSpecialNeedQualifiers() {
            return qualifierListSelect == SPECIAL_NEED_QUALIFIERS_CHOICE;
        }

        /** 
         * Get the 'SpecialNeedQualifiers' element value.
         * 
         * @return value
         */
        public SpecialType getSpecialNeedQualifiers() {
            return specialNeedQualifiers;
        }

        /** 
         * Set the 'SpecialNeedQualifiers' element value.
         * 
         * @param specialNeedQualifiers
         */
        public void setSpecialNeedQualifiers(SpecialType specialNeedQualifiers) {
            setQualifierListSelect(SPECIAL_NEED_QUALIFIERS_CHOICE);
            this.specialNeedQualifiers = specialNeedQualifiers;
        }

        /** 
         * Check if TripPurposeQualifier is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifTripPurposeQualifier() {
            return qualifierListSelect == TRIP_PURPOSE_QUALIFIER_CHOICE;
        }

        /** 
         * Get the 'TripPurposeQualifier' element value.
         * 
         * @return value
         */
        public TripPurposeQualifier getTripPurposeQualifier() {
            return tripPurposeQualifier;
        }

        /** 
         * Set the 'TripPurposeQualifier' element value.
         * 
         * @param tripPurposeQualifier
         */
        public void setTripPurposeQualifier(
                TripPurposeQualifier tripPurposeQualifier) {
            setQualifierListSelect(TRIP_PURPOSE_QUALIFIER_CHOICE);
            this.tripPurposeQualifier = tripPurposeQualifier;
        }
    }
}
