
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * REDEMPTION Payment Method definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RedemptionMethodType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Certificates" minOccurs="0">
 *       &lt;!-- Reference to inner class Certificates -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="MemberNumber" minOccurs="0">
 *       &lt;!-- Reference to inner class MemberNumber -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:string" name="RedemptionQuantity" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="PromotionCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="PromoVendorCode" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class RedemptionMethodType implements Serializable
{
    private Certificates certificates;
    private MemberNumber memberNumber;
    private String redemptionQuantity;
    private String promotionCode;
    private List<String> promoVendorCodeList = new ArrayList<String>();
    private String refs;

    /** 
     * Get the 'Certificates' element value.
     * 
     * @return value
     */
    public Certificates getCertificates() {
        return certificates;
    }

    /** 
     * Set the 'Certificates' element value.
     * 
     * @param certificates
     */
    public void setCertificates(Certificates certificates) {
        this.certificates = certificates;
    }

    /** 
     * Get the 'MemberNumber' element value.
     * 
     * @return value
     */
    public MemberNumber getMemberNumber() {
        return memberNumber;
    }

    /** 
     * Set the 'MemberNumber' element value.
     * 
     * @param memberNumber
     */
    public void setMemberNumber(MemberNumber memberNumber) {
        this.memberNumber = memberNumber;
    }

    /** 
     * Get the 'RedemptionQuantity' element value. The quantity of loyalty units  redeemed. Example: 15000
     * 
     * @return value
     */
    public String getRedemptionQuantity() {
        return redemptionQuantity;
    }

    /** 
     * Set the 'RedemptionQuantity' element value. The quantity of loyalty units  redeemed. Example: 15000
     * 
     * @param redemptionQuantity
     */
    public void setRedemptionQuantity(String redemptionQuantity) {
        this.redemptionQuantity = redemptionQuantity;
    }

    /** 
     * Get the 'PromotionCode' element value. Promotion Code.

    Note: Promotion code is the identifier used by the host to link directly with a specific named advertising campaign. By including the required code, the client is able to gain access to special offers which may have been created for a specifically targeted group via a CRM system or for a wider advertising campaign using Television or press adverts.
     * 
     * @return value
     */
    public String getPromotionCode() {
        return promotionCode;
    }

    /** 
     * Set the 'PromotionCode' element value. Promotion Code.

    Note: Promotion code is the identifier used by the host to link directly with a specific named advertising campaign. By including the required code, the client is able to gain access to special offers which may have been created for a specifically targeted group via a CRM system or for a wider advertising campaign using Television or press adverts.
     * 
     * @param promotionCode
     */
    public void setPromotionCode(String promotionCode) {
        this.promotionCode = promotionCode;
    }

    /** 
     * Get the list of 'PromoVendorCode' element items. List of vendor codes associated with the promotion.
     * 
     * @return list
     */
    public List<String> getPromoVendorCodeList() {
        return promoVendorCodeList;
    }

    /** 
     * Set the list of 'PromoVendorCode' element items. List of vendor codes associated with the promotion.
     * 
     * @param list
     */
    public void setPromoVendorCodeList(List<String> list) {
        promoVendorCodeList = list;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
    /** 
     * Loyalty Certificates Redeemed.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Certificates" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="CertificateNumber" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class CertificateNumber -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Certificates implements Serializable
    {
        private List<CertificateNumber> certificateNumberList = new ArrayList<CertificateNumber>();

        /** 
         * Get the list of 'CertificateNumber' element items.
         * 
         * @return list
         */
        public List<CertificateNumber> getCertificateNumberList() {
            return certificateNumberList;
        }

        /** 
         * Set the list of 'CertificateNumber' element items.
         * 
         * @param list
         */
        public void setCertificateNumberList(List<CertificateNumber> list) {
            certificateNumberList = list;
        }
        /** 
         * The loyalty redemption certificate number.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CertificateNumber" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:simpleContent>
         *       &lt;xs:extension base="xs:string">
         *         &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:simpleContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * 
         * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
         *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
         * &lt;/xs:attributeGroup>
         * </pre>
         */
        public static class CertificateNumber implements Serializable
        {
            private String string;
            private String refs;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getString() {
                return string;
            }

            /** 
             * Set the extension value.
             * 
             * @param string
             */
            public void setString(String string) {
                this.string = string;
            }

            /** 
             * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
             * 
             * @return value
             */
            public String getRefs() {
                return refs;
            }

            /** 
             * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
             * 
             * @param refs
             */
            public void setRefs(String refs) {
                this.refs = refs;
            }
        }
    }
    /** 
     * An individual airline identifier assigned to a passenger who is a member of an airline's Frequent Flyer Program.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MemberNumber" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:string">
     *         &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * 
     * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
     *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
     * &lt;/xs:attributeGroup>
     * </pre>
     */
    public static class MemberNumber implements Serializable
    {
        private String string;
        private String refs;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getString() {
            return string;
        }

        /** 
         * Set the extension value.
         * 
         * @param string
         */
        public void setString(String string) {
            this.string = string;
        }

        /** 
         * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @return value
         */
        public String getRefs() {
            return refs;
        }

        /** 
         * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @param refs
         */
        public void setRefs(String refs) {
            this.refs = refs;
        }
    }
}
