
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * RULE SET definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RuleSetType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:KeyWithMetaObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element name="RuleSetID" minOccurs="0">
 *           &lt;!-- Reference to inner class RuleSetID -->
 *         &lt;/xs:element>
 *         &lt;xs:element name="RuleValid" minOccurs="0">
 *           &lt;!-- Reference to inner class RuleValid -->
 *         &lt;/xs:element>
 *         &lt;xs:element type="xs:string" name="Owner" minOccurs="0"/>
 *         &lt;xs:element type="ns:RuleType" name="Rule" maxOccurs="unbounded"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class RuleSetType extends KeyWithMetaObjectBaseType implements
    Serializable
{
    private RuleSetID ruleSetID;
    private RuleValid ruleValid;
    private String owner;
    private List<RuleType> ruleList = new ArrayList<RuleType>();

    /** 
     * Get the 'RuleSetID' element value.
     * 
     * @return value
     */
    public RuleSetID getRuleSetID() {
        return ruleSetID;
    }

    /** 
     * Set the 'RuleSetID' element value.
     * 
     * @param ruleSetID
     */
    public void setRuleSetID(RuleSetID ruleSetID) {
        this.ruleSetID = ruleSetID;
    }

    /** 
     * Get the 'RuleValid' element value.
     * 
     * @return value
     */
    public RuleValid getRuleValid() {
        return ruleValid;
    }

    /** 
     * Set the 'RuleValid' element value.
     * 
     * @param ruleValid
     */
    public void setRuleValid(RuleValid ruleValid) {
        this.ruleValid = ruleValid;
    }

    /** 
     * Get the 'Owner' element value. 
                  Entity that owns/ assigned this Rule Set. Example: BA Note: If this is an airline, the IATA/ A4A (two or three character) Airline Designator Code should be used.
                
     * 
     * @return value
     */
    public String getOwner() {
        return owner;
    }

    /** 
     * Set the 'Owner' element value. 
                  Entity that owns/ assigned this Rule Set. Example: BA Note: If this is an airline, the IATA/ A4A (two or three character) Airline Designator Code should be used.
                
     * 
     * @param owner
     */
    public void setOwner(String owner) {
        this.owner = owner;
    }

    /** 
     * Get the list of 'Rule' element items. Rule(s).
     * 
     * @return list
     */
    public List<RuleType> getRuleList() {
        return ruleList;
    }

    /** 
     * Set the list of 'Rule' element items. Rule(s).
     * 
     * @param list
     */
    public void setRuleList(List<RuleType> list) {
        ruleList = list;
    }
    /** 
     * Unique ID for a set of rules which was applied during transaction processing. Example: PRICERULE001 Note: Optional rule context and name may also be specified.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RuleSetID" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:string">
     *         &lt;xs:attribute type="xs:anySimpleType" name="Name"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class RuleSetID implements Serializable
    {
        private String string;
        private String name;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getString() {
            return string;
        }

        /** 
         * Set the extension value.
         * 
         * @param string
         */
        public void setString(String string) {
            this.string = string;
        }

        /** 
         * Get the 'Name' attribute value. Rule Set Name. Example: Order Item Price Variance
         * 
         * @return value
         */
        public String getName() {
            return name;
        }

        /** 
         * Set the 'Name' attribute value. Rule Set Name. Example: Order Item Price Variance
         * 
         * @param name
         */
        public void setName(String name) {
            this.name = name;
        }
    }
    /** 
     * 
                  Rule Set Effective and Expiration Period. Notes: 1.If specified, this applies to all rules within the rule set. 2.Use a Rule Parameter to specify rule-level effective/ expiration periods, e.g.: (Name) EffectiveDate, (Value) 2015-01-15
                
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RuleValid" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element ref="ns:YearPeriod"/>
     *       &lt;xs:element ref="ns:YearMonthPeriod"/>
     *       &lt;xs:element ref="ns:TimePeriod"/>
     *       &lt;xs:element ref="ns:QuarterPeriod"/>
     *       &lt;xs:element ref="ns:MonthPeriod"/>
     *       &lt;xs:element ref="ns:DayPeriod"/>
     *       &lt;xs:element ref="ns:DateTimePeriod"/>
     *       &lt;xs:element ref="ns:DatePeriod"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class RuleValid implements Serializable
    {
        private YearPeriodRepType yearPeriod;
        private YearMonthPeriodRepType yearMonthPeriod;
        private TimePeriodRepType timePeriod;
        private QuarterPeriodRepType quarterPeriod;
        private MonthPeriodRepType monthPeriod;
        private DayPeriodRepType dayPeriod;
        private DateTimePeriodRepType dateTimePeriod;
        private DatePeriodRepType datePeriod;

        /** 
         * Get the 'YearPeriod' element value.
         * 
         * @return value
         */
        public YearPeriodRepType getYearPeriod() {
            return yearPeriod;
        }

        /** 
         * Set the 'YearPeriod' element value.
         * 
         * @param yearPeriod
         */
        public void setYearPeriod(YearPeriodRepType yearPeriod) {
            this.yearPeriod = yearPeriod;
        }

        /** 
         * Get the 'YearMonthPeriod' element value.
         * 
         * @return value
         */
        public YearMonthPeriodRepType getYearMonthPeriod() {
            return yearMonthPeriod;
        }

        /** 
         * Set the 'YearMonthPeriod' element value.
         * 
         * @param yearMonthPeriod
         */
        public void setYearMonthPeriod(YearMonthPeriodRepType yearMonthPeriod) {
            this.yearMonthPeriod = yearMonthPeriod;
        }

        /** 
         * Get the 'TimePeriod' element value.
         * 
         * @return value
         */
        public TimePeriodRepType getTimePeriod() {
            return timePeriod;
        }

        /** 
         * Set the 'TimePeriod' element value.
         * 
         * @param timePeriod
         */
        public void setTimePeriod(TimePeriodRepType timePeriod) {
            this.timePeriod = timePeriod;
        }

        /** 
         * Get the 'QuarterPeriod' element value.
         * 
         * @return value
         */
        public QuarterPeriodRepType getQuarterPeriod() {
            return quarterPeriod;
        }

        /** 
         * Set the 'QuarterPeriod' element value.
         * 
         * @param quarterPeriod
         */
        public void setQuarterPeriod(QuarterPeriodRepType quarterPeriod) {
            this.quarterPeriod = quarterPeriod;
        }

        /** 
         * Get the 'MonthPeriod' element value.
         * 
         * @return value
         */
        public MonthPeriodRepType getMonthPeriod() {
            return monthPeriod;
        }

        /** 
         * Set the 'MonthPeriod' element value.
         * 
         * @param monthPeriod
         */
        public void setMonthPeriod(MonthPeriodRepType monthPeriod) {
            this.monthPeriod = monthPeriod;
        }

        /** 
         * Get the 'DayPeriod' element value.
         * 
         * @return value
         */
        public DayPeriodRepType getDayPeriod() {
            return dayPeriod;
        }

        /** 
         * Set the 'DayPeriod' element value.
         * 
         * @param dayPeriod
         */
        public void setDayPeriod(DayPeriodRepType dayPeriod) {
            this.dayPeriod = dayPeriod;
        }

        /** 
         * Get the 'DateTimePeriod' element value.
         * 
         * @return value
         */
        public DateTimePeriodRepType getDateTimePeriod() {
            return dateTimePeriod;
        }

        /** 
         * Set the 'DateTimePeriod' element value.
         * 
         * @param dateTimePeriod
         */
        public void setDateTimePeriod(DateTimePeriodRepType dateTimePeriod) {
            this.dateTimePeriod = dateTimePeriod;
        }

        /** 
         * Get the 'DatePeriod' element value.
         * 
         * @return value
         */
        public DatePeriodRepType getDatePeriod() {
            return datePeriod;
        }

        /** 
         * Set the 'DatePeriod' element value.
         * 
         * @param datePeriod
         */
        public void setDatePeriod(DatePeriodRepType datePeriod) {
            this.datePeriod = datePeriod;
        }
    }
}
