
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * RULE definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RuleType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="RuleID"/>
 *     &lt;xs:element name="Value">
 *       &lt;xs:complexType>
 *         &lt;xs:sequence>
 *           &lt;xs:element type="xs:string" name="Text" minOccurs="0"/>
 *           &lt;xs:element ref="ns:AugmentationPoint" minOccurs="0"/>
 *         &lt;/xs:sequence>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:string" name="Name" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Owner" minOccurs="0"/>
 *     &lt;xs:element name="EffectivePeriod" minOccurs="0">
 *       &lt;!-- Reference to inner class EffectivePeriod -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ns:ObjectKeyAttrGroup"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class RuleType implements Serializable
{
    private String ruleID;
    private String valueText;
    private AugPointInfoType valueAugmentationPoint;
    private String name;
    private String owner;
    private EffectivePeriod effectivePeriod;
    private ObjectKeyAttrGroup objectKeyAttrGroup;

    /** 
     * Get the 'RuleID' element value. Unique Rule ID. Example: RULE001
     * 
     * @return value
     */
    public String getRuleID() {
        return ruleID;
    }

    /** 
     * Set the 'RuleID' element value. Unique Rule ID. Example: RULE001
     * 
     * @param ruleID
     */
    public void setRuleID(String ruleID) {
        this.ruleID = ruleID;
    }

    /** 
     * Get the 'Text' element value. Rule text value.
     * 
     * @return value
     */
    public String getValueText() {
        return valueText;
    }

    /** 
     * Set the 'Text' element value. Rule text value.
     * 
     * @param valueText
     */
    public void setValueText(String valueText) {
        this.valueText = valueText;
    }

    /** 
     * Get the 'AugmentationPoint' element value. Implementer-defined rule values.
     * 
     * @return value
     */
    public AugPointInfoType getValueAugmentationPoint() {
        return valueAugmentationPoint;
    }

    /** 
     * Set the 'AugmentationPoint' element value. Implementer-defined rule values.
     * 
     * @param valueAugmentationPoint
     */
    public void setValueAugmentationPoint(
            AugPointInfoType valueAugmentationPoint) {
        this.valueAugmentationPoint = valueAugmentationPoint;
    }

    /** 
     * Get the 'Name' element value. Rule Name. Example: Acceptable Price variance
     * 
     * @return value
     */
    public String getName() {
        return name;
    }

    /** 
     * Set the 'Name' element value. Rule Name. Example: Acceptable Price variance
     * 
     * @param name
     */
    public void setName(String name) {
        this.name = name;
    }

    /** 
     * Get the 'Owner' element value. Entity that owns/ assigned this Rule. Example: BA

    Note: If this is an airline, the IATA/ A4A (two or three character) Airline Designator Code should be used.
     * 
     * @return value
     */
    public String getOwner() {
        return owner;
    }

    /** 
     * Set the 'Owner' element value. Entity that owns/ assigned this Rule. Example: BA

    Note: If this is an airline, the IATA/ A4A (two or three character) Airline Designator Code should be used.
     * 
     * @param owner
     */
    public void setOwner(String owner) {
        this.owner = owner;
    }

    /** 
     * Get the 'EffectivePeriod' element value.
     * 
     * @return value
     */
    public EffectivePeriod getEffectivePeriod() {
        return effectivePeriod;
    }

    /** 
     * Set the 'EffectivePeriod' element value.
     * 
     * @param effectivePeriod
     */
    public void setEffectivePeriod(EffectivePeriod effectivePeriod) {
        this.effectivePeriod = effectivePeriod;
    }

    /** 
     * Get the 'ObjectKeyAttrGroup' attributeGroup value.
     * 
     * @return value
     */
    public ObjectKeyAttrGroup getObjectKeyAttrGroup() {
        return objectKeyAttrGroup;
    }

    /** 
     * Set the 'ObjectKeyAttrGroup' attributeGroup value.
     * 
     * @param objectKeyAttrGroup
     */
    public void setObjectKeyAttrGroup(ObjectKeyAttrGroup objectKeyAttrGroup) {
        this.objectKeyAttrGroup = objectKeyAttrGroup;
    }
    /** 
     * Rule Effective Period.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EffectivePeriod" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element ref="ns:YearPeriod"/>
     *       &lt;xs:element ref="ns:YearMonthPeriod"/>
     *       &lt;xs:element ref="ns:TimePeriod"/>
     *       &lt;xs:element ref="ns:QuarterPeriod"/>
     *       &lt;xs:element ref="ns:MonthPeriod"/>
     *       &lt;xs:element ref="ns:DayPeriod"/>
     *       &lt;xs:element ref="ns:DateTimePeriod"/>
     *       &lt;xs:element ref="ns:DatePeriod"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class EffectivePeriod implements Serializable
    {
        private YearPeriodRepType yearPeriod;
        private YearMonthPeriodRepType yearMonthPeriod;
        private TimePeriodRepType timePeriod;
        private QuarterPeriodRepType quarterPeriod;
        private MonthPeriodRepType monthPeriod;
        private DayPeriodRepType dayPeriod;
        private DateTimePeriodRepType dateTimePeriod;
        private DatePeriodRepType datePeriod;

        /** 
         * Get the 'YearPeriod' element value.
         * 
         * @return value
         */
        public YearPeriodRepType getYearPeriod() {
            return yearPeriod;
        }

        /** 
         * Set the 'YearPeriod' element value.
         * 
         * @param yearPeriod
         */
        public void setYearPeriod(YearPeriodRepType yearPeriod) {
            this.yearPeriod = yearPeriod;
        }

        /** 
         * Get the 'YearMonthPeriod' element value.
         * 
         * @return value
         */
        public YearMonthPeriodRepType getYearMonthPeriod() {
            return yearMonthPeriod;
        }

        /** 
         * Set the 'YearMonthPeriod' element value.
         * 
         * @param yearMonthPeriod
         */
        public void setYearMonthPeriod(YearMonthPeriodRepType yearMonthPeriod) {
            this.yearMonthPeriod = yearMonthPeriod;
        }

        /** 
         * Get the 'TimePeriod' element value.
         * 
         * @return value
         */
        public TimePeriodRepType getTimePeriod() {
            return timePeriod;
        }

        /** 
         * Set the 'TimePeriod' element value.
         * 
         * @param timePeriod
         */
        public void setTimePeriod(TimePeriodRepType timePeriod) {
            this.timePeriod = timePeriod;
        }

        /** 
         * Get the 'QuarterPeriod' element value.
         * 
         * @return value
         */
        public QuarterPeriodRepType getQuarterPeriod() {
            return quarterPeriod;
        }

        /** 
         * Set the 'QuarterPeriod' element value.
         * 
         * @param quarterPeriod
         */
        public void setQuarterPeriod(QuarterPeriodRepType quarterPeriod) {
            this.quarterPeriod = quarterPeriod;
        }

        /** 
         * Get the 'MonthPeriod' element value.
         * 
         * @return value
         */
        public MonthPeriodRepType getMonthPeriod() {
            return monthPeriod;
        }

        /** 
         * Set the 'MonthPeriod' element value.
         * 
         * @param monthPeriod
         */
        public void setMonthPeriod(MonthPeriodRepType monthPeriod) {
            this.monthPeriod = monthPeriod;
        }

        /** 
         * Get the 'DayPeriod' element value.
         * 
         * @return value
         */
        public DayPeriodRepType getDayPeriod() {
            return dayPeriod;
        }

        /** 
         * Set the 'DayPeriod' element value.
         * 
         * @param dayPeriod
         */
        public void setDayPeriod(DayPeriodRepType dayPeriod) {
            this.dayPeriod = dayPeriod;
        }

        /** 
         * Get the 'DateTimePeriod' element value.
         * 
         * @return value
         */
        public DateTimePeriodRepType getDateTimePeriod() {
            return dateTimePeriod;
        }

        /** 
         * Set the 'DateTimePeriod' element value.
         * 
         * @param dateTimePeriod
         */
        public void setDateTimePeriod(DateTimePeriodRepType dateTimePeriod) {
            this.dateTimePeriod = dateTimePeriod;
        }

        /** 
         * Get the 'DatePeriod' element value.
         * 
         * @return value
         */
        public DatePeriodRepType getDatePeriod() {
            return datePeriod;
        }

        /** 
         * Set the 'DatePeriod' element value.
         * 
         * @param datePeriod
         */
        public void setDatePeriod(DatePeriodRepType datePeriod) {
            this.datePeriod = datePeriod;
        }
    }
}
