
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.math.BigInteger;

/** 
 * Record S7 diagnostic definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="S7Type">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:AssociatedObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="xs:string" name="UID" minOccurs="0"/>
 *         &lt;xs:element type="xs:integer" name="Seq" minOccurs="0"/>
 *         &lt;xs:element type="xs:integer" name="ExcessFirst" minOccurs="0"/>
 *         &lt;xs:element type="xs:integer" name="ExcessLast" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class S7Type extends AssociatedObjectBaseType implements Serializable
{
    private String UID;
    private BigInteger seq;
    private BigInteger excessFirst;
    private BigInteger excessLast;

    /** 
     * Get the 'UID' element value. Unique ID. Example: 6
     * 
     * @return value
     */
    public String getUID() {
        return UID;
    }

    /** 
     * Set the 'UID' element value. Unique ID. Example: 6
     * 
     * @param UID
     */
    public void setUID(String UID) {
        this.UID = UID;
    }

    /** 
     * Get the 'Seq' element value. Table sequence number. Example: 3
     * 
     * @return value
     */
    public BigInteger getSeq() {
        return seq;
    }

    /** 
     * Set the 'Seq' element value. Table sequence number. Example: 3
     * 
     * @param seq
     */
    public void setSeq(BigInteger seq) {
        this.seq = seq;
    }

    /** 
     * Get the 'ExcessFirst' element value. ID of the first occurrence of an excess bag. Example: 4
     * 
     * @return value
     */
    public BigInteger getExcessFirst() {
        return excessFirst;
    }

    /** 
     * Set the 'ExcessFirst' element value. ID of the first occurrence of an excess bag. Example: 4
     * 
     * @param excessFirst
     */
    public void setExcessFirst(BigInteger excessFirst) {
        this.excessFirst = excessFirst;
    }

    /** 
     * Get the 'ExcessLast' element value. ID of the last occurrence of an excess bag. Example: 6
     * 
     * @return value
     */
    public BigInteger getExcessLast() {
        return excessLast;
    }

    /** 
     * Set the 'ExcessLast' element value. ID of the last occurrence of an excess bag. Example: 6
     * 
     * @param excessLast
     */
    public void setExcessLast(BigInteger excessLast) {
        this.excessLast = excessLast;
    }
}
