
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * The SeatAvailability transaction set returns data used to construct respective seat maps with fully integrated fees for any identified premium seats.

 The message also returns multi-media content at the message level with media content references at the individual service level.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SeatAvailabilityRQ">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element ref="ns:PointOfSale" minOccurs="0"/>
 *       &lt;xs:element ref="ns:Document"/>
 *       &lt;xs:element ref="ns:Party"/>
 *       &lt;xs:element type="ns:SeatAvailReqParamsType" name="Parameters" minOccurs="0"/>
 *       &lt;xs:element ref="ns:Travelers" minOccurs="0"/>
 *       &lt;xs:element type="ns:QualifiersType" name="Qualifiers" minOccurs="0"/>
 *       &lt;xs:choice>
 *         &lt;xs:element ref="ns:ShoppingResponseIDs"/>
 *         &lt;xs:element name="Query">
 *           &lt;!-- Reference to inner class Query -->
 *         &lt;/xs:element>
 *       &lt;/xs:choice>
 *       &lt;xs:element type="ns:ItineraryType" name="JourneyData" minOccurs="0"/>
 *       &lt;xs:element type="ns:DataListType" name="DataList" minOccurs="0"/>
 *       &lt;xs:element type="ns:SeatAvailReqMetadataType" name="Metadata" minOccurs="0"/>
 *       &lt;xs:element ref="ns:Policies" minOccurs="0"/>
 *     &lt;/xs:sequence>
 *     &lt;xs:attributeGroup ref="ns:IATA_PayloadStdAttributes"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class SeatAvailabilityRQ implements Serializable
{
    private PointOfSaleType pointOfSale;
    private MsgDocumentType document;
    private MsgPartiesType party;
    private SeatAvailReqParamsType parameters;
    private Travelers travelers;
    private QualifiersType qualifiers;
    private int choiceSelect = -1;
    private static final int SHOPPING_RESPONSE_I_DS_CHOICE = 0;
    private static final int QUERY_CHOICE = 1;
    private ShoppingResponseIDType shoppingResponseIDs;
    private Query query;
    private ItineraryType journeyData;
    private DataListType dataList;
    private SeatAvailReqMetadataType metadata;
    private Policies policies;
    private IATAPayloadStdAttributes IATAPayloadStdAttributes;

    /** 
     * Get the 'PointOfSale' element value.
     * 
     * @return value
     */
    public PointOfSaleType getPointOfSale() {
        return pointOfSale;
    }

    /** 
     * Set the 'PointOfSale' element value.
     * 
     * @param pointOfSale
     */
    public void setPointOfSale(PointOfSaleType pointOfSale) {
        this.pointOfSale = pointOfSale;
    }

    /** 
     * Get the 'Document' element value.
     * 
     * @return value
     */
    public MsgDocumentType getDocument() {
        return document;
    }

    /** 
     * Set the 'Document' element value.
     * 
     * @param document
     */
    public void setDocument(MsgDocumentType document) {
        this.document = document;
    }

    /** 
     * Get the 'Party' element value.
     * 
     * @return value
     */
    public MsgPartiesType getParty() {
        return party;
    }

    /** 
     * Set the 'Party' element value.
     * 
     * @param party
     */
    public void setParty(MsgPartiesType party) {
        this.party = party;
    }

    /** 
     * Get the 'Parameters' element value. Parameters that influence overall message results.

    Note: These capabilities may not be supported by all NDC-enabled systems or may be supported by bilateral agreement only. The technical implementation of this capability is not dictated by this specification. 
     * 
     * @return value
     */
    public SeatAvailReqParamsType getParameters() {
        return parameters;
    }

    /** 
     * Set the 'Parameters' element value. Parameters that influence overall message results.

    Note: These capabilities may not be supported by all NDC-enabled systems or may be supported by bilateral agreement only. The technical implementation of this capability is not dictated by this specification. 
     * 
     * @param parameters
     */
    public void setParameters(SeatAvailReqParamsType parameters) {
        this.parameters = parameters;
    }

    /** 
     * Get the 'Travelers' element value.
     * 
     * @return value
     */
    public Travelers getTravelers() {
        return travelers;
    }

    /** 
     * Set the 'Travelers' element value.
     * 
     * @param travelers
     */
    public void setTravelers(Travelers travelers) {
        this.travelers = travelers;
    }

    /** 
     * Get the 'Qualifiers' element value. Traveler requested qualifiers to influence search results, e.g. offers and/ or offer pricing.

    Notes: 
    1. Included Existing Orders, Payment Card, Programs, Promotions, Seat, Service, Social Media, Special Fare, Special Needs, Trip Purpose.

    2. These capabilities may not be supported by all NDC-enabled systems or may be supported by bilateral agreement only.
     * 
     * @return value
     */
    public QualifiersType getQualifiers() {
        return qualifiers;
    }

    /** 
     * Set the 'Qualifiers' element value. Traveler requested qualifiers to influence search results, e.g. offers and/ or offer pricing.

    Notes: 
    1. Included Existing Orders, Payment Card, Programs, Promotions, Seat, Service, Social Media, Special Fare, Special Needs, Trip Purpose.

    2. These capabilities may not be supported by all NDC-enabled systems or may be supported by bilateral agreement only.
     * 
     * @param qualifiers
     */
    public void setQualifiers(QualifiersType qualifiers) {
        this.qualifiers = qualifiers;
    }

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if ShoppingResponseIDs is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifShoppingResponseIDs() {
        return choiceSelect == SHOPPING_RESPONSE_I_DS_CHOICE;
    }

    /** 
     * Get the 'ShoppingResponseIDs' element value.
     * 
     * @return value
     */
    public ShoppingResponseIDType getShoppingResponseIDs() {
        return shoppingResponseIDs;
    }

    /** 
     * Set the 'ShoppingResponseIDs' element value.
     * 
     * @param shoppingResponseIDs
     */
    public void setShoppingResponseIDs(
            ShoppingResponseIDType shoppingResponseIDs) {
        setChoiceSelect(SHOPPING_RESPONSE_I_DS_CHOICE);
        this.shoppingResponseIDs = shoppingResponseIDs;
    }

    /** 
     * Check if Query is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifQuery() {
        return choiceSelect == QUERY_CHOICE;
    }

    /** 
     * Get the 'Query' element value. Choice between entering: 
    1) Cached Shopping Offer IDs
    2) Detailed Query Parameters 
     * 
     * @return value
     */
    public Query getQuery() {
        return query;
    }

    /** 
     * Set the 'Query' element value. Choice between entering: 
    1) Cached Shopping Offer IDs
    2) Detailed Query Parameters 
     * 
     * @param query
     */
    public void setQuery(Query query) {
        setChoiceSelect(QUERY_CHOICE);
        this.query = query;
    }

    /** 
     * Get the 'JourneyData' element value. Existing Flight Itinerary Information.
     * 
     * @return value
     */
    public ItineraryType getJourneyData() {
        return journeyData;
    }

    /** 
     * Set the 'JourneyData' element value. Existing Flight Itinerary Information.
     * 
     * @param journeyData
     */
    public void setJourneyData(ItineraryType journeyData) {
        this.journeyData = journeyData;
    }

    /** 
     * Get the 'DataList' element value. Data Lists(s).
     * 
     * @return value
     */
    public DataListType getDataList() {
        return dataList;
    }

    /** 
     * Set the 'DataList' element value. Data Lists(s).
     * 
     * @param dataList
     */
    public void setDataList(DataListType dataList) {
        this.dataList = dataList;
    }

    /** 
     * Get the 'Metadata' element value. Metadata List(s).
     * 
     * @return value
     */
    public SeatAvailReqMetadataType getMetadata() {
        return metadata;
    }

    /** 
     * Set the 'Metadata' element value. Metadata List(s).
     * 
     * @param metadata
     */
    public void setMetadata(SeatAvailReqMetadataType metadata) {
        this.metadata = metadata;
    }

    /** 
     * Get the 'Policies' element value. Message Policy information.
     * 
     * @return value
     */
    public Policies getPolicies() {
        return policies;
    }

    /** 
     * Set the 'Policies' element value. Message Policy information.
     * 
     * @param policies
     */
    public void setPolicies(Policies policies) {
        this.policies = policies;
    }

    /** 
     * Get the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @return value
     */
    public IATAPayloadStdAttributes getIATAPayloadStdAttributes() {
        return IATAPayloadStdAttributes;
    }

    /** 
     * Set the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @param IATAPayloadStdAttributes
     */
    public void setIATAPayloadStdAttributes(
            IATAPayloadStdAttributes IATAPayloadStdAttributes) {
        this.IATAPayloadStdAttributes = IATAPayloadStdAttributes;
    }
    /** 
     * Core Service Price query parameters.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Query">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:FlightInfoAssocType" name="OriginDestination" minOccurs="0" maxOccurs="unbounded"/>
     *       &lt;xs:element ref="ns:OrderID" minOccurs="0"/>
     *       &lt;xs:element ref="ns:BookingReference" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Query implements Serializable
    {
        private List<FlightInfoAssocType> originDestinationList = new ArrayList<FlightInfoAssocType>();
        private OrderIDType orderID;
        private BookingReferenceType bookingReference;

        /** 
         * Get the list of 'OriginDestination' element items. Origin and Destination.
         * 
         * @return list
         */
        public List<FlightInfoAssocType> getOriginDestinationList() {
            return originDestinationList;
        }

        /** 
         * Set the list of 'OriginDestination' element items. Origin and Destination.
         * 
         * @param list
         */
        public void setOriginDestinationList(List<FlightInfoAssocType> list) {
            originDestinationList = list;
        }

        /** 
         * Get the 'OrderID' element value.
         * 
         * @return value
         */
        public OrderIDType getOrderID() {
            return orderID;
        }

        /** 
         * Set the 'OrderID' element value.
         * 
         * @param orderID
         */
        public void setOrderID(OrderIDType orderID) {
            this.orderID = orderID;
        }

        /** 
         * Get the 'BookingReference' element value.
         * 
         * @return value
         */
        public BookingReferenceType getBookingReference() {
            return bookingReference;
        }

        /** 
         * Set the 'BookingReference' element value.
         * 
         * @param bookingReference
         */
        public void setBookingReference(BookingReferenceType bookingReference) {
            this.bookingReference = bookingReference;
        }
    }
}
