
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/** 
 * Seat display information.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SeatDisplay">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element ref="ns:SeatDisplayKey" minOccurs="0"/>
 *       &lt;xs:element name="Columns" maxOccurs="unbounded">
 *         &lt;!-- Reference to inner class Columns -->
 *       &lt;/xs:element>
 *       &lt;xs:element name="Rows">
 *         &lt;xs:complexType>
 *           &lt;xs:sequence>
 *             &lt;xs:element type="xs:integer" name="First"/>
 *             &lt;xs:element type="xs:integer" name="Last"/>
 *             &lt;xs:element type="ns:SeatDataType" name="SectionSeatData" minOccurs="0"/>
 *           &lt;/xs:sequence>
 *         &lt;/xs:complexType>
 *       &lt;/xs:element>
 *       &lt;xs:element type="ns:SeatComponentType" name="Component" minOccurs="0" maxOccurs="unbounded"/>
 *       &lt;xs:element ref="ns:CabinType" minOccurs="0"/>
 *     &lt;/xs:sequence>
 *     &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class SeatDisplay implements Serializable
{
    private SeatDisplayKey seatDisplayKey;
    private List<Columns> columnList = new ArrayList<Columns>();
    private BigInteger rowsFirst;
    private BigInteger rowsLast;
    private SeatDataType rowsSectionSeatData;
    private List<SeatComponentType> componentList = new ArrayList<SeatComponentType>();
    private CabinType cabinType;
    private String refs;

    /** 
     * Get the 'SeatDisplayKey' element value.
     * 
     * @return value
     */
    public SeatDisplayKey getSeatDisplayKey() {
        return seatDisplayKey;
    }

    /** 
     * Set the 'SeatDisplayKey' element value.
     * 
     * @param seatDisplayKey
     */
    public void setSeatDisplayKey(SeatDisplayKey seatDisplayKey) {
        this.seatDisplayKey = seatDisplayKey;
    }

    /** 
     * Get the list of 'Columns' element items.
     * 
     * @return list
     */
    public List<Columns> getColumnList() {
        return columnList;
    }

    /** 
     * Set the list of 'Columns' element items.
     * 
     * @param list
     */
    public void setColumnList(List<Columns> list) {
        columnList = list;
    }

    /** 
     * Get the 'First' element value. First row number. Example: 08
     * 
     * @return value
     */
    public BigInteger getRowsFirst() {
        return rowsFirst;
    }

    /** 
     * Set the 'First' element value. First row number. Example: 08
     * 
     * @param rowsFirst
     */
    public void setRowsFirst(BigInteger rowsFirst) {
        this.rowsFirst = rowsFirst;
    }

    /** 
     * Get the 'Last' element value. Last row number.  Example: 44
     * 
     * @return value
     */
    public BigInteger getRowsLast() {
        return rowsLast;
    }

    /** 
     * Set the 'Last' element value. Last row number.  Example: 44
     * 
     * @param rowsLast
     */
    public void setRowsLast(BigInteger rowsLast) {
        this.rowsLast = rowsLast;
    }

    /** 
     * Get the 'SectionSeatData' element value. Seat information by aircraft section.
     * 
     * @return value
     */
    public SeatDataType getRowsSectionSeatData() {
        return rowsSectionSeatData;
    }

    /** 
     * Set the 'SectionSeatData' element value. Seat information by aircraft section.
     * 
     * @param rowsSectionSeatData
     */
    public void setRowsSectionSeatData(SeatDataType rowsSectionSeatData) {
        this.rowsSectionSeatData = rowsSectionSeatData;
    }

    /** 
     * Get the list of 'Component' element items. Non-Seat Cabin Component information.
     * 
     * @return list
     */
    public List<SeatComponentType> getComponentList() {
        return componentList;
    }

    /** 
     * Set the list of 'Component' element items. Non-Seat Cabin Component information.
     * 
     * @param list
     */
    public void setComponentList(List<SeatComponentType> list) {
        componentList = list;
    }

    /** 
     * Get the 'CabinType' element value.
     * 
     * @return value
     */
    public CabinType getCabinType() {
        return cabinType;
    }

    /** 
     * Set the 'CabinType' element value.
     * 
     * @param cabinType
     */
    public void setCabinType(CabinType cabinType) {
        this.cabinType = cabinType;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
    /** 
     * Seat column to identify a particular seat position on an aircraft
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Columns" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:string">
     *         &lt;xs:attribute type="xs:string" use="optional" name="Position"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Columns implements Serializable
    {
        private String string;
        private String position;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getString() {
            return string;
        }

        /** 
         * Set the extension value.
         * 
         * @param string
         */
        public void setString(String string) {
            this.string = string;
        }

        /** 
         * Get the 'Position' attribute value. Column position in of the seat.
        Example: A (AISLE SEAT)

        For maximum interoperability, refer to IATA PADIS Code List for data element 9825 - Seat Characteristic, Coded.
         * 
         * @return value
         */
        public String getPosition() {
            return position;
        }

        /** 
         * Set the 'Position' attribute value. Column position in of the seat.
        Example: A (AISLE SEAT)

        For maximum interoperability, refer to IATA PADIS Code List for data element 9825 - Seat Characteristic, Coded.
         * 
         * @param position
         */
        public void setPosition(String position) {
            this.position = position;
        }
    }
}
