
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * Seat Offer with Association definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SeatOfferType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:SeatDetailType">
 *       &lt;xs:sequence>
 *         &lt;xs:element name="OfferPrice">
 *           &lt;xs:complexType>
 *             &lt;xs:choice>
 *               &lt;xs:element ref="ns:SimpleCurrencyPrice"/>
 *               &lt;xs:element ref="ns:EncodedCurrencyPrice"/>
 *               &lt;xs:element ref="ns:DetailCurrencyPrice"/>
 *               &lt;xs:element ref="ns:CombinationPricing"/>
 *               &lt;xs:element ref="ns:AwardPricing"/>
 *             &lt;/xs:choice>
 *           &lt;/xs:complexType>
 *         &lt;/xs:element>
 *         &lt;xs:element type="ns:SeatOfferAssocType" name="Association"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SeatOfferType extends SeatDetailType implements Serializable
{
    private int offerPriceSelect = -1;
    private static final int OFFER_PRICE_SIMPLE_CURRENCY_PRICE_CHOICE = 0;
    private static final int OFFER_PRICE_ENCODED_CURRENCY_PRICE_CHOICE = 1;
    private static final int OFFER_PRICE_DETAIL_CURRENCY_PRICE_CHOICE = 2;
    private static final int OFFER_PRICE_COMBINATION_PRICING_CHOICE = 3;
    private static final int OFFER_PRICE_AWARD_PRICING_CHOICE = 4;
    private SimpleCurrencyPrice offerPriceSimpleCurrencyPrice;
    private EncodedCurrencyPrice offerPriceEncodedCurrencyPrice;
    private DetailCurrencyPriceType offerPriceDetailCurrencyPrice;
    private CombinationPriceType offerPriceCombinationPricing;
    private AwardPriceUnitType offerPriceAwardPricing;
    private SeatOfferAssocType association;

    private void setOfferPriceSelect(int choice) {
        if (offerPriceSelect == -1) {
            offerPriceSelect = choice;
        } else if (offerPriceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearOfferPriceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearOfferPriceSelect() {
        offerPriceSelect = -1;
    }

    /** 
     * Check if OfferPriceSimpleCurrencyPrice is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifOfferPriceSimpleCurrencyPrice() {
        return offerPriceSelect == OFFER_PRICE_SIMPLE_CURRENCY_PRICE_CHOICE;
    }

    /** 
     * Get the 'SimpleCurrencyPrice' element value.
     * 
     * @return value
     */
    public SimpleCurrencyPrice getOfferPriceSimpleCurrencyPrice() {
        return offerPriceSimpleCurrencyPrice;
    }

    /** 
     * Set the 'SimpleCurrencyPrice' element value.
     * 
     * @param offerPriceSimpleCurrencyPrice
     */
    public void setOfferPriceSimpleCurrencyPrice(
            SimpleCurrencyPrice offerPriceSimpleCurrencyPrice) {
        setOfferPriceSelect(OFFER_PRICE_SIMPLE_CURRENCY_PRICE_CHOICE);
        this.offerPriceSimpleCurrencyPrice = offerPriceSimpleCurrencyPrice;
    }

    /** 
     * Check if OfferPriceEncodedCurrencyPrice is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifOfferPriceEncodedCurrencyPrice() {
        return offerPriceSelect == OFFER_PRICE_ENCODED_CURRENCY_PRICE_CHOICE;
    }

    /** 
     * Get the 'EncodedCurrencyPrice' element value.
     * 
     * @return value
     */
    public EncodedCurrencyPrice getOfferPriceEncodedCurrencyPrice() {
        return offerPriceEncodedCurrencyPrice;
    }

    /** 
     * Set the 'EncodedCurrencyPrice' element value.
     * 
     * @param offerPriceEncodedCurrencyPrice
     */
    public void setOfferPriceEncodedCurrencyPrice(
            EncodedCurrencyPrice offerPriceEncodedCurrencyPrice) {
        setOfferPriceSelect(OFFER_PRICE_ENCODED_CURRENCY_PRICE_CHOICE);
        this.offerPriceEncodedCurrencyPrice = offerPriceEncodedCurrencyPrice;
    }

    /** 
     * Check if OfferPriceDetailCurrencyPrice is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifOfferPriceDetailCurrencyPrice() {
        return offerPriceSelect == OFFER_PRICE_DETAIL_CURRENCY_PRICE_CHOICE;
    }

    /** 
     * Get the 'DetailCurrencyPrice' element value.
     * 
     * @return value
     */
    public DetailCurrencyPriceType getOfferPriceDetailCurrencyPrice() {
        return offerPriceDetailCurrencyPrice;
    }

    /** 
     * Set the 'DetailCurrencyPrice' element value.
     * 
     * @param offerPriceDetailCurrencyPrice
     */
    public void setOfferPriceDetailCurrencyPrice(
            DetailCurrencyPriceType offerPriceDetailCurrencyPrice) {
        setOfferPriceSelect(OFFER_PRICE_DETAIL_CURRENCY_PRICE_CHOICE);
        this.offerPriceDetailCurrencyPrice = offerPriceDetailCurrencyPrice;
    }

    /** 
     * Check if OfferPriceCombinationPricing is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifOfferPriceCombinationPricing() {
        return offerPriceSelect == OFFER_PRICE_COMBINATION_PRICING_CHOICE;
    }

    /** 
     * Get the 'CombinationPricing' element value.
     * 
     * @return value
     */
    public CombinationPriceType getOfferPriceCombinationPricing() {
        return offerPriceCombinationPricing;
    }

    /** 
     * Set the 'CombinationPricing' element value.
     * 
     * @param offerPriceCombinationPricing
     */
    public void setOfferPriceCombinationPricing(
            CombinationPriceType offerPriceCombinationPricing) {
        setOfferPriceSelect(OFFER_PRICE_COMBINATION_PRICING_CHOICE);
        this.offerPriceCombinationPricing = offerPriceCombinationPricing;
    }

    /** 
     * Check if OfferPriceAwardPricing is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifOfferPriceAwardPricing() {
        return offerPriceSelect == OFFER_PRICE_AWARD_PRICING_CHOICE;
    }

    /** 
     * Get the 'AwardPricing' element value.
     * 
     * @return value
     */
    public AwardPriceUnitType getOfferPriceAwardPricing() {
        return offerPriceAwardPricing;
    }

    /** 
     * Set the 'AwardPricing' element value.
     * 
     * @param offerPriceAwardPricing
     */
    public void setOfferPriceAwardPricing(
            AwardPriceUnitType offerPriceAwardPricing) {
        setOfferPriceSelect(OFFER_PRICE_AWARD_PRICING_CHOICE);
        this.offerPriceAwardPricing = offerPriceAwardPricing;
    }

    /** 
     * Get the 'Association' element value. Seat Offer Association(s).
     * 
     * @return value
     */
    public SeatOfferAssocType getAssociation() {
        return association;
    }

    /** 
     * Set the 'Association' element value. Seat Offer Association(s).
     * 
     * @param association
     */
    public void setAssociation(SeatOfferAssocType association) {
        this.association = association;
    }
}
