
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * 
 A data type for 3DS Action Type contextual list. Examples: CheckEnrollment CompleteAuthentication DoAuthentication ValidateAddress ValidateCVC

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SecureActionListType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="EnrollmentCheckRequest"/>
 *     &lt;xs:enumeration value="EnrollmentCheckResponse"/>
 *     &lt;xs:enumeration value="CardAuthenticationRequest"/>
 *     &lt;xs:enumeration value="CardAuthenticationResponse"/>
 *     &lt;xs:enumeration value="ValidateCardInfoRequest"/>
 *     &lt;xs:enumeration value="ValidateCardInfoResponse"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum SecureActionListType implements Serializable {
    ENROLLMENT_CHECK_REQUEST("EnrollmentCheckRequest"), ENROLLMENT_CHECK_RESPONSE(
            "EnrollmentCheckResponse"), CARD_AUTHENTICATION_REQUEST(
            "CardAuthenticationRequest"), CARD_AUTHENTICATION_RESPONSE(
            "CardAuthenticationResponse"), VALIDATE_CARD_INFO_REQUEST(
            "ValidateCardInfoRequest"), VALIDATE_CARD_INFO_RESPONSE(
            "ValidateCardInfoResponse");
    private final String value;

    private SecureActionListType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static SecureActionListType convert(String value) {
        for (SecureActionListType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
