
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * 
 A data type for 3DS Secure Authorization Client Type contextual list. Examples: InteractiveVoiceResponse (IVR) Internet MailOrTelephoneOrder (MOTO) Recurring Unattended

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SecureTrxClientListType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="InteractiveVoiceResponse"/>
 *     &lt;xs:enumeration value="Internet"/>
 *     &lt;xs:enumeration value="MailOrTelephoneOrder"/>
 *     &lt;xs:enumeration value="Recurring"/>
 *     &lt;xs:enumeration value="Unattended"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum SecureTrxClientListType implements Serializable {
    /** 
     * IVR
     */
    INTERACTIVE_VOICE_RESPONSE("InteractiveVoiceResponse"), INTERNET("Internet"), /** 
                                                                                   * MOTO
                                                                                   */
    MAIL_OR_TELEPHONE_ORDER("MailOrTelephoneOrder"), RECURRING("Recurring"), UNATTENDED(
            "Unattended");
    private final String value;

    private SecureTrxClientListType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static SecureTrxClientListType convert(String value) {
        for (SecureTrxClientListType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
